/*
 * DISCLAIMER
 *
 * Copyright 2016 ArangoDB GmbH, Cologne, Germany
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright holder is ArangoDB GmbH, Cologne, Germany
 */

package com.arangodb.entity;

import java.util.Collection;

/**
 * @author Mark - mark at arangodb.com
 *
 * @see <a href= "https://docs.arangodb.com/current/HTTP/Traversal/index.html#executes-a-traversal">API
 *      Documentation</a>
 */
public class PathEntity<V, E> {

	private Collection<E> edges;
	private Collection<V> vertices;

	public PathEntity() {
		super();
	}

	public Collection<E> getEdges() {
		return edges;
	}

	public void setEdges(final Collection<E> edges) {
		this.edges = edges;
	}

	public Collection<V> getVertices() {
		return vertices;
	}

	public void setVertices(final Collection<V> vertices) {
		this.vertices = vertices;
	}

}
