/*
 * Copyright (C) 2012 tamtam180
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.arangodb.util;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author tamtam180 - kirscheless at gmail.com
 *
 */
public class MapBuilder {
  
  private boolean ignoreValue = true;
  private LinkedHashMap<String, Object> map;
  
  public MapBuilder() {
    map = new LinkedHashMap<String, Object>();
  }
  public MapBuilder(boolean ignoreValue) {
    this();
    this.ignoreValue = ignoreValue;
  }
  public MapBuilder(String key, Object value) {
    this();
    put(key, value);
  }
  public MapBuilder(String key, Object value, boolean ignoreValue) {
    this();
    this.ignoreValue = ignoreValue;
    put(key, value);
  }

  public MapBuilder put(String key, Object value) {
    return put(key, value, false);
  }
  public MapBuilder put(String key, Object value, boolean toString) {
    if (!this.ignoreValue || (key != null && value != null)) {
      map.put(key, toString ? value.toString() : value);
    }
    return this;
  }
  public Map<String, Object> get() {
    return map;
  }
  
}
