/*
 * Copyright (C) 2012 tamtam180
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.arangodb.entity;

import java.io.IOException;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

/**
 *
 * Used only internally for entity deserialisation
 *
 * @author tamtam180 - kirscheless at gmail.com
 *
 */
public class CollectionStatusTypeAdapter extends TypeAdapter<CollectionStatus> {

  @Override
  public void write(JsonWriter out, CollectionStatus value) throws IOException {
    out.value(value.status());
  }

  @Override
  public CollectionStatus read(JsonReader in) throws IOException {
    if (in.peek() == JsonToken.NULL) {
      in.nextNull();
      return null;
    }
    
    CollectionStatus ret = CollectionStatus.valueOf(in.nextInt());
    return ret;
  }

}
