# serialization / deserialization
## JavaBeans
The driver can serialize/deserialize JavaBeans. They need at least a constructor without parameter.

``` Java
  public class MyObject {

    private String name;
    private Gender gender;
    private int age;

    public MyObject() {
      super();
    }

  }  
```

## internal fields
To use Arango-internal fields (like _id, _key, _rev, _from, _to) in your JavaBeans, use the annotation `DocumentField`.

``` Java
  public class MyObject {

    @DocumentField(Type.KEY)
    private String key;
    
    private String name;
    private Gender gender;
    private int age;

    public MyObject() {
      super();
    }

  }  
```

## serialized fieldnames
To use a different serialized name for a field, use the annotation `SerializedName`.

``` Java
  public class MyObject {

    @SerializedName("title")
    private String name;
    
    private Gender gender;
    private int age;

    public MyObject() {
      super();
    }

  }  
```

## ignore fields
To ignore fields at serialization/deserialization, use the annotation `Expose`

``` Java
  public class MyObject {

    @Expose
    private String name;
    @Expose(serialize = true, deserialize = false)
    private Gender gender;
    private int age;

    public MyObject() {
      super();
    }

  }  
```

## custom de-/serializer
``` Java
  ArangoDBAsync arangoDB = new ArangoDBAsync.Builder()
    .registerDeserializer(MyObject.class, new VPackDeserializer<MyObject>() {
      @Override
      public MyObject deserialize(
        final VPackSlice parent,
        final VPackSlice vpack,
        final VPackDeserializationContext context) throws VPackException {
        
          final MyObject obj = new MyObject();
          obj.setName(vpack.get("name").getAsString());
          return obj;
      }
    }).registerSerializer(MyObject.class, new VPackSerializer<MyObject>() {
      @Override
      public void serialize(
        final VPackBuilder builder,
        final String attribute,
        final MyObject value,
        final VPackSerializationContext context) throws VPackException {
        
          builder.add(attribute, ValueType.OBJECT);
          builder.add("name", value.getName());
          builder.close();
      }
    }).build();
``` 

## manually de-/serialization
To de-/serialize from and to VelocyPack before or after a database call, use the `ArangoUtil` from the method `util()` in `ArangoDB`, `ArangoDatabase`, `ArangoCollection`, `ArangoGraph`, `ArangoEdgeCollection`or `ArangoVertexCollection`.

``` Java
  ArangoDB arangoDB = new ArangoDB.Builder();
  arangoDB.util().deserialize(vpack, type);
```