//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2021 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// HTTPServerUpgradeTests+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension HTTPServerUpgradeTestCase {

   @available(*, deprecated, message: "not actually deprecated. Just deprecated to allow deprecated tests (which test deprecated functionality) without warnings")
   static var allTests : [(String, (HTTPServerUpgradeTestCase) -> () throws -> Void)] {
      return [
                ("testUpgradeWithoutUpgrade", testUpgradeWithoutUpgrade),
                ("testUpgradeAfterInitialRequest", testUpgradeAfterInitialRequest),
                ("testUpgradeHandlerBarfsOnUnexpectedOrdering", testUpgradeHandlerBarfsOnUnexpectedOrdering),
                ("testSimpleUpgradeSucceeds", testSimpleUpgradeSucceeds),
                ("testUpgradeRequiresCorrectHeaders", testUpgradeRequiresCorrectHeaders),
                ("testUpgradeRequiresHeadersInConnection", testUpgradeRequiresHeadersInConnection),
                ("testUpgradeOnlyHandlesKnownProtocols", testUpgradeOnlyHandlesKnownProtocols),
                ("testUpgradeRespectsClientPreference", testUpgradeRespectsClientPreference),
                ("testUpgradeFiresUserEvent", testUpgradeFiresUserEvent),
                ("testUpgraderCanRejectUpgradeForPersonalReasons", testUpgraderCanRejectUpgradeForPersonalReasons),
                ("testUpgradeIsCaseInsensitive", testUpgradeIsCaseInsensitive),
                ("testDelayedUpgradeBehaviour", testDelayedUpgradeBehaviour),
                ("testBuffersInboundDataDuringDelayedUpgrade", testBuffersInboundDataDuringDelayedUpgrade),
                ("testDelayedUpgradeResponse", testDelayedUpgradeResponse),
                ("testChainsDelayedUpgradesAppropriately", testChainsDelayedUpgradesAppropriately),
                ("testDelayedUpgradeResponseDeliversFullRequest", testDelayedUpgradeResponseDeliversFullRequest),
                ("testDelayedUpgradeResponseDeliversFullRequestAndPendingBits", testDelayedUpgradeResponseDeliversFullRequestAndPendingBits),
                ("testRemovesAllHTTPRelatedHandlersAfterUpgrade", testRemovesAllHTTPRelatedHandlersAfterUpgrade),
                ("testUpgradeWithUpgradePayloadInlineWithRequestWorks", testUpgradeWithUpgradePayloadInlineWithRequestWorks),
                ("testDeliversBytesWhenRemovedDuringPartialUpgrade", testDeliversBytesWhenRemovedDuringPartialUpgrade),
                ("testDeliversBytesWhenReentrantlyCalledInChannelReadCompleteOnRemoval", testDeliversBytesWhenReentrantlyCalledInChannelReadCompleteOnRemoval),
                ("testWeTolerateUpgradeFuturesFromWrongEventLoops", testWeTolerateUpgradeFuturesFromWrongEventLoops),
           ]
   }
}

