//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// CodecTest+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension ByteToMessageDecoderTest {

   @available(*, deprecated, message: "not actually deprecated. Just deprecated to allow deprecated tests (which test deprecated functionality) without warnings")
   static var allTests : [(String, (ByteToMessageDecoderTest) -> () throws -> Void)] {
      return [
                ("testDecoder", testDecoder),
                ("testDecoderPropagatesChannelInactive", testDecoderPropagatesChannelInactive),
                ("testDecoderIsNotQuadratic", testDecoderIsNotQuadratic),
                ("testMemoryIsReclaimedIfMostIsConsumed", testMemoryIsReclaimedIfMostIsConsumed),
                ("testMemoryIsReclaimedIfLotsIsAvailable", testMemoryIsReclaimedIfLotsIsAvailable),
                ("testDecoderReentranceChannelRead", testDecoderReentranceChannelRead),
                ("testTrivialDecoderDoesSensibleStuffWhenCloseInRead", testTrivialDecoderDoesSensibleStuffWhenCloseInRead),
                ("testLeftOversMakeDecodeLastCalled", testLeftOversMakeDecodeLastCalled),
                ("testRemovingHandlerMakesLeftoversAppearInDecodeLast", testRemovingHandlerMakesLeftoversAppearInDecodeLast),
                ("testStructsWorkAsByteToMessageDecoders", testStructsWorkAsByteToMessageDecoders),
                ("testReentrantChannelReadWhileWholeBufferIsBeingProcessed", testReentrantChannelReadWhileWholeBufferIsBeingProcessed),
                ("testReentrantChannelCloseInChannelRead", testReentrantChannelCloseInChannelRead),
                ("testHandlerRemoveInChannelRead", testHandlerRemoveInChannelRead),
                ("testChannelCloseInChannelRead", testChannelCloseInChannelRead),
                ("testDecodeLoopGetsInterruptedWhenRemovalIsTriggered", testDecodeLoopGetsInterruptedWhenRemovalIsTriggered),
                ("testDecodeLastIsInvokedOnceEvenIfNothingEverArrivedOnChannelClosed", testDecodeLastIsInvokedOnceEvenIfNothingEverArrivedOnChannelClosed),
                ("testDecodeLastIsInvokedOnceEvenIfNothingEverArrivedOnChannelHalfClosure", testDecodeLastIsInvokedOnceEvenIfNothingEverArrivedOnChannelHalfClosure),
                ("testDecodeLastHasSeenEOFFalseOnHandlerRemoved", testDecodeLastHasSeenEOFFalseOnHandlerRemoved),
                ("testDecodeLastHasSeenEOFFalseOnHandlerRemovedEvenIfNoData", testDecodeLastHasSeenEOFFalseOnHandlerRemovedEvenIfNoData),
                ("testDecodeLastHasSeenEOFTrueOnChannelInactive", testDecodeLastHasSeenEOFTrueOnChannelInactive),
                ("testWriteObservingByteToMessageDecoderBasic", testWriteObservingByteToMessageDecoderBasic),
                ("testWriteObservingByteToMessageDecoderWhereWriteIsReentrantlyCalled", testWriteObservingByteToMessageDecoderWhereWriteIsReentrantlyCalled),
                ("testDecodeMethodsNoLongerCalledIfErrorInDecode", testDecodeMethodsNoLongerCalledIfErrorInDecode),
                ("testDecodeMethodsNoLongerCalledIfErrorInDecodeLast", testDecodeMethodsNoLongerCalledIfErrorInDecodeLast),
                ("testBasicLifecycle", testBasicLifecycle),
                ("testDecodeLoopStopsOnChannelInactive", testDecodeLoopStopsOnChannelInactive),
                ("testDecodeLoopStopsOnInboundHalfClosure", testDecodeLoopStopsOnInboundHalfClosure),
                ("testWeForwardReadEOFAndChannelInactive", testWeForwardReadEOFAndChannelInactive),
                ("testErrorInDecodeLastWhenCloseIsReceivedReentrantlyInDecode", testErrorInDecodeLastWhenCloseIsReceivedReentrantlyInDecode),
                ("testWeAreOkayWithReceivingDataAfterHalfClosureEOF", testWeAreOkayWithReceivingDataAfterHalfClosureEOF),
                ("testWeAreOkayWithReceivingDataAfterFullClose", testWeAreOkayWithReceivingDataAfterFullClose),
                ("testPayloadTooLarge", testPayloadTooLarge),
                ("testPayloadTooLargeButHandlerOk", testPayloadTooLargeButHandlerOk),
                ("testRemoveHandlerBecauseOfChannelTearDownWhilstUserTriggeredRemovalIsInProgress", testRemoveHandlerBecauseOfChannelTearDownWhilstUserTriggeredRemovalIsInProgress),
           ]
   }
}

extension MessageToByteEncoderTest {

   @available(*, deprecated, message: "not actually deprecated. Just deprecated to allow deprecated tests (which test deprecated functionality) without warnings")
   static var allTests : [(String, (MessageToByteEncoderTest) -> () throws -> Void)] {
      return [
                ("testEncoderOverrideAllocateOutBuffer", testEncoderOverrideAllocateOutBuffer),
                ("testEncoder", testEncoder),
                ("testB2MHIsHappyNeverBeingAddedToAPipeline", testB2MHIsHappyNeverBeingAddedToAPipeline),
                ("testM2BHIsHappyNeverBeingAddedToAPipeline", testM2BHIsHappyNeverBeingAddedToAPipeline),
           ]
   }
}

extension MessageToByteHandlerTest {

   @available(*, deprecated, message: "not actually deprecated. Just deprecated to allow deprecated tests (which test deprecated functionality) without warnings")
   static var allTests : [(String, (MessageToByteHandlerTest) -> () throws -> Void)] {
      return [
                ("testThrowingEncoderFailsPromises", testThrowingEncoderFailsPromises),
           ]
   }
}

