//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// SNIHandlerTests+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension SniHandlerTest {

   static var allTests : [(String, (SniHandlerTest) -> () throws -> Void)] {
      return [
                ("testLibre227NoSniDripFeed", testLibre227NoSniDripFeed),
                ("testLibre227WithSniDripFeed", testLibre227WithSniDripFeed),
                ("testOpenSSL102NoSniDripFeed", testOpenSSL102NoSniDripFeed),
                ("testOpenSSL102WithSniDripFeed", testOpenSSL102WithSniDripFeed),
                ("testCurlSecureTransportDripFeed", testCurlSecureTransportDripFeed),
                ("testSafariDripFeed", testSafariDripFeed),
                ("testChromeDripFeed", testChromeDripFeed),
                ("testFirefoxDripFeed", testFirefoxDripFeed),
                ("testLibre227NoSniBlast", testLibre227NoSniBlast),
                ("testLibre227WithSniBlast", testLibre227WithSniBlast),
                ("testOpenSSL102NoSniBlast", testOpenSSL102NoSniBlast),
                ("testOpenSSL102WithSniBlast", testOpenSSL102WithSniBlast),
                ("testCurlSecureTransportBlast", testCurlSecureTransportBlast),
                ("testSafariBlast", testSafariBlast),
                ("testChromeBlast", testChromeBlast),
                ("testFirefoxBlast", testFirefoxBlast),
                ("testIgnoresUnknownRecordTypes", testIgnoresUnknownRecordTypes),
                ("testIgnoresUnknownTlsVersions", testIgnoresUnknownTlsVersions),
                ("testIgnoresNonClientHelloHandshakeMessages", testIgnoresNonClientHelloHandshakeMessages),
                ("testIgnoresInvalidHandshakeLength", testIgnoresInvalidHandshakeLength),
                ("testIgnoresInvalidCipherSuiteLength", testIgnoresInvalidCipherSuiteLength),
                ("testIgnoresInvalidCompressionLength", testIgnoresInvalidCompressionLength),
                ("testIgnoresInvalidExtensionLength", testIgnoresInvalidExtensionLength),
                ("testIgnoresInvalidIndividualExtensionLength", testIgnoresInvalidIndividualExtensionLength),
                ("testIgnoresUnknownNameType", testIgnoresUnknownNameType),
                ("testIgnoresInvalidNameLength", testIgnoresInvalidNameLength),
                ("testIgnoresInvalidNameExtensionLength", testIgnoresInvalidNameExtensionLength),
                ("testLudicrouslyTruncatedPacket", testLudicrouslyTruncatedPacket),
                ("testFuzzingInputOne", testFuzzingInputOne),
           ]
   }
}

