//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// DatagramChannelTests+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension DatagramChannelTests {

   static var allTests : [(String, (DatagramChannelTests) -> () throws -> Void)] {
      return [
                ("testBasicChannelCommunication", testBasicChannelCommunication),
                ("testManyWrites", testManyWrites),
                ("testConnectionFails", testConnectionFails),
                ("testDatagramChannelHasWatermark", testDatagramChannelHasWatermark),
                ("testWriteFuturesFailWhenChannelClosed", testWriteFuturesFailWhenChannelClosed),
                ("testManyManyDatagramWrites", testManyManyDatagramWrites),
                ("testSendmmsgLotsOfData", testSendmmsgLotsOfData),
                ("testLargeWritesFail", testLargeWritesFail),
                ("testOneLargeWriteDoesntPreventOthersWriting", testOneLargeWriteDoesntPreventOthersWriting),
                ("testClosingBeforeFlushFailsAllWrites", testClosingBeforeFlushFailsAllWrites),
                ("testRecvFromFailsWithECONNREFUSED", testRecvFromFailsWithECONNREFUSED),
                ("testRecvFromFailsWithENOMEM", testRecvFromFailsWithENOMEM),
                ("testRecvFromFailsWithEFAULT", testRecvFromFailsWithEFAULT),
                ("testSetGetOptionClosedDatagramChannel", testSetGetOptionClosedDatagramChannel),
                ("testWritesAreAccountedCorrectly", testWritesAreAccountedCorrectly),
                ("testSettingTwoDistinctChannelOptionsWorksForDatagramChannel", testSettingTwoDistinctChannelOptionsWorksForDatagramChannel),
           ]
   }
}

