// Copyright 2018 The BoringSSL Authors
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
// SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
// OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

#if !defined(__APPLE__)
#include "CNIOBoringSSL_boringssl_prefix_symbols.h"
#else
// On iOS and macOS, we need to treat assembly symbols differently from other
// symbols. The linker expects symbols to be prefixed with an underscore.
// Perlasm thus generates symbol with this underscore applied. Our macros must,
// in turn, incorporate it.
#define BORINGSSL_ADD_PREFIX_MAC_ASM(a, b) BORINGSSL_ADD_PREFIX_INNER_MAC_ASM(a, b)
#define BORINGSSL_ADD_PREFIX_INNER_MAC_ASM(a, b) _ ## a ## _ ## b

#define _ACCESS_DESCRIPTION_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ACCESS_DESCRIPTION_free)
#define _ACCESS_DESCRIPTION_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ACCESS_DESCRIPTION_new)
#define _AES_CMAC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_CMAC)
#define _AES_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_cbc_encrypt)
#define _AES_cfb128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_cfb128_encrypt)
#define _AES_ctr128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_ctr128_encrypt)
#define _AES_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_decrypt)
#define _AES_ecb_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_ecb_encrypt)
#define _AES_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_encrypt)
#define _AES_ofb128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_ofb128_encrypt)
#define _AES_set_decrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_set_decrypt_key)
#define _AES_set_encrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_set_encrypt_key)
#define _AES_unwrap_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_unwrap_key)
#define _AES_unwrap_key_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_unwrap_key_padded)
#define _AES_wrap_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_wrap_key)
#define _AES_wrap_key_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AES_wrap_key_padded)
#define _ASN1_ANY_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ANY_it)
#define _ASN1_BIT_STRING_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_check)
#define _ASN1_BIT_STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_free)
#define _ASN1_BIT_STRING_get_bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_get_bit)
#define _ASN1_BIT_STRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_it)
#define _ASN1_BIT_STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_new)
#define _ASN1_BIT_STRING_num_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_num_bytes)
#define _ASN1_BIT_STRING_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_set)
#define _ASN1_BIT_STRING_set_bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BIT_STRING_set_bit)
#define _ASN1_BMPSTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BMPSTRING_free)
#define _ASN1_BMPSTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BMPSTRING_it)
#define _ASN1_BMPSTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BMPSTRING_new)
#define _ASN1_BOOLEAN_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_BOOLEAN_it)
#define _ASN1_ENUMERATED_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_free)
#define _ASN1_ENUMERATED_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_get)
#define _ASN1_ENUMERATED_get_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_get_int64)
#define _ASN1_ENUMERATED_get_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_get_uint64)
#define _ASN1_ENUMERATED_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_it)
#define _ASN1_ENUMERATED_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_new)
#define _ASN1_ENUMERATED_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_set)
#define _ASN1_ENUMERATED_set_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_set_int64)
#define _ASN1_ENUMERATED_set_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_set_uint64)
#define _ASN1_ENUMERATED_to_BN BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_ENUMERATED_to_BN)
#define _ASN1_FBOOLEAN_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_FBOOLEAN_it)
#define _ASN1_GENERALIZEDTIME_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_adj)
#define _ASN1_GENERALIZEDTIME_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_check)
#define _ASN1_GENERALIZEDTIME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_free)
#define _ASN1_GENERALIZEDTIME_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_it)
#define _ASN1_GENERALIZEDTIME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_new)
#define _ASN1_GENERALIZEDTIME_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_print)
#define _ASN1_GENERALIZEDTIME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_set)
#define _ASN1_GENERALIZEDTIME_set_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALIZEDTIME_set_string)
#define _ASN1_GENERALSTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALSTRING_free)
#define _ASN1_GENERALSTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALSTRING_it)
#define _ASN1_GENERALSTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_GENERALSTRING_new)
#define _ASN1_IA5STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_IA5STRING_free)
#define _ASN1_IA5STRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_IA5STRING_it)
#define _ASN1_IA5STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_IA5STRING_new)
#define _ASN1_INTEGER_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_cmp)
#define _ASN1_INTEGER_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_dup)
#define _ASN1_INTEGER_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_free)
#define _ASN1_INTEGER_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_get)
#define _ASN1_INTEGER_get_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_get_int64)
#define _ASN1_INTEGER_get_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_get_uint64)
#define _ASN1_INTEGER_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_it)
#define _ASN1_INTEGER_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_new)
#define _ASN1_INTEGER_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_set)
#define _ASN1_INTEGER_set_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_set_int64)
#define _ASN1_INTEGER_set_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_set_uint64)
#define _ASN1_INTEGER_to_BN BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_INTEGER_to_BN)
#define _ASN1_NULL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_NULL_free)
#define _ASN1_NULL_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_NULL_it)
#define _ASN1_NULL_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_NULL_new)
#define _ASN1_OBJECT_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OBJECT_create)
#define _ASN1_OBJECT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OBJECT_free)
#define _ASN1_OBJECT_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OBJECT_it)
#define _ASN1_OBJECT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OBJECT_new)
#define _ASN1_OCTET_STRING_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_cmp)
#define _ASN1_OCTET_STRING_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_dup)
#define _ASN1_OCTET_STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_free)
#define _ASN1_OCTET_STRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_it)
#define _ASN1_OCTET_STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_new)
#define _ASN1_OCTET_STRING_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_OCTET_STRING_set)
#define _ASN1_PRINTABLESTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLESTRING_free)
#define _ASN1_PRINTABLESTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLESTRING_it)
#define _ASN1_PRINTABLESTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLESTRING_new)
#define _ASN1_PRINTABLE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLE_free)
#define _ASN1_PRINTABLE_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLE_it)
#define _ASN1_PRINTABLE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_PRINTABLE_new)
#define _ASN1_SEQUENCE_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_SEQUENCE_it)
#define _ASN1_STRING_TABLE_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_TABLE_add)
#define _ASN1_STRING_TABLE_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_TABLE_cleanup)
#define _ASN1_STRING_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_cmp)
#define _ASN1_STRING_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_copy)
#define _ASN1_STRING_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_data)
#define _ASN1_STRING_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_dup)
#define _ASN1_STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_free)
#define _ASN1_STRING_get0_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_get0_data)
#define _ASN1_STRING_get_default_mask BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_get_default_mask)
#define _ASN1_STRING_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_length)
#define _ASN1_STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_new)
#define _ASN1_STRING_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_print)
#define _ASN1_STRING_print_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_print_ex)
#define _ASN1_STRING_print_ex_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_print_ex_fp)
#define _ASN1_STRING_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_set)
#define _ASN1_STRING_set0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_set0)
#define _ASN1_STRING_set_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_set_by_NID)
#define _ASN1_STRING_set_default_mask BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_set_default_mask)
#define _ASN1_STRING_set_default_mask_asc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_set_default_mask_asc)
#define _ASN1_STRING_to_UTF8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_to_UTF8)
#define _ASN1_STRING_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_type)
#define _ASN1_STRING_type_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_STRING_type_new)
#define _ASN1_T61STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_T61STRING_free)
#define _ASN1_T61STRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_T61STRING_it)
#define _ASN1_T61STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_T61STRING_new)
#define _ASN1_TBOOLEAN_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TBOOLEAN_it)
#define _ASN1_TIME_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_adj)
#define _ASN1_TIME_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_check)
#define _ASN1_TIME_diff BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_diff)
#define _ASN1_TIME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_free)
#define _ASN1_TIME_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_it)
#define _ASN1_TIME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_new)
#define _ASN1_TIME_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_print)
#define _ASN1_TIME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_set)
#define _ASN1_TIME_set_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_set_posix)
#define _ASN1_TIME_set_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_set_string)
#define _ASN1_TIME_set_string_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_set_string_X509)
#define _ASN1_TIME_to_generalizedtime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_to_generalizedtime)
#define _ASN1_TIME_to_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_to_posix)
#define _ASN1_TIME_to_posix_nonstandard BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_to_posix_nonstandard)
#define _ASN1_TIME_to_time_t BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TIME_to_time_t)
#define _ASN1_TYPE_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_cmp)
#define _ASN1_TYPE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_free)
#define _ASN1_TYPE_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_get)
#define _ASN1_TYPE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_new)
#define _ASN1_TYPE_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_set)
#define _ASN1_TYPE_set1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_TYPE_set1)
#define _ASN1_UNIVERSALSTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UNIVERSALSTRING_free)
#define _ASN1_UNIVERSALSTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UNIVERSALSTRING_it)
#define _ASN1_UNIVERSALSTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UNIVERSALSTRING_new)
#define _ASN1_UTCTIME_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_adj)
#define _ASN1_UTCTIME_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_check)
#define _ASN1_UTCTIME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_free)
#define _ASN1_UTCTIME_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_it)
#define _ASN1_UTCTIME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_new)
#define _ASN1_UTCTIME_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_print)
#define _ASN1_UTCTIME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_set)
#define _ASN1_UTCTIME_set_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTCTIME_set_string)
#define _ASN1_UTF8STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTF8STRING_free)
#define _ASN1_UTF8STRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTF8STRING_it)
#define _ASN1_UTF8STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_UTF8STRING_new)
#define _ASN1_VISIBLESTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_VISIBLESTRING_free)
#define _ASN1_VISIBLESTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_VISIBLESTRING_it)
#define _ASN1_VISIBLESTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_VISIBLESTRING_new)
#define _ASN1_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_digest)
#define _ASN1_generate_v3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_generate_v3)
#define _ASN1_get_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_get_object)
#define _ASN1_item_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_d2i)
#define _ASN1_item_d2i_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_d2i_bio)
#define _ASN1_item_d2i_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_d2i_fp)
#define _ASN1_item_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_digest)
#define _ASN1_item_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_dup)
#define _ASN1_item_ex_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_ex_d2i)
#define _ASN1_item_ex_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_ex_free)
#define _ASN1_item_ex_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_ex_i2d)
#define _ASN1_item_ex_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_ex_new)
#define _ASN1_item_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_free)
#define _ASN1_item_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_i2d)
#define _ASN1_item_i2d_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_i2d_bio)
#define _ASN1_item_i2d_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_i2d_fp)
#define _ASN1_item_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_new)
#define _ASN1_item_pack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_pack)
#define _ASN1_item_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_sign)
#define _ASN1_item_sign_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_sign_ctx)
#define _ASN1_item_unpack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_unpack)
#define _ASN1_item_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_item_verify)
#define _ASN1_mbstring_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_mbstring_copy)
#define _ASN1_mbstring_ncopy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_mbstring_ncopy)
#define _ASN1_object_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_object_size)
#define _ASN1_primitive_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_primitive_free)
#define _ASN1_put_eoc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_put_eoc)
#define _ASN1_put_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_put_object)
#define _ASN1_tag2bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_tag2bit)
#define _ASN1_tag2str BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_tag2str)
#define _ASN1_template_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ASN1_template_free)
#define _AUTHORITY_INFO_ACCESS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_INFO_ACCESS_free)
#define _AUTHORITY_INFO_ACCESS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_INFO_ACCESS_it)
#define _AUTHORITY_INFO_ACCESS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_INFO_ACCESS_new)
#define _AUTHORITY_KEYID_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_KEYID_free)
#define _AUTHORITY_KEYID_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_KEYID_it)
#define _AUTHORITY_KEYID_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, AUTHORITY_KEYID_new)
#define _BASIC_CONSTRAINTS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BASIC_CONSTRAINTS_free)
#define _BASIC_CONSTRAINTS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BASIC_CONSTRAINTS_it)
#define _BASIC_CONSTRAINTS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BASIC_CONSTRAINTS_new)
#define _BCM_fips_186_2_prf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_fips_186_2_prf)
#define _BCM_mldsa65_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_generate_key)
#define _BCM_mldsa65_generate_key_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_generate_key_external_entropy)
#define _BCM_mldsa65_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_marshal_private_key)
#define _BCM_mldsa65_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_marshal_public_key)
#define _BCM_mldsa65_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_parse_private_key)
#define _BCM_mldsa65_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_parse_public_key)
#define _BCM_mldsa65_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_private_key_from_seed)
#define _BCM_mldsa65_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_public_from_private)
#define _BCM_mldsa65_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_sign)
#define _BCM_mldsa65_sign_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_sign_internal)
#define _BCM_mldsa65_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_verify)
#define _BCM_mldsa65_verify_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa65_verify_internal)
#define _BCM_mldsa87_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_generate_key)
#define _BCM_mldsa87_generate_key_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_generate_key_external_entropy)
#define _BCM_mldsa87_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_marshal_private_key)
#define _BCM_mldsa87_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_marshal_public_key)
#define _BCM_mldsa87_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_parse_private_key)
#define _BCM_mldsa87_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_parse_public_key)
#define _BCM_mldsa87_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_private_key_from_seed)
#define _BCM_mldsa87_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_public_from_private)
#define _BCM_mldsa87_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_sign)
#define _BCM_mldsa87_sign_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_sign_internal)
#define _BCM_mldsa87_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_verify)
#define _BCM_mldsa87_verify_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mldsa87_verify_internal)
#define _BCM_mlkem1024_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_decap)
#define _BCM_mlkem1024_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_encap)
#define _BCM_mlkem1024_encap_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_encap_external_entropy)
#define _BCM_mlkem1024_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_generate_key)
#define _BCM_mlkem1024_generate_key_external_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_generate_key_external_seed)
#define _BCM_mlkem1024_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_marshal_private_key)
#define _BCM_mlkem1024_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_marshal_public_key)
#define _BCM_mlkem1024_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_parse_private_key)
#define _BCM_mlkem1024_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_parse_public_key)
#define _BCM_mlkem1024_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_private_key_from_seed)
#define _BCM_mlkem1024_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem1024_public_from_private)
#define _BCM_mlkem768_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_decap)
#define _BCM_mlkem768_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_encap)
#define _BCM_mlkem768_encap_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_encap_external_entropy)
#define _BCM_mlkem768_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_generate_key)
#define _BCM_mlkem768_generate_key_external_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_generate_key_external_seed)
#define _BCM_mlkem768_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_marshal_private_key)
#define _BCM_mlkem768_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_marshal_public_key)
#define _BCM_mlkem768_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_parse_private_key)
#define _BCM_mlkem768_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_parse_public_key)
#define _BCM_mlkem768_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_private_key_from_seed)
#define _BCM_mlkem768_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_mlkem768_public_from_private)
#define _BCM_rand_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_rand_bytes)
#define _BCM_rand_bytes_hwrng BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_rand_bytes_hwrng)
#define _BCM_rand_bytes_with_additional_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_rand_bytes_with_additional_data)
#define _BCM_sha1_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha1_final)
#define _BCM_sha1_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha1_init)
#define _BCM_sha1_transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha1_transform)
#define _BCM_sha1_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha1_update)
#define _BCM_sha224_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha224_final)
#define _BCM_sha224_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha224_init)
#define _BCM_sha224_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha224_update)
#define _BCM_sha256_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha256_final)
#define _BCM_sha256_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha256_init)
#define _BCM_sha256_transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha256_transform)
#define _BCM_sha256_transform_blocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha256_transform_blocks)
#define _BCM_sha256_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha256_update)
#define _BCM_sha384_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha384_final)
#define _BCM_sha384_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha384_init)
#define _BCM_sha384_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha384_update)
#define _BCM_sha512_256_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_256_final)
#define _BCM_sha512_256_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_256_init)
#define _BCM_sha512_256_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_256_update)
#define _BCM_sha512_final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_final)
#define _BCM_sha512_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_init)
#define _BCM_sha512_transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_transform)
#define _BCM_sha512_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_sha512_update)
#define _BCM_slhdsa_sha2_128s_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_generate_key)
#define _BCM_slhdsa_sha2_128s_generate_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_generate_key_from_seed)
#define _BCM_slhdsa_sha2_128s_prehash_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_prehash_sign)
#define _BCM_slhdsa_sha2_128s_prehash_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_prehash_verify)
#define _BCM_slhdsa_sha2_128s_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_public_from_private)
#define _BCM_slhdsa_sha2_128s_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_sign)
#define _BCM_slhdsa_sha2_128s_sign_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_sign_internal)
#define _BCM_slhdsa_sha2_128s_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_verify)
#define _BCM_slhdsa_sha2_128s_verify_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BCM_slhdsa_sha2_128s_verify_internal)
#define _BIO_append_filename BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_append_filename)
#define _BIO_callback_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_callback_ctrl)
#define _BIO_clear_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_clear_flags)
#define _BIO_clear_retry_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_clear_retry_flags)
#define _BIO_copy_next_retry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_copy_next_retry)
#define _BIO_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_ctrl)
#define _BIO_ctrl_get_read_request BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_ctrl_get_read_request)
#define _BIO_ctrl_get_write_guarantee BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_ctrl_get_write_guarantee)
#define _BIO_ctrl_pending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_ctrl_pending)
#define _BIO_do_connect BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_do_connect)
#define _BIO_eof BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_eof)
#define _BIO_f_ssl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_f_ssl)
#define _BIO_find_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_find_type)
#define _BIO_flush BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_flush)
#define _BIO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_free)
#define _BIO_free_all BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_free_all)
#define _BIO_get_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_data)
#define _BIO_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_ex_data)
#define _BIO_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_ex_new_index)
#define _BIO_get_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_fd)
#define _BIO_get_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_fp)
#define _BIO_get_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_init)
#define _BIO_get_mem_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_mem_data)
#define _BIO_get_mem_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_mem_ptr)
#define _BIO_get_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_new_index)
#define _BIO_get_retry_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_retry_flags)
#define _BIO_get_retry_reason BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_retry_reason)
#define _BIO_get_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_get_shutdown)
#define _BIO_gets BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_gets)
#define _BIO_hexdump BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_hexdump)
#define _BIO_indent BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_indent)
#define _BIO_int_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_int_ctrl)
#define _BIO_mem_contents BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_mem_contents)
#define _BIO_meth_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_free)
#define _BIO_meth_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_new)
#define _BIO_meth_set_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_create)
#define _BIO_meth_set_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_ctrl)
#define _BIO_meth_set_destroy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_destroy)
#define _BIO_meth_set_gets BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_gets)
#define _BIO_meth_set_puts BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_puts)
#define _BIO_meth_set_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_read)
#define _BIO_meth_set_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_meth_set_write)
#define _BIO_method_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_method_type)
#define _BIO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new)
#define _BIO_new_bio_pair BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_bio_pair)
#define _BIO_new_connect BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_connect)
#define _BIO_new_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_fd)
#define _BIO_new_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_file)
#define _BIO_new_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_fp)
#define _BIO_new_mem_buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_mem_buf)
#define _BIO_new_socket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_new_socket)
#define _BIO_next BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_next)
#define _BIO_number_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_number_read)
#define _BIO_number_written BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_number_written)
#define _BIO_pending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_pending)
#define _BIO_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_pop)
#define _BIO_printf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_printf)
#define _BIO_ptr_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_ptr_ctrl)
#define _BIO_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_push)
#define _BIO_puts BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_puts)
#define _BIO_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_read)
#define _BIO_read_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_read_asn1)
#define _BIO_read_filename BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_read_filename)
#define _BIO_reset BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_reset)
#define _BIO_rw_filename BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_rw_filename)
#define _BIO_s_connect BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_s_connect)
#define _BIO_s_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_s_fd)
#define _BIO_s_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_s_file)
#define _BIO_s_mem BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_s_mem)
#define _BIO_s_socket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_s_socket)
#define _BIO_seek BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_seek)
#define _BIO_set_close BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_close)
#define _BIO_set_conn_hostname BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_conn_hostname)
#define _BIO_set_conn_int_port BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_conn_int_port)
#define _BIO_set_conn_port BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_conn_port)
#define _BIO_set_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_data)
#define _BIO_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_ex_data)
#define _BIO_set_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_fd)
#define _BIO_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_flags)
#define _BIO_set_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_fp)
#define _BIO_set_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_init)
#define _BIO_set_mem_buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_mem_buf)
#define _BIO_set_mem_eof_return BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_mem_eof_return)
#define _BIO_set_nbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_nbio)
#define _BIO_set_retry_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_retry_read)
#define _BIO_set_retry_reason BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_retry_reason)
#define _BIO_set_retry_special BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_retry_special)
#define _BIO_set_retry_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_retry_write)
#define _BIO_set_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_shutdown)
#define _BIO_set_ssl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_ssl)
#define _BIO_set_write_buffer_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_set_write_buffer_size)
#define _BIO_should_io_special BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_should_io_special)
#define _BIO_should_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_should_read)
#define _BIO_should_retry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_should_retry)
#define _BIO_should_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_should_write)
#define _BIO_shutdown_wr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_shutdown_wr)
#define _BIO_snprintf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_snprintf)
#define _BIO_tell BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_tell)
#define _BIO_test_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_test_flags)
#define _BIO_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_up_ref)
#define _BIO_vfree BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_vfree)
#define _BIO_vsnprintf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_vsnprintf)
#define _BIO_wpending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_wpending)
#define _BIO_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_write)
#define _BIO_write_all BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_write_all)
#define _BIO_write_filename BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BIO_write_filename)
#define _BLAKE2B256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BLAKE2B256)
#define _BLAKE2B256_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BLAKE2B256_Final)
#define _BLAKE2B256_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BLAKE2B256_Init)
#define _BLAKE2B256_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BLAKE2B256_Update)
#define _BN_BLINDING_convert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_BLINDING_convert)
#define _BN_BLINDING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_BLINDING_free)
#define _BN_BLINDING_invalidate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_BLINDING_invalidate)
#define _BN_BLINDING_invert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_BLINDING_invert)
#define _BN_BLINDING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_BLINDING_new)
#define _BN_CTX_end BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_CTX_end)
#define _BN_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_CTX_free)
#define _BN_CTX_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_CTX_get)
#define _BN_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_CTX_new)
#define _BN_CTX_start BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_CTX_start)
#define _BN_GENCB_call BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_GENCB_call)
#define _BN_GENCB_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_GENCB_free)
#define _BN_GENCB_get_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_GENCB_get_arg)
#define _BN_GENCB_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_GENCB_new)
#define _BN_GENCB_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_GENCB_set)
#define _BN_MONT_CTX_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_copy)
#define _BN_MONT_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_free)
#define _BN_MONT_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_new)
#define _BN_MONT_CTX_new_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_new_consttime)
#define _BN_MONT_CTX_new_for_modulus BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_new_for_modulus)
#define _BN_MONT_CTX_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_set)
#define _BN_MONT_CTX_set_locked BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_MONT_CTX_set_locked)
#define _BN_abs_is_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_abs_is_word)
#define _BN_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_add)
#define _BN_add_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_add_word)
#define _BN_asc2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_asc2bn)
#define _BN_bin2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bin2bn)
#define _BN_bn2bin BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2bin)
#define _BN_bn2bin_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2bin_padded)
#define _BN_bn2binpad BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2binpad)
#define _BN_bn2cbb_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2cbb_padded)
#define _BN_bn2dec BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2dec)
#define _BN_bn2hex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2hex)
#define _BN_bn2le_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2le_padded)
#define _BN_bn2lebinpad BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2lebinpad)
#define _BN_bn2mpi BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_bn2mpi)
#define _BN_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_clear)
#define _BN_clear_bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_clear_bit)
#define _BN_clear_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_clear_free)
#define _BN_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_cmp)
#define _BN_cmp_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_cmp_word)
#define _BN_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_copy)
#define _BN_count_low_zero_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_count_low_zero_bits)
#define _BN_dec2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_dec2bn)
#define _BN_div BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_div)
#define _BN_div_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_div_word)
#define _BN_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_dup)
#define _BN_enhanced_miller_rabin_primality_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_enhanced_miller_rabin_primality_test)
#define _BN_equal_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_equal_consttime)
#define _BN_exp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_exp)
#define _BN_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_free)
#define _BN_from_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_from_montgomery)
#define _BN_gcd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_gcd)
#define _BN_generate_prime_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_generate_prime_ex)
#define _BN_get_rfc3526_prime_1536 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_1536)
#define _BN_get_rfc3526_prime_2048 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_2048)
#define _BN_get_rfc3526_prime_3072 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_3072)
#define _BN_get_rfc3526_prime_4096 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_4096)
#define _BN_get_rfc3526_prime_6144 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_6144)
#define _BN_get_rfc3526_prime_8192 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_rfc3526_prime_8192)
#define _BN_get_u64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_u64)
#define _BN_get_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_get_word)
#define _BN_hex2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_hex2bn)
#define _BN_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_init)
#define _BN_is_bit_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_bit_set)
#define _BN_is_negative BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_negative)
#define _BN_is_odd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_odd)
#define _BN_is_one BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_one)
#define _BN_is_pow2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_pow2)
#define _BN_is_prime_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_prime_ex)
#define _BN_is_prime_fasttest_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_prime_fasttest_ex)
#define _BN_is_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_word)
#define _BN_is_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_is_zero)
#define _BN_le2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_le2bn)
#define _BN_lebin2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_lebin2bn)
#define _BN_lshift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_lshift)
#define _BN_lshift1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_lshift1)
#define _BN_marshal_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_marshal_asn1)
#define _BN_mask_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mask_bits)
#define _BN_mod_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_add)
#define _BN_mod_add_quick BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_add_quick)
#define _BN_mod_exp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_exp)
#define _BN_mod_exp2_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_exp2_mont)
#define _BN_mod_exp_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_exp_mont)
#define _BN_mod_exp_mont_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_exp_mont_consttime)
#define _BN_mod_exp_mont_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_exp_mont_word)
#define _BN_mod_inverse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_inverse)
#define _BN_mod_inverse_blinded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_inverse_blinded)
#define _BN_mod_inverse_odd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_inverse_odd)
#define _BN_mod_lshift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_lshift)
#define _BN_mod_lshift1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_lshift1)
#define _BN_mod_lshift1_quick BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_lshift1_quick)
#define _BN_mod_lshift_quick BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_lshift_quick)
#define _BN_mod_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_mul)
#define _BN_mod_mul_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_mul_montgomery)
#define _BN_mod_pow2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_pow2)
#define _BN_mod_sqr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_sqr)
#define _BN_mod_sqrt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_sqrt)
#define _BN_mod_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_sub)
#define _BN_mod_sub_quick BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_sub_quick)
#define _BN_mod_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mod_word)
#define _BN_mpi2bn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mpi2bn)
#define _BN_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mul)
#define _BN_mul_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_mul_word)
#define _BN_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_new)
#define _BN_nnmod BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_nnmod)
#define _BN_nnmod_pow2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_nnmod_pow2)
#define _BN_num_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_num_bits)
#define _BN_num_bits_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_num_bits_word)
#define _BN_num_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_num_bytes)
#define _BN_one BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_one)
#define _BN_parse_asn1_unsigned BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_parse_asn1_unsigned)
#define _BN_primality_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_primality_test)
#define _BN_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_print)
#define _BN_print_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_print_fp)
#define _BN_pseudo_rand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_pseudo_rand)
#define _BN_pseudo_rand_range BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_pseudo_rand_range)
#define _BN_rand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_rand)
#define _BN_rand_range BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_rand_range)
#define _BN_rand_range_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_rand_range_ex)
#define _BN_rshift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_rshift)
#define _BN_rshift1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_rshift1)
#define _BN_secure_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_secure_new)
#define _BN_set_bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_set_bit)
#define _BN_set_negative BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_set_negative)
#define _BN_set_u64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_set_u64)
#define _BN_set_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_set_word)
#define _BN_sqr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_sqr)
#define _BN_sqrt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_sqrt)
#define _BN_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_sub)
#define _BN_sub_word BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_sub_word)
#define _BN_to_ASN1_ENUMERATED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_to_ASN1_ENUMERATED)
#define _BN_to_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_to_ASN1_INTEGER)
#define _BN_to_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_to_montgomery)
#define _BN_uadd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_uadd)
#define _BN_ucmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_ucmp)
#define _BN_usub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_usub)
#define _BN_value_one BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_value_one)
#define _BN_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BN_zero)
#define _BORINGSSL_keccak BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BORINGSSL_keccak)
#define _BORINGSSL_keccak_absorb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BORINGSSL_keccak_absorb)
#define _BORINGSSL_keccak_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BORINGSSL_keccak_init)
#define _BORINGSSL_keccak_squeeze BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BORINGSSL_keccak_squeeze)
#define _BORINGSSL_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BORINGSSL_self_test)
#define _BUF_MEM_append BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_append)
#define _BUF_MEM_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_free)
#define _BUF_MEM_grow BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_grow)
#define _BUF_MEM_grow_clean BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_grow_clean)
#define _BUF_MEM_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_new)
#define _BUF_MEM_reserve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_MEM_reserve)
#define _BUF_memdup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_memdup)
#define _BUF_strdup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_strdup)
#define _BUF_strlcat BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_strlcat)
#define _BUF_strlcpy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_strlcpy)
#define _BUF_strndup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_strndup)
#define _BUF_strnlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, BUF_strnlen)
#define _CBB_add_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1)
#define _CBB_add_asn1_bool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_bool)
#define _CBB_add_asn1_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_int64)
#define _CBB_add_asn1_int64_with_tag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_int64_with_tag)
#define _CBB_add_asn1_octet_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_octet_string)
#define _CBB_add_asn1_oid_from_text BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_oid_from_text)
#define _CBB_add_asn1_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_uint64)
#define _CBB_add_asn1_uint64_with_tag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_asn1_uint64_with_tag)
#define _CBB_add_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_bytes)
#define _CBB_add_latin1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_latin1)
#define _CBB_add_space BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_space)
#define _CBB_add_u16 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u16)
#define _CBB_add_u16_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u16_length_prefixed)
#define _CBB_add_u16le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u16le)
#define _CBB_add_u24 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u24)
#define _CBB_add_u24_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u24_length_prefixed)
#define _CBB_add_u32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u32)
#define _CBB_add_u32le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u32le)
#define _CBB_add_u64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u64)
#define _CBB_add_u64le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u64le)
#define _CBB_add_u8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u8)
#define _CBB_add_u8_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_u8_length_prefixed)
#define _CBB_add_ucs2_be BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_ucs2_be)
#define _CBB_add_utf32_be BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_utf32_be)
#define _CBB_add_utf8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_utf8)
#define _CBB_add_zeros BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_add_zeros)
#define _CBB_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_cleanup)
#define _CBB_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_data)
#define _CBB_did_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_did_write)
#define _CBB_discard_child BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_discard_child)
#define _CBB_finish BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_finish)
#define _CBB_finish_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_finish_i2d)
#define _CBB_flush BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_flush)
#define _CBB_flush_asn1_set_of BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_flush_asn1_set_of)
#define _CBB_get_utf8_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_get_utf8_len)
#define _CBB_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_init)
#define _CBB_init_fixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_init_fixed)
#define _CBB_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_len)
#define _CBB_reserve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_reserve)
#define _CBB_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBB_zero)
#define _CBS_asn1_ber_to_der BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_asn1_ber_to_der)
#define _CBS_asn1_bitstring_has_bit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_asn1_bitstring_has_bit)
#define _CBS_asn1_oid_to_text BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_asn1_oid_to_text)
#define _CBS_contains_zero_byte BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_contains_zero_byte)
#define _CBS_copy_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_copy_bytes)
#define _CBS_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_data)
#define _CBS_get_any_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_any_asn1)
#define _CBS_get_any_asn1_element BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_any_asn1_element)
#define _CBS_get_any_ber_asn1_element BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_any_ber_asn1_element)
#define _CBS_get_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1)
#define _CBS_get_asn1_bool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1_bool)
#define _CBS_get_asn1_element BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1_element)
#define _CBS_get_asn1_implicit_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1_implicit_string)
#define _CBS_get_asn1_int64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1_int64)
#define _CBS_get_asn1_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_asn1_uint64)
#define _CBS_get_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_bytes)
#define _CBS_get_last_u8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_last_u8)
#define _CBS_get_latin1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_latin1)
#define _CBS_get_optional_asn1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_optional_asn1)
#define _CBS_get_optional_asn1_bool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_optional_asn1_bool)
#define _CBS_get_optional_asn1_octet_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_optional_asn1_octet_string)
#define _CBS_get_optional_asn1_uint64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_optional_asn1_uint64)
#define _CBS_get_u16 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u16)
#define _CBS_get_u16_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u16_length_prefixed)
#define _CBS_get_u16le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u16le)
#define _CBS_get_u24 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u24)
#define _CBS_get_u24_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u24_length_prefixed)
#define _CBS_get_u32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u32)
#define _CBS_get_u32le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u32le)
#define _CBS_get_u64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u64)
#define _CBS_get_u64_decimal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u64_decimal)
#define _CBS_get_u64le BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u64le)
#define _CBS_get_u8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u8)
#define _CBS_get_u8_length_prefixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_u8_length_prefixed)
#define _CBS_get_ucs2_be BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_ucs2_be)
#define _CBS_get_until_first BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_until_first)
#define _CBS_get_utf32_be BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_utf32_be)
#define _CBS_get_utf8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_get_utf8)
#define _CBS_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_init)
#define _CBS_is_unsigned_asn1_integer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_is_unsigned_asn1_integer)
#define _CBS_is_valid_asn1_bitstring BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_is_valid_asn1_bitstring)
#define _CBS_is_valid_asn1_integer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_is_valid_asn1_integer)
#define _CBS_is_valid_asn1_oid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_is_valid_asn1_oid)
#define _CBS_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_len)
#define _CBS_mem_equal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_mem_equal)
#define _CBS_parse_generalized_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_parse_generalized_time)
#define _CBS_parse_utc_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_parse_utc_time)
#define _CBS_peek_asn1_tag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_peek_asn1_tag)
#define _CBS_skip BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_skip)
#define _CBS_stow BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_stow)
#define _CBS_strdup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CBS_strdup)
#define _CERTIFICATEPOLICIES_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CERTIFICATEPOLICIES_free)
#define _CERTIFICATEPOLICIES_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CERTIFICATEPOLICIES_it)
#define _CERTIFICATEPOLICIES_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CERTIFICATEPOLICIES_new)
#define _CMAC_CTX_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_CTX_copy)
#define _CMAC_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_CTX_free)
#define _CMAC_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_CTX_new)
#define _CMAC_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_Final)
#define _CMAC_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_Init)
#define _CMAC_Reset BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_Reset)
#define _CMAC_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CMAC_Update)
#define _CONF_VALUE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CONF_VALUE_new)
#define _CONF_modules_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CONF_modules_free)
#define _CONF_modules_load_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CONF_modules_load_file)
#define _CONF_parse_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CONF_parse_list)
#define _CRL_DIST_POINTS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRL_DIST_POINTS_free)
#define _CRL_DIST_POINTS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRL_DIST_POINTS_it)
#define _CRL_DIST_POINTS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRL_DIST_POINTS_new)
#define _CRYPTO_BUFFER_POOL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_POOL_free)
#define _CRYPTO_BUFFER_POOL_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_POOL_new)
#define _CRYPTO_BUFFER_alloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_alloc)
#define _CRYPTO_BUFFER_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_data)
#define _CRYPTO_BUFFER_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_free)
#define _CRYPTO_BUFFER_init_CBS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_init_CBS)
#define _CRYPTO_BUFFER_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_len)
#define _CRYPTO_BUFFER_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_new)
#define _CRYPTO_BUFFER_new_from_CBS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_new_from_CBS)
#define _CRYPTO_BUFFER_new_from_static_data_unsafe BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_new_from_static_data_unsafe)
#define _CRYPTO_BUFFER_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_BUFFER_up_ref)
#define _CRYPTO_MUTEX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_cleanup)
#define _CRYPTO_MUTEX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_init)
#define _CRYPTO_MUTEX_lock_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_lock_read)
#define _CRYPTO_MUTEX_lock_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_lock_write)
#define _CRYPTO_MUTEX_unlock_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_unlock_read)
#define _CRYPTO_MUTEX_unlock_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_MUTEX_unlock_write)
#define _CRYPTO_POLYVAL_finish BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_POLYVAL_finish)
#define _CRYPTO_POLYVAL_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_POLYVAL_init)
#define _CRYPTO_POLYVAL_update_blocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_POLYVAL_update_blocks)
#define _CRYPTO_THREADID_current BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_THREADID_current)
#define _CRYPTO_THREADID_set_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_THREADID_set_callback)
#define _CRYPTO_THREADID_set_numeric BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_THREADID_set_numeric)
#define _CRYPTO_THREADID_set_pointer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_THREADID_set_pointer)
#define _CRYPTO_atomic_compare_exchange_weak_u32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_atomic_compare_exchange_weak_u32)
#define _CRYPTO_atomic_load_u32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_atomic_load_u32)
#define _CRYPTO_atomic_store_u32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_atomic_store_u32)
#define _CRYPTO_cbc128_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cbc128_decrypt)
#define _CRYPTO_cbc128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cbc128_encrypt)
#define _CRYPTO_cfb128_1_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cfb128_1_encrypt)
#define _CRYPTO_cfb128_8_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cfb128_8_encrypt)
#define _CRYPTO_cfb128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cfb128_encrypt)
#define _CRYPTO_chacha_20 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_chacha_20)
#define _CRYPTO_cleanup_all_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cleanup_all_ex_data)
#define _CRYPTO_cpu_avoid_zmm_registers BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cpu_avoid_zmm_registers)
#define _CRYPTO_cpu_perf_is_like_silvermont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_cpu_perf_is_like_silvermont)
#define _CRYPTO_ctr128_encrypt_ctr32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_ctr128_encrypt_ctr32)
#define _CRYPTO_fips_186_2_prf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_fips_186_2_prf)
#define _CRYPTO_fork_detect_force_madv_wipeonfork_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_fork_detect_force_madv_wipeonfork_for_testing)
#define _CRYPTO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_free)
#define _CRYPTO_free_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_free_ex_data)
#define _CRYPTO_gcm128_aad BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_aad)
#define _CRYPTO_gcm128_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_decrypt)
#define _CRYPTO_gcm128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_encrypt)
#define _CRYPTO_gcm128_finish BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_finish)
#define _CRYPTO_gcm128_init_aes_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_init_aes_key)
#define _CRYPTO_gcm128_init_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_init_ctx)
#define _CRYPTO_gcm128_tag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_gcm128_tag)
#define _CRYPTO_get_dynlock_create_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_dynlock_create_callback)
#define _CRYPTO_get_dynlock_destroy_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_dynlock_destroy_callback)
#define _CRYPTO_get_dynlock_lock_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_dynlock_lock_callback)
#define _CRYPTO_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_ex_data)
#define _CRYPTO_get_ex_new_index_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_ex_new_index_ex)
#define _CRYPTO_get_fork_generation BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_fork_generation)
#define _CRYPTO_get_lock_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_lock_name)
#define _CRYPTO_get_locking_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_locking_callback)
#define _CRYPTO_get_stderr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_stderr)
#define _CRYPTO_get_thread_local BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_get_thread_local)
#define _CRYPTO_ghash_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_ghash_init)
#define _CRYPTO_has_asm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_has_asm)
#define _CRYPTO_hchacha20 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_hchacha20)
#define _CRYPTO_init_sysrand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_init_sysrand)
#define _CRYPTO_is_ADX_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ADX_capable)
#define _CRYPTO_is_AESNI_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_AESNI_capable)
#define _CRYPTO_is_ARMv8_AES_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ARMv8_AES_capable)
#define _CRYPTO_is_ARMv8_PMULL_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ARMv8_PMULL_capable)
#define _CRYPTO_is_ARMv8_SHA1_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ARMv8_SHA1_capable)
#define _CRYPTO_is_ARMv8_SHA256_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ARMv8_SHA256_capable)
#define _CRYPTO_is_ARMv8_SHA512_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_ARMv8_SHA512_capable)
#define _CRYPTO_is_AVX2_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_AVX2_capable)
#define _CRYPTO_is_AVX512BW_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_AVX512BW_capable)
#define _CRYPTO_is_AVX512VL_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_AVX512VL_capable)
#define _CRYPTO_is_AVX_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_AVX_capable)
#define _CRYPTO_is_BMI1_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_BMI1_capable)
#define _CRYPTO_is_BMI2_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_BMI2_capable)
#define _CRYPTO_is_FXSR_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_FXSR_capable)
#define _CRYPTO_is_MOVBE_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_MOVBE_capable)
#define _CRYPTO_is_NEON_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_NEON_capable)
#define _CRYPTO_is_PCLMUL_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_PCLMUL_capable)
#define _CRYPTO_is_RDRAND_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_RDRAND_capable)
#define _CRYPTO_is_SSE4_1_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_SSE4_1_capable)
#define _CRYPTO_is_SSSE3_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_SSSE3_capable)
#define _CRYPTO_is_VAES_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_VAES_capable)
#define _CRYPTO_is_VPCLMULQDQ_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_VPCLMULQDQ_capable)
#define _CRYPTO_is_confidential_build BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_confidential_build)
#define _CRYPTO_is_intel_cpu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_intel_cpu)
#define _CRYPTO_is_x86_SHA_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_is_x86_SHA_capable)
#define _CRYPTO_library_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_library_init)
#define _CRYPTO_malloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_malloc)
#define _CRYPTO_malloc_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_malloc_init)
#define _CRYPTO_memcmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_memcmp)
#define _CRYPTO_new_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_new_ex_data)
#define _CRYPTO_num_locks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_num_locks)
#define _CRYPTO_ofb128_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_ofb128_encrypt)
#define _CRYPTO_once BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_once)
#define _CRYPTO_poly1305_finish BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_poly1305_finish)
#define _CRYPTO_poly1305_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_poly1305_init)
#define _CRYPTO_poly1305_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_poly1305_update)
#define _CRYPTO_pre_sandbox_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_pre_sandbox_init)
#define _CRYPTO_rdrand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_rdrand)
#define _CRYPTO_rdrand_multiple8_buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_rdrand_multiple8_buf)
#define _CRYPTO_realloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_realloc)
#define _CRYPTO_refcount_dec_and_test_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_refcount_dec_and_test_zero)
#define _CRYPTO_refcount_inc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_refcount_inc)
#define _CRYPTO_secure_malloc_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_secure_malloc_init)
#define _CRYPTO_secure_malloc_initialized BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_secure_malloc_initialized)
#define _CRYPTO_secure_used BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_secure_used)
#define _CRYPTO_set_add_lock_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_add_lock_callback)
#define _CRYPTO_set_dynlock_create_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_dynlock_create_callback)
#define _CRYPTO_set_dynlock_destroy_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_dynlock_destroy_callback)
#define _CRYPTO_set_dynlock_lock_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_dynlock_lock_callback)
#define _CRYPTO_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_ex_data)
#define _CRYPTO_set_id_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_id_callback)
#define _CRYPTO_set_locking_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_locking_callback)
#define _CRYPTO_set_thread_local BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_set_thread_local)
#define _CRYPTO_sysrand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_sysrand)
#define _CRYPTO_sysrand_for_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_sysrand_for_seed)
#define _CRYPTO_sysrand_if_available BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_sysrand_if_available)
#define _CRYPTO_tls13_hkdf_expand_label BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_tls13_hkdf_expand_label)
#define _CRYPTO_tls1_prf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_tls1_prf)
#define _CRYPTO_xor16 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CRYPTO_xor16)
#define _CTR_DRBG_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_clear)
#define _CTR_DRBG_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_free)
#define _CTR_DRBG_generate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_generate)
#define _CTR_DRBG_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_init)
#define _CTR_DRBG_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_new)
#define _CTR_DRBG_reseed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, CTR_DRBG_reseed)
#define _ChaCha20_ctr32_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_avx2)
#define _ChaCha20_ctr32_avx2_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_avx2_capable)
#define _ChaCha20_ctr32_neon BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_neon)
#define _ChaCha20_ctr32_neon_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_neon_capable)
#define _ChaCha20_ctr32_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_nohw)
#define _ChaCha20_ctr32_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_ssse3)
#define _ChaCha20_ctr32_ssse3_4x BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_ssse3_4x)
#define _ChaCha20_ctr32_ssse3_4x_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_ssse3_4x_capable)
#define _ChaCha20_ctr32_ssse3_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ChaCha20_ctr32_ssse3_capable)
#define _DES_decrypt3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_decrypt3)
#define _DES_ecb3_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ecb3_encrypt)
#define _DES_ecb3_encrypt_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ecb3_encrypt_ex)
#define _DES_ecb_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ecb_encrypt)
#define _DES_ecb_encrypt_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ecb_encrypt_ex)
#define _DES_ede2_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ede2_cbc_encrypt)
#define _DES_ede3_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ede3_cbc_encrypt)
#define _DES_ede3_cbc_encrypt_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ede3_cbc_encrypt_ex)
#define _DES_encrypt3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_encrypt3)
#define _DES_ncbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ncbc_encrypt)
#define _DES_ncbc_encrypt_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_ncbc_encrypt_ex)
#define _DES_set_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_set_key)
#define _DES_set_key_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_set_key_ex)
#define _DES_set_key_unchecked BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_set_key_unchecked)
#define _DES_set_odd_parity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DES_set_odd_parity)
#define _DH_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_bits)
#define _DH_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_check)
#define _DH_check_pub_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_check_pub_key)
#define _DH_compute_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_compute_key)
#define _DH_compute_key_hashed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_compute_key_hashed)
#define _DH_compute_key_padded BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_compute_key_padded)
#define _DH_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_free)
#define _DH_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_generate_key)
#define _DH_generate_parameters_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_generate_parameters_ex)
#define _DH_get0_g BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_g)
#define _DH_get0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_key)
#define _DH_get0_p BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_p)
#define _DH_get0_pqg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_pqg)
#define _DH_get0_priv_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_priv_key)
#define _DH_get0_pub_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_pub_key)
#define _DH_get0_q BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get0_q)
#define _DH_get_rfc7919_2048 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_get_rfc7919_2048)
#define _DH_marshal_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_marshal_parameters)
#define _DH_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_new)
#define _DH_num_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_num_bits)
#define _DH_parse_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_parse_parameters)
#define _DH_set0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_set0_key)
#define _DH_set0_pqg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_set0_pqg)
#define _DH_set_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_set_length)
#define _DH_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_size)
#define _DH_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DH_up_ref)
#define _DHparams_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DHparams_dup)
#define _DIRECTORYSTRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIRECTORYSTRING_free)
#define _DIRECTORYSTRING_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIRECTORYSTRING_it)
#define _DIRECTORYSTRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIRECTORYSTRING_new)
#define _DISPLAYTEXT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DISPLAYTEXT_free)
#define _DISPLAYTEXT_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DISPLAYTEXT_it)
#define _DISPLAYTEXT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DISPLAYTEXT_new)
#define _DIST_POINT_NAME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIST_POINT_NAME_free)
#define _DIST_POINT_NAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIST_POINT_NAME_new)
#define _DIST_POINT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIST_POINT_free)
#define _DIST_POINT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIST_POINT_new)
#define _DIST_POINT_set_dpname BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DIST_POINT_set_dpname)
#define _DSA_SIG_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_free)
#define _DSA_SIG_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_get0)
#define _DSA_SIG_marshal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_marshal)
#define _DSA_SIG_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_new)
#define _DSA_SIG_parse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_parse)
#define _DSA_SIG_set0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_SIG_set0)
#define _DSA_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_bits)
#define _DSA_check_signature BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_check_signature)
#define _DSA_do_check_signature BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_do_check_signature)
#define _DSA_do_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_do_sign)
#define _DSA_do_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_do_verify)
#define _DSA_dup_DH BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_dup_DH)
#define _DSA_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_free)
#define _DSA_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_generate_key)
#define _DSA_generate_parameters_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_generate_parameters_ex)
#define _DSA_get0_g BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_g)
#define _DSA_get0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_key)
#define _DSA_get0_p BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_p)
#define _DSA_get0_pqg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_pqg)
#define _DSA_get0_priv_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_priv_key)
#define _DSA_get0_pub_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_pub_key)
#define _DSA_get0_q BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get0_q)
#define _DSA_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get_ex_data)
#define _DSA_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_get_ex_new_index)
#define _DSA_marshal_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_marshal_parameters)
#define _DSA_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_marshal_private_key)
#define _DSA_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_marshal_public_key)
#define _DSA_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_new)
#define _DSA_parse_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_parse_parameters)
#define _DSA_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_parse_private_key)
#define _DSA_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_parse_public_key)
#define _DSA_set0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_set0_key)
#define _DSA_set0_pqg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_set0_pqg)
#define _DSA_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_set_ex_data)
#define _DSA_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_sign)
#define _DSA_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_size)
#define _DSA_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_up_ref)
#define _DSA_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSA_verify)
#define _DSAparams_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DSAparams_dup)
#define _DTLS_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLS_client_method)
#define _DTLS_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLS_method)
#define _DTLS_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLS_server_method)
#define _DTLS_with_buffers_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLS_with_buffers_method)
#define _DTLSv1_2_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_2_client_method)
#define _DTLSv1_2_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_2_method)
#define _DTLSv1_2_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_2_server_method)
#define _DTLSv1_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_client_method)
#define _DTLSv1_get_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_get_timeout)
#define _DTLSv1_handle_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_handle_timeout)
#define _DTLSv1_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_method)
#define _DTLSv1_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_server_method)
#define _DTLSv1_set_initial_timeout_duration BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, DTLSv1_set_initial_timeout_duration)
#define _ECDH_compute_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDH_compute_key)
#define _ECDH_compute_key_fips BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDH_compute_key_fips)
#define _ECDSA_SIG_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_free)
#define _ECDSA_SIG_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_from_bytes)
#define _ECDSA_SIG_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_get0)
#define _ECDSA_SIG_get0_r BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_get0_r)
#define _ECDSA_SIG_get0_s BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_get0_s)
#define _ECDSA_SIG_marshal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_marshal)
#define _ECDSA_SIG_max_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_max_len)
#define _ECDSA_SIG_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_new)
#define _ECDSA_SIG_parse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_parse)
#define _ECDSA_SIG_set0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_set0)
#define _ECDSA_SIG_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_SIG_to_bytes)
#define _ECDSA_do_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_do_sign)
#define _ECDSA_do_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_do_verify)
#define _ECDSA_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_sign)
#define _ECDSA_sign_with_nonce_and_leak_private_key_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_sign_with_nonce_and_leak_private_key_for_testing)
#define _ECDSA_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_size)
#define _ECDSA_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ECDSA_verify)
#define _EC_GFp_mont_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GFp_mont_method)
#define _EC_GFp_nistp224_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GFp_nistp224_method)
#define _EC_GFp_nistp256_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GFp_nistp256_method)
#define _EC_GFp_nistz256_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GFp_nistz256_method)
#define _EC_GROUP_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_cmp)
#define _EC_GROUP_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_dup)
#define _EC_GROUP_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_free)
#define _EC_GROUP_get0_generator BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get0_generator)
#define _EC_GROUP_get0_order BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get0_order)
#define _EC_GROUP_get_asn1_flag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_asn1_flag)
#define _EC_GROUP_get_cofactor BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_cofactor)
#define _EC_GROUP_get_curve_GFp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_curve_GFp)
#define _EC_GROUP_get_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_curve_name)
#define _EC_GROUP_get_degree BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_degree)
#define _EC_GROUP_get_order BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_get_order)
#define _EC_GROUP_method_of BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_method_of)
#define _EC_GROUP_new_by_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_new_by_curve_name)
#define _EC_GROUP_new_curve_GFp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_new_curve_GFp)
#define _EC_GROUP_order_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_order_bits)
#define _EC_GROUP_set_asn1_flag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_set_asn1_flag)
#define _EC_GROUP_set_generator BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_set_generator)
#define _EC_GROUP_set_point_conversion_form BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_GROUP_set_point_conversion_form)
#define _EC_KEY_check_fips BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_check_fips)
#define _EC_KEY_check_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_check_key)
#define _EC_KEY_derive_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_derive_from_secret)
#define _EC_KEY_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_dup)
#define _EC_KEY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_free)
#define _EC_KEY_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_generate_key)
#define _EC_KEY_generate_key_fips BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_generate_key_fips)
#define _EC_KEY_get0_group BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get0_group)
#define _EC_KEY_get0_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get0_private_key)
#define _EC_KEY_get0_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get0_public_key)
#define _EC_KEY_get_conv_form BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get_conv_form)
#define _EC_KEY_get_enc_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get_enc_flags)
#define _EC_KEY_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get_ex_data)
#define _EC_KEY_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_get_ex_new_index)
#define _EC_KEY_is_opaque BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_is_opaque)
#define _EC_KEY_key2buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_key2buf)
#define _EC_KEY_marshal_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_marshal_curve_name)
#define _EC_KEY_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_marshal_private_key)
#define _EC_KEY_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_new)
#define _EC_KEY_new_by_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_new_by_curve_name)
#define _EC_KEY_new_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_new_method)
#define _EC_KEY_oct2key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_oct2key)
#define _EC_KEY_oct2priv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_oct2priv)
#define _EC_KEY_parse_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_parse_curve_name)
#define _EC_KEY_parse_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_parse_parameters)
#define _EC_KEY_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_parse_private_key)
#define _EC_KEY_priv2buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_priv2buf)
#define _EC_KEY_priv2oct BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_priv2oct)
#define _EC_KEY_set_asn1_flag BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_asn1_flag)
#define _EC_KEY_set_conv_form BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_conv_form)
#define _EC_KEY_set_enc_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_enc_flags)
#define _EC_KEY_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_ex_data)
#define _EC_KEY_set_group BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_group)
#define _EC_KEY_set_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_private_key)
#define _EC_KEY_set_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_public_key)
#define _EC_KEY_set_public_key_affine_coordinates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_set_public_key_affine_coordinates)
#define _EC_KEY_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_KEY_up_ref)
#define _EC_METHOD_get_field_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_METHOD_get_field_type)
#define _EC_POINT_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_add)
#define _EC_POINT_clear_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_clear_free)
#define _EC_POINT_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_cmp)
#define _EC_POINT_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_copy)
#define _EC_POINT_dbl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_dbl)
#define _EC_POINT_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_dup)
#define _EC_POINT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_free)
#define _EC_POINT_get_affine_coordinates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_get_affine_coordinates)
#define _EC_POINT_get_affine_coordinates_GFp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_get_affine_coordinates_GFp)
#define _EC_POINT_invert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_invert)
#define _EC_POINT_is_at_infinity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_is_at_infinity)
#define _EC_POINT_is_on_curve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_is_on_curve)
#define _EC_POINT_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_mul)
#define _EC_POINT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_new)
#define _EC_POINT_oct2point BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_oct2point)
#define _EC_POINT_point2buf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_point2buf)
#define _EC_POINT_point2cbb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_point2cbb)
#define _EC_POINT_point2oct BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_point2oct)
#define _EC_POINT_set_affine_coordinates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_set_affine_coordinates)
#define _EC_POINT_set_affine_coordinates_GFp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_set_affine_coordinates_GFp)
#define _EC_POINT_set_compressed_coordinates_GFp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_set_compressed_coordinates_GFp)
#define _EC_POINT_set_to_infinity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_POINT_set_to_infinity)
#define _EC_curve_nid2nist BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_curve_nid2nist)
#define _EC_curve_nist2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_curve_nist2nid)
#define _EC_get_builtin_curves BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_get_builtin_curves)
#define _EC_group_p224 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_group_p224)
#define _EC_group_p256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_group_p256)
#define _EC_group_p384 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_group_p384)
#define _EC_group_p521 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_group_p521)
#define _EC_hash_to_curve_p256_xmd_sha256_sswu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_hash_to_curve_p256_xmd_sha256_sswu)
#define _EC_hash_to_curve_p384_xmd_sha384_sswu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EC_hash_to_curve_p384_xmd_sha384_sswu)
#define _ED25519_keypair BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ED25519_keypair)
#define _ED25519_keypair_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ED25519_keypair_from_seed)
#define _ED25519_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ED25519_sign)
#define _ED25519_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ED25519_verify)
#define _EDIPARTYNAME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EDIPARTYNAME_free)
#define _EDIPARTYNAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EDIPARTYNAME_new)
#define _ENGINE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_free)
#define _ENGINE_get_ECDSA_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_get_ECDSA_method)
#define _ENGINE_get_RSA_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_get_RSA_method)
#define _ENGINE_load_builtin_engines BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_load_builtin_engines)
#define _ENGINE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_new)
#define _ENGINE_register_all_complete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_register_all_complete)
#define _ENGINE_set_ECDSA_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_set_ECDSA_method)
#define _ENGINE_set_RSA_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ENGINE_set_RSA_method)
#define _ERR_GET_LIB BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_GET_LIB)
#define _ERR_GET_REASON BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_GET_REASON)
#define _ERR_SAVE_STATE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_SAVE_STATE_free)
#define _ERR_add_error_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_add_error_data)
#define _ERR_add_error_dataf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_add_error_dataf)
#define _ERR_clear_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_clear_error)
#define _ERR_clear_system_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_clear_system_error)
#define _ERR_error_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_error_string)
#define _ERR_error_string_n BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_error_string_n)
#define _ERR_free_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_free_strings)
#define _ERR_func_error_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_func_error_string)
#define _ERR_get_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_get_error)
#define _ERR_get_error_line BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_get_error_line)
#define _ERR_get_error_line_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_get_error_line_data)
#define _ERR_get_next_error_library BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_get_next_error_library)
#define _ERR_lib_error_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_lib_error_string)
#define _ERR_lib_symbol_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_lib_symbol_name)
#define _ERR_load_BIO_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_load_BIO_strings)
#define _ERR_load_ERR_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_load_ERR_strings)
#define _ERR_load_RAND_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_load_RAND_strings)
#define _ERR_load_SSL_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_load_SSL_strings)
#define _ERR_load_crypto_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_load_crypto_strings)
#define _ERR_peek_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_error)
#define _ERR_peek_error_line BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_error_line)
#define _ERR_peek_error_line_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_error_line_data)
#define _ERR_peek_last_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_last_error)
#define _ERR_peek_last_error_line BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_last_error_line)
#define _ERR_peek_last_error_line_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_peek_last_error_line_data)
#define _ERR_pop_to_mark BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_pop_to_mark)
#define _ERR_print_errors BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_print_errors)
#define _ERR_print_errors_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_print_errors_cb)
#define _ERR_print_errors_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_print_errors_fp)
#define _ERR_put_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_put_error)
#define _ERR_reason_error_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_reason_error_string)
#define _ERR_reason_symbol_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_reason_symbol_name)
#define _ERR_remove_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_remove_state)
#define _ERR_remove_thread_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_remove_thread_state)
#define _ERR_restore_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_restore_state)
#define _ERR_save_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_save_state)
#define _ERR_set_error_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_set_error_data)
#define _ERR_set_mark BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ERR_set_mark)
#define _EVP_AEAD_CTX_aead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_aead)
#define _EVP_AEAD_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_cleanup)
#define _EVP_AEAD_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_free)
#define _EVP_AEAD_CTX_get_iv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_get_iv)
#define _EVP_AEAD_CTX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_init)
#define _EVP_AEAD_CTX_init_with_direction BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_init_with_direction)
#define _EVP_AEAD_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_new)
#define _EVP_AEAD_CTX_open BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_open)
#define _EVP_AEAD_CTX_open_gather BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_open_gather)
#define _EVP_AEAD_CTX_seal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_seal)
#define _EVP_AEAD_CTX_seal_scatter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_seal_scatter)
#define _EVP_AEAD_CTX_tag_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_tag_len)
#define _EVP_AEAD_CTX_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_CTX_zero)
#define _EVP_AEAD_key_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_key_length)
#define _EVP_AEAD_max_overhead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_max_overhead)
#define _EVP_AEAD_max_tag_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_max_tag_len)
#define _EVP_AEAD_nonce_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_AEAD_nonce_length)
#define _EVP_BytesToKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_BytesToKey)
#define _EVP_CIPHER_CTX_block_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_block_size)
#define _EVP_CIPHER_CTX_cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_cipher)
#define _EVP_CIPHER_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_cleanup)
#define _EVP_CIPHER_CTX_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_copy)
#define _EVP_CIPHER_CTX_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_ctrl)
#define _EVP_CIPHER_CTX_encrypting BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_encrypting)
#define _EVP_CIPHER_CTX_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_flags)
#define _EVP_CIPHER_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_free)
#define _EVP_CIPHER_CTX_get_app_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_get_app_data)
#define _EVP_CIPHER_CTX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_init)
#define _EVP_CIPHER_CTX_iv_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_iv_length)
#define _EVP_CIPHER_CTX_key_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_key_length)
#define _EVP_CIPHER_CTX_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_mode)
#define _EVP_CIPHER_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_new)
#define _EVP_CIPHER_CTX_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_nid)
#define _EVP_CIPHER_CTX_reset BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_reset)
#define _EVP_CIPHER_CTX_set_app_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_set_app_data)
#define _EVP_CIPHER_CTX_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_set_flags)
#define _EVP_CIPHER_CTX_set_key_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_set_key_length)
#define _EVP_CIPHER_CTX_set_padding BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_CTX_set_padding)
#define _EVP_CIPHER_block_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_block_size)
#define _EVP_CIPHER_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_flags)
#define _EVP_CIPHER_iv_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_iv_length)
#define _EVP_CIPHER_key_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_key_length)
#define _EVP_CIPHER_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_mode)
#define _EVP_CIPHER_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CIPHER_nid)
#define _EVP_Cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_Cipher)
#define _EVP_CipherFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CipherFinal)
#define _EVP_CipherFinal_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CipherFinal_ex)
#define _EVP_CipherInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CipherInit)
#define _EVP_CipherInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CipherInit_ex)
#define _EVP_CipherUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_CipherUpdate)
#define _EVP_DecodeBase64 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodeBase64)
#define _EVP_DecodeBlock BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodeBlock)
#define _EVP_DecodeFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodeFinal)
#define _EVP_DecodeInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodeInit)
#define _EVP_DecodeUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodeUpdate)
#define _EVP_DecodedLength BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecodedLength)
#define _EVP_DecryptFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecryptFinal)
#define _EVP_DecryptFinal_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecryptFinal_ex)
#define _EVP_DecryptInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecryptInit)
#define _EVP_DecryptInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecryptInit_ex)
#define _EVP_DecryptUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DecryptUpdate)
#define _EVP_Digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_Digest)
#define _EVP_DigestFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestFinal)
#define _EVP_DigestFinalXOF BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestFinalXOF)
#define _EVP_DigestFinal_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestFinal_ex)
#define _EVP_DigestInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestInit)
#define _EVP_DigestInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestInit_ex)
#define _EVP_DigestSign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestSign)
#define _EVP_DigestSignFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestSignFinal)
#define _EVP_DigestSignInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestSignInit)
#define _EVP_DigestSignUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestSignUpdate)
#define _EVP_DigestUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestUpdate)
#define _EVP_DigestVerify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestVerify)
#define _EVP_DigestVerifyFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestVerifyFinal)
#define _EVP_DigestVerifyInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestVerifyInit)
#define _EVP_DigestVerifyUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_DigestVerifyUpdate)
#define _EVP_ENCODE_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_ENCODE_CTX_free)
#define _EVP_ENCODE_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_ENCODE_CTX_new)
#define _EVP_EncodeBlock BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncodeBlock)
#define _EVP_EncodeFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncodeFinal)
#define _EVP_EncodeInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncodeInit)
#define _EVP_EncodeUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncodeUpdate)
#define _EVP_EncodedLength BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncodedLength)
#define _EVP_EncryptFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncryptFinal)
#define _EVP_EncryptFinal_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncryptFinal_ex)
#define _EVP_EncryptInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncryptInit)
#define _EVP_EncryptInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncryptInit_ex)
#define _EVP_EncryptUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_EncryptUpdate)
#define _EVP_HPKE_AEAD_aead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_AEAD_aead)
#define _EVP_HPKE_AEAD_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_AEAD_id)
#define _EVP_HPKE_CTX_aead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_aead)
#define _EVP_HPKE_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_cleanup)
#define _EVP_HPKE_CTX_export BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_export)
#define _EVP_HPKE_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_free)
#define _EVP_HPKE_CTX_kdf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_kdf)
#define _EVP_HPKE_CTX_kem BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_kem)
#define _EVP_HPKE_CTX_max_overhead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_max_overhead)
#define _EVP_HPKE_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_new)
#define _EVP_HPKE_CTX_open BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_open)
#define _EVP_HPKE_CTX_seal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_seal)
#define _EVP_HPKE_CTX_setup_auth_recipient BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_auth_recipient)
#define _EVP_HPKE_CTX_setup_auth_sender BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_auth_sender)
#define _EVP_HPKE_CTX_setup_auth_sender_with_seed_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_auth_sender_with_seed_for_testing)
#define _EVP_HPKE_CTX_setup_recipient BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_recipient)
#define _EVP_HPKE_CTX_setup_sender BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_sender)
#define _EVP_HPKE_CTX_setup_sender_with_seed_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_setup_sender_with_seed_for_testing)
#define _EVP_HPKE_CTX_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_CTX_zero)
#define _EVP_HPKE_KDF_hkdf_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KDF_hkdf_md)
#define _EVP_HPKE_KDF_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KDF_id)
#define _EVP_HPKE_KEM_enc_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEM_enc_len)
#define _EVP_HPKE_KEM_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEM_id)
#define _EVP_HPKE_KEM_private_key_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEM_private_key_len)
#define _EVP_HPKE_KEM_public_key_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEM_public_key_len)
#define _EVP_HPKE_KEY_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_cleanup)
#define _EVP_HPKE_KEY_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_copy)
#define _EVP_HPKE_KEY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_free)
#define _EVP_HPKE_KEY_generate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_generate)
#define _EVP_HPKE_KEY_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_init)
#define _EVP_HPKE_KEY_kem BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_kem)
#define _EVP_HPKE_KEY_move BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_move)
#define _EVP_HPKE_KEY_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_new)
#define _EVP_HPKE_KEY_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_private_key)
#define _EVP_HPKE_KEY_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_public_key)
#define _EVP_HPKE_KEY_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_HPKE_KEY_zero)
#define _EVP_MD_CTX_block_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_block_size)
#define _EVP_MD_CTX_cleanse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_cleanse)
#define _EVP_MD_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_cleanup)
#define _EVP_MD_CTX_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_copy)
#define _EVP_MD_CTX_copy_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_copy_ex)
#define _EVP_MD_CTX_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_create)
#define _EVP_MD_CTX_destroy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_destroy)
#define _EVP_MD_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_free)
#define _EVP_MD_CTX_get0_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_get0_md)
#define _EVP_MD_CTX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_init)
#define _EVP_MD_CTX_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_md)
#define _EVP_MD_CTX_move BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_move)
#define _EVP_MD_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_new)
#define _EVP_MD_CTX_reset BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_reset)
#define _EVP_MD_CTX_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_set_flags)
#define _EVP_MD_CTX_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_size)
#define _EVP_MD_CTX_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_CTX_type)
#define _EVP_MD_block_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_block_size)
#define _EVP_MD_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_flags)
#define _EVP_MD_meth_get_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_meth_get_flags)
#define _EVP_MD_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_nid)
#define _EVP_MD_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_size)
#define _EVP_MD_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_MD_type)
#define _EVP_PBE_scrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PBE_scrypt)
#define _EVP_PKCS82PKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKCS82PKEY)
#define _EVP_PKEY2PKCS8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY2PKCS8)
#define _EVP_PKEY_CTX_add1_hkdf_info BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_add1_hkdf_info)
#define _EVP_PKEY_CTX_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_ctrl)
#define _EVP_PKEY_CTX_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_dup)
#define _EVP_PKEY_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_free)
#define _EVP_PKEY_CTX_get0_pkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get0_pkey)
#define _EVP_PKEY_CTX_get0_rsa_oaep_label BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get0_rsa_oaep_label)
#define _EVP_PKEY_CTX_get_rsa_mgf1_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get_rsa_mgf1_md)
#define _EVP_PKEY_CTX_get_rsa_oaep_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get_rsa_oaep_md)
#define _EVP_PKEY_CTX_get_rsa_padding BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get_rsa_padding)
#define _EVP_PKEY_CTX_get_rsa_pss_saltlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get_rsa_pss_saltlen)
#define _EVP_PKEY_CTX_get_signature_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_get_signature_md)
#define _EVP_PKEY_CTX_hkdf_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_hkdf_mode)
#define _EVP_PKEY_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_new)
#define _EVP_PKEY_CTX_new_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_new_id)
#define _EVP_PKEY_CTX_set0_rsa_oaep_label BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set0_rsa_oaep_label)
#define _EVP_PKEY_CTX_set1_hkdf_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set1_hkdf_key)
#define _EVP_PKEY_CTX_set1_hkdf_salt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set1_hkdf_salt)
#define _EVP_PKEY_CTX_set_dh_pad BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_dh_pad)
#define _EVP_PKEY_CTX_set_dsa_paramgen_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_dsa_paramgen_bits)
#define _EVP_PKEY_CTX_set_dsa_paramgen_q_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_dsa_paramgen_q_bits)
#define _EVP_PKEY_CTX_set_ec_param_enc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_ec_param_enc)
#define _EVP_PKEY_CTX_set_ec_paramgen_curve_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_ec_paramgen_curve_nid)
#define _EVP_PKEY_CTX_set_hkdf_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_hkdf_md)
#define _EVP_PKEY_CTX_set_rsa_keygen_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_keygen_bits)
#define _EVP_PKEY_CTX_set_rsa_keygen_pubexp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_keygen_pubexp)
#define _EVP_PKEY_CTX_set_rsa_mgf1_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_mgf1_md)
#define _EVP_PKEY_CTX_set_rsa_oaep_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_oaep_md)
#define _EVP_PKEY_CTX_set_rsa_padding BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_padding)
#define _EVP_PKEY_CTX_set_rsa_pss_keygen_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_pss_keygen_md)
#define _EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md)
#define _EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen)
#define _EVP_PKEY_CTX_set_rsa_pss_saltlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_rsa_pss_saltlen)
#define _EVP_PKEY_CTX_set_signature_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_CTX_set_signature_md)
#define _EVP_PKEY_assign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_assign)
#define _EVP_PKEY_assign_DH BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_assign_DH)
#define _EVP_PKEY_assign_DSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_assign_DSA)
#define _EVP_PKEY_assign_EC_KEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_assign_EC_KEY)
#define _EVP_PKEY_assign_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_assign_RSA)
#define _EVP_PKEY_base_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_base_id)
#define _EVP_PKEY_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_bits)
#define _EVP_PKEY_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_cmp)
#define _EVP_PKEY_cmp_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_cmp_parameters)
#define _EVP_PKEY_copy_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_copy_parameters)
#define _EVP_PKEY_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_decrypt)
#define _EVP_PKEY_decrypt_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_decrypt_init)
#define _EVP_PKEY_derive BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_derive)
#define _EVP_PKEY_derive_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_derive_init)
#define _EVP_PKEY_derive_set_peer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_derive_set_peer)
#define _EVP_PKEY_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_encrypt)
#define _EVP_PKEY_encrypt_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_encrypt_init)
#define _EVP_PKEY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_free)
#define _EVP_PKEY_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get0)
#define _EVP_PKEY_get0_DH BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get0_DH)
#define _EVP_PKEY_get0_DSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get0_DSA)
#define _EVP_PKEY_get0_EC_KEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get0_EC_KEY)
#define _EVP_PKEY_get0_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get0_RSA)
#define _EVP_PKEY_get1_DH BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get1_DH)
#define _EVP_PKEY_get1_DSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get1_DSA)
#define _EVP_PKEY_get1_EC_KEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get1_EC_KEY)
#define _EVP_PKEY_get1_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get1_RSA)
#define _EVP_PKEY_get1_tls_encodedpoint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get1_tls_encodedpoint)
#define _EVP_PKEY_get_raw_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get_raw_private_key)
#define _EVP_PKEY_get_raw_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_get_raw_public_key)
#define _EVP_PKEY_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_id)
#define _EVP_PKEY_is_opaque BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_is_opaque)
#define _EVP_PKEY_keygen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_keygen)
#define _EVP_PKEY_keygen_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_keygen_init)
#define _EVP_PKEY_missing_parameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_missing_parameters)
#define _EVP_PKEY_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_new)
#define _EVP_PKEY_new_raw_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_new_raw_private_key)
#define _EVP_PKEY_new_raw_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_new_raw_public_key)
#define _EVP_PKEY_paramgen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_paramgen)
#define _EVP_PKEY_paramgen_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_paramgen_init)
#define _EVP_PKEY_print_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_print_params)
#define _EVP_PKEY_print_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_print_private)
#define _EVP_PKEY_print_public BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_print_public)
#define _EVP_PKEY_set1_DH BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set1_DH)
#define _EVP_PKEY_set1_DSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set1_DSA)
#define _EVP_PKEY_set1_EC_KEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set1_EC_KEY)
#define _EVP_PKEY_set1_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set1_RSA)
#define _EVP_PKEY_set1_tls_encodedpoint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set1_tls_encodedpoint)
#define _EVP_PKEY_set_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_set_type)
#define _EVP_PKEY_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_sign)
#define _EVP_PKEY_sign_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_sign_init)
#define _EVP_PKEY_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_size)
#define _EVP_PKEY_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_type)
#define _EVP_PKEY_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_up_ref)
#define _EVP_PKEY_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_verify)
#define _EVP_PKEY_verify_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_verify_init)
#define _EVP_PKEY_verify_recover BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_verify_recover)
#define _EVP_PKEY_verify_recover_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_PKEY_verify_recover_init)
#define _EVP_SignFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_SignFinal)
#define _EVP_SignInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_SignInit)
#define _EVP_SignInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_SignInit_ex)
#define _EVP_SignUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_SignUpdate)
#define _EVP_VerifyFinal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_VerifyFinal)
#define _EVP_VerifyInit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_VerifyInit)
#define _EVP_VerifyInit_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_VerifyInit_ex)
#define _EVP_VerifyUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_VerifyUpdate)
#define _EVP_add_cipher_alias BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_add_cipher_alias)
#define _EVP_add_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_add_digest)
#define _EVP_aead_aes_128_cbc_sha1_tls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_cbc_sha1_tls)
#define _EVP_aead_aes_128_cbc_sha1_tls_implicit_iv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_cbc_sha1_tls_implicit_iv)
#define _EVP_aead_aes_128_cbc_sha256_tls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_cbc_sha256_tls)
#define _EVP_aead_aes_128_ccm_bluetooth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_ccm_bluetooth)
#define _EVP_aead_aes_128_ccm_bluetooth_8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_ccm_bluetooth_8)
#define _EVP_aead_aes_128_ccm_matter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_ccm_matter)
#define _EVP_aead_aes_128_ctr_hmac_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_ctr_hmac_sha256)
#define _EVP_aead_aes_128_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_gcm)
#define _EVP_aead_aes_128_gcm_randnonce BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_gcm_randnonce)
#define _EVP_aead_aes_128_gcm_siv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_gcm_siv)
#define _EVP_aead_aes_128_gcm_tls12 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_gcm_tls12)
#define _EVP_aead_aes_128_gcm_tls13 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_128_gcm_tls13)
#define _EVP_aead_aes_192_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_192_gcm)
#define _EVP_aead_aes_256_cbc_sha1_tls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_cbc_sha1_tls)
#define _EVP_aead_aes_256_cbc_sha1_tls_implicit_iv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_cbc_sha1_tls_implicit_iv)
#define _EVP_aead_aes_256_ctr_hmac_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_ctr_hmac_sha256)
#define _EVP_aead_aes_256_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_gcm)
#define _EVP_aead_aes_256_gcm_randnonce BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_gcm_randnonce)
#define _EVP_aead_aes_256_gcm_siv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_gcm_siv)
#define _EVP_aead_aes_256_gcm_tls12 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_gcm_tls12)
#define _EVP_aead_aes_256_gcm_tls13 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_aes_256_gcm_tls13)
#define _EVP_aead_chacha20_poly1305 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_chacha20_poly1305)
#define _EVP_aead_des_ede3_cbc_sha1_tls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_des_ede3_cbc_sha1_tls)
#define _EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv)
#define _EVP_aead_xchacha20_poly1305 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aead_xchacha20_poly1305)
#define _EVP_aes_128_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_128_cbc)
#define _EVP_aes_128_ctr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_128_ctr)
#define _EVP_aes_128_ecb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_128_ecb)
#define _EVP_aes_128_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_128_gcm)
#define _EVP_aes_128_ofb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_128_ofb)
#define _EVP_aes_192_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_192_cbc)
#define _EVP_aes_192_ctr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_192_ctr)
#define _EVP_aes_192_ecb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_192_ecb)
#define _EVP_aes_192_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_192_gcm)
#define _EVP_aes_192_ofb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_192_ofb)
#define _EVP_aes_256_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_256_cbc)
#define _EVP_aes_256_ctr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_256_ctr)
#define _EVP_aes_256_ecb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_256_ecb)
#define _EVP_aes_256_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_256_gcm)
#define _EVP_aes_256_ofb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_aes_256_ofb)
#define _EVP_blake2b256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_blake2b256)
#define _EVP_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_cleanup)
#define _EVP_des_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_cbc)
#define _EVP_des_ecb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ecb)
#define _EVP_des_ede BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ede)
#define _EVP_des_ede3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ede3)
#define _EVP_des_ede3_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ede3_cbc)
#define _EVP_des_ede3_ecb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ede3_ecb)
#define _EVP_des_ede_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_des_ede_cbc)
#define _EVP_enc_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_enc_null)
#define _EVP_get_cipherbyname BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_get_cipherbyname)
#define _EVP_get_cipherbynid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_get_cipherbynid)
#define _EVP_get_digestbyname BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_get_digestbyname)
#define _EVP_get_digestbynid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_get_digestbynid)
#define _EVP_get_digestbyobj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_get_digestbyobj)
#define _EVP_has_aes_hardware BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_has_aes_hardware)
#define _EVP_hpke_aes_128_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_aes_128_gcm)
#define _EVP_hpke_aes_256_gcm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_aes_256_gcm)
#define _EVP_hpke_chacha20_poly1305 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_chacha20_poly1305)
#define _EVP_hpke_hkdf_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_hkdf_sha256)
#define _EVP_hpke_p256_hkdf_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_p256_hkdf_sha256)
#define _EVP_hpke_x25519_hkdf_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_hpke_x25519_hkdf_sha256)
#define _EVP_marshal_digest_algorithm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_marshal_digest_algorithm)
#define _EVP_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_marshal_private_key)
#define _EVP_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_marshal_public_key)
#define _EVP_md4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_md4)
#define _EVP_md5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_md5)
#define _EVP_md5_sha1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_md5_sha1)
#define _EVP_parse_digest_algorithm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_parse_digest_algorithm)
#define _EVP_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_parse_private_key)
#define _EVP_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_parse_public_key)
#define _EVP_rc2_40_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_rc2_40_cbc)
#define _EVP_rc2_cbc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_rc2_cbc)
#define _EVP_rc4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_rc4)
#define _EVP_sha1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha1)
#define _EVP_sha1_final_with_secret_suffix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha1_final_with_secret_suffix)
#define _EVP_sha224 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha224)
#define _EVP_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha256)
#define _EVP_sha256_final_with_secret_suffix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha256_final_with_secret_suffix)
#define _EVP_sha384 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha384)
#define _EVP_sha512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha512)
#define _EVP_sha512_256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_sha512_256)
#define _EVP_tls_cbc_copy_mac BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_tls_cbc_copy_mac)
#define _EVP_tls_cbc_digest_record BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_tls_cbc_digest_record)
#define _EVP_tls_cbc_record_digest_supported BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_tls_cbc_record_digest_supported)
#define _EVP_tls_cbc_remove_padding BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EVP_tls_cbc_remove_padding)
#define _EXTENDED_KEY_USAGE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EXTENDED_KEY_USAGE_free)
#define _EXTENDED_KEY_USAGE_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EXTENDED_KEY_USAGE_it)
#define _EXTENDED_KEY_USAGE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, EXTENDED_KEY_USAGE_new)
#define _FIPS_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_mode)
#define _FIPS_mode_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_mode_set)
#define _FIPS_module_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_module_name)
#define _FIPS_query_algorithm_status BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_query_algorithm_status)
#define _FIPS_read_counter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_read_counter)
#define _FIPS_service_indicator_after_call BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_service_indicator_after_call)
#define _FIPS_service_indicator_before_call BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_service_indicator_before_call)
#define _FIPS_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, FIPS_version)
#define _GENERAL_NAMES_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAMES_free)
#define _GENERAL_NAMES_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAMES_it)
#define _GENERAL_NAMES_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAMES_new)
#define _GENERAL_NAME_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_cmp)
#define _GENERAL_NAME_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_dup)
#define _GENERAL_NAME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_free)
#define _GENERAL_NAME_get0_otherName BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_get0_otherName)
#define _GENERAL_NAME_get0_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_get0_value)
#define _GENERAL_NAME_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_it)
#define _GENERAL_NAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_new)
#define _GENERAL_NAME_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_print)
#define _GENERAL_NAME_set0_othername BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_set0_othername)
#define _GENERAL_NAME_set0_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_NAME_set0_value)
#define _GENERAL_SUBTREE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_SUBTREE_free)
#define _GENERAL_SUBTREE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, GENERAL_SUBTREE_new)
#define _HKDF BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HKDF)
#define _HKDF_expand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HKDF_expand)
#define _HKDF_extract BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HKDF_extract)
#define _HMAC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC)
#define _HMAC_CTX_cleanse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_cleanse)
#define _HMAC_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_cleanup)
#define _HMAC_CTX_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_copy)
#define _HMAC_CTX_copy_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_copy_ex)
#define _HMAC_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_free)
#define _HMAC_CTX_get_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_get_md)
#define _HMAC_CTX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_init)
#define _HMAC_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_new)
#define _HMAC_CTX_reset BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_CTX_reset)
#define _HMAC_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_Final)
#define _HMAC_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_Init)
#define _HMAC_Init_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_Init_ex)
#define _HMAC_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_Update)
#define _HMAC_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HMAC_size)
#define _HRSS_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_decap)
#define _HRSS_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_encap)
#define _HRSS_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_generate_key)
#define _HRSS_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_marshal_public_key)
#define _HRSS_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_parse_public_key)
#define _HRSS_poly3_invert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_poly3_invert)
#define _HRSS_poly3_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, HRSS_poly3_mul)
#define _ISSUING_DIST_POINT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ISSUING_DIST_POINT_free)
#define _ISSUING_DIST_POINT_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ISSUING_DIST_POINT_it)
#define _ISSUING_DIST_POINT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ISSUING_DIST_POINT_new)
#define _KYBER_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_decap)
#define _KYBER_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_encap)
#define _KYBER_encap_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_encap_external_entropy)
#define _KYBER_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_generate_key)
#define _KYBER_generate_key_external_entropy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_generate_key_external_entropy)
#define _KYBER_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_marshal_private_key)
#define _KYBER_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_marshal_public_key)
#define _KYBER_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_parse_private_key)
#define _KYBER_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_parse_public_key)
#define _KYBER_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, KYBER_public_from_private)
#define _MD4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD4)
#define _MD4_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD4_Final)
#define _MD4_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD4_Init)
#define _MD4_Transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD4_Transform)
#define _MD4_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD4_Update)
#define _MD5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD5)
#define _MD5_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD5_Final)
#define _MD5_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD5_Init)
#define _MD5_Transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD5_Transform)
#define _MD5_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MD5_Update)
#define _METHOD_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, METHOD_ref)
#define _METHOD_unref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, METHOD_unref)
#define _MLDSA65_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_generate_key)
#define _MLDSA65_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_marshal_public_key)
#define _MLDSA65_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_parse_public_key)
#define _MLDSA65_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_private_key_from_seed)
#define _MLDSA65_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_public_from_private)
#define _MLDSA65_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_sign)
#define _MLDSA65_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLDSA65_verify)
#define _MLKEM1024_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_decap)
#define _MLKEM1024_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_encap)
#define _MLKEM1024_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_generate_key)
#define _MLKEM1024_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_marshal_public_key)
#define _MLKEM1024_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_parse_public_key)
#define _MLKEM1024_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_private_key_from_seed)
#define _MLKEM1024_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM1024_public_from_private)
#define _MLKEM768_decap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_decap)
#define _MLKEM768_encap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_encap)
#define _MLKEM768_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_generate_key)
#define _MLKEM768_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_marshal_public_key)
#define _MLKEM768_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_parse_public_key)
#define _MLKEM768_private_key_from_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_private_key_from_seed)
#define _MLKEM768_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, MLKEM768_public_from_private)
#define _NAME_CONSTRAINTS_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NAME_CONSTRAINTS_check)
#define _NAME_CONSTRAINTS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NAME_CONSTRAINTS_free)
#define _NAME_CONSTRAINTS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NAME_CONSTRAINTS_it)
#define _NAME_CONSTRAINTS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NAME_CONSTRAINTS_new)
#define _NCONF_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_free)
#define _NCONF_get_section BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_get_section)
#define _NCONF_get_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_get_string)
#define _NCONF_load BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_load)
#define _NCONF_load_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_load_bio)
#define _NCONF_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NCONF_new)
#define _NETSCAPE_SPKAC_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKAC_free)
#define _NETSCAPE_SPKAC_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKAC_it)
#define _NETSCAPE_SPKAC_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKAC_new)
#define _NETSCAPE_SPKI_b64_decode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_b64_decode)
#define _NETSCAPE_SPKI_b64_encode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_b64_encode)
#define _NETSCAPE_SPKI_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_free)
#define _NETSCAPE_SPKI_get_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_get_pubkey)
#define _NETSCAPE_SPKI_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_it)
#define _NETSCAPE_SPKI_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_new)
#define _NETSCAPE_SPKI_set_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_set_pubkey)
#define _NETSCAPE_SPKI_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_sign)
#define _NETSCAPE_SPKI_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NETSCAPE_SPKI_verify)
#define _NOTICEREF_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NOTICEREF_free)
#define _NOTICEREF_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NOTICEREF_it)
#define _NOTICEREF_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, NOTICEREF_new)
#define _OBJ_cbs2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_cbs2nid)
#define _OBJ_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_cleanup)
#define _OBJ_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_cmp)
#define _OBJ_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_create)
#define _OBJ_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_dup)
#define _OBJ_find_sigid_algs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_find_sigid_algs)
#define _OBJ_find_sigid_by_algs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_find_sigid_by_algs)
#define _OBJ_get0_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_get0_data)
#define _OBJ_get_undef BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_get_undef)
#define _OBJ_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_length)
#define _OBJ_ln2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_ln2nid)
#define _OBJ_nid2cbb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_nid2cbb)
#define _OBJ_nid2ln BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_nid2ln)
#define _OBJ_nid2obj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_nid2obj)
#define _OBJ_nid2sn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_nid2sn)
#define _OBJ_obj2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_obj2nid)
#define _OBJ_obj2txt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_obj2txt)
#define _OBJ_sn2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_sn2nid)
#define _OBJ_txt2nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_txt2nid)
#define _OBJ_txt2obj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OBJ_txt2obj)
#define _OPENSSL_add_all_algorithms_conf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_add_all_algorithms_conf)
#define _OPENSSL_armcap_P BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_armcap_P)
#define _OPENSSL_asprintf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_asprintf)
#define _OPENSSL_calloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_calloc)
#define _OPENSSL_cleanse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_cleanse)
#define _OPENSSL_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_cleanup)
#define _OPENSSL_clear_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_clear_free)
#define _OPENSSL_config BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_config)
#define _OPENSSL_cpuid_setup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_cpuid_setup)
#define _OPENSSL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_free)
#define _OPENSSL_fromxdigit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_fromxdigit)
#define _OPENSSL_get_armcap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_get_armcap)
#define _OPENSSL_get_armcap_pointer_for_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_get_armcap_pointer_for_test)
#define _OPENSSL_get_ia32cap BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_get_ia32cap)
#define _OPENSSL_gmtime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_gmtime)
#define _OPENSSL_gmtime_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_gmtime_adj)
#define _OPENSSL_gmtime_diff BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_gmtime_diff)
#define _OPENSSL_hash32 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_hash32)
#define _OPENSSL_ia32cap_P BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_ia32cap_P)
#define _OPENSSL_init_cpuid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_init_cpuid)
#define _OPENSSL_init_crypto BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_init_crypto)
#define _OPENSSL_init_ssl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_init_ssl)
#define _OPENSSL_isalnum BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_isalnum)
#define _OPENSSL_isalpha BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_isalpha)
#define _OPENSSL_isdigit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_isdigit)
#define _OPENSSL_isspace BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_isspace)
#define _OPENSSL_isxdigit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_isxdigit)
#define _OPENSSL_lh_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_delete)
#define _OPENSSL_lh_doall_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_doall_arg)
#define _OPENSSL_lh_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_free)
#define _OPENSSL_lh_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_insert)
#define _OPENSSL_lh_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_new)
#define _OPENSSL_lh_num_items BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_num_items)
#define _OPENSSL_lh_retrieve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_retrieve)
#define _OPENSSL_lh_retrieve_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_lh_retrieve_key)
#define _OPENSSL_load_builtin_modules BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_load_builtin_modules)
#define _OPENSSL_malloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_malloc)
#define _OPENSSL_malloc_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_malloc_init)
#define _OPENSSL_memdup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_memdup)
#define _OPENSSL_no_config BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_no_config)
#define _OPENSSL_posix_to_tm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_posix_to_tm)
#define _OPENSSL_realloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_realloc)
#define _OPENSSL_secure_clear_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_secure_clear_free)
#define _OPENSSL_secure_malloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_secure_malloc)
#define _OPENSSL_sk_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_deep_copy)
#define _OPENSSL_sk_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_delete)
#define _OPENSSL_sk_delete_if BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_delete_if)
#define _OPENSSL_sk_delete_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_delete_ptr)
#define _OPENSSL_sk_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_dup)
#define _OPENSSL_sk_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_find)
#define _OPENSSL_sk_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_free)
#define _OPENSSL_sk_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_insert)
#define _OPENSSL_sk_is_sorted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_is_sorted)
#define _OPENSSL_sk_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_new)
#define _OPENSSL_sk_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_new_null)
#define _OPENSSL_sk_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_num)
#define _OPENSSL_sk_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_pop)
#define _OPENSSL_sk_pop_free_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_pop_free_ex)
#define _OPENSSL_sk_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_push)
#define _OPENSSL_sk_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_set)
#define _OPENSSL_sk_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_set_cmp_func)
#define _OPENSSL_sk_shift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_shift)
#define _OPENSSL_sk_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_sort)
#define _OPENSSL_sk_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_value)
#define _OPENSSL_sk_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_sk_zero)
#define _OPENSSL_strcasecmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strcasecmp)
#define _OPENSSL_strdup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strdup)
#define _OPENSSL_strhash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strhash)
#define _OPENSSL_strlcat BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strlcat)
#define _OPENSSL_strlcpy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strlcpy)
#define _OPENSSL_strncasecmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strncasecmp)
#define _OPENSSL_strndup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strndup)
#define _OPENSSL_strnlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_strnlen)
#define _OPENSSL_timegm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_timegm)
#define _OPENSSL_tm_to_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_tm_to_posix)
#define _OPENSSL_tolower BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_tolower)
#define _OPENSSL_vasprintf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_vasprintf)
#define _OPENSSL_vasprintf_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_vasprintf_internal)
#define _OPENSSL_zalloc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OPENSSL_zalloc)
#define _OTHERNAME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OTHERNAME_free)
#define _OTHERNAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OTHERNAME_new)
#define _OpenSSL_add_all_algorithms BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OpenSSL_add_all_algorithms)
#define _OpenSSL_add_all_ciphers BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OpenSSL_add_all_ciphers)
#define _OpenSSL_add_all_digests BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OpenSSL_add_all_digests)
#define _OpenSSL_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OpenSSL_version)
#define _OpenSSL_version_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, OpenSSL_version_num)
#define _PEM_ASN1_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_ASN1_read)
#define _PEM_ASN1_read_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_ASN1_read_bio)
#define _PEM_ASN1_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_ASN1_write)
#define _PEM_ASN1_write_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_ASN1_write_bio)
#define _PEM_X509_INFO_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_X509_INFO_read)
#define _PEM_X509_INFO_read_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_X509_INFO_read_bio)
#define _PEM_bytes_read_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_bytes_read_bio)
#define _PEM_def_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_def_callback)
#define _PEM_do_header BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_do_header)
#define _PEM_get_EVP_CIPHER_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_get_EVP_CIPHER_INFO)
#define _PEM_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read)
#define _PEM_read_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_DHparams)
#define _PEM_read_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_DSAPrivateKey)
#define _PEM_read_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_DSA_PUBKEY)
#define _PEM_read_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_DSAparams)
#define _PEM_read_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_ECPrivateKey)
#define _PEM_read_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_EC_PUBKEY)
#define _PEM_read_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_PKCS7)
#define _PEM_read_PKCS8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_PKCS8)
#define _PEM_read_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_PKCS8_PRIV_KEY_INFO)
#define _PEM_read_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_PUBKEY)
#define _PEM_read_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_PrivateKey)
#define _PEM_read_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_RSAPrivateKey)
#define _PEM_read_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_RSAPublicKey)
#define _PEM_read_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_RSA_PUBKEY)
#define _PEM_read_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_SSL_SESSION)
#define _PEM_read_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_X509)
#define _PEM_read_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_X509_AUX)
#define _PEM_read_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_X509_CRL)
#define _PEM_read_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_X509_REQ)
#define _PEM_read_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio)
#define _PEM_read_bio_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_DHparams)
#define _PEM_read_bio_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_DSAPrivateKey)
#define _PEM_read_bio_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_DSA_PUBKEY)
#define _PEM_read_bio_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_DSAparams)
#define _PEM_read_bio_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_ECPrivateKey)
#define _PEM_read_bio_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_EC_PUBKEY)
#define _PEM_read_bio_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_PKCS7)
#define _PEM_read_bio_PKCS8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_PKCS8)
#define _PEM_read_bio_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_PKCS8_PRIV_KEY_INFO)
#define _PEM_read_bio_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_PUBKEY)
#define _PEM_read_bio_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_PrivateKey)
#define _PEM_read_bio_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_RSAPrivateKey)
#define _PEM_read_bio_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_RSAPublicKey)
#define _PEM_read_bio_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_RSA_PUBKEY)
#define _PEM_read_bio_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_SSL_SESSION)
#define _PEM_read_bio_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_X509)
#define _PEM_read_bio_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_X509_AUX)
#define _PEM_read_bio_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_X509_CRL)
#define _PEM_read_bio_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_read_bio_X509_REQ)
#define _PEM_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write)
#define _PEM_write_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_DHparams)
#define _PEM_write_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_DSAPrivateKey)
#define _PEM_write_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_DSA_PUBKEY)
#define _PEM_write_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_DSAparams)
#define _PEM_write_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_ECPrivateKey)
#define _PEM_write_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_EC_PUBKEY)
#define _PEM_write_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PKCS7)
#define _PEM_write_PKCS8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PKCS8)
#define _PEM_write_PKCS8PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PKCS8PrivateKey)
#define _PEM_write_PKCS8PrivateKey_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PKCS8PrivateKey_nid)
#define _PEM_write_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PKCS8_PRIV_KEY_INFO)
#define _PEM_write_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PUBKEY)
#define _PEM_write_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_PrivateKey)
#define _PEM_write_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_RSAPrivateKey)
#define _PEM_write_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_RSAPublicKey)
#define _PEM_write_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_RSA_PUBKEY)
#define _PEM_write_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_SSL_SESSION)
#define _PEM_write_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_X509)
#define _PEM_write_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_X509_AUX)
#define _PEM_write_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_X509_CRL)
#define _PEM_write_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_X509_REQ)
#define _PEM_write_X509_REQ_NEW BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_X509_REQ_NEW)
#define _PEM_write_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio)
#define _PEM_write_bio_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_DHparams)
#define _PEM_write_bio_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_DSAPrivateKey)
#define _PEM_write_bio_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_DSA_PUBKEY)
#define _PEM_write_bio_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_DSAparams)
#define _PEM_write_bio_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_ECPrivateKey)
#define _PEM_write_bio_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_EC_PUBKEY)
#define _PEM_write_bio_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PKCS7)
#define _PEM_write_bio_PKCS8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PKCS8)
#define _PEM_write_bio_PKCS8PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PKCS8PrivateKey)
#define _PEM_write_bio_PKCS8PrivateKey_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PKCS8PrivateKey_nid)
#define _PEM_write_bio_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PKCS8_PRIV_KEY_INFO)
#define _PEM_write_bio_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PUBKEY)
#define _PEM_write_bio_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_PrivateKey)
#define _PEM_write_bio_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_RSAPrivateKey)
#define _PEM_write_bio_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_RSAPublicKey)
#define _PEM_write_bio_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_RSA_PUBKEY)
#define _PEM_write_bio_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_SSL_SESSION)
#define _PEM_write_bio_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_X509)
#define _PEM_write_bio_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_X509_AUX)
#define _PEM_write_bio_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_X509_CRL)
#define _PEM_write_bio_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_X509_REQ)
#define _PEM_write_bio_X509_REQ_NEW BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PEM_write_bio_X509_REQ_NEW)
#define _PKCS12_PBE_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_PBE_add)
#define _PKCS12_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_create)
#define _PKCS12_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_free)
#define _PKCS12_get_key_and_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_get_key_and_certs)
#define _PKCS12_parse BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_parse)
#define _PKCS12_verify_mac BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS12_verify_mac)
#define _PKCS1_MGF1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS1_MGF1)
#define _PKCS5_PBKDF2_HMAC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS5_PBKDF2_HMAC)
#define _PKCS5_PBKDF2_HMAC_SHA1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS5_PBKDF2_HMAC_SHA1)
#define _PKCS5_pbe2_decrypt_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS5_pbe2_decrypt_init)
#define _PKCS5_pbe2_encrypt_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS5_pbe2_encrypt_init)
#define _PKCS7_bundle_CRLs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_bundle_CRLs)
#define _PKCS7_bundle_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_bundle_certificates)
#define _PKCS7_bundle_raw_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_bundle_raw_certificates)
#define _PKCS7_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_free)
#define _PKCS7_get_CRLs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_get_CRLs)
#define _PKCS7_get_PEM_CRLs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_get_PEM_CRLs)
#define _PKCS7_get_PEM_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_get_PEM_certificates)
#define _PKCS7_get_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_get_certificates)
#define _PKCS7_get_raw_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_get_raw_certificates)
#define _PKCS7_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_sign)
#define _PKCS7_type_is_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_data)
#define _PKCS7_type_is_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_digest)
#define _PKCS7_type_is_encrypted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_encrypted)
#define _PKCS7_type_is_enveloped BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_enveloped)
#define _PKCS7_type_is_signed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_signed)
#define _PKCS7_type_is_signedAndEnveloped BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS7_type_is_signedAndEnveloped)
#define _PKCS8_PRIV_KEY_INFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_PRIV_KEY_INFO_free)
#define _PKCS8_PRIV_KEY_INFO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_PRIV_KEY_INFO_new)
#define _PKCS8_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_decrypt)
#define _PKCS8_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_encrypt)
#define _PKCS8_marshal_encrypted_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_marshal_encrypted_private_key)
#define _PKCS8_parse_encrypted_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, PKCS8_parse_encrypted_private_key)
#define _POLICYINFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYINFO_free)
#define _POLICYINFO_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYINFO_it)
#define _POLICYINFO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYINFO_new)
#define _POLICYQUALINFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYQUALINFO_free)
#define _POLICYQUALINFO_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYQUALINFO_it)
#define _POLICYQUALINFO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICYQUALINFO_new)
#define _POLICY_CONSTRAINTS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_CONSTRAINTS_free)
#define _POLICY_CONSTRAINTS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_CONSTRAINTS_it)
#define _POLICY_CONSTRAINTS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_CONSTRAINTS_new)
#define _POLICY_MAPPINGS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_MAPPINGS_it)
#define _POLICY_MAPPING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_MAPPING_free)
#define _POLICY_MAPPING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, POLICY_MAPPING_new)
#define _RAND_OpenSSL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_OpenSSL)
#define _RAND_SSLeay BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_SSLeay)
#define _RAND_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_add)
#define _RAND_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_bytes)
#define _RAND_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_cleanup)
#define _RAND_disable_fork_unsafe_buffering BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_disable_fork_unsafe_buffering)
#define _RAND_egd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_egd)
#define _RAND_enable_fork_unsafe_buffering BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_enable_fork_unsafe_buffering)
#define _RAND_file_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_file_name)
#define _RAND_get_rand_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_get_rand_method)
#define _RAND_get_system_entropy_for_custom_prng BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_get_system_entropy_for_custom_prng)
#define _RAND_load_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_load_file)
#define _RAND_poll BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_poll)
#define _RAND_pseudo_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_pseudo_bytes)
#define _RAND_seed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_seed)
#define _RAND_set_rand_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_set_rand_method)
#define _RAND_status BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RAND_status)
#define _RC4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RC4)
#define _RC4_set_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RC4_set_key)
#define _RSAPrivateKey_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSAPrivateKey_dup)
#define _RSAPublicKey_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSAPublicKey_dup)
#define _RSAZ_1024_mod_exp_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSAZ_1024_mod_exp_avx2)
#define _RSA_PSS_PARAMS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_PSS_PARAMS_free)
#define _RSA_PSS_PARAMS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_PSS_PARAMS_it)
#define _RSA_PSS_PARAMS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_PSS_PARAMS_new)
#define _RSA_add_pkcs1_prefix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_add_pkcs1_prefix)
#define _RSA_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_bits)
#define _RSA_blinding_off BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_blinding_off)
#define _RSA_blinding_on BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_blinding_on)
#define _RSA_check_fips BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_check_fips)
#define _RSA_check_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_check_key)
#define _RSA_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_decrypt)
#define _RSA_default_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_default_method)
#define _RSA_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_encrypt)
#define _RSA_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_flags)
#define _RSA_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_free)
#define _RSA_generate_key_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_generate_key_ex)
#define _RSA_generate_key_fips BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_generate_key_fips)
#define _RSA_get0_crt_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_crt_params)
#define _RSA_get0_d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_d)
#define _RSA_get0_dmp1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_dmp1)
#define _RSA_get0_dmq1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_dmq1)
#define _RSA_get0_e BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_e)
#define _RSA_get0_factors BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_factors)
#define _RSA_get0_iqmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_iqmp)
#define _RSA_get0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_key)
#define _RSA_get0_n BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_n)
#define _RSA_get0_p BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_p)
#define _RSA_get0_pss_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_pss_params)
#define _RSA_get0_q BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get0_q)
#define _RSA_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get_ex_data)
#define _RSA_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_get_ex_new_index)
#define _RSA_is_opaque BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_is_opaque)
#define _RSA_marshal_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_marshal_private_key)
#define _RSA_marshal_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_marshal_public_key)
#define _RSA_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new)
#define _RSA_new_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_method)
#define _RSA_new_method_no_e BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_method_no_e)
#define _RSA_new_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_private_key)
#define _RSA_new_private_key_large_e BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_private_key_large_e)
#define _RSA_new_private_key_no_crt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_private_key_no_crt)
#define _RSA_new_private_key_no_e BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_private_key_no_e)
#define _RSA_new_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_public_key)
#define _RSA_new_public_key_large_e BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_new_public_key_large_e)
#define _RSA_padding_add_PKCS1_OAEP_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_add_PKCS1_OAEP_mgf1)
#define _RSA_padding_add_PKCS1_PSS_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_add_PKCS1_PSS_mgf1)
#define _RSA_padding_add_PKCS1_type_1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_add_PKCS1_type_1)
#define _RSA_padding_add_none BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_add_none)
#define _RSA_padding_check_PKCS1_OAEP_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_check_PKCS1_OAEP_mgf1)
#define _RSA_padding_check_PKCS1_type_1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_padding_check_PKCS1_type_1)
#define _RSA_parse_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_parse_private_key)
#define _RSA_parse_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_parse_public_key)
#define _RSA_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_print)
#define _RSA_private_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_private_decrypt)
#define _RSA_private_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_private_encrypt)
#define _RSA_private_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_private_key_from_bytes)
#define _RSA_private_key_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_private_key_to_bytes)
#define _RSA_public_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_public_decrypt)
#define _RSA_public_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_public_encrypt)
#define _RSA_public_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_public_key_from_bytes)
#define _RSA_public_key_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_public_key_to_bytes)
#define _RSA_set0_crt_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_set0_crt_params)
#define _RSA_set0_factors BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_set0_factors)
#define _RSA_set0_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_set0_key)
#define _RSA_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_set_ex_data)
#define _RSA_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_sign)
#define _RSA_sign_pss_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_sign_pss_mgf1)
#define _RSA_sign_raw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_sign_raw)
#define _RSA_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_size)
#define _RSA_test_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_test_flags)
#define _RSA_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_up_ref)
#define _RSA_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_verify)
#define _RSA_verify_PKCS1_PSS_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_verify_PKCS1_PSS_mgf1)
#define _RSA_verify_pss_mgf1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_verify_pss_mgf1)
#define _RSA_verify_raw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, RSA_verify_raw)
#define _SHA1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA1)
#define _SHA1_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA1_Final)
#define _SHA1_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA1_Init)
#define _SHA1_Transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA1_Transform)
#define _SHA1_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA1_Update)
#define _SHA224 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA224)
#define _SHA224_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA224_Final)
#define _SHA224_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA224_Init)
#define _SHA224_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA224_Update)
#define _SHA256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256)
#define _SHA256_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256_Final)
#define _SHA256_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256_Init)
#define _SHA256_Transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256_Transform)
#define _SHA256_TransformBlocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256_TransformBlocks)
#define _SHA256_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA256_Update)
#define _SHA384 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA384)
#define _SHA384_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA384_Final)
#define _SHA384_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA384_Init)
#define _SHA384_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA384_Update)
#define _SHA512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512)
#define _SHA512_256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_256)
#define _SHA512_256_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_256_Final)
#define _SHA512_256_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_256_Init)
#define _SHA512_256_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_256_Update)
#define _SHA512_Final BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_Final)
#define _SHA512_Init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_Init)
#define _SHA512_Transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_Transform)
#define _SHA512_Update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SHA512_Update)
#define _SIPHASH_24 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SIPHASH_24)
#define _SLHDSA_SHA2_128S_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_generate_key)
#define _SLHDSA_SHA2_128S_prehash_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_prehash_sign)
#define _SLHDSA_SHA2_128S_prehash_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_prehash_verify)
#define _SLHDSA_SHA2_128S_prehash_warning_nonstandard_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_prehash_warning_nonstandard_sign)
#define _SLHDSA_SHA2_128S_prehash_warning_nonstandard_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_prehash_warning_nonstandard_verify)
#define _SLHDSA_SHA2_128S_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_public_from_private)
#define _SLHDSA_SHA2_128S_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_sign)
#define _SLHDSA_SHA2_128S_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SLHDSA_SHA2_128S_verify)
#define _SPAKE2_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SPAKE2_CTX_free)
#define _SPAKE2_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SPAKE2_CTX_new)
#define _SPAKE2_generate_msg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SPAKE2_generate_msg)
#define _SPAKE2_process_msg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SPAKE2_process_msg)
#define _SSL_CIPHER_description BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_description)
#define _SSL_CIPHER_get_auth_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_auth_nid)
#define _SSL_CIPHER_get_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_bits)
#define _SSL_CIPHER_get_cipher_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_cipher_nid)
#define _SSL_CIPHER_get_digest_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_digest_nid)
#define _SSL_CIPHER_get_handshake_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_handshake_digest)
#define _SSL_CIPHER_get_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_id)
#define _SSL_CIPHER_get_kx_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_kx_name)
#define _SSL_CIPHER_get_kx_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_kx_nid)
#define _SSL_CIPHER_get_max_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_max_version)
#define _SSL_CIPHER_get_min_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_min_version)
#define _SSL_CIPHER_get_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_name)
#define _SSL_CIPHER_get_prf_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_prf_nid)
#define _SSL_CIPHER_get_protocol_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_protocol_id)
#define _SSL_CIPHER_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_get_version)
#define _SSL_CIPHER_is_aead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_is_aead)
#define _SSL_CIPHER_is_block_cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_is_block_cipher)
#define _SSL_CIPHER_standard_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CIPHER_standard_name)
#define _SSL_COMP_add_compression_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_add_compression_method)
#define _SSL_COMP_free_compression_methods BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_free_compression_methods)
#define _SSL_COMP_get0_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_get0_name)
#define _SSL_COMP_get_compression_methods BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_get_compression_methods)
#define _SSL_COMP_get_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_get_id)
#define _SSL_COMP_get_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_COMP_get_name)
#define _SSL_CREDENTIAL_clear_must_match_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_clear_must_match_issuer)
#define _SSL_CREDENTIAL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_free)
#define _SSL_CREDENTIAL_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_get_ex_data)
#define _SSL_CREDENTIAL_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_get_ex_new_index)
#define _SSL_CREDENTIAL_must_match_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_must_match_issuer)
#define _SSL_CREDENTIAL_new_delegated BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_new_delegated)
#define _SSL_CREDENTIAL_new_x509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_new_x509)
#define _SSL_CREDENTIAL_set1_cert_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_cert_chain)
#define _SSL_CREDENTIAL_set1_delegated_credential BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_delegated_credential)
#define _SSL_CREDENTIAL_set1_ocsp_response BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_ocsp_response)
#define _SSL_CREDENTIAL_set1_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_private_key)
#define _SSL_CREDENTIAL_set1_signed_cert_timestamp_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_signed_cert_timestamp_list)
#define _SSL_CREDENTIAL_set1_signing_algorithm_prefs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set1_signing_algorithm_prefs)
#define _SSL_CREDENTIAL_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set_ex_data)
#define _SSL_CREDENTIAL_set_must_match_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set_must_match_issuer)
#define _SSL_CREDENTIAL_set_private_key_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_set_private_key_method)
#define _SSL_CREDENTIAL_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CREDENTIAL_up_ref)
#define _SSL_CTX_add0_chain_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add0_chain_cert)
#define _SSL_CTX_add1_chain_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add1_chain_cert)
#define _SSL_CTX_add1_credential BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add1_credential)
#define _SSL_CTX_add_cert_compression_alg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add_cert_compression_alg)
#define _SSL_CTX_add_client_CA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add_client_CA)
#define _SSL_CTX_add_extra_chain_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add_extra_chain_cert)
#define _SSL_CTX_add_session BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_add_session)
#define _SSL_CTX_check_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_check_private_key)
#define _SSL_CTX_cipher_in_group BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_cipher_in_group)
#define _SSL_CTX_clear_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_clear_chain_certs)
#define _SSL_CTX_clear_extra_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_clear_extra_chain_certs)
#define _SSL_CTX_clear_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_clear_mode)
#define _SSL_CTX_clear_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_clear_options)
#define _SSL_CTX_enable_ocsp_stapling BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_enable_ocsp_stapling)
#define _SSL_CTX_enable_signed_cert_timestamps BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_enable_signed_cert_timestamps)
#define _SSL_CTX_enable_tls_channel_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_enable_tls_channel_id)
#define _SSL_CTX_flush_sessions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_flush_sessions)
#define _SSL_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_free)
#define _SSL_CTX_get0_certificate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get0_certificate)
#define _SSL_CTX_get0_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get0_chain)
#define _SSL_CTX_get0_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get0_chain_certs)
#define _SSL_CTX_get0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get0_param)
#define _SSL_CTX_get0_privatekey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get0_privatekey)
#define _SSL_CTX_get_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_cert_store)
#define _SSL_CTX_get_ciphers BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_ciphers)
#define _SSL_CTX_get_client_CA_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_client_CA_list)
#define _SSL_CTX_get_compliance_policy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_compliance_policy)
#define _SSL_CTX_get_default_passwd_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_default_passwd_cb)
#define _SSL_CTX_get_default_passwd_cb_userdata BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_default_passwd_cb_userdata)
#define _SSL_CTX_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_ex_data)
#define _SSL_CTX_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_ex_new_index)
#define _SSL_CTX_get_extra_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_extra_chain_certs)
#define _SSL_CTX_get_info_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_info_callback)
#define _SSL_CTX_get_keylog_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_keylog_callback)
#define _SSL_CTX_get_max_cert_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_max_cert_list)
#define _SSL_CTX_get_max_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_max_proto_version)
#define _SSL_CTX_get_min_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_min_proto_version)
#define _SSL_CTX_get_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_mode)
#define _SSL_CTX_get_num_tickets BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_num_tickets)
#define _SSL_CTX_get_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_options)
#define _SSL_CTX_get_quiet_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_quiet_shutdown)
#define _SSL_CTX_get_read_ahead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_read_ahead)
#define _SSL_CTX_get_session_cache_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_session_cache_mode)
#define _SSL_CTX_get_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_timeout)
#define _SSL_CTX_get_tlsext_ticket_keys BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_tlsext_ticket_keys)
#define _SSL_CTX_get_verify_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_verify_callback)
#define _SSL_CTX_get_verify_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_verify_depth)
#define _SSL_CTX_get_verify_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_get_verify_mode)
#define _SSL_CTX_load_verify_locations BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_load_verify_locations)
#define _SSL_CTX_need_tmp_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_need_tmp_RSA)
#define _SSL_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_new)
#define _SSL_CTX_remove_session BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_remove_session)
#define _SSL_CTX_sess_accept BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_accept)
#define _SSL_CTX_sess_accept_good BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_accept_good)
#define _SSL_CTX_sess_accept_renegotiate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_accept_renegotiate)
#define _SSL_CTX_sess_cache_full BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_cache_full)
#define _SSL_CTX_sess_cb_hits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_cb_hits)
#define _SSL_CTX_sess_connect BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_connect)
#define _SSL_CTX_sess_connect_good BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_connect_good)
#define _SSL_CTX_sess_connect_renegotiate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_connect_renegotiate)
#define _SSL_CTX_sess_get_cache_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_get_cache_size)
#define _SSL_CTX_sess_get_get_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_get_get_cb)
#define _SSL_CTX_sess_get_new_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_get_new_cb)
#define _SSL_CTX_sess_get_remove_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_get_remove_cb)
#define _SSL_CTX_sess_hits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_hits)
#define _SSL_CTX_sess_misses BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_misses)
#define _SSL_CTX_sess_number BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_number)
#define _SSL_CTX_sess_set_cache_size BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_set_cache_size)
#define _SSL_CTX_sess_set_get_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_set_get_cb)
#define _SSL_CTX_sess_set_new_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_set_new_cb)
#define _SSL_CTX_sess_set_remove_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_set_remove_cb)
#define _SSL_CTX_sess_timeouts BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_sess_timeouts)
#define _SSL_CTX_set0_buffer_pool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set0_buffer_pool)
#define _SSL_CTX_set0_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set0_chain)
#define _SSL_CTX_set0_client_CAs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set0_client_CAs)
#define _SSL_CTX_set0_verify_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set0_verify_cert_store)
#define _SSL_CTX_set1_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_chain)
#define _SSL_CTX_set1_curves BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_curves)
#define _SSL_CTX_set1_curves_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_curves_list)
#define _SSL_CTX_set1_ech_keys BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_ech_keys)
#define _SSL_CTX_set1_group_ids BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_group_ids)
#define _SSL_CTX_set1_groups BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_groups)
#define _SSL_CTX_set1_groups_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_groups_list)
#define _SSL_CTX_set1_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_param)
#define _SSL_CTX_set1_sigalgs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_sigalgs)
#define _SSL_CTX_set1_sigalgs_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_sigalgs_list)
#define _SSL_CTX_set1_tls_channel_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_tls_channel_id)
#define _SSL_CTX_set1_verify_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set1_verify_cert_store)
#define _SSL_CTX_set_allow_unknown_alpn_protos BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_allow_unknown_alpn_protos)
#define _SSL_CTX_set_alpn_protos BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_alpn_protos)
#define _SSL_CTX_set_alpn_select_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_alpn_select_cb)
#define _SSL_CTX_set_cert_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_cert_cb)
#define _SSL_CTX_set_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_cert_store)
#define _SSL_CTX_set_cert_verify_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_cert_verify_callback)
#define _SSL_CTX_set_chain_and_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_chain_and_key)
#define _SSL_CTX_set_cipher_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_cipher_list)
#define _SSL_CTX_set_client_CA_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_client_CA_list)
#define _SSL_CTX_set_client_cert_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_client_cert_cb)
#define _SSL_CTX_set_compliance_policy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_compliance_policy)
#define _SSL_CTX_set_current_time_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_current_time_cb)
#define _SSL_CTX_set_custom_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_custom_verify)
#define _SSL_CTX_set_default_passwd_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_default_passwd_cb)
#define _SSL_CTX_set_default_passwd_cb_userdata BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_default_passwd_cb_userdata)
#define _SSL_CTX_set_default_verify_paths BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_default_verify_paths)
#define _SSL_CTX_set_dos_protection_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_dos_protection_cb)
#define _SSL_CTX_set_early_data_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_early_data_enabled)
#define _SSL_CTX_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_ex_data)
#define _SSL_CTX_set_false_start_allowed_without_alpn BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_false_start_allowed_without_alpn)
#define _SSL_CTX_set_grease_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_grease_enabled)
#define _SSL_CTX_set_info_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_info_callback)
#define _SSL_CTX_set_keylog_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_keylog_callback)
#define _SSL_CTX_set_max_cert_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_max_cert_list)
#define _SSL_CTX_set_max_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_max_proto_version)
#define _SSL_CTX_set_max_send_fragment BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_max_send_fragment)
#define _SSL_CTX_set_min_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_min_proto_version)
#define _SSL_CTX_set_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_mode)
#define _SSL_CTX_set_msg_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_msg_callback)
#define _SSL_CTX_set_msg_callback_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_msg_callback_arg)
#define _SSL_CTX_set_next_proto_select_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_next_proto_select_cb)
#define _SSL_CTX_set_next_protos_advertised_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_next_protos_advertised_cb)
#define _SSL_CTX_set_num_tickets BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_num_tickets)
#define _SSL_CTX_set_ocsp_response BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_ocsp_response)
#define _SSL_CTX_set_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_options)
#define _SSL_CTX_set_permute_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_permute_extensions)
#define _SSL_CTX_set_private_key_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_private_key_method)
#define _SSL_CTX_set_psk_client_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_psk_client_callback)
#define _SSL_CTX_set_psk_server_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_psk_server_callback)
#define _SSL_CTX_set_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_purpose)
#define _SSL_CTX_set_quic_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_quic_method)
#define _SSL_CTX_set_quiet_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_quiet_shutdown)
#define _SSL_CTX_set_read_ahead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_read_ahead)
#define _SSL_CTX_set_record_protocol_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_record_protocol_version)
#define _SSL_CTX_set_retain_only_sha256_of_client_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_retain_only_sha256_of_client_certs)
#define _SSL_CTX_set_reverify_on_resume BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_reverify_on_resume)
#define _SSL_CTX_set_select_certificate_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_select_certificate_cb)
#define _SSL_CTX_set_session_cache_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_session_cache_mode)
#define _SSL_CTX_set_session_id_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_session_id_context)
#define _SSL_CTX_set_session_psk_dhe_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_session_psk_dhe_timeout)
#define _SSL_CTX_set_signed_cert_timestamp_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_signed_cert_timestamp_list)
#define _SSL_CTX_set_signing_algorithm_prefs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_signing_algorithm_prefs)
#define _SSL_CTX_set_srtp_profiles BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_srtp_profiles)
#define _SSL_CTX_set_strict_cipher_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_strict_cipher_list)
#define _SSL_CTX_set_ticket_aead_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_ticket_aead_method)
#define _SSL_CTX_set_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_timeout)
#define _SSL_CTX_set_tls_channel_id_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tls_channel_id_enabled)
#define _SSL_CTX_set_tlsext_servername_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_servername_arg)
#define _SSL_CTX_set_tlsext_servername_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_servername_callback)
#define _SSL_CTX_set_tlsext_status_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_status_arg)
#define _SSL_CTX_set_tlsext_status_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_status_cb)
#define _SSL_CTX_set_tlsext_ticket_key_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_ticket_key_cb)
#define _SSL_CTX_set_tlsext_ticket_keys BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_ticket_keys)
#define _SSL_CTX_set_tlsext_use_srtp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tlsext_use_srtp)
#define _SSL_CTX_set_tmp_dh BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tmp_dh)
#define _SSL_CTX_set_tmp_dh_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tmp_dh_callback)
#define _SSL_CTX_set_tmp_ecdh BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tmp_ecdh)
#define _SSL_CTX_set_tmp_rsa BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tmp_rsa)
#define _SSL_CTX_set_tmp_rsa_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_tmp_rsa_callback)
#define _SSL_CTX_set_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_trust)
#define _SSL_CTX_set_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_verify)
#define _SSL_CTX_set_verify_algorithm_prefs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_verify_algorithm_prefs)
#define _SSL_CTX_set_verify_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_set_verify_depth)
#define _SSL_CTX_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_up_ref)
#define _SSL_CTX_use_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_PrivateKey)
#define _SSL_CTX_use_PrivateKey_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_PrivateKey_ASN1)
#define _SSL_CTX_use_PrivateKey_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_PrivateKey_file)
#define _SSL_CTX_use_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_RSAPrivateKey)
#define _SSL_CTX_use_RSAPrivateKey_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_RSAPrivateKey_ASN1)
#define _SSL_CTX_use_RSAPrivateKey_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_RSAPrivateKey_file)
#define _SSL_CTX_use_certificate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_certificate)
#define _SSL_CTX_use_certificate_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_certificate_ASN1)
#define _SSL_CTX_use_certificate_chain_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_certificate_chain_file)
#define _SSL_CTX_use_certificate_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_certificate_file)
#define _SSL_CTX_use_psk_identity_hint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_CTX_use_psk_identity_hint)
#define _SSL_ECH_KEYS_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_add)
#define _SSL_ECH_KEYS_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_free)
#define _SSL_ECH_KEYS_has_duplicate_config_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_has_duplicate_config_id)
#define _SSL_ECH_KEYS_marshal_retry_configs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_marshal_retry_configs)
#define _SSL_ECH_KEYS_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_new)
#define _SSL_ECH_KEYS_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ECH_KEYS_up_ref)
#define _SSL_SESSION_copy_without_early_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_copy_without_early_data)
#define _SSL_SESSION_early_data_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_early_data_capable)
#define _SSL_SESSION_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_free)
#define _SSL_SESSION_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_from_bytes)
#define _SSL_SESSION_get0_cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_cipher)
#define _SSL_SESSION_get0_id_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_id_context)
#define _SSL_SESSION_get0_ocsp_response BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_ocsp_response)
#define _SSL_SESSION_get0_peer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_peer)
#define _SSL_SESSION_get0_peer_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_peer_certificates)
#define _SSL_SESSION_get0_peer_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_peer_sha256)
#define _SSL_SESSION_get0_signed_cert_timestamp_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_signed_cert_timestamp_list)
#define _SSL_SESSION_get0_ticket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get0_ticket)
#define _SSL_SESSION_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_ex_data)
#define _SSL_SESSION_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_ex_new_index)
#define _SSL_SESSION_get_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_id)
#define _SSL_SESSION_get_master_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_master_key)
#define _SSL_SESSION_get_protocol_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_protocol_version)
#define _SSL_SESSION_get_ticket_lifetime_hint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_ticket_lifetime_hint)
#define _SSL_SESSION_get_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_time)
#define _SSL_SESSION_get_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_timeout)
#define _SSL_SESSION_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_get_version)
#define _SSL_SESSION_has_peer_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_has_peer_sha256)
#define _SSL_SESSION_has_ticket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_has_ticket)
#define _SSL_SESSION_is_resumable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_is_resumable)
#define _SSL_SESSION_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_new)
#define _SSL_SESSION_set1_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set1_id)
#define _SSL_SESSION_set1_id_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set1_id_context)
#define _SSL_SESSION_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set_ex_data)
#define _SSL_SESSION_set_protocol_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set_protocol_version)
#define _SSL_SESSION_set_ticket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set_ticket)
#define _SSL_SESSION_set_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set_time)
#define _SSL_SESSION_set_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_set_timeout)
#define _SSL_SESSION_should_be_single_use BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_should_be_single_use)
#define _SSL_SESSION_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_to_bytes)
#define _SSL_SESSION_to_bytes_for_ticket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_to_bytes_for_ticket)
#define _SSL_SESSION_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_SESSION_up_ref)
#define _SSL_accept BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_accept)
#define _SSL_add0_chain_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add0_chain_cert)
#define _SSL_add1_chain_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add1_chain_cert)
#define _SSL_add1_credential BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add1_credential)
#define _SSL_add_application_settings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add_application_settings)
#define _SSL_add_bio_cert_subjects_to_stack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add_bio_cert_subjects_to_stack)
#define _SSL_add_client_CA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add_client_CA)
#define _SSL_add_file_cert_subjects_to_stack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_add_file_cert_subjects_to_stack)
#define _SSL_alert_desc_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_alert_desc_string)
#define _SSL_alert_desc_string_long BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_alert_desc_string_long)
#define _SSL_alert_from_verify_result BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_alert_from_verify_result)
#define _SSL_alert_type_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_alert_type_string)
#define _SSL_alert_type_string_long BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_alert_type_string_long)
#define _SSL_cache_hit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_cache_hit)
#define _SSL_can_release_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_can_release_private_key)
#define _SSL_certs_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_certs_clear)
#define _SSL_check_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_check_private_key)
#define _SSL_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_clear)
#define _SSL_clear_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_clear_chain_certs)
#define _SSL_clear_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_clear_mode)
#define _SSL_clear_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_clear_options)
#define _SSL_connect BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_connect)
#define _SSL_cutthrough_complete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_cutthrough_complete)
#define _SSL_do_handshake BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_do_handshake)
#define _SSL_dup_CA_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_dup_CA_list)
#define _SSL_early_callback_ctx_extension_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_early_callback_ctx_extension_get)
#define _SSL_early_data_accepted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_early_data_accepted)
#define _SSL_early_data_reason_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_early_data_reason_string)
#define _SSL_ech_accepted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_ech_accepted)
#define _SSL_enable_ocsp_stapling BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_enable_ocsp_stapling)
#define _SSL_enable_signed_cert_timestamps BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_enable_signed_cert_timestamps)
#define _SSL_enable_tls_channel_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_enable_tls_channel_id)
#define _SSL_error_description BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_error_description)
#define _SSL_export_keying_material BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_export_keying_material)
#define _SSL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_free)
#define _SSL_generate_key_block BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_generate_key_block)
#define _SSL_get0_alpn_selected BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_alpn_selected)
#define _SSL_get0_certificate_types BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_certificate_types)
#define _SSL_get0_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_chain)
#define _SSL_get0_chain_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_chain_certs)
#define _SSL_get0_ech_name_override BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_ech_name_override)
#define _SSL_get0_ech_retry_configs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_ech_retry_configs)
#define _SSL_get0_next_proto_negotiated BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_next_proto_negotiated)
#define _SSL_get0_ocsp_response BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_ocsp_response)
#define _SSL_get0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_param)
#define _SSL_get0_peer_application_settings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_peer_application_settings)
#define _SSL_get0_peer_certificates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_peer_certificates)
#define _SSL_get0_peer_delegation_algorithms BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_peer_delegation_algorithms)
#define _SSL_get0_peer_verify_algorithms BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_peer_verify_algorithms)
#define _SSL_get0_selected_credential BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_selected_credential)
#define _SSL_get0_server_requested_CAs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_server_requested_CAs)
#define _SSL_get0_session_id_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_session_id_context)
#define _SSL_get0_signed_cert_timestamp_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get0_signed_cert_timestamp_list)
#define _SSL_get1_session BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get1_session)
#define _SSL_get_SSL_CTX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_SSL_CTX)
#define _SSL_get_all_cipher_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_cipher_names)
#define _SSL_get_all_curve_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_curve_names)
#define _SSL_get_all_group_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_group_names)
#define _SSL_get_all_signature_algorithm_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_signature_algorithm_names)
#define _SSL_get_all_standard_cipher_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_standard_cipher_names)
#define _SSL_get_all_version_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_all_version_names)
#define _SSL_get_certificate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_certificate)
#define _SSL_get_cipher_by_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_cipher_by_value)
#define _SSL_get_cipher_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_cipher_list)
#define _SSL_get_ciphers BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ciphers)
#define _SSL_get_client_CA_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_client_CA_list)
#define _SSL_get_client_random BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_client_random)
#define _SSL_get_compliance_policy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_compliance_policy)
#define _SSL_get_current_cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_current_cipher)
#define _SSL_get_current_compression BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_current_compression)
#define _SSL_get_current_expansion BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_current_expansion)
#define _SSL_get_curve_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_curve_id)
#define _SSL_get_curve_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_curve_name)
#define _SSL_get_default_timeout BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_default_timeout)
#define _SSL_get_early_data_reason BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_early_data_reason)
#define _SSL_get_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_error)
#define _SSL_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ex_data)
#define _SSL_get_ex_data_X509_STORE_CTX_idx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ex_data_X509_STORE_CTX_idx)
#define _SSL_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ex_new_index)
#define _SSL_get_extms_support BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_extms_support)
#define _SSL_get_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_fd)
#define _SSL_get_finished BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_finished)
#define _SSL_get_group_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_group_id)
#define _SSL_get_group_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_group_name)
#define _SSL_get_info_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_info_callback)
#define _SSL_get_ivs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ivs)
#define _SSL_get_key_block_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_key_block_len)
#define _SSL_get_max_cert_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_max_cert_list)
#define _SSL_get_max_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_max_proto_version)
#define _SSL_get_min_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_min_proto_version)
#define _SSL_get_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_mode)
#define _SSL_get_negotiated_group BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_negotiated_group)
#define _SSL_get_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_options)
#define _SSL_get_peer_cert_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_cert_chain)
#define _SSL_get_peer_certificate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_certificate)
#define _SSL_get_peer_finished BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_finished)
#define _SSL_get_peer_full_cert_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_full_cert_chain)
#define _SSL_get_peer_quic_transport_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_quic_transport_params)
#define _SSL_get_peer_signature_algorithm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_peer_signature_algorithm)
#define _SSL_get_pending_cipher BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_pending_cipher)
#define _SSL_get_privatekey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_privatekey)
#define _SSL_get_psk_identity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_psk_identity)
#define _SSL_get_psk_identity_hint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_psk_identity_hint)
#define _SSL_get_quiet_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_quiet_shutdown)
#define _SSL_get_rbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_rbio)
#define _SSL_get_read_ahead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_read_ahead)
#define _SSL_get_read_sequence BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_read_sequence)
#define _SSL_get_rfd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_rfd)
#define _SSL_get_secure_renegotiation_support BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_secure_renegotiation_support)
#define _SSL_get_selected_srtp_profile BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_selected_srtp_profile)
#define _SSL_get_server_random BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_server_random)
#define _SSL_get_server_tmp_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_server_tmp_key)
#define _SSL_get_servername BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_servername)
#define _SSL_get_servername_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_servername_type)
#define _SSL_get_session BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_session)
#define _SSL_get_shared_ciphers BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_shared_ciphers)
#define _SSL_get_shared_sigalgs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_shared_sigalgs)
#define _SSL_get_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_shutdown)
#define _SSL_get_signature_algorithm_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_signature_algorithm_digest)
#define _SSL_get_signature_algorithm_key_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_signature_algorithm_key_type)
#define _SSL_get_signature_algorithm_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_signature_algorithm_name)
#define _SSL_get_srtp_profiles BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_srtp_profiles)
#define _SSL_get_ticket_age_skew BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_ticket_age_skew)
#define _SSL_get_tls_channel_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_tls_channel_id)
#define _SSL_get_tls_unique BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_tls_unique)
#define _SSL_get_tlsext_status_ocsp_resp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_tlsext_status_ocsp_resp)
#define _SSL_get_tlsext_status_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_tlsext_status_type)
#define _SSL_get_verify_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_verify_callback)
#define _SSL_get_verify_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_verify_depth)
#define _SSL_get_verify_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_verify_mode)
#define _SSL_get_verify_result BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_verify_result)
#define _SSL_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_version)
#define _SSL_get_wbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_wbio)
#define _SSL_get_wfd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_wfd)
#define _SSL_get_write_sequence BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_get_write_sequence)
#define _SSL_has_application_settings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_has_application_settings)
#define _SSL_has_pending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_has_pending)
#define _SSL_in_early_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_in_early_data)
#define _SSL_in_false_start BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_in_false_start)
#define _SSL_in_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_in_init)
#define _SSL_is_dtls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_is_dtls)
#define _SSL_is_init_finished BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_is_init_finished)
#define _SSL_is_quic BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_is_quic)
#define _SSL_is_server BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_is_server)
#define _SSL_is_signature_algorithm_rsa_pss BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_is_signature_algorithm_rsa_pss)
#define _SSL_key_update BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_key_update)
#define _SSL_library_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_library_init)
#define _SSL_load_client_CA_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_load_client_CA_file)
#define _SSL_load_error_strings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_load_error_strings)
#define _SSL_magic_pending_session_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_magic_pending_session_ptr)
#define _SSL_marshal_ech_config BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_marshal_ech_config)
#define _SSL_max_seal_overhead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_max_seal_overhead)
#define _SSL_need_tmp_RSA BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_need_tmp_RSA)
#define _SSL_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_new)
#define _SSL_num_renegotiations BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_num_renegotiations)
#define _SSL_peek BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_peek)
#define _SSL_pending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_pending)
#define _SSL_process_quic_post_handshake BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_process_quic_post_handshake)
#define _SSL_process_tls13_new_session_ticket BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_process_tls13_new_session_ticket)
#define _SSL_provide_quic_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_provide_quic_data)
#define _SSL_quic_max_handshake_flight_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_quic_max_handshake_flight_len)
#define _SSL_quic_read_level BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_quic_read_level)
#define _SSL_quic_write_level BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_quic_write_level)
#define _SSL_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_read)
#define _SSL_renegotiate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_renegotiate)
#define _SSL_renegotiate_pending BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_renegotiate_pending)
#define _SSL_request_handshake_hints BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_request_handshake_hints)
#define _SSL_reset_early_data_reject BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_reset_early_data_reject)
#define _SSL_select_next_proto BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_select_next_proto)
#define _SSL_send_fatal_alert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_send_fatal_alert)
#define _SSL_serialize_capabilities BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_serialize_capabilities)
#define _SSL_serialize_handshake_hints BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_serialize_handshake_hints)
#define _SSL_session_reused BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_session_reused)
#define _SSL_set0_CA_names BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_CA_names)
#define _SSL_set0_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_chain)
#define _SSL_set0_client_CAs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_client_CAs)
#define _SSL_set0_rbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_rbio)
#define _SSL_set0_verify_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_verify_cert_store)
#define _SSL_set0_wbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set0_wbio)
#define _SSL_set1_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_chain)
#define _SSL_set1_curves BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_curves)
#define _SSL_set1_curves_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_curves_list)
#define _SSL_set1_ech_config_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_ech_config_list)
#define _SSL_set1_group_ids BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_group_ids)
#define _SSL_set1_groups BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_groups)
#define _SSL_set1_groups_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_groups_list)
#define _SSL_set1_host BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_host)
#define _SSL_set1_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_param)
#define _SSL_set1_sigalgs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_sigalgs)
#define _SSL_set1_sigalgs_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_sigalgs_list)
#define _SSL_set1_tls_channel_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_tls_channel_id)
#define _SSL_set1_verify_cert_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set1_verify_cert_store)
#define _SSL_set_SSL_CTX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_SSL_CTX)
#define _SSL_set_accept_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_accept_state)
#define _SSL_set_alpn_protos BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_alpn_protos)
#define _SSL_set_alps_use_new_codepoint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_alps_use_new_codepoint)
#define _SSL_set_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_bio)
#define _SSL_set_cert_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_cert_cb)
#define _SSL_set_chain_and_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_chain_and_key)
#define _SSL_set_check_client_certificate_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_check_client_certificate_type)
#define _SSL_set_check_ecdsa_curve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_check_ecdsa_curve)
#define _SSL_set_cipher_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_cipher_list)
#define _SSL_set_client_CA_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_client_CA_list)
#define _SSL_set_compliance_policy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_compliance_policy)
#define _SSL_set_connect_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_connect_state)
#define _SSL_set_custom_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_custom_verify)
#define _SSL_set_early_data_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_early_data_enabled)
#define _SSL_set_enable_ech_grease BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_enable_ech_grease)
#define _SSL_set_enforce_rsa_key_usage BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_enforce_rsa_key_usage)
#define _SSL_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_ex_data)
#define _SSL_set_fd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_fd)
#define _SSL_set_handshake_hints BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_handshake_hints)
#define _SSL_set_hostflags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_hostflags)
#define _SSL_set_info_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_info_callback)
#define _SSL_set_jdk11_workaround BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_jdk11_workaround)
#define _SSL_set_max_cert_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_max_cert_list)
#define _SSL_set_max_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_max_proto_version)
#define _SSL_set_max_send_fragment BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_max_send_fragment)
#define _SSL_set_min_proto_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_min_proto_version)
#define _SSL_set_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_mode)
#define _SSL_set_msg_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_msg_callback)
#define _SSL_set_msg_callback_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_msg_callback_arg)
#define _SSL_set_mtu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_mtu)
#define _SSL_set_ocsp_response BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_ocsp_response)
#define _SSL_set_options BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_options)
#define _SSL_set_permute_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_permute_extensions)
#define _SSL_set_private_key_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_private_key_method)
#define _SSL_set_psk_client_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_psk_client_callback)
#define _SSL_set_psk_server_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_psk_server_callback)
#define _SSL_set_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_purpose)
#define _SSL_set_quic_early_data_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_quic_early_data_context)
#define _SSL_set_quic_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_quic_method)
#define _SSL_set_quic_transport_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_quic_transport_params)
#define _SSL_set_quic_use_legacy_codepoint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_quic_use_legacy_codepoint)
#define _SSL_set_quiet_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_quiet_shutdown)
#define _SSL_set_read_ahead BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_read_ahead)
#define _SSL_set_renegotiate_mode BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_renegotiate_mode)
#define _SSL_set_retain_only_sha256_of_client_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_retain_only_sha256_of_client_certs)
#define _SSL_set_rfd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_rfd)
#define _SSL_set_session BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_session)
#define _SSL_set_session_id_context BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_session_id_context)
#define _SSL_set_shed_handshake_config BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_shed_handshake_config)
#define _SSL_set_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_shutdown)
#define _SSL_set_signed_cert_timestamp_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_signed_cert_timestamp_list)
#define _SSL_set_signing_algorithm_prefs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_signing_algorithm_prefs)
#define _SSL_set_srtp_profiles BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_srtp_profiles)
#define _SSL_set_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_state)
#define _SSL_set_strict_cipher_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_strict_cipher_list)
#define _SSL_set_tls_channel_id_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tls_channel_id_enabled)
#define _SSL_set_tlsext_host_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tlsext_host_name)
#define _SSL_set_tlsext_status_ocsp_resp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tlsext_status_ocsp_resp)
#define _SSL_set_tlsext_status_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tlsext_status_type)
#define _SSL_set_tlsext_use_srtp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tlsext_use_srtp)
#define _SSL_set_tmp_dh BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tmp_dh)
#define _SSL_set_tmp_dh_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tmp_dh_callback)
#define _SSL_set_tmp_ecdh BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tmp_ecdh)
#define _SSL_set_tmp_rsa BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tmp_rsa)
#define _SSL_set_tmp_rsa_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_tmp_rsa_callback)
#define _SSL_set_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_trust)
#define _SSL_set_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_verify)
#define _SSL_set_verify_algorithm_prefs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_verify_algorithm_prefs)
#define _SSL_set_verify_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_verify_depth)
#define _SSL_set_wfd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_set_wfd)
#define _SSL_shutdown BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_shutdown)
#define _SSL_state BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_state)
#define _SSL_state_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_state_string)
#define _SSL_state_string_long BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_state_string_long)
#define _SSL_total_renegotiations BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_total_renegotiations)
#define _SSL_use_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_PrivateKey)
#define _SSL_use_PrivateKey_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_PrivateKey_ASN1)
#define _SSL_use_PrivateKey_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_PrivateKey_file)
#define _SSL_use_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_RSAPrivateKey)
#define _SSL_use_RSAPrivateKey_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_RSAPrivateKey_ASN1)
#define _SSL_use_RSAPrivateKey_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_RSAPrivateKey_file)
#define _SSL_use_certificate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_certificate)
#define _SSL_use_certificate_ASN1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_certificate_ASN1)
#define _SSL_use_certificate_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_certificate_file)
#define _SSL_use_psk_identity_hint BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_use_psk_identity_hint)
#define _SSL_used_hello_retry_request BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_used_hello_retry_request)
#define _SSL_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_version)
#define _SSL_want BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_want)
#define _SSL_was_key_usage_invalid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_was_key_usage_invalid)
#define _SSL_write BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSL_write)
#define _SSLeay BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSLeay)
#define _SSLeay_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSLeay_version)
#define _SSLv23_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSLv23_client_method)
#define _SSLv23_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSLv23_method)
#define _SSLv23_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, SSLv23_server_method)
#define _TLS_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLS_client_method)
#define _TLS_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLS_method)
#define _TLS_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLS_server_method)
#define _TLS_with_buffers_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLS_with_buffers_method)
#define _TLSv1_1_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_1_client_method)
#define _TLSv1_1_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_1_method)
#define _TLSv1_1_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_1_server_method)
#define _TLSv1_2_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_2_client_method)
#define _TLSv1_2_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_2_method)
#define _TLSv1_2_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_2_server_method)
#define _TLSv1_client_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_client_method)
#define _TLSv1_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_method)
#define _TLSv1_server_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TLSv1_server_method)
#define _TRUST_TOKEN_CLIENT_add_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_add_key)
#define _TRUST_TOKEN_CLIENT_begin_issuance BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_begin_issuance)
#define _TRUST_TOKEN_CLIENT_begin_issuance_over_message BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_begin_issuance_over_message)
#define _TRUST_TOKEN_CLIENT_begin_redemption BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_begin_redemption)
#define _TRUST_TOKEN_CLIENT_finish_issuance BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_finish_issuance)
#define _TRUST_TOKEN_CLIENT_finish_redemption BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_finish_redemption)
#define _TRUST_TOKEN_CLIENT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_free)
#define _TRUST_TOKEN_CLIENT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_new)
#define _TRUST_TOKEN_CLIENT_set_srr_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_CLIENT_set_srr_key)
#define _TRUST_TOKEN_ISSUER_add_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_add_key)
#define _TRUST_TOKEN_ISSUER_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_free)
#define _TRUST_TOKEN_ISSUER_issue BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_issue)
#define _TRUST_TOKEN_ISSUER_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_new)
#define _TRUST_TOKEN_ISSUER_redeem BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_redeem)
#define _TRUST_TOKEN_ISSUER_redeem_over_message BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_redeem_over_message)
#define _TRUST_TOKEN_ISSUER_set_metadata_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_set_metadata_key)
#define _TRUST_TOKEN_ISSUER_set_srr_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_ISSUER_set_srr_key)
#define _TRUST_TOKEN_PRETOKEN_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_PRETOKEN_free)
#define _TRUST_TOKEN_decode_private_metadata BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_decode_private_metadata)
#define _TRUST_TOKEN_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_derive_key_from_secret)
#define _TRUST_TOKEN_experiment_v1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_experiment_v1)
#define _TRUST_TOKEN_experiment_v2_pmb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_experiment_v2_pmb)
#define _TRUST_TOKEN_experiment_v2_voprf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_experiment_v2_voprf)
#define _TRUST_TOKEN_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_free)
#define _TRUST_TOKEN_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_generate_key)
#define _TRUST_TOKEN_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_new)
#define _TRUST_TOKEN_pst_v1_pmb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_pst_v1_pmb)
#define _TRUST_TOKEN_pst_v1_voprf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, TRUST_TOKEN_pst_v1_voprf)
#define _USERNOTICE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, USERNOTICE_free)
#define _USERNOTICE_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, USERNOTICE_it)
#define _USERNOTICE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, USERNOTICE_new)
#define _X25519 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X25519)
#define _X25519_keypair BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X25519_keypair)
#define _X25519_public_from_private BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X25519_public_from_private)
#define _X509V3_EXT_CRL_add_nconf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_CRL_add_nconf)
#define _X509V3_EXT_REQ_add_nconf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_REQ_add_nconf)
#define _X509V3_EXT_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_add)
#define _X509V3_EXT_add_alias BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_add_alias)
#define _X509V3_EXT_add_nconf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_add_nconf)
#define _X509V3_EXT_add_nconf_sk BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_add_nconf_sk)
#define _X509V3_EXT_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_d2i)
#define _X509V3_EXT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_free)
#define _X509V3_EXT_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_get)
#define _X509V3_EXT_get_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_get_nid)
#define _X509V3_EXT_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_i2d)
#define _X509V3_EXT_nconf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_nconf)
#define _X509V3_EXT_nconf_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_nconf_nid)
#define _X509V3_EXT_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_print)
#define _X509V3_EXT_print_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_EXT_print_fp)
#define _X509V3_NAME_from_section BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_NAME_from_section)
#define _X509V3_add1_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_add1_i2d)
#define _X509V3_add_standard_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_add_standard_extensions)
#define _X509V3_add_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_add_value)
#define _X509V3_add_value_bool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_add_value_bool)
#define _X509V3_add_value_int BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_add_value_int)
#define _X509V3_bool_from_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_bool_from_string)
#define _X509V3_conf_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_conf_free)
#define _X509V3_extensions_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_extensions_print)
#define _X509V3_get_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_get_d2i)
#define _X509V3_get_section BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_get_section)
#define _X509V3_get_value_bool BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_get_value_bool)
#define _X509V3_get_value_int BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_get_value_int)
#define _X509V3_parse_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_parse_list)
#define _X509V3_set_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_set_ctx)
#define _X509V3_set_nconf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509V3_set_nconf)
#define _X509_ALGOR_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_cmp)
#define _X509_ALGOR_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_dup)
#define _X509_ALGOR_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_free)
#define _X509_ALGOR_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_get0)
#define _X509_ALGOR_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_it)
#define _X509_ALGOR_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_new)
#define _X509_ALGOR_set0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_set0)
#define _X509_ALGOR_set_md BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ALGOR_set_md)
#define _X509_ATTRIBUTE_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_count)
#define _X509_ATTRIBUTE_create BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_create)
#define _X509_ATTRIBUTE_create_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_create_by_NID)
#define _X509_ATTRIBUTE_create_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_create_by_OBJ)
#define _X509_ATTRIBUTE_create_by_txt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_create_by_txt)
#define _X509_ATTRIBUTE_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_dup)
#define _X509_ATTRIBUTE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_free)
#define _X509_ATTRIBUTE_get0_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_get0_data)
#define _X509_ATTRIBUTE_get0_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_get0_object)
#define _X509_ATTRIBUTE_get0_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_get0_type)
#define _X509_ATTRIBUTE_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_it)
#define _X509_ATTRIBUTE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_new)
#define _X509_ATTRIBUTE_set1_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_set1_data)
#define _X509_ATTRIBUTE_set1_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_ATTRIBUTE_set1_object)
#define _X509_CERT_AUX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CERT_AUX_free)
#define _X509_CERT_AUX_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CERT_AUX_it)
#define _X509_CERT_AUX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CERT_AUX_new)
#define _X509_CERT_AUX_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CERT_AUX_print)
#define _X509_CINF_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CINF_free)
#define _X509_CINF_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CINF_it)
#define _X509_CINF_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CINF_new)
#define _X509_CRL_INFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_INFO_free)
#define _X509_CRL_INFO_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_INFO_it)
#define _X509_CRL_INFO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_INFO_new)
#define _X509_CRL_add0_revoked BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_add0_revoked)
#define _X509_CRL_add1_ext_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_add1_ext_i2d)
#define _X509_CRL_add_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_add_ext)
#define _X509_CRL_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_cmp)
#define _X509_CRL_delete_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_delete_ext)
#define _X509_CRL_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_digest)
#define _X509_CRL_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_dup)
#define _X509_CRL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_free)
#define _X509_CRL_get0_by_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_by_cert)
#define _X509_CRL_get0_by_serial BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_by_serial)
#define _X509_CRL_get0_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_extensions)
#define _X509_CRL_get0_lastUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_lastUpdate)
#define _X509_CRL_get0_nextUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_nextUpdate)
#define _X509_CRL_get0_signature BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get0_signature)
#define _X509_CRL_get_REVOKED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_REVOKED)
#define _X509_CRL_get_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext)
#define _X509_CRL_get_ext_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext_by_NID)
#define _X509_CRL_get_ext_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext_by_OBJ)
#define _X509_CRL_get_ext_by_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext_by_critical)
#define _X509_CRL_get_ext_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext_count)
#define _X509_CRL_get_ext_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_ext_d2i)
#define _X509_CRL_get_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_issuer)
#define _X509_CRL_get_lastUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_lastUpdate)
#define _X509_CRL_get_nextUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_nextUpdate)
#define _X509_CRL_get_signature_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_signature_nid)
#define _X509_CRL_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_get_version)
#define _X509_CRL_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_it)
#define _X509_CRL_match BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_match)
#define _X509_CRL_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_new)
#define _X509_CRL_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_print)
#define _X509_CRL_print_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_print_fp)
#define _X509_CRL_set1_lastUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set1_lastUpdate)
#define _X509_CRL_set1_nextUpdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set1_nextUpdate)
#define _X509_CRL_set1_signature_algo BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set1_signature_algo)
#define _X509_CRL_set1_signature_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set1_signature_value)
#define _X509_CRL_set_issuer_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set_issuer_name)
#define _X509_CRL_set_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_set_version)
#define _X509_CRL_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_sign)
#define _X509_CRL_sign_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_sign_ctx)
#define _X509_CRL_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_sort)
#define _X509_CRL_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_up_ref)
#define _X509_CRL_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_CRL_verify)
#define _X509_EXTENSIONS_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSIONS_it)
#define _X509_EXTENSION_create_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_create_by_NID)
#define _X509_EXTENSION_create_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_create_by_OBJ)
#define _X509_EXTENSION_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_dup)
#define _X509_EXTENSION_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_free)
#define _X509_EXTENSION_get_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_get_critical)
#define _X509_EXTENSION_get_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_get_data)
#define _X509_EXTENSION_get_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_get_object)
#define _X509_EXTENSION_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_it)
#define _X509_EXTENSION_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_new)
#define _X509_EXTENSION_set_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_set_critical)
#define _X509_EXTENSION_set_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_set_data)
#define _X509_EXTENSION_set_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_EXTENSION_set_object)
#define _X509_INFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_INFO_free)
#define _X509_LOOKUP_add_dir BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_add_dir)
#define _X509_LOOKUP_ctrl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_ctrl)
#define _X509_LOOKUP_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_file)
#define _X509_LOOKUP_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_free)
#define _X509_LOOKUP_hash_dir BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_hash_dir)
#define _X509_LOOKUP_load_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_LOOKUP_load_file)
#define _X509_NAME_ENTRY_create_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_create_by_NID)
#define _X509_NAME_ENTRY_create_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_create_by_OBJ)
#define _X509_NAME_ENTRY_create_by_txt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_create_by_txt)
#define _X509_NAME_ENTRY_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_dup)
#define _X509_NAME_ENTRY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_free)
#define _X509_NAME_ENTRY_get_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_get_data)
#define _X509_NAME_ENTRY_get_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_get_object)
#define _X509_NAME_ENTRY_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_it)
#define _X509_NAME_ENTRY_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_new)
#define _X509_NAME_ENTRY_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_set)
#define _X509_NAME_ENTRY_set_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_set_data)
#define _X509_NAME_ENTRY_set_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_ENTRY_set_object)
#define _X509_NAME_add_entry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_add_entry)
#define _X509_NAME_add_entry_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_add_entry_by_NID)
#define _X509_NAME_add_entry_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_add_entry_by_OBJ)
#define _X509_NAME_add_entry_by_txt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_add_entry_by_txt)
#define _X509_NAME_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_cmp)
#define _X509_NAME_delete_entry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_delete_entry)
#define _X509_NAME_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_digest)
#define _X509_NAME_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_dup)
#define _X509_NAME_entry_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_entry_count)
#define _X509_NAME_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_free)
#define _X509_NAME_get0_der BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get0_der)
#define _X509_NAME_get_entry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get_entry)
#define _X509_NAME_get_index_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get_index_by_NID)
#define _X509_NAME_get_index_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get_index_by_OBJ)
#define _X509_NAME_get_text_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get_text_by_NID)
#define _X509_NAME_get_text_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_get_text_by_OBJ)
#define _X509_NAME_hash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_hash)
#define _X509_NAME_hash_old BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_hash_old)
#define _X509_NAME_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_it)
#define _X509_NAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_new)
#define _X509_NAME_oneline BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_oneline)
#define _X509_NAME_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_print)
#define _X509_NAME_print_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_print_ex)
#define _X509_NAME_print_ex_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_print_ex_fp)
#define _X509_NAME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_NAME_set)
#define _X509_OBJECT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_OBJECT_free)
#define _X509_OBJECT_free_contents BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_OBJECT_free_contents)
#define _X509_OBJECT_get0_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_OBJECT_get0_X509)
#define _X509_OBJECT_get_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_OBJECT_get_type)
#define _X509_OBJECT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_OBJECT_new)
#define _X509_PUBKEY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_free)
#define _X509_PUBKEY_get BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_get)
#define _X509_PUBKEY_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_get0)
#define _X509_PUBKEY_get0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_get0_param)
#define _X509_PUBKEY_get0_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_get0_public_key)
#define _X509_PUBKEY_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_it)
#define _X509_PUBKEY_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_new)
#define _X509_PUBKEY_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_set)
#define _X509_PUBKEY_set0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PUBKEY_set0_param)
#define _X509_PURPOSE_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PURPOSE_get0)
#define _X509_PURPOSE_get_by_sname BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PURPOSE_get_by_sname)
#define _X509_PURPOSE_get_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PURPOSE_get_id)
#define _X509_PURPOSE_get_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_PURPOSE_get_trust)
#define _X509_REQ_INFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_INFO_free)
#define _X509_REQ_INFO_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_INFO_it)
#define _X509_REQ_INFO_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_INFO_new)
#define _X509_REQ_add1_attr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add1_attr)
#define _X509_REQ_add1_attr_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add1_attr_by_NID)
#define _X509_REQ_add1_attr_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add1_attr_by_OBJ)
#define _X509_REQ_add1_attr_by_txt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add1_attr_by_txt)
#define _X509_REQ_add_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add_extensions)
#define _X509_REQ_add_extensions_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_add_extensions_nid)
#define _X509_REQ_check_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_check_private_key)
#define _X509_REQ_delete_attr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_delete_attr)
#define _X509_REQ_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_digest)
#define _X509_REQ_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_dup)
#define _X509_REQ_extension_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_extension_nid)
#define _X509_REQ_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_free)
#define _X509_REQ_get0_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get0_pubkey)
#define _X509_REQ_get0_signature BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get0_signature)
#define _X509_REQ_get1_email BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get1_email)
#define _X509_REQ_get_attr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_attr)
#define _X509_REQ_get_attr_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_attr_by_NID)
#define _X509_REQ_get_attr_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_attr_by_OBJ)
#define _X509_REQ_get_attr_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_attr_count)
#define _X509_REQ_get_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_extensions)
#define _X509_REQ_get_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_pubkey)
#define _X509_REQ_get_signature_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_signature_nid)
#define _X509_REQ_get_subject_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_subject_name)
#define _X509_REQ_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_get_version)
#define _X509_REQ_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_it)
#define _X509_REQ_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_new)
#define _X509_REQ_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_print)
#define _X509_REQ_print_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_print_ex)
#define _X509_REQ_print_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_print_fp)
#define _X509_REQ_set1_signature_algo BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_set1_signature_algo)
#define _X509_REQ_set1_signature_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_set1_signature_value)
#define _X509_REQ_set_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_set_pubkey)
#define _X509_REQ_set_subject_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_set_subject_name)
#define _X509_REQ_set_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_set_version)
#define _X509_REQ_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_sign)
#define _X509_REQ_sign_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_sign_ctx)
#define _X509_REQ_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REQ_verify)
#define _X509_REVOKED_add1_ext_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_add1_ext_i2d)
#define _X509_REVOKED_add_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_add_ext)
#define _X509_REVOKED_delete_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_delete_ext)
#define _X509_REVOKED_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_dup)
#define _X509_REVOKED_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_free)
#define _X509_REVOKED_get0_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get0_extensions)
#define _X509_REVOKED_get0_revocationDate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get0_revocationDate)
#define _X509_REVOKED_get0_serialNumber BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get0_serialNumber)
#define _X509_REVOKED_get_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext)
#define _X509_REVOKED_get_ext_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext_by_NID)
#define _X509_REVOKED_get_ext_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext_by_OBJ)
#define _X509_REVOKED_get_ext_by_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext_by_critical)
#define _X509_REVOKED_get_ext_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext_count)
#define _X509_REVOKED_get_ext_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_get_ext_d2i)
#define _X509_REVOKED_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_it)
#define _X509_REVOKED_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_new)
#define _X509_REVOKED_set_revocationDate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_set_revocationDate)
#define _X509_REVOKED_set_serialNumber BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_REVOKED_set_serialNumber)
#define _X509_SIG_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_SIG_free)
#define _X509_SIG_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_SIG_get0)
#define _X509_SIG_getm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_SIG_getm)
#define _X509_SIG_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_SIG_new)
#define _X509_STORE_CTX_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_cleanup)
#define _X509_STORE_CTX_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_free)
#define _X509_STORE_CTX_get0_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_cert)
#define _X509_STORE_CTX_get0_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_chain)
#define _X509_STORE_CTX_get0_current_crl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_current_crl)
#define _X509_STORE_CTX_get0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_param)
#define _X509_STORE_CTX_get0_parent_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_parent_ctx)
#define _X509_STORE_CTX_get0_store BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_store)
#define _X509_STORE_CTX_get0_untrusted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get0_untrusted)
#define _X509_STORE_CTX_get1_certs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get1_certs)
#define _X509_STORE_CTX_get1_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get1_chain)
#define _X509_STORE_CTX_get1_crls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get1_crls)
#define _X509_STORE_CTX_get1_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get1_issuer)
#define _X509_STORE_CTX_get_by_subject BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_by_subject)
#define _X509_STORE_CTX_get_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_chain)
#define _X509_STORE_CTX_get_current_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_current_cert)
#define _X509_STORE_CTX_get_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_error)
#define _X509_STORE_CTX_get_error_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_error_depth)
#define _X509_STORE_CTX_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_ex_data)
#define _X509_STORE_CTX_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_get_ex_new_index)
#define _X509_STORE_CTX_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_init)
#define _X509_STORE_CTX_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_new)
#define _X509_STORE_CTX_set0_crls BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set0_crls)
#define _X509_STORE_CTX_set0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set0_param)
#define _X509_STORE_CTX_set0_trusted_stack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set0_trusted_stack)
#define _X509_STORE_CTX_set_chain BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_chain)
#define _X509_STORE_CTX_set_default BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_default)
#define _X509_STORE_CTX_set_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_depth)
#define _X509_STORE_CTX_set_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_error)
#define _X509_STORE_CTX_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_ex_data)
#define _X509_STORE_CTX_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_flags)
#define _X509_STORE_CTX_set_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_purpose)
#define _X509_STORE_CTX_set_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_time)
#define _X509_STORE_CTX_set_time_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_time_posix)
#define _X509_STORE_CTX_set_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_trust)
#define _X509_STORE_CTX_set_verify_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_set_verify_cb)
#define _X509_STORE_CTX_trusted_stack BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_CTX_trusted_stack)
#define _X509_STORE_add_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_add_cert)
#define _X509_STORE_add_crl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_add_crl)
#define _X509_STORE_add_lookup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_add_lookup)
#define _X509_STORE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_free)
#define _X509_STORE_get0_objects BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_get0_objects)
#define _X509_STORE_get0_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_get0_param)
#define _X509_STORE_get1_objects BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_get1_objects)
#define _X509_STORE_load_locations BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_load_locations)
#define _X509_STORE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_new)
#define _X509_STORE_set1_param BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set1_param)
#define _X509_STORE_set_default_paths BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_default_paths)
#define _X509_STORE_set_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_depth)
#define _X509_STORE_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_flags)
#define _X509_STORE_set_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_purpose)
#define _X509_STORE_set_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_trust)
#define _X509_STORE_set_verify_cb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_set_verify_cb)
#define _X509_STORE_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_STORE_up_ref)
#define _X509_VAL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VAL_free)
#define _X509_VAL_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VAL_it)
#define _X509_VAL_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VAL_new)
#define _X509_VERIFY_PARAM_add0_policy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_add0_policy)
#define _X509_VERIFY_PARAM_add1_host BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_add1_host)
#define _X509_VERIFY_PARAM_clear_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_clear_flags)
#define _X509_VERIFY_PARAM_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_free)
#define _X509_VERIFY_PARAM_get_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_get_depth)
#define _X509_VERIFY_PARAM_get_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_get_flags)
#define _X509_VERIFY_PARAM_inherit BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_inherit)
#define _X509_VERIFY_PARAM_lookup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_lookup)
#define _X509_VERIFY_PARAM_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_new)
#define _X509_VERIFY_PARAM_set1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1)
#define _X509_VERIFY_PARAM_set1_email BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1_email)
#define _X509_VERIFY_PARAM_set1_host BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1_host)
#define _X509_VERIFY_PARAM_set1_ip BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1_ip)
#define _X509_VERIFY_PARAM_set1_ip_asc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1_ip_asc)
#define _X509_VERIFY_PARAM_set1_policies BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set1_policies)
#define _X509_VERIFY_PARAM_set_depth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_depth)
#define _X509_VERIFY_PARAM_set_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_flags)
#define _X509_VERIFY_PARAM_set_hostflags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_hostflags)
#define _X509_VERIFY_PARAM_set_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_purpose)
#define _X509_VERIFY_PARAM_set_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_time)
#define _X509_VERIFY_PARAM_set_time_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_time_posix)
#define _X509_VERIFY_PARAM_set_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_VERIFY_PARAM_set_trust)
#define _X509_add1_ext_i2d BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_add1_ext_i2d)
#define _X509_add1_reject_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_add1_reject_object)
#define _X509_add1_trust_object BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_add1_trust_object)
#define _X509_add_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_add_ext)
#define _X509_alias_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_alias_get0)
#define _X509_alias_set1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_alias_set1)
#define _X509_chain_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_chain_up_ref)
#define _X509_check_akid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_akid)
#define _X509_check_ca BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_ca)
#define _X509_check_email BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_email)
#define _X509_check_host BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_host)
#define _X509_check_ip BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_ip)
#define _X509_check_ip_asc BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_ip_asc)
#define _X509_check_issued BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_issued)
#define _X509_check_private_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_private_key)
#define _X509_check_purpose BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_purpose)
#define _X509_check_trust BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_check_trust)
#define _X509_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_cmp)
#define _X509_cmp_current_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_cmp_current_time)
#define _X509_cmp_time BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_cmp_time)
#define _X509_cmp_time_posix BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_cmp_time_posix)
#define _X509_delete_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_delete_ext)
#define _X509_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_digest)
#define _X509_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_dup)
#define _X509_email_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_email_free)
#define _X509_find_by_issuer_and_serial BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_find_by_issuer_and_serial)
#define _X509_find_by_subject BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_find_by_subject)
#define _X509_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_free)
#define _X509_get0_authority_issuer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_authority_issuer)
#define _X509_get0_authority_key_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_authority_key_id)
#define _X509_get0_authority_serial BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_authority_serial)
#define _X509_get0_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_extensions)
#define _X509_get0_notAfter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_notAfter)
#define _X509_get0_notBefore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_notBefore)
#define _X509_get0_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_pubkey)
#define _X509_get0_pubkey_bitstr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_pubkey_bitstr)
#define _X509_get0_serialNumber BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_serialNumber)
#define _X509_get0_signature BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_signature)
#define _X509_get0_subject_key_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_subject_key_id)
#define _X509_get0_tbs_sigalg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_tbs_sigalg)
#define _X509_get0_uids BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get0_uids)
#define _X509_get1_email BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get1_email)
#define _X509_get1_ocsp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get1_ocsp)
#define _X509_get_X509_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_X509_PUBKEY)
#define _X509_get_default_cert_area BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_cert_area)
#define _X509_get_default_cert_dir BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_cert_dir)
#define _X509_get_default_cert_dir_env BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_cert_dir_env)
#define _X509_get_default_cert_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_cert_file)
#define _X509_get_default_cert_file_env BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_cert_file_env)
#define _X509_get_default_private_dir BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_default_private_dir)
#define _X509_get_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ex_data)
#define _X509_get_ex_new_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ex_new_index)
#define _X509_get_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext)
#define _X509_get_ext_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext_by_NID)
#define _X509_get_ext_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext_by_OBJ)
#define _X509_get_ext_by_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext_by_critical)
#define _X509_get_ext_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext_count)
#define _X509_get_ext_d2i BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_ext_d2i)
#define _X509_get_extended_key_usage BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_extended_key_usage)
#define _X509_get_extension_flags BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_extension_flags)
#define _X509_get_issuer_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_issuer_name)
#define _X509_get_key_usage BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_key_usage)
#define _X509_get_notAfter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_notAfter)
#define _X509_get_notBefore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_notBefore)
#define _X509_get_pathlen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_pathlen)
#define _X509_get_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_pubkey)
#define _X509_get_serialNumber BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_serialNumber)
#define _X509_get_signature_nid BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_signature_nid)
#define _X509_get_subject_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_subject_name)
#define _X509_get_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_get_version)
#define _X509_getm_notAfter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_getm_notAfter)
#define _X509_getm_notBefore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_getm_notBefore)
#define _X509_gmtime_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_gmtime_adj)
#define _X509_is_valid_trust_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_is_valid_trust_id)
#define _X509_issuer_name_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_issuer_name_cmp)
#define _X509_issuer_name_hash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_issuer_name_hash)
#define _X509_issuer_name_hash_old BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_issuer_name_hash_old)
#define _X509_it BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_it)
#define _X509_keyid_get0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_keyid_get0)
#define _X509_keyid_set1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_keyid_set1)
#define _X509_load_cert_crl_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_load_cert_crl_file)
#define _X509_load_cert_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_load_cert_file)
#define _X509_load_crl_file BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_load_crl_file)
#define _X509_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_new)
#define _X509_parse_from_buffer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_parse_from_buffer)
#define _X509_policy_check BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_policy_check)
#define _X509_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_print)
#define _X509_print_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_print_ex)
#define _X509_print_ex_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_print_ex_fp)
#define _X509_print_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_print_fp)
#define _X509_pubkey_digest BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_pubkey_digest)
#define _X509_reject_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_reject_clear)
#define _X509_set1_notAfter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set1_notAfter)
#define _X509_set1_notBefore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set1_notBefore)
#define _X509_set1_signature_algo BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set1_signature_algo)
#define _X509_set1_signature_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set1_signature_value)
#define _X509_set_ex_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_ex_data)
#define _X509_set_issuer_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_issuer_name)
#define _X509_set_notAfter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_notAfter)
#define _X509_set_notBefore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_notBefore)
#define _X509_set_pubkey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_pubkey)
#define _X509_set_serialNumber BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_serialNumber)
#define _X509_set_subject_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_subject_name)
#define _X509_set_version BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_set_version)
#define _X509_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_sign)
#define _X509_sign_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_sign_ctx)
#define _X509_signature_dump BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_signature_dump)
#define _X509_signature_print BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_signature_print)
#define _X509_subject_name_cmp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_subject_name_cmp)
#define _X509_subject_name_hash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_subject_name_hash)
#define _X509_subject_name_hash_old BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_subject_name_hash_old)
#define _X509_supported_extension BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_supported_extension)
#define _X509_time_adj BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_time_adj)
#define _X509_time_adj_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_time_adj_ex)
#define _X509_trust_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_trust_clear)
#define _X509_up_ref BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_up_ref)
#define _X509_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_verify)
#define _X509_verify_cert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_verify_cert)
#define _X509_verify_cert_error_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509_verify_cert_error_string)
#define _X509v3_add_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_add_ext)
#define _X509v3_delete_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_delete_ext)
#define _X509v3_get_ext BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_get_ext)
#define _X509v3_get_ext_by_NID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_get_ext_by_NID)
#define _X509v3_get_ext_by_OBJ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_get_ext_by_OBJ)
#define _X509v3_get_ext_by_critical BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_get_ext_by_critical)
#define _X509v3_get_ext_count BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, X509v3_get_ext_count)
#define ___clang_call_terminate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, __clang_call_terminate)
#define _a2i_IPADDRESS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, a2i_IPADDRESS)
#define _a2i_IPADDRESS_NC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, a2i_IPADDRESS_NC)
#define _aes128gcmsiv_aes_ks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_aes_ks)
#define _aes128gcmsiv_aes_ks_enc_x1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_aes_ks_enc_x1)
#define _aes128gcmsiv_dec BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_dec)
#define _aes128gcmsiv_ecb_enc_block BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_ecb_enc_block)
#define _aes128gcmsiv_enc_msg_x4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_enc_msg_x4)
#define _aes128gcmsiv_enc_msg_x8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_enc_msg_x8)
#define _aes128gcmsiv_kdf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes128gcmsiv_kdf)
#define _aes256gcmsiv_aes_ks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_aes_ks)
#define _aes256gcmsiv_aes_ks_enc_x1 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_aes_ks_enc_x1)
#define _aes256gcmsiv_dec BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_dec)
#define _aes256gcmsiv_ecb_enc_block BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_ecb_enc_block)
#define _aes256gcmsiv_enc_msg_x4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_enc_msg_x4)
#define _aes256gcmsiv_enc_msg_x8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_enc_msg_x8)
#define _aes256gcmsiv_kdf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes256gcmsiv_kdf)
#define _aes_ctr_set_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_ctr_set_key)
#define _aes_gcm_dec_kernel BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_dec_kernel)
#define _aes_gcm_dec_update_vaes_avx10_512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_dec_update_vaes_avx10_512)
#define _aes_gcm_dec_update_vaes_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_dec_update_vaes_avx2)
#define _aes_gcm_enc_kernel BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_enc_kernel)
#define _aes_gcm_enc_update_vaes_avx10_512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_enc_update_vaes_avx10_512)
#define _aes_gcm_enc_update_vaes_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_gcm_enc_update_vaes_avx2)
#define _aes_hw_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_cbc_encrypt)
#define _aes_hw_ctr32_encrypt_blocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_ctr32_encrypt_blocks)
#define _aes_hw_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_decrypt)
#define _aes_hw_ecb_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_ecb_encrypt)
#define _aes_hw_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_encrypt)
#define _aes_hw_encrypt_key_to_decrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_encrypt_key_to_decrypt_key)
#define _aes_hw_set_decrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_set_decrypt_key)
#define _aes_hw_set_encrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_set_encrypt_key)
#define _aes_hw_set_encrypt_key_alt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_set_encrypt_key_alt)
#define _aes_hw_set_encrypt_key_alt_preferred BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_set_encrypt_key_alt_preferred)
#define _aes_hw_set_encrypt_key_base BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_hw_set_encrypt_key_base)
#define _aes_nohw_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_cbc_encrypt)
#define _aes_nohw_ctr32_encrypt_blocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_ctr32_encrypt_blocks)
#define _aes_nohw_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_decrypt)
#define _aes_nohw_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_encrypt)
#define _aes_nohw_set_decrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_set_decrypt_key)
#define _aes_nohw_set_encrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aes_nohw_set_encrypt_key)
#define _aesgcmsiv_htable6_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesgcmsiv_htable6_init)
#define _aesgcmsiv_htable_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesgcmsiv_htable_init)
#define _aesgcmsiv_htable_polyval BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesgcmsiv_htable_polyval)
#define _aesgcmsiv_polyval_horner BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesgcmsiv_polyval_horner)
#define _aesni_gcm_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesni_gcm_decrypt)
#define _aesni_gcm_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, aesni_gcm_encrypt)
#define _asn1_bit_string_length BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_bit_string_length)
#define _asn1_do_adb BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_do_adb)
#define _asn1_enc_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_enc_free)
#define _asn1_enc_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_enc_init)
#define _asn1_enc_restore BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_enc_restore)
#define _asn1_enc_save BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_enc_save)
#define _asn1_encoding_clear BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_encoding_clear)
#define _asn1_generalizedtime_to_tm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_generalizedtime_to_tm)
#define _asn1_get_choice_selector BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_get_choice_selector)
#define _asn1_get_field_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_get_field_ptr)
#define _asn1_get_string_table_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_get_string_table_for_testing)
#define _asn1_is_printable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_is_printable)
#define _asn1_refcount_dec_and_test_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_refcount_dec_and_test_zero)
#define _asn1_refcount_set_one BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_refcount_set_one)
#define _asn1_set_choice_selector BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_set_choice_selector)
#define _asn1_type_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_type_cleanup)
#define _asn1_type_set0_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_type_set0_string)
#define _asn1_type_value_as_pointer BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_type_value_as_pointer)
#define _asn1_utctime_to_tm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, asn1_utctime_to_tm)
#define _bcm_as_approved_status BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bcm_as_approved_status)
#define _bcm_success BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bcm_success)
#define _beeu_mod_inverse_vartime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, beeu_mod_inverse_vartime)
#define _bio_clear_socket_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_clear_socket_error)
#define _bio_errno_should_retry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_errno_should_retry)
#define _bio_ip_and_port_to_socket_and_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_ip_and_port_to_socket_and_addr)
#define _bio_sock_error BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_sock_error)
#define _bio_socket_nbio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_socket_nbio)
#define _bio_socket_should_retry BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bio_socket_should_retry)
#define _bn_abs_sub_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_abs_sub_consttime)
#define _bn_add_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_add_words)
#define _bn_assert_fits_in_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_assert_fits_in_bytes)
#define _bn_big_endian_to_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_big_endian_to_words)
#define _bn_copy_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_copy_words)
#define _bn_declassify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_declassify)
#define _bn_div_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_div_consttime)
#define _bn_expand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_expand)
#define _bn_fits_in_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_fits_in_words)
#define _bn_from_montgomery_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_from_montgomery_small)
#define _bn_gather5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_gather5)
#define _bn_in_range_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_in_range_words)
#define _bn_is_bit_set_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_is_bit_set_words)
#define _bn_is_relatively_prime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_is_relatively_prime)
#define _bn_jacobi BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_jacobi)
#define _bn_lcm_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_lcm_consttime)
#define _bn_less_than_montgomery_R BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_less_than_montgomery_R)
#define _bn_less_than_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_less_than_words)
#define _bn_miller_rabin_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_miller_rabin_init)
#define _bn_miller_rabin_iteration BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_miller_rabin_iteration)
#define _bn_minimal_width BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_minimal_width)
#define _bn_mod_add_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_add_consttime)
#define _bn_mod_add_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_add_words)
#define _bn_mod_exp_mont_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_exp_mont_small)
#define _bn_mod_inverse0_prime_mont_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_inverse0_prime_mont_small)
#define _bn_mod_inverse_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_inverse_consttime)
#define _bn_mod_inverse_prime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_inverse_prime)
#define _bn_mod_inverse_secret_prime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_inverse_secret_prime)
#define _bn_mod_lshift1_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_lshift1_consttime)
#define _bn_mod_lshift_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_lshift_consttime)
#define _bn_mod_mul_montgomery_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_mul_montgomery_small)
#define _bn_mod_sub_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_sub_consttime)
#define _bn_mod_sub_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_sub_words)
#define _bn_mod_u16_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mod_u16_consttime)
#define _bn_mont_ctx_cleanup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mont_ctx_cleanup)
#define _bn_mont_ctx_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mont_ctx_init)
#define _bn_mont_ctx_set_RR_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mont_ctx_set_RR_consttime)
#define _bn_mont_n0 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mont_n0)
#define _bn_mul4x_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul4x_mont)
#define _bn_mul4x_mont_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul4x_mont_capable)
#define _bn_mul4x_mont_gather5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul4x_mont_gather5)
#define _bn_mul4x_mont_gather5_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul4x_mont_gather5_capable)
#define _bn_mul_add_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_add_words)
#define _bn_mul_comba4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_comba4)
#define _bn_mul_comba8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_comba8)
#define _bn_mul_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_consttime)
#define _bn_mul_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_mont)
#define _bn_mul_mont_gather5_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_mont_gather5_nohw)
#define _bn_mul_mont_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_mont_nohw)
#define _bn_mul_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_small)
#define _bn_mul_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mul_words)
#define _bn_mulx4x_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mulx4x_mont)
#define _bn_mulx4x_mont_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mulx4x_mont_capable)
#define _bn_mulx4x_mont_gather5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mulx4x_mont_gather5)
#define _bn_mulx4x_mont_gather5_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mulx4x_mont_gather5_capable)
#define _bn_mulx_adx_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_mulx_adx_capable)
#define _bn_odd_number_is_obviously_composite BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_odd_number_is_obviously_composite)
#define _bn_one_to_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_one_to_montgomery)
#define _bn_power5_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_power5_capable)
#define _bn_power5_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_power5_nohw)
#define _bn_powerx5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_powerx5)
#define _bn_powerx5_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_powerx5_capable)
#define _bn_rand_range_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_rand_range_words)
#define _bn_rand_secret_range BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_rand_secret_range)
#define _bn_reduce_once BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_reduce_once)
#define _bn_reduce_once_in_place BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_reduce_once_in_place)
#define _bn_resize_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_resize_words)
#define _bn_rshift1_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_rshift1_words)
#define _bn_rshift_secret_shift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_rshift_secret_shift)
#define _bn_rshift_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_rshift_words)
#define _bn_scatter5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_scatter5)
#define _bn_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_secret)
#define _bn_select_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_select_words)
#define _bn_set_minimal_width BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_set_minimal_width)
#define _bn_set_static_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_set_static_words)
#define _bn_set_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_set_words)
#define _bn_sqr8x_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr8x_internal)
#define _bn_sqr8x_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr8x_mont)
#define _bn_sqr8x_mont_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr8x_mont_capable)
#define _bn_sqr_comba4 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr_comba4)
#define _bn_sqr_comba8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr_comba8)
#define _bn_sqr_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr_consttime)
#define _bn_sqr_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr_small)
#define _bn_sqr_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqr_words)
#define _bn_sqrx8x_internal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sqrx8x_internal)
#define _bn_sub_words BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_sub_words)
#define _bn_to_montgomery_small BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_to_montgomery_small)
#define _bn_uadd_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_uadd_consttime)
#define _bn_usub_consttime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_usub_consttime)
#define _bn_wexpand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_wexpand)
#define _bn_words_to_big_endian BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bn_words_to_big_endian)
#define _boringssl_ensure_ecc_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_ensure_ecc_self_test)
#define _boringssl_ensure_ffdh_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_ensure_ffdh_self_test)
#define _boringssl_ensure_rsa_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_ensure_rsa_self_test)
#define _boringssl_fips_break_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_fips_break_test)
#define _boringssl_fips_inc_counter BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_fips_inc_counter)
#define _boringssl_self_test_hmac_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_self_test_hmac_sha256)
#define _boringssl_self_test_sha256 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_self_test_sha256)
#define _boringssl_self_test_sha512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, boringssl_self_test_sha512)
#define _bsaes_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bsaes_capable)
#define _bsaes_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, bsaes_cbc_encrypt)
#define _c2i_ASN1_BIT_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, c2i_ASN1_BIT_STRING)
#define _c2i_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, c2i_ASN1_INTEGER)
#define _c2i_ASN1_OBJECT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, c2i_ASN1_OBJECT)
#define _chacha20_poly1305_asm_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_asm_capable)
#define _chacha20_poly1305_open BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_open)
#define _chacha20_poly1305_open_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_open_avx2)
#define _chacha20_poly1305_open_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_open_nohw)
#define _chacha20_poly1305_seal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_seal)
#define _chacha20_poly1305_seal_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_seal_avx2)
#define _chacha20_poly1305_seal_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, chacha20_poly1305_seal_nohw)
#define _crypto_gcm_clmul_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, crypto_gcm_clmul_enabled)
#define _d2i_ASN1_BIT_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_BIT_STRING)
#define _d2i_ASN1_BMPSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_BMPSTRING)
#define _d2i_ASN1_BOOLEAN BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_BOOLEAN)
#define _d2i_ASN1_ENUMERATED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_ENUMERATED)
#define _d2i_ASN1_GENERALIZEDTIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_GENERALIZEDTIME)
#define _d2i_ASN1_GENERALSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_GENERALSTRING)
#define _d2i_ASN1_IA5STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_IA5STRING)
#define _d2i_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_INTEGER)
#define _d2i_ASN1_NULL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_NULL)
#define _d2i_ASN1_OBJECT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_OBJECT)
#define _d2i_ASN1_OCTET_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_OCTET_STRING)
#define _d2i_ASN1_PRINTABLE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_PRINTABLE)
#define _d2i_ASN1_PRINTABLESTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_PRINTABLESTRING)
#define _d2i_ASN1_SEQUENCE_ANY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_SEQUENCE_ANY)
#define _d2i_ASN1_SET_ANY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_SET_ANY)
#define _d2i_ASN1_T61STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_T61STRING)
#define _d2i_ASN1_TIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_TIME)
#define _d2i_ASN1_TYPE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_TYPE)
#define _d2i_ASN1_UNIVERSALSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_UNIVERSALSTRING)
#define _d2i_ASN1_UTCTIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_UTCTIME)
#define _d2i_ASN1_UTF8STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_UTF8STRING)
#define _d2i_ASN1_VISIBLESTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ASN1_VISIBLESTRING)
#define _d2i_AUTHORITY_INFO_ACCESS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_AUTHORITY_INFO_ACCESS)
#define _d2i_AUTHORITY_KEYID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_AUTHORITY_KEYID)
#define _d2i_AutoPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_AutoPrivateKey)
#define _d2i_BASIC_CONSTRAINTS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_BASIC_CONSTRAINTS)
#define _d2i_CERTIFICATEPOLICIES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_CERTIFICATEPOLICIES)
#define _d2i_CRL_DIST_POINTS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_CRL_DIST_POINTS)
#define _d2i_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DHparams)
#define _d2i_DHparams_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DHparams_bio)
#define _d2i_DIRECTORYSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DIRECTORYSTRING)
#define _d2i_DISPLAYTEXT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DISPLAYTEXT)
#define _d2i_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSAPrivateKey)
#define _d2i_DSAPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSAPrivateKey_bio)
#define _d2i_DSAPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSAPrivateKey_fp)
#define _d2i_DSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSAPublicKey)
#define _d2i_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSA_PUBKEY)
#define _d2i_DSA_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSA_PUBKEY_bio)
#define _d2i_DSA_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSA_PUBKEY_fp)
#define _d2i_DSA_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSA_SIG)
#define _d2i_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_DSAparams)
#define _d2i_ECDSA_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECDSA_SIG)
#define _d2i_ECPKParameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECPKParameters)
#define _d2i_ECParameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECParameters)
#define _d2i_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECPrivateKey)
#define _d2i_ECPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECPrivateKey_bio)
#define _d2i_ECPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ECPrivateKey_fp)
#define _d2i_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_EC_PUBKEY)
#define _d2i_EC_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_EC_PUBKEY_bio)
#define _d2i_EC_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_EC_PUBKEY_fp)
#define _d2i_EXTENDED_KEY_USAGE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_EXTENDED_KEY_USAGE)
#define _d2i_GENERAL_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_GENERAL_NAME)
#define _d2i_GENERAL_NAMES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_GENERAL_NAMES)
#define _d2i_ISSUING_DIST_POINT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_ISSUING_DIST_POINT)
#define _d2i_NETSCAPE_SPKAC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_NETSCAPE_SPKAC)
#define _d2i_NETSCAPE_SPKI BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_NETSCAPE_SPKI)
#define _d2i_PKCS12 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS12)
#define _d2i_PKCS12_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS12_bio)
#define _d2i_PKCS12_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS12_fp)
#define _d2i_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS7)
#define _d2i_PKCS7_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS7_bio)
#define _d2i_PKCS8PrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8PrivateKey_bio)
#define _d2i_PKCS8PrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8PrivateKey_fp)
#define _d2i_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8_PRIV_KEY_INFO)
#define _d2i_PKCS8_PRIV_KEY_INFO_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8_PRIV_KEY_INFO_bio)
#define _d2i_PKCS8_PRIV_KEY_INFO_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8_PRIV_KEY_INFO_fp)
#define _d2i_PKCS8_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8_bio)
#define _d2i_PKCS8_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PKCS8_fp)
#define _d2i_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PUBKEY)
#define _d2i_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PUBKEY_bio)
#define _d2i_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PUBKEY_fp)
#define _d2i_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PrivateKey)
#define _d2i_PrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PrivateKey_bio)
#define _d2i_PrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PrivateKey_fp)
#define _d2i_PublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_PublicKey)
#define _d2i_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPrivateKey)
#define _d2i_RSAPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPrivateKey_bio)
#define _d2i_RSAPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPrivateKey_fp)
#define _d2i_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPublicKey)
#define _d2i_RSAPublicKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPublicKey_bio)
#define _d2i_RSAPublicKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSAPublicKey_fp)
#define _d2i_RSA_PSS_PARAMS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSA_PSS_PARAMS)
#define _d2i_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSA_PUBKEY)
#define _d2i_RSA_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSA_PUBKEY_bio)
#define _d2i_RSA_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_RSA_PUBKEY_fp)
#define _d2i_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_SSL_SESSION)
#define _d2i_SSL_SESSION_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_SSL_SESSION_bio)
#define _d2i_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509)
#define _d2i_X509_ALGOR BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_ALGOR)
#define _d2i_X509_ATTRIBUTE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_ATTRIBUTE)
#define _d2i_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_AUX)
#define _d2i_X509_CERT_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CERT_AUX)
#define _d2i_X509_CINF BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CINF)
#define _d2i_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CRL)
#define _d2i_X509_CRL_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CRL_INFO)
#define _d2i_X509_CRL_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CRL_bio)
#define _d2i_X509_CRL_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_CRL_fp)
#define _d2i_X509_EXTENSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_EXTENSION)
#define _d2i_X509_EXTENSIONS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_EXTENSIONS)
#define _d2i_X509_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_NAME)
#define _d2i_X509_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_PUBKEY)
#define _d2i_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_REQ)
#define _d2i_X509_REQ_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_REQ_INFO)
#define _d2i_X509_REQ_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_REQ_bio)
#define _d2i_X509_REQ_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_REQ_fp)
#define _d2i_X509_REVOKED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_REVOKED)
#define _d2i_X509_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_SIG)
#define _d2i_X509_VAL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_VAL)
#define _d2i_X509_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_bio)
#define _d2i_X509_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, d2i_X509_fp)
#define _dh_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dh_asn1_meth)
#define _dh_check_params_fast BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dh_check_params_fast)
#define _dh_compute_key_padded_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dh_compute_key_padded_no_self_test)
#define _dh_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dh_pkey_meth)
#define _dsa_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dsa_asn1_meth)
#define _dsa_check_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, dsa_check_key)
#define _ec_GFp_mont_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_add)
#define _ec_GFp_mont_dbl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_dbl)
#define _ec_GFp_mont_felem_exp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_exp)
#define _ec_GFp_mont_felem_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_from_bytes)
#define _ec_GFp_mont_felem_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_mul)
#define _ec_GFp_mont_felem_reduce BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_reduce)
#define _ec_GFp_mont_felem_sqr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_sqr)
#define _ec_GFp_mont_felem_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_felem_to_bytes)
#define _ec_GFp_mont_init_precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_init_precomp)
#define _ec_GFp_mont_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_mul)
#define _ec_GFp_mont_mul_base BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_mul_base)
#define _ec_GFp_mont_mul_batch BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_mul_batch)
#define _ec_GFp_mont_mul_precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_mul_precomp)
#define _ec_GFp_mont_mul_public_batch BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_mont_mul_public_batch)
#define _ec_GFp_nistp_recode_scalar_bits BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_nistp_recode_scalar_bits)
#define _ec_GFp_simple_cmp_x_coordinate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_cmp_x_coordinate)
#define _ec_GFp_simple_felem_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_felem_from_bytes)
#define _ec_GFp_simple_felem_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_felem_to_bytes)
#define _ec_GFp_simple_group_get_curve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_group_get_curve)
#define _ec_GFp_simple_group_set_curve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_group_set_curve)
#define _ec_GFp_simple_invert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_invert)
#define _ec_GFp_simple_is_at_infinity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_is_at_infinity)
#define _ec_GFp_simple_is_on_curve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_is_on_curve)
#define _ec_GFp_simple_point_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_point_copy)
#define _ec_GFp_simple_point_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_point_init)
#define _ec_GFp_simple_point_set_to_infinity BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_point_set_to_infinity)
#define _ec_GFp_simple_points_equal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_GFp_simple_points_equal)
#define _ec_affine_jacobian_equal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_affine_jacobian_equal)
#define _ec_affine_select BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_affine_select)
#define _ec_affine_to_jacobian BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_affine_to_jacobian)
#define _ec_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_asn1_meth)
#define _ec_bignum_to_felem BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_bignum_to_felem)
#define _ec_bignum_to_scalar BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_bignum_to_scalar)
#define _ec_cmp_x_coordinate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_cmp_x_coordinate)
#define _ec_compute_wNAF BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_compute_wNAF)
#define _ec_felem_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_add)
#define _ec_felem_equal BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_equal)
#define _ec_felem_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_from_bytes)
#define _ec_felem_neg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_neg)
#define _ec_felem_non_zero_mask BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_non_zero_mask)
#define _ec_felem_one BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_one)
#define _ec_felem_select BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_select)
#define _ec_felem_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_sub)
#define _ec_felem_to_bignum BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_to_bignum)
#define _ec_felem_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_felem_to_bytes)
#define _ec_get_x_coordinate_as_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_get_x_coordinate_as_bytes)
#define _ec_get_x_coordinate_as_scalar BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_get_x_coordinate_as_scalar)
#define _ec_hash_to_curve_p256_xmd_sha256_sswu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_hash_to_curve_p256_xmd_sha256_sswu)
#define _ec_hash_to_curve_p384_xmd_sha384_sswu BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_hash_to_curve_p384_xmd_sha384_sswu)
#define _ec_hash_to_curve_p384_xmd_sha512_sswu_draft07 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_hash_to_curve_p384_xmd_sha512_sswu_draft07)
#define _ec_hash_to_scalar_p384_xmd_sha384 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_hash_to_scalar_p384_xmd_sha384)
#define _ec_hash_to_scalar_p384_xmd_sha512_draft07 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_hash_to_scalar_p384_xmd_sha512_draft07)
#define _ec_init_precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_init_precomp)
#define _ec_jacobian_to_affine BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_jacobian_to_affine)
#define _ec_jacobian_to_affine_batch BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_jacobian_to_affine_batch)
#define _ec_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_pkey_meth)
#define _ec_point_byte_len BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_byte_len)
#define _ec_point_from_uncompressed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_from_uncompressed)
#define _ec_point_mul_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_no_self_test)
#define _ec_point_mul_scalar BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar)
#define _ec_point_mul_scalar_base BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar_base)
#define _ec_point_mul_scalar_batch BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar_batch)
#define _ec_point_mul_scalar_precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar_precomp)
#define _ec_point_mul_scalar_public BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar_public)
#define _ec_point_mul_scalar_public_batch BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_mul_scalar_public_batch)
#define _ec_point_select BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_select)
#define _ec_point_set_affine_coordinates BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_set_affine_coordinates)
#define _ec_point_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_point_to_bytes)
#define _ec_precomp_select BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_precomp_select)
#define _ec_random_nonzero_scalar BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_random_nonzero_scalar)
#define _ec_random_scalar BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_random_scalar)
#define _ec_scalar_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_add)
#define _ec_scalar_equal_vartime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_equal_vartime)
#define _ec_scalar_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_from_bytes)
#define _ec_scalar_from_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_from_montgomery)
#define _ec_scalar_inv0_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_inv0_montgomery)
#define _ec_scalar_is_zero BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_is_zero)
#define _ec_scalar_mul_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_mul_montgomery)
#define _ec_scalar_neg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_neg)
#define _ec_scalar_reduce BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_reduce)
#define _ec_scalar_select BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_select)
#define _ec_scalar_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_sub)
#define _ec_scalar_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_to_bytes)
#define _ec_scalar_to_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_to_montgomery)
#define _ec_scalar_to_montgomery_inv_vartime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_scalar_to_montgomery_inv_vartime)
#define _ec_set_to_safe_point BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_set_to_safe_point)
#define _ec_simple_scalar_inv0_montgomery BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_simple_scalar_inv0_montgomery)
#define _ec_simple_scalar_to_montgomery_inv_vartime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ec_simple_scalar_to_montgomery_inv_vartime)
#define _ecdsa_sign_fixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecdsa_sign_fixed)
#define _ecdsa_sign_fixed_with_nonce_for_known_answer_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecdsa_sign_fixed_with_nonce_for_known_answer_test)
#define _ecdsa_verify_fixed BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecdsa_verify_fixed)
#define _ecdsa_verify_fixed_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecdsa_verify_fixed_no_self_test)
#define _ecp_nistz256_div_by_2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_div_by_2)
#define _ecp_nistz256_mul_by_2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_mul_by_2)
#define _ecp_nistz256_mul_by_3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_mul_by_3)
#define _ecp_nistz256_mul_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_mul_mont)
#define _ecp_nistz256_mul_mont_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_mul_mont_adx)
#define _ecp_nistz256_mul_mont_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_mul_mont_nohw)
#define _ecp_nistz256_neg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_neg)
#define _ecp_nistz256_ord_mul_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_mul_mont)
#define _ecp_nistz256_ord_mul_mont_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_mul_mont_adx)
#define _ecp_nistz256_ord_mul_mont_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_mul_mont_nohw)
#define _ecp_nistz256_ord_sqr_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_sqr_mont)
#define _ecp_nistz256_ord_sqr_mont_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_sqr_mont_adx)
#define _ecp_nistz256_ord_sqr_mont_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_ord_sqr_mont_nohw)
#define _ecp_nistz256_point_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add)
#define _ecp_nistz256_point_add_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add_adx)
#define _ecp_nistz256_point_add_affine BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add_affine)
#define _ecp_nistz256_point_add_affine_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add_affine_adx)
#define _ecp_nistz256_point_add_affine_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add_affine_nohw)
#define _ecp_nistz256_point_add_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_add_nohw)
#define _ecp_nistz256_point_double BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_double)
#define _ecp_nistz256_point_double_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_double_adx)
#define _ecp_nistz256_point_double_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_point_double_nohw)
#define _ecp_nistz256_select_w5 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w5)
#define _ecp_nistz256_select_w5_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w5_avx2)
#define _ecp_nistz256_select_w5_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w5_nohw)
#define _ecp_nistz256_select_w7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w7)
#define _ecp_nistz256_select_w7_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w7_avx2)
#define _ecp_nistz256_select_w7_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_select_w7_nohw)
#define _ecp_nistz256_sqr_mont BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_sqr_mont)
#define _ecp_nistz256_sqr_mont_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_sqr_mont_adx)
#define _ecp_nistz256_sqr_mont_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_sqr_mont_nohw)
#define _ecp_nistz256_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ecp_nistz256_sub)
#define _ed25519_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ed25519_asn1_meth)
#define _ed25519_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, ed25519_pkey_meth)
#define _evp_pkey_set_method BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, evp_pkey_set_method)
#define _fiat_curve25519_adx_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, fiat_curve25519_adx_mul)
#define _fiat_curve25519_adx_square BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, fiat_curve25519_adx_square)
#define _fiat_p256_adx_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, fiat_p256_adx_mul)
#define _fiat_p256_adx_sqr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, fiat_p256_adx_sqr)
#define _gcm_ghash_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_avx)
#define _gcm_ghash_clmul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_clmul)
#define _gcm_ghash_neon BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_neon)
#define _gcm_ghash_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_nohw)
#define _gcm_ghash_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_ssse3)
#define _gcm_ghash_v8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_v8)
#define _gcm_ghash_vpclmulqdq_avx10_512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_vpclmulqdq_avx10_512)
#define _gcm_ghash_vpclmulqdq_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_ghash_vpclmulqdq_avx2)
#define _gcm_gmult_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_avx)
#define _gcm_gmult_clmul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_clmul)
#define _gcm_gmult_neon BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_neon)
#define _gcm_gmult_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_nohw)
#define _gcm_gmult_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_ssse3)
#define _gcm_gmult_v8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_v8)
#define _gcm_gmult_vpclmulqdq_avx10 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_vpclmulqdq_avx10)
#define _gcm_gmult_vpclmulqdq_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_gmult_vpclmulqdq_avx2)
#define _gcm_init_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_avx)
#define _gcm_init_clmul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_clmul)
#define _gcm_init_neon BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_neon)
#define _gcm_init_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_nohw)
#define _gcm_init_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_ssse3)
#define _gcm_init_v8 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_v8)
#define _gcm_init_vpclmulqdq_avx10_512 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_vpclmulqdq_avx10_512)
#define _gcm_init_vpclmulqdq_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_init_vpclmulqdq_avx2)
#define _gcm_neon_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_neon_capable)
#define _gcm_pmull_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, gcm_pmull_capable)
#define _have_fast_rdrand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, have_fast_rdrand)
#define _have_rdrand BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, have_rdrand)
#define _hkdf_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, hkdf_pkey_meth)
#define _hwaes_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, hwaes_capable)
#define _i2a_ASN1_ENUMERATED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2a_ASN1_ENUMERATED)
#define _i2a_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2a_ASN1_INTEGER)
#define _i2a_ASN1_OBJECT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2a_ASN1_OBJECT)
#define _i2a_ASN1_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2a_ASN1_STRING)
#define _i2c_ASN1_BIT_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2c_ASN1_BIT_STRING)
#define _i2c_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2c_ASN1_INTEGER)
#define _i2d_ASN1_BIT_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_BIT_STRING)
#define _i2d_ASN1_BMPSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_BMPSTRING)
#define _i2d_ASN1_BOOLEAN BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_BOOLEAN)
#define _i2d_ASN1_ENUMERATED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_ENUMERATED)
#define _i2d_ASN1_GENERALIZEDTIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_GENERALIZEDTIME)
#define _i2d_ASN1_GENERALSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_GENERALSTRING)
#define _i2d_ASN1_IA5STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_IA5STRING)
#define _i2d_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_INTEGER)
#define _i2d_ASN1_NULL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_NULL)
#define _i2d_ASN1_OBJECT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_OBJECT)
#define _i2d_ASN1_OCTET_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_OCTET_STRING)
#define _i2d_ASN1_PRINTABLE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_PRINTABLE)
#define _i2d_ASN1_PRINTABLESTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_PRINTABLESTRING)
#define _i2d_ASN1_SEQUENCE_ANY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_SEQUENCE_ANY)
#define _i2d_ASN1_SET_ANY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_SET_ANY)
#define _i2d_ASN1_T61STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_T61STRING)
#define _i2d_ASN1_TIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_TIME)
#define _i2d_ASN1_TYPE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_TYPE)
#define _i2d_ASN1_UNIVERSALSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_UNIVERSALSTRING)
#define _i2d_ASN1_UTCTIME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_UTCTIME)
#define _i2d_ASN1_UTF8STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_UTF8STRING)
#define _i2d_ASN1_VISIBLESTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ASN1_VISIBLESTRING)
#define _i2d_AUTHORITY_INFO_ACCESS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_AUTHORITY_INFO_ACCESS)
#define _i2d_AUTHORITY_KEYID BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_AUTHORITY_KEYID)
#define _i2d_BASIC_CONSTRAINTS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_BASIC_CONSTRAINTS)
#define _i2d_CERTIFICATEPOLICIES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_CERTIFICATEPOLICIES)
#define _i2d_CRL_DIST_POINTS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_CRL_DIST_POINTS)
#define _i2d_DHparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DHparams)
#define _i2d_DHparams_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DHparams_bio)
#define _i2d_DIRECTORYSTRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DIRECTORYSTRING)
#define _i2d_DISPLAYTEXT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DISPLAYTEXT)
#define _i2d_DSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSAPrivateKey)
#define _i2d_DSAPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSAPrivateKey_bio)
#define _i2d_DSAPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSAPrivateKey_fp)
#define _i2d_DSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSAPublicKey)
#define _i2d_DSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSA_PUBKEY)
#define _i2d_DSA_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSA_PUBKEY_bio)
#define _i2d_DSA_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSA_PUBKEY_fp)
#define _i2d_DSA_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSA_SIG)
#define _i2d_DSAparams BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_DSAparams)
#define _i2d_ECDSA_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECDSA_SIG)
#define _i2d_ECPKParameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECPKParameters)
#define _i2d_ECParameters BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECParameters)
#define _i2d_ECPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECPrivateKey)
#define _i2d_ECPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECPrivateKey_bio)
#define _i2d_ECPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ECPrivateKey_fp)
#define _i2d_EC_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_EC_PUBKEY)
#define _i2d_EC_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_EC_PUBKEY_bio)
#define _i2d_EC_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_EC_PUBKEY_fp)
#define _i2d_EXTENDED_KEY_USAGE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_EXTENDED_KEY_USAGE)
#define _i2d_GENERAL_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_GENERAL_NAME)
#define _i2d_GENERAL_NAMES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_GENERAL_NAMES)
#define _i2d_ISSUING_DIST_POINT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_ISSUING_DIST_POINT)
#define _i2d_NETSCAPE_SPKAC BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_NETSCAPE_SPKAC)
#define _i2d_NETSCAPE_SPKI BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_NETSCAPE_SPKI)
#define _i2d_PKCS12 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS12)
#define _i2d_PKCS12_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS12_bio)
#define _i2d_PKCS12_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS12_fp)
#define _i2d_PKCS7 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS7)
#define _i2d_PKCS7_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS7_bio)
#define _i2d_PKCS8PrivateKeyInfo_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKeyInfo_bio)
#define _i2d_PKCS8PrivateKeyInfo_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKeyInfo_fp)
#define _i2d_PKCS8PrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKey_bio)
#define _i2d_PKCS8PrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKey_fp)
#define _i2d_PKCS8PrivateKey_nid_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKey_nid_bio)
#define _i2d_PKCS8PrivateKey_nid_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8PrivateKey_nid_fp)
#define _i2d_PKCS8_PRIV_KEY_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8_PRIV_KEY_INFO)
#define _i2d_PKCS8_PRIV_KEY_INFO_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8_PRIV_KEY_INFO_bio)
#define _i2d_PKCS8_PRIV_KEY_INFO_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8_PRIV_KEY_INFO_fp)
#define _i2d_PKCS8_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8_bio)
#define _i2d_PKCS8_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PKCS8_fp)
#define _i2d_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PUBKEY)
#define _i2d_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PUBKEY_bio)
#define _i2d_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PUBKEY_fp)
#define _i2d_PrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PrivateKey)
#define _i2d_PrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PrivateKey_bio)
#define _i2d_PrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PrivateKey_fp)
#define _i2d_PublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_PublicKey)
#define _i2d_RSAPrivateKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPrivateKey)
#define _i2d_RSAPrivateKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPrivateKey_bio)
#define _i2d_RSAPrivateKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPrivateKey_fp)
#define _i2d_RSAPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPublicKey)
#define _i2d_RSAPublicKey_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPublicKey_bio)
#define _i2d_RSAPublicKey_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSAPublicKey_fp)
#define _i2d_RSA_PSS_PARAMS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSA_PSS_PARAMS)
#define _i2d_RSA_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSA_PUBKEY)
#define _i2d_RSA_PUBKEY_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSA_PUBKEY_bio)
#define _i2d_RSA_PUBKEY_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_RSA_PUBKEY_fp)
#define _i2d_SSL_SESSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_SSL_SESSION)
#define _i2d_SSL_SESSION_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_SSL_SESSION_bio)
#define _i2d_X509 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509)
#define _i2d_X509_ALGOR BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_ALGOR)
#define _i2d_X509_ATTRIBUTE BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_ATTRIBUTE)
#define _i2d_X509_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_AUX)
#define _i2d_X509_CERT_AUX BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CERT_AUX)
#define _i2d_X509_CINF BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CINF)
#define _i2d_X509_CRL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CRL)
#define _i2d_X509_CRL_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CRL_INFO)
#define _i2d_X509_CRL_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CRL_bio)
#define _i2d_X509_CRL_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CRL_fp)
#define _i2d_X509_CRL_tbs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_CRL_tbs)
#define _i2d_X509_EXTENSION BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_EXTENSION)
#define _i2d_X509_EXTENSIONS BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_EXTENSIONS)
#define _i2d_X509_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_NAME)
#define _i2d_X509_PUBKEY BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_PUBKEY)
#define _i2d_X509_REQ BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_REQ)
#define _i2d_X509_REQ_INFO BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_REQ_INFO)
#define _i2d_X509_REQ_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_REQ_bio)
#define _i2d_X509_REQ_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_REQ_fp)
#define _i2d_X509_REVOKED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_REVOKED)
#define _i2d_X509_SIG BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_SIG)
#define _i2d_X509_VAL BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_VAL)
#define _i2d_X509_bio BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_bio)
#define _i2d_X509_fp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_fp)
#define _i2d_X509_tbs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_X509_tbs)
#define _i2d_re_X509_CRL_tbs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_re_X509_CRL_tbs)
#define _i2d_re_X509_REQ_tbs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_re_X509_REQ_tbs)
#define _i2d_re_X509_tbs BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2d_re_X509_tbs)
#define _i2o_ECPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2o_ECPublicKey)
#define _i2s_ASN1_ENUMERATED BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2s_ASN1_ENUMERATED)
#define _i2s_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2s_ASN1_INTEGER)
#define _i2s_ASN1_OCTET_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2s_ASN1_OCTET_STRING)
#define _i2t_ASN1_OBJECT BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2t_ASN1_OBJECT)
#define _i2v_GENERAL_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2v_GENERAL_NAME)
#define _i2v_GENERAL_NAMES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, i2v_GENERAL_NAMES)
#define _k25519Precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, k25519Precomp)
#define _kBoringSSLRSASqrtTwo BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, kBoringSSLRSASqrtTwo)
#define _kBoringSSLRSASqrtTwoLen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, kBoringSSLRSASqrtTwoLen)
#define _kOpenSSLReasonStringData BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, kOpenSSLReasonStringData)
#define _kOpenSSLReasonValues BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, kOpenSSLReasonValues)
#define _kOpenSSLReasonValuesLen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, kOpenSSLReasonValuesLen)
#define _lh_CONF_SECTION_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_call_cmp_func)
#define _lh_CONF_SECTION_call_doall_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_call_doall_arg)
#define _lh_CONF_SECTION_call_hash_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_call_hash_func)
#define _lh_CONF_SECTION_doall_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_doall_arg)
#define _lh_CONF_SECTION_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_free)
#define _lh_CONF_SECTION_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_insert)
#define _lh_CONF_SECTION_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_new)
#define _lh_CONF_SECTION_retrieve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_SECTION_retrieve)
#define _lh_CONF_VALUE_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_call_cmp_func)
#define _lh_CONF_VALUE_call_doall_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_call_doall_arg)
#define _lh_CONF_VALUE_call_hash_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_call_hash_func)
#define _lh_CONF_VALUE_doall_arg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_doall_arg)
#define _lh_CONF_VALUE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_free)
#define _lh_CONF_VALUE_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_insert)
#define _lh_CONF_VALUE_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_new)
#define _lh_CONF_VALUE_retrieve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CONF_VALUE_retrieve)
#define _lh_CRYPTO_BUFFER_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_call_cmp_func)
#define _lh_CRYPTO_BUFFER_call_hash_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_call_hash_func)
#define _lh_CRYPTO_BUFFER_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_delete)
#define _lh_CRYPTO_BUFFER_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_free)
#define _lh_CRYPTO_BUFFER_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_insert)
#define _lh_CRYPTO_BUFFER_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_new)
#define _lh_CRYPTO_BUFFER_num_items BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_num_items)
#define _lh_CRYPTO_BUFFER_retrieve BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, lh_CRYPTO_BUFFER_retrieve)
#define _md5_block_asm_data_order BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, md5_block_asm_data_order)
#define _o2i_ECPublicKey BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, o2i_ECPublicKey)
#define _pkcs12_iterations_acceptable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs12_iterations_acceptable)
#define _pkcs12_key_gen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs12_key_gen)
#define _pkcs12_pbe_encrypt_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs12_pbe_encrypt_init)
#define _pkcs7_add_signed_data BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs7_add_signed_data)
#define _pkcs7_parse_header BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs7_parse_header)
#define _pkcs8_pbe_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pkcs8_pbe_decrypt)
#define _pmbtoken_exp1_blind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_blind)
#define _pmbtoken_exp1_client_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_client_key_from_bytes)
#define _pmbtoken_exp1_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_derive_key_from_secret)
#define _pmbtoken_exp1_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_generate_key)
#define _pmbtoken_exp1_get_h_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_get_h_for_testing)
#define _pmbtoken_exp1_issuer_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_issuer_key_from_bytes)
#define _pmbtoken_exp1_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_read)
#define _pmbtoken_exp1_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_sign)
#define _pmbtoken_exp1_unblind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp1_unblind)
#define _pmbtoken_exp2_blind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_blind)
#define _pmbtoken_exp2_client_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_client_key_from_bytes)
#define _pmbtoken_exp2_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_derive_key_from_secret)
#define _pmbtoken_exp2_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_generate_key)
#define _pmbtoken_exp2_get_h_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_get_h_for_testing)
#define _pmbtoken_exp2_issuer_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_issuer_key_from_bytes)
#define _pmbtoken_exp2_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_read)
#define _pmbtoken_exp2_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_sign)
#define _pmbtoken_exp2_unblind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_exp2_unblind)
#define _pmbtoken_pst1_blind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_blind)
#define _pmbtoken_pst1_client_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_client_key_from_bytes)
#define _pmbtoken_pst1_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_derive_key_from_secret)
#define _pmbtoken_pst1_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_generate_key)
#define _pmbtoken_pst1_get_h_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_get_h_for_testing)
#define _pmbtoken_pst1_issuer_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_issuer_key_from_bytes)
#define _pmbtoken_pst1_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_read)
#define _pmbtoken_pst1_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_sign)
#define _pmbtoken_pst1_unblind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, pmbtoken_pst1_unblind)
#define _poly_Rq_mul BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, poly_Rq_mul)
#define _rand_fork_unsafe_buffering_enabled BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rand_fork_unsafe_buffering_enabled)
#define _rsa_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_asn1_meth)
#define _rsa_check_public_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_check_public_key)
#define _rsa_default_private_transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_default_private_transform)
#define _rsa_default_sign_raw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_default_sign_raw)
#define _rsa_invalidate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_invalidate_key)
#define _rsa_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_pkey_meth)
#define _rsa_private_transform BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_private_transform)
#define _rsa_private_transform_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_private_transform_no_self_test)
#define _rsa_sign_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_sign_no_self_test)
#define _rsa_verify_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_verify_no_self_test)
#define _rsa_verify_raw_no_self_test BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsa_verify_raw_no_self_test)
#define _rsaz_1024_gather5_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_gather5_avx2)
#define _rsaz_1024_mul_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_mul_avx2)
#define _rsaz_1024_norm2red_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_norm2red_avx2)
#define _rsaz_1024_red2norm_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_red2norm_avx2)
#define _rsaz_1024_scatter5_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_scatter5_avx2)
#define _rsaz_1024_sqr_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_1024_sqr_avx2)
#define _rsaz_avx2_preferred BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, rsaz_avx2_preferred)
#define _s2i_ASN1_INTEGER BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, s2i_ASN1_INTEGER)
#define _s2i_ASN1_OCTET_STRING BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, s2i_ASN1_OCTET_STRING)
#define _sha1_avx2_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_avx2_capable)
#define _sha1_avx_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_avx_capable)
#define _sha1_block_data_order_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_block_data_order_avx)
#define _sha1_block_data_order_avx2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_block_data_order_avx2)
#define _sha1_block_data_order_hw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_block_data_order_hw)
#define _sha1_block_data_order_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_block_data_order_nohw)
#define _sha1_block_data_order_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_block_data_order_ssse3)
#define _sha1_hw_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_hw_capable)
#define _sha1_ssse3_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha1_ssse3_capable)
#define _sha256_avx_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_avx_capable)
#define _sha256_block_data_order_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_block_data_order_avx)
#define _sha256_block_data_order_hw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_block_data_order_hw)
#define _sha256_block_data_order_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_block_data_order_nohw)
#define _sha256_block_data_order_ssse3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_block_data_order_ssse3)
#define _sha256_hw_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_hw_capable)
#define _sha256_ssse3_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha256_ssse3_capable)
#define _sha512_avx_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha512_avx_capable)
#define _sha512_block_data_order_avx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha512_block_data_order_avx)
#define _sha512_block_data_order_hw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha512_block_data_order_hw)
#define _sha512_block_data_order_nohw BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha512_block_data_order_nohw)
#define _sha512_hw_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sha512_hw_capable)
#define _sk_ACCESS_DESCRIPTION_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_call_free_func)
#define _sk_ACCESS_DESCRIPTION_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_new_null)
#define _sk_ACCESS_DESCRIPTION_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_num)
#define _sk_ACCESS_DESCRIPTION_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_pop_free)
#define _sk_ACCESS_DESCRIPTION_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_push)
#define _sk_ACCESS_DESCRIPTION_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ACCESS_DESCRIPTION_value)
#define _sk_ASN1_INTEGER_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_INTEGER_num)
#define _sk_ASN1_INTEGER_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_INTEGER_push)
#define _sk_ASN1_INTEGER_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_INTEGER_value)
#define _sk_ASN1_OBJECT_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_call_cmp_func)
#define _sk_ASN1_OBJECT_call_copy_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_call_copy_func)
#define _sk_ASN1_OBJECT_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_call_free_func)
#define _sk_ASN1_OBJECT_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_deep_copy)
#define _sk_ASN1_OBJECT_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_dup)
#define _sk_ASN1_OBJECT_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_find)
#define _sk_ASN1_OBJECT_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_free)
#define _sk_ASN1_OBJECT_is_sorted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_is_sorted)
#define _sk_ASN1_OBJECT_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_new_null)
#define _sk_ASN1_OBJECT_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_num)
#define _sk_ASN1_OBJECT_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_pop_free)
#define _sk_ASN1_OBJECT_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_push)
#define _sk_ASN1_OBJECT_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_set_cmp_func)
#define _sk_ASN1_OBJECT_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_sort)
#define _sk_ASN1_OBJECT_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_OBJECT_value)
#define _sk_ASN1_TYPE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_TYPE_num)
#define _sk_ASN1_TYPE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_TYPE_push)
#define _sk_ASN1_TYPE_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_TYPE_value)
#define _sk_ASN1_VALUE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_free)
#define _sk_ASN1_VALUE_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_new_null)
#define _sk_ASN1_VALUE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_num)
#define _sk_ASN1_VALUE_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_pop)
#define _sk_ASN1_VALUE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_push)
#define _sk_ASN1_VALUE_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_ASN1_VALUE_value)
#define _sk_CONF_VALUE_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_call_free_func)
#define _sk_CONF_VALUE_delete_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_delete_ptr)
#define _sk_CONF_VALUE_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_free)
#define _sk_CONF_VALUE_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_new_null)
#define _sk_CONF_VALUE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_num)
#define _sk_CONF_VALUE_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_pop)
#define _sk_CONF_VALUE_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_pop_free)
#define _sk_CONF_VALUE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_push)
#define _sk_CONF_VALUE_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CONF_VALUE_value)
#define _sk_CRYPTO_BUFFER_call_copy_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_call_copy_func)
#define _sk_CRYPTO_BUFFER_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_call_free_func)
#define _sk_CRYPTO_BUFFER_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_deep_copy)
#define _sk_CRYPTO_BUFFER_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_new_null)
#define _sk_CRYPTO_BUFFER_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_num)
#define _sk_CRYPTO_BUFFER_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_pop)
#define _sk_CRYPTO_BUFFER_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_pop_free)
#define _sk_CRYPTO_BUFFER_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_push)
#define _sk_CRYPTO_BUFFER_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_set)
#define _sk_CRYPTO_BUFFER_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_CRYPTO_BUFFER_value)
#define _sk_DIST_POINT_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_call_free_func)
#define _sk_DIST_POINT_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_new_null)
#define _sk_DIST_POINT_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_num)
#define _sk_DIST_POINT_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_pop_free)
#define _sk_DIST_POINT_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_push)
#define _sk_DIST_POINT_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_DIST_POINT_value)
#define _sk_GENERAL_NAME_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_call_free_func)
#define _sk_GENERAL_NAME_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_new_null)
#define _sk_GENERAL_NAME_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_num)
#define _sk_GENERAL_NAME_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_pop_free)
#define _sk_GENERAL_NAME_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_push)
#define _sk_GENERAL_NAME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_set)
#define _sk_GENERAL_NAME_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_NAME_value)
#define _sk_GENERAL_SUBTREE_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_SUBTREE_new_null)
#define _sk_GENERAL_SUBTREE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_SUBTREE_num)
#define _sk_GENERAL_SUBTREE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_SUBTREE_push)
#define _sk_GENERAL_SUBTREE_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_GENERAL_SUBTREE_value)
#define _sk_OPENSSL_STRING_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_call_cmp_func)
#define _sk_OPENSSL_STRING_call_copy_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_call_copy_func)
#define _sk_OPENSSL_STRING_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_call_free_func)
#define _sk_OPENSSL_STRING_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_deep_copy)
#define _sk_OPENSSL_STRING_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_find)
#define _sk_OPENSSL_STRING_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_free)
#define _sk_OPENSSL_STRING_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_new)
#define _sk_OPENSSL_STRING_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_new_null)
#define _sk_OPENSSL_STRING_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_num)
#define _sk_OPENSSL_STRING_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_pop_free)
#define _sk_OPENSSL_STRING_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_push)
#define _sk_OPENSSL_STRING_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_sort)
#define _sk_OPENSSL_STRING_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_OPENSSL_STRING_value)
#define _sk_POLICYINFO_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_call_cmp_func)
#define _sk_POLICYINFO_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_call_free_func)
#define _sk_POLICYINFO_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_find)
#define _sk_POLICYINFO_is_sorted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_is_sorted)
#define _sk_POLICYINFO_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_new_null)
#define _sk_POLICYINFO_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_num)
#define _sk_POLICYINFO_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_pop_free)
#define _sk_POLICYINFO_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_push)
#define _sk_POLICYINFO_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_set_cmp_func)
#define _sk_POLICYINFO_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_sort)
#define _sk_POLICYINFO_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYINFO_value)
#define _sk_POLICYQUALINFO_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYQUALINFO_new_null)
#define _sk_POLICYQUALINFO_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYQUALINFO_num)
#define _sk_POLICYQUALINFO_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYQUALINFO_push)
#define _sk_POLICYQUALINFO_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICYQUALINFO_value)
#define _sk_POLICY_MAPPING_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_call_cmp_func)
#define _sk_POLICY_MAPPING_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_call_free_func)
#define _sk_POLICY_MAPPING_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_find)
#define _sk_POLICY_MAPPING_is_sorted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_is_sorted)
#define _sk_POLICY_MAPPING_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_new_null)
#define _sk_POLICY_MAPPING_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_num)
#define _sk_POLICY_MAPPING_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_pop_free)
#define _sk_POLICY_MAPPING_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_push)
#define _sk_POLICY_MAPPING_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_set_cmp_func)
#define _sk_POLICY_MAPPING_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_sort)
#define _sk_POLICY_MAPPING_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_POLICY_MAPPING_value)
#define _sk_SRTP_PROTECTION_PROFILE_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SRTP_PROTECTION_PROFILE_new_null)
#define _sk_SRTP_PROTECTION_PROFILE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SRTP_PROTECTION_PROFILE_num)
#define _sk_SRTP_PROTECTION_PROFILE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SRTP_PROTECTION_PROFILE_push)
#define _sk_SSL_CIPHER_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_call_cmp_func)
#define _sk_SSL_CIPHER_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_delete)
#define _sk_SSL_CIPHER_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_dup)
#define _sk_SSL_CIPHER_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_find)
#define _sk_SSL_CIPHER_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_new_null)
#define _sk_SSL_CIPHER_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_num)
#define _sk_SSL_CIPHER_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_push)
#define _sk_SSL_CIPHER_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_SSL_CIPHER_value)
#define _sk_TRUST_TOKEN_PRETOKEN_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_call_free_func)
#define _sk_TRUST_TOKEN_PRETOKEN_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_new_null)
#define _sk_TRUST_TOKEN_PRETOKEN_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_num)
#define _sk_TRUST_TOKEN_PRETOKEN_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_pop_free)
#define _sk_TRUST_TOKEN_PRETOKEN_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_push)
#define _sk_TRUST_TOKEN_PRETOKEN_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_PRETOKEN_value)
#define _sk_TRUST_TOKEN_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_call_free_func)
#define _sk_TRUST_TOKEN_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_new_null)
#define _sk_TRUST_TOKEN_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_pop_free)
#define _sk_TRUST_TOKEN_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_TRUST_TOKEN_push)
#define _sk_X509_ATTRIBUTE_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_ATTRIBUTE_delete)
#define _sk_X509_ATTRIBUTE_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_ATTRIBUTE_new_null)
#define _sk_X509_ATTRIBUTE_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_ATTRIBUTE_num)
#define _sk_X509_ATTRIBUTE_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_ATTRIBUTE_push)
#define _sk_X509_ATTRIBUTE_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_ATTRIBUTE_value)
#define _sk_X509_CRL_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_call_free_func)
#define _sk_X509_CRL_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_free)
#define _sk_X509_CRL_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_new_null)
#define _sk_X509_CRL_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_num)
#define _sk_X509_CRL_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_pop)
#define _sk_X509_CRL_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_pop_free)
#define _sk_X509_CRL_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_push)
#define _sk_X509_CRL_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_CRL_value)
#define _sk_X509_EXTENSION_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_call_free_func)
#define _sk_X509_EXTENSION_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_delete)
#define _sk_X509_EXTENSION_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_free)
#define _sk_X509_EXTENSION_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_insert)
#define _sk_X509_EXTENSION_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_new_null)
#define _sk_X509_EXTENSION_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_num)
#define _sk_X509_EXTENSION_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_pop_free)
#define _sk_X509_EXTENSION_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_push)
#define _sk_X509_EXTENSION_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_set)
#define _sk_X509_EXTENSION_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_EXTENSION_value)
#define _sk_X509_INFO_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_call_free_func)
#define _sk_X509_INFO_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_free)
#define _sk_X509_INFO_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_new_null)
#define _sk_X509_INFO_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_num)
#define _sk_X509_INFO_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_pop)
#define _sk_X509_INFO_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_pop_free)
#define _sk_X509_INFO_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_push)
#define _sk_X509_INFO_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_INFO_value)
#define _sk_X509_LOOKUP_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_call_free_func)
#define _sk_X509_LOOKUP_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_new_null)
#define _sk_X509_LOOKUP_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_num)
#define _sk_X509_LOOKUP_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_pop_free)
#define _sk_X509_LOOKUP_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_push)
#define _sk_X509_LOOKUP_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_LOOKUP_value)
#define _sk_X509_NAME_ENTRY_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_call_free_func)
#define _sk_X509_NAME_ENTRY_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_delete)
#define _sk_X509_NAME_ENTRY_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_free)
#define _sk_X509_NAME_ENTRY_insert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_insert)
#define _sk_X509_NAME_ENTRY_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_new_null)
#define _sk_X509_NAME_ENTRY_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_num)
#define _sk_X509_NAME_ENTRY_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_pop_free)
#define _sk_X509_NAME_ENTRY_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_push)
#define _sk_X509_NAME_ENTRY_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_set)
#define _sk_X509_NAME_ENTRY_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_ENTRY_value)
#define _sk_X509_NAME_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_call_cmp_func)
#define _sk_X509_NAME_call_copy_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_call_copy_func)
#define _sk_X509_NAME_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_call_free_func)
#define _sk_X509_NAME_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_deep_copy)
#define _sk_X509_NAME_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_find)
#define _sk_X509_NAME_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_new)
#define _sk_X509_NAME_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_new_null)
#define _sk_X509_NAME_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_num)
#define _sk_X509_NAME_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_pop_free)
#define _sk_X509_NAME_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_set)
#define _sk_X509_NAME_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_set_cmp_func)
#define _sk_X509_NAME_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_sort)
#define _sk_X509_NAME_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_NAME_value)
#define _sk_X509_OBJECT_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_call_cmp_func)
#define _sk_X509_OBJECT_call_copy_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_call_copy_func)
#define _sk_X509_OBJECT_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_call_free_func)
#define _sk_X509_OBJECT_deep_copy BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_deep_copy)
#define _sk_X509_OBJECT_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_find)
#define _sk_X509_OBJECT_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_new)
#define _sk_X509_OBJECT_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_num)
#define _sk_X509_OBJECT_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_pop_free)
#define _sk_X509_OBJECT_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_push)
#define _sk_X509_OBJECT_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_sort)
#define _sk_X509_OBJECT_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_OBJECT_value)
#define _sk_X509_REVOKED_call_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_call_cmp_func)
#define _sk_X509_REVOKED_find BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_find)
#define _sk_X509_REVOKED_is_sorted BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_is_sorted)
#define _sk_X509_REVOKED_new BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_new)
#define _sk_X509_REVOKED_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_num)
#define _sk_X509_REVOKED_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_push)
#define _sk_X509_REVOKED_set_cmp_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_set_cmp_func)
#define _sk_X509_REVOKED_sort BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_sort)
#define _sk_X509_REVOKED_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_REVOKED_value)
#define _sk_X509_call_free_func BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_call_free_func)
#define _sk_X509_delete BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_delete)
#define _sk_X509_delete_ptr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_delete_ptr)
#define _sk_X509_dup BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_dup)
#define _sk_X509_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_free)
#define _sk_X509_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_new_null)
#define _sk_X509_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_num)
#define _sk_X509_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_pop)
#define _sk_X509_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_pop_free)
#define _sk_X509_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_push)
#define _sk_X509_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_set)
#define _sk_X509_shift BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_shift)
#define _sk_X509_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_X509_value)
#define _sk_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_free)
#define _sk_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_new_null)
#define _sk_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_num)
#define _sk_pop BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_pop)
#define _sk_pop_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_pop_free)
#define _sk_pop_free_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_pop_free_ex)
#define _sk_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_push)
#define _sk_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_value)
#define _sk_void_free BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_free)
#define _sk_void_new_null BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_new_null)
#define _sk_void_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_num)
#define _sk_void_push BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_push)
#define _sk_void_set BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_set)
#define _sk_void_value BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, sk_void_value)
#define _slhdsa_copy_keypair_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_copy_keypair_addr)
#define _slhdsa_fors_pk_from_sig BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_fors_pk_from_sig)
#define _slhdsa_fors_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_fors_sign)
#define _slhdsa_fors_sk_gen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_fors_sk_gen)
#define _slhdsa_fors_treehash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_fors_treehash)
#define _slhdsa_get_tree_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_get_tree_index)
#define _slhdsa_ht_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_ht_sign)
#define _slhdsa_ht_verify BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_ht_verify)
#define _slhdsa_set_chain_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_chain_addr)
#define _slhdsa_set_hash_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_hash_addr)
#define _slhdsa_set_keypair_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_keypair_addr)
#define _slhdsa_set_layer_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_layer_addr)
#define _slhdsa_set_tree_addr BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_tree_addr)
#define _slhdsa_set_tree_height BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_tree_height)
#define _slhdsa_set_tree_index BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_tree_index)
#define _slhdsa_set_type BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_set_type)
#define _slhdsa_thash_f BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_f)
#define _slhdsa_thash_h BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_h)
#define _slhdsa_thash_hmsg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_hmsg)
#define _slhdsa_thash_prf BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_prf)
#define _slhdsa_thash_prfmsg BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_prfmsg)
#define _slhdsa_thash_tk BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_tk)
#define _slhdsa_thash_tl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_thash_tl)
#define _slhdsa_treehash BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_treehash)
#define _slhdsa_wots_pk_from_sig BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_wots_pk_from_sig)
#define _slhdsa_wots_pk_gen BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_wots_pk_gen)
#define _slhdsa_wots_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_wots_sign)
#define _slhdsa_xmss_pk_from_sig BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_xmss_pk_from_sig)
#define _slhdsa_xmss_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, slhdsa_xmss_sign)
#define _v2i_GENERAL_NAME BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v2i_GENERAL_NAME)
#define _v2i_GENERAL_NAMES BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v2i_GENERAL_NAMES)
#define _v2i_GENERAL_NAME_ex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v2i_GENERAL_NAME_ex)
#define _v3_akey_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_akey_id)
#define _v3_alt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_alt)
#define _v3_bcons BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_bcons)
#define _v3_cpols BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_cpols)
#define _v3_crl_invdate BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_crl_invdate)
#define _v3_crl_num BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_crl_num)
#define _v3_crl_reason BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_crl_reason)
#define _v3_crld BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_crld)
#define _v3_delta_crl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_delta_crl)
#define _v3_ext_ku BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_ext_ku)
#define _v3_freshest_crl BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_freshest_crl)
#define _v3_idp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_idp)
#define _v3_info BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_info)
#define _v3_inhibit_anyp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_inhibit_anyp)
#define _v3_key_usage BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_key_usage)
#define _v3_name_constraints BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_name_constraints)
#define _v3_ns_ia5_list BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_ns_ia5_list)
#define _v3_nscert BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_nscert)
#define _v3_ocsp_accresp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_ocsp_accresp)
#define _v3_ocsp_nocheck BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_ocsp_nocheck)
#define _v3_policy_constraints BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_policy_constraints)
#define _v3_policy_mappings BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_policy_mappings)
#define _v3_sinfo BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_sinfo)
#define _v3_skey_id BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, v3_skey_id)
#define _voprf_exp2_blind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_blind)
#define _voprf_exp2_client_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_client_key_from_bytes)
#define _voprf_exp2_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_derive_key_from_secret)
#define _voprf_exp2_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_generate_key)
#define _voprf_exp2_issuer_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_issuer_key_from_bytes)
#define _voprf_exp2_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_read)
#define _voprf_exp2_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_sign)
#define _voprf_exp2_unblind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_exp2_unblind)
#define _voprf_pst1_blind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_blind)
#define _voprf_pst1_client_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_client_key_from_bytes)
#define _voprf_pst1_derive_key_from_secret BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_derive_key_from_secret)
#define _voprf_pst1_generate_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_generate_key)
#define _voprf_pst1_issuer_key_from_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_issuer_key_from_bytes)
#define _voprf_pst1_read BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_read)
#define _voprf_pst1_sign BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_sign)
#define _voprf_pst1_sign_with_proof_scalar_for_testing BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_sign_with_proof_scalar_for_testing)
#define _voprf_pst1_unblind BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, voprf_pst1_unblind)
#define _vpaes_capable BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_capable)
#define _vpaes_cbc_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_cbc_encrypt)
#define _vpaes_ctr32_encrypt_blocks BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_ctr32_encrypt_blocks)
#define _vpaes_decrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_decrypt)
#define _vpaes_decrypt_key_to_bsaes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_decrypt_key_to_bsaes)
#define _vpaes_encrypt BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_encrypt)
#define _vpaes_set_decrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_set_decrypt_key)
#define _vpaes_set_encrypt_key BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, vpaes_set_encrypt_key)
#define _x25519_asn1_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_asn1_meth)
#define _x25519_ge_add BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_add)
#define _x25519_ge_frombytes_vartime BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_frombytes_vartime)
#define _x25519_ge_p1p1_to_p2 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_p1p1_to_p2)
#define _x25519_ge_p1p1_to_p3 BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_p1p1_to_p3)
#define _x25519_ge_p3_to_cached BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_p3_to_cached)
#define _x25519_ge_scalarmult BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_scalarmult)
#define _x25519_ge_scalarmult_base BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_scalarmult_base)
#define _x25519_ge_scalarmult_base_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_scalarmult_base_adx)
#define _x25519_ge_scalarmult_small_precomp BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_scalarmult_small_precomp)
#define _x25519_ge_sub BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_sub)
#define _x25519_ge_tobytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_ge_tobytes)
#define _x25519_pkey_meth BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_pkey_meth)
#define _x25519_sc_reduce BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_sc_reduce)
#define _x25519_scalar_mult_adx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x25519_scalar_mult_adx)
#define _x509V3_add_value_asn1_string BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509V3_add_value_asn1_string)
#define _x509_check_issued_with_callback BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_check_issued_with_callback)
#define _x509_digest_sign_algorithm BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_digest_sign_algorithm)
#define _x509_digest_verify_init BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_digest_verify_init)
#define _x509_print_rsa_pss_params BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_print_rsa_pss_params)
#define _x509_rsa_ctx_to_pss BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_rsa_ctx_to_pss)
#define _x509_rsa_pss_to_ctx BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509_rsa_pss_to_ctx)
#define _x509v3_a2i_ipadd BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_a2i_ipadd)
#define _x509v3_bytes_to_hex BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_bytes_to_hex)
#define _x509v3_cache_extensions BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_cache_extensions)
#define _x509v3_conf_name_matches BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_conf_name_matches)
#define _x509v3_hex_to_bytes BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_hex_to_bytes)
#define _x509v3_looks_like_dns_name BORINGSSL_ADD_PREFIX_MAC_ASM(BORINGSSL_PREFIX, x509v3_looks_like_dns_name)
#endif
