//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2019-2021 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//

import Dispatch
import Foundation

// MARK: Test Harness

#if compiler(>=5.10)
nonisolated(unsafe) var warning: String = ""
#else
var warning: String = ""
#endif

assert(
    {
        print("======================================================")
        print("= YOU ARE RUNNING NIOPerformanceTester IN DEBUG MODE =")
        print("======================================================")
        warning = " <<< DEBUG MODE >>>"
        return true
    }()
)

public func measure(_ fn: () throws -> Int) rethrows -> [TimeInterval] {
    func measureOne(_ fn: () throws -> Int) rethrows -> TimeInterval {
        let start = Date()
        _ = try fn()
        let end = Date()
        return end.timeIntervalSince(start)
    }

    _ = try measureOne(fn)  // pre-heat and throw away
    var measurements = Array(repeating: 0.0, count: 10)
    for i in 0..<10 {
        measurements[i] = try measureOne(fn)
    }

    return measurements
}

let limitSet = CommandLine.arguments.dropFirst()

public func measureAndPrint(desc: String, fn: () throws -> Int) rethrows {
    if limitSet.count == 0 || limitSet.contains(desc) {
        print("measuring\(warning): \(desc): ", terminator: "")
        let measurements = try measure(fn)
        print(measurements.reduce("") { $0 + "\($1), " })
    } else {
        print("skipping '\(desc)', limit set = \(limitSet)")
    }
}

// MARK: Utilities

try measureAndPrint(desc: "repeated_handshakes", benchmark: try BenchRepeatedHandshakes(loopCount: 1000))
try measureAndPrint(desc: "many_writes_512b", benchmark: try BenchManyWrites(loopCount: 2000, writeSizeInBytes: 512))
