//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2019 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
#ifndef C_NIO_BORINGSSL_H
#define C_NIO_BORINGSSL_H

#include "CNIOBoringSSL_aead.h"
#include "CNIOBoringSSL_aes.h"
#include "CNIOBoringSSL_arm_arch.h"
#include "CNIOBoringSSL_asm_base.h"
#include "CNIOBoringSSL_asn1_mac.h"
#include "CNIOBoringSSL_asn1t.h"
#include "CNIOBoringSSL_base.h"
#include "CNIOBoringSSL_bio.h"
#include "CNIOBoringSSL_blake2.h"
#include "CNIOBoringSSL_blowfish.h"
#include "CNIOBoringSSL_bn.h"
#include "CNIOBoringSSL_boringssl_prefix_symbols.h"
#include "CNIOBoringSSL_boringssl_prefix_symbols_asm.h"
#include "CNIOBoringSSL_cast.h"
#include "CNIOBoringSSL_chacha.h"
#include "CNIOBoringSSL_ctrdrbg.h"
#include "CNIOBoringSSL_cmac.h"
#include "CNIOBoringSSL_conf.h"
#include "CNIOBoringSSL_cpu.h"
#include "CNIOBoringSSL_curve25519.h"
#include "CNIOBoringSSL_des.h"
#include "CNIOBoringSSL_dtls1.h"
#include "CNIOBoringSSL_e_os2.h"
#include "CNIOBoringSSL_ec.h"
#include "CNIOBoringSSL_ec_key.h"
#include "CNIOBoringSSL_ecdsa.h"
#include "CNIOBoringSSL_err.h"
#include "CNIOBoringSSL_evp.h"
#include "CNIOBoringSSL_hkdf.h"
#include "CNIOBoringSSL_hmac.h"
#include "CNIOBoringSSL_hpke.h"
#include "CNIOBoringSSL_hrss.h"
#include "CNIOBoringSSL_kdf.h"
#include "CNIOBoringSSL_md4.h"
#include "CNIOBoringSSL_md5.h"
#include "CNIOBoringSSL_mldsa.h"
#include "CNIOBoringSSL_mlkem.h"
#include "CNIOBoringSSL_obj_mac.h"
#include "CNIOBoringSSL_objects.h"
#include "CNIOBoringSSL_opensslv.h"
#include "CNIOBoringSSL_ossl_typ.h"
#include "CNIOBoringSSL_pkcs12.h"
#include "CNIOBoringSSL_poly1305.h"
#include "CNIOBoringSSL_rand.h"
#include "CNIOBoringSSL_rc4.h"
#include "CNIOBoringSSL_ripemd.h"
#include "CNIOBoringSSL_rsa.h"
#include "CNIOBoringSSL_safestack.h"
#include "CNIOBoringSSL_service_indicator.h"
#include "CNIOBoringSSL_sha.h"
#include "CNIOBoringSSL_siphash.h"
#include "CNIOBoringSSL_slhdsa.h"
#include "CNIOBoringSSL_srtp.h"
#include "CNIOBoringSSL_ssl.h"
#include "CNIOBoringSSL_time.h"
#include "CNIOBoringSSL_trust_token.h"
#include "CNIOBoringSSL_type_check.h"
#include "CNIOBoringSSL_x509_vfy.h"
#include "CNIOBoringSSL_x509v3.h"
#include "experimental/CNIOBoringSSL_kyber.h"

#endif  // C_NIO_BORINGSSL_H
