//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// RUN: %empty-directory(%t)
// RUN: %gyb %s > %t/AtomicsFolding.swift
//
// RUN: %target-swift-frontend -parse-as-library -emit-sil -Onone -module-name AtomicsFolding %t/AtomicsFolding.swift > %t/AtomicsFolding-Onone.sil
// RUN: %FileCheck --check-prefixes=SECTIONING,CHECK      --input-file=%t/AtomicsFolding-Onone.sil %t/AtomicsFolding.swift
// RUN: %FileCheck --check-prefixes=SECTIONING,EXCLUSIONS --input-file=%t/AtomicsFolding-Onone.sil %t/AtomicsFolding.swift
//
// RUN: %target-swift-frontend -parse-as-library -emit-sil -O -module-name AtomicsFolding %t/AtomicsFolding.swift > %t/AtomicsFolding-O.sil
// RUN: %FileCheck --check-prefixes=SECTIONING,CHECK      --input-file=%t/AtomicsFolding-O.sil %t/AtomicsFolding.swift
// RUN: %FileCheck --check-prefixes=SECTIONING,EXCLUSIONS --input-file=%t/AtomicsFolding-O.sil %t/AtomicsFolding.swift
//
// RUN: %target-swift-frontend -parse-as-library -emit-sil -Osize -module-name AtomicsFolding %t/AtomicsFolding.swift > %t/AtomicsFolding-Osize.sil
// RUN: %FileCheck --check-prefixes=SECTIONING,CHECK      --input-file=%t/AtomicsFolding-Osize.sil %t/AtomicsFolding.swift
// RUN: %FileCheck --check-prefixes=SECTIONING,EXCLUSIONS --input-file=%t/AtomicsFolding-Osize.sil %t/AtomicsFolding.swift

// Tests that atomic operations get compiled to the expected builtins, and only
// the expected builtins. (I.e., that the switch statements over the orderings
// get constant folded away.)


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import Atomics

public struct Foo {}
public class Bar {}

// -----------------------------------------------------------------------------

public struct AtomicFoldingTests {
  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int_relaxed(_:)
  public func load_Int_relaxed(
    _ value: UnsafeAtomic<Int>
  ) -> Int {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int_acquiring(_:)
  public func load_Int_acquiring(
    _ value: UnsafeAtomic<Int>
  ) -> Int {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int_sequential(_:)
  public func load_Int_sequential(
    _ value: UnsafeAtomic<Int>
  ) -> Int {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int64_relaxed(_:)
  public func load_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>
  ) -> Int64 {
    // CHECK: builtin "atomicload_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int64_acquiring(_:)
  public func load_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>
  ) -> Int64 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int64"
    // CHECK: builtin "atomicload_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int64_sequential(_:)
  public func load_Int64_sequential(
    _ value: UnsafeAtomic<Int64>
  ) -> Int64 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int64"
    // CHECK: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int32_relaxed(_:)
  public func load_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>
  ) -> Int32 {
    // CHECK: builtin "atomicload_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int32_acquiring(_:)
  public func load_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>
  ) -> Int32 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int32"
    // CHECK: builtin "atomicload_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int32_sequential(_:)
  public func load_Int32_sequential(
    _ value: UnsafeAtomic<Int32>
  ) -> Int32 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int32"
    // CHECK: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int16_relaxed(_:)
  public func load_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>
  ) -> Int16 {
    // CHECK: builtin "atomicload_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int16_acquiring(_:)
  public func load_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>
  ) -> Int16 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int16"
    // CHECK: builtin "atomicload_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int16_sequential(_:)
  public func load_Int16_sequential(
    _ value: UnsafeAtomic<Int16>
  ) -> Int16 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int16"
    // CHECK: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int8_relaxed(_:)
  public func load_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>
  ) -> Int8 {
    // CHECK: builtin "atomicload_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int8_acquiring(_:)
  public func load_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>
  ) -> Int8 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int8"
    // CHECK: builtin "atomicload_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Int8_sequential(_:)
  public func load_Int8_sequential(
    _ value: UnsafeAtomic<Int8>
  ) -> Int8 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int8"
    // CHECK: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt_relaxed(_:)
  public func load_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>
  ) -> UInt {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt_acquiring(_:)
  public func load_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>
  ) -> UInt {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt_sequential(_:)
  public func load_UInt_sequential(
    _ value: UnsafeAtomic<UInt>
  ) -> UInt {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt64_relaxed(_:)
  public func load_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>
  ) -> UInt64 {
    // CHECK: builtin "atomicload_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt64_acquiring(_:)
  public func load_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>
  ) -> UInt64 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int64"
    // CHECK: builtin "atomicload_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt64_sequential(_:)
  public func load_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>
  ) -> UInt64 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int64"
    // CHECK: builtin "atomicload_seqcst_Int64"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt32_relaxed(_:)
  public func load_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>
  ) -> UInt32 {
    // CHECK: builtin "atomicload_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt32_acquiring(_:)
  public func load_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>
  ) -> UInt32 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int32"
    // CHECK: builtin "atomicload_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt32_sequential(_:)
  public func load_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>
  ) -> UInt32 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int32"
    // CHECK: builtin "atomicload_seqcst_Int32"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt16_relaxed(_:)
  public func load_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>
  ) -> UInt16 {
    // CHECK: builtin "atomicload_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt16_acquiring(_:)
  public func load_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>
  ) -> UInt16 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int16"
    // CHECK: builtin "atomicload_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt16_sequential(_:)
  public func load_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>
  ) -> UInt16 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int16"
    // CHECK: builtin "atomicload_seqcst_Int16"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt8_relaxed(_:)
  public func load_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>
  ) -> UInt8 {
    // CHECK: builtin "atomicload_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt8_acquiring(_:)
  public func load_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>
  ) -> UInt8 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int8"
    // CHECK: builtin "atomicload_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UInt8_sequential(_:)
  public func load_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>
  ) -> UInt8 {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Int8"
    // CHECK: builtin "atomicload_seqcst_Int8"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeRawPointer_relaxed(_:)
  public func load_UnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>
  ) -> UnsafeRawPointer {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeRawPointer_acquiring(_:)
  public func load_UnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>
  ) -> UnsafeRawPointer {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeRawPointer_sequential(_:)
  public func load_UnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeRawPointer>
  ) -> UnsafeRawPointer {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutableRawPointer_relaxed(_:)
  public func load_UnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>
  ) -> UnsafeMutableRawPointer {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutableRawPointer_acquiring(_:)
  public func load_UnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>
  ) -> UnsafeMutableRawPointer {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutableRawPointer_sequential(_:)
  public func load_UnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>
  ) -> UnsafeMutableRawPointer {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafePointer_relaxed(_:)
  public func load_UnsafePointer_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>
  ) -> UnsafePointer<Foo> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafePointer_acquiring(_:)
  public func load_UnsafePointer_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>
  ) -> UnsafePointer<Foo> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafePointer_sequential(_:)
  public func load_UnsafePointer_sequential(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>
  ) -> UnsafePointer<Foo> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutablePointer_relaxed(_:)
  public func load_UnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>
  ) -> UnsafeMutablePointer<Foo> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutablePointer_acquiring(_:)
  public func load_UnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>
  ) -> UnsafeMutablePointer<Foo> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_UnsafeMutablePointer_sequential(_:)
  public func load_UnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>
  ) -> UnsafeMutablePointer<Foo> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Unmanaged_relaxed(_:)
  public func load_Unmanaged_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>
  ) -> Unmanaged<Bar> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Unmanaged_acquiring(_:)
  public func load_Unmanaged_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>
  ) -> Unmanaged<Bar> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_Unmanaged_sequential(_:)
  public func load_Unmanaged_sequential(
    _ value: UnsafeAtomic<Unmanaged<Bar>>
  ) -> Unmanaged<Bar> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeRawPointer_relaxed(_:)
  public func load_OptionalUnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>
  ) -> Optional<UnsafeRawPointer> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeRawPointer_acquiring(_:)
  public func load_OptionalUnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>
  ) -> Optional<UnsafeRawPointer> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeRawPointer_sequential(_:)
  public func load_OptionalUnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>
  ) -> Optional<UnsafeRawPointer> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutableRawPointer_relaxed(_:)
  public func load_OptionalUnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>
  ) -> Optional<UnsafeMutableRawPointer> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutableRawPointer_acquiring(_:)
  public func load_OptionalUnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>
  ) -> Optional<UnsafeMutableRawPointer> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutableRawPointer_sequential(_:)
  public func load_OptionalUnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>
  ) -> Optional<UnsafeMutableRawPointer> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafePointer_relaxed(_:)
  public func load_OptionalUnsafePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>
  ) -> Optional<UnsafePointer<Foo>> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafePointer_acquiring(_:)
  public func load_OptionalUnsafePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>
  ) -> Optional<UnsafePointer<Foo>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafePointer_sequential(_:)
  public func load_OptionalUnsafePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>
  ) -> Optional<UnsafePointer<Foo>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutablePointer_relaxed(_:)
  public func load_OptionalUnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>
  ) -> Optional<UnsafeMutablePointer<Foo>> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutablePointer_acquiring(_:)
  public func load_OptionalUnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>
  ) -> Optional<UnsafeMutablePointer<Foo>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnsafeMutablePointer_sequential(_:)
  public func load_OptionalUnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>
  ) -> Optional<UnsafeMutablePointer<Foo>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnmanaged_relaxed(_:)
  public func load_OptionalUnmanaged_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>
  ) -> Optional<Unmanaged<Bar>> {
    // CHECK: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnmanaged_acquiring(_:)
  public func load_OptionalUnmanaged_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>
  ) -> Optional<Unmanaged<Bar>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // CHECK: builtin "atomicload_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.load_OptionalUnmanaged_sequential(_:)
  public func load_OptionalUnmanaged_sequential(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>
  ) -> Optional<Unmanaged<Bar>> {
    // EXCLUSIONS-NOT: builtin "atomicload_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicload_acquire_Word"
    // CHECK: builtin "atomicload_seqcst_Word"
    return value.load(ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int_relaxed(_:_:)
  public func store_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int_releasing(_:_:)
  public func store_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int_sequential(_:_:)
  public func store_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int64_relaxed(_:_:)
  public func store_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int64_releasing(_:_:)
  public func store_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int64"
    // CHECK: builtin "atomicstore_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int64_sequential(_:_:)
  public func store_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int64"
    // CHECK: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int32_relaxed(_:_:)
  public func store_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int32_releasing(_:_:)
  public func store_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int32"
    // CHECK: builtin "atomicstore_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int32_sequential(_:_:)
  public func store_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int32"
    // CHECK: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int16_relaxed(_:_:)
  public func store_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int16_releasing(_:_:)
  public func store_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int16"
    // CHECK: builtin "atomicstore_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int16_sequential(_:_:)
  public func store_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int16"
    // CHECK: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int8_relaxed(_:_:)
  public func store_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int8_releasing(_:_:)
  public func store_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int8"
    // CHECK: builtin "atomicstore_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Int8_sequential(_:_:)
  public func store_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int8"
    // CHECK: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt_relaxed(_:_:)
  public func store_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt_releasing(_:_:)
  public func store_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt_sequential(_:_:)
  public func store_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt64_relaxed(_:_:)
  public func store_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt64_releasing(_:_:)
  public func store_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int64"
    // CHECK: builtin "atomicstore_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt64_sequential(_:_:)
  public func store_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int64"
    // CHECK: builtin "atomicstore_seqcst_Int64"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt32_relaxed(_:_:)
  public func store_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt32_releasing(_:_:)
  public func store_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int32"
    // CHECK: builtin "atomicstore_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt32_sequential(_:_:)
  public func store_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int32"
    // CHECK: builtin "atomicstore_seqcst_Int32"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt16_relaxed(_:_:)
  public func store_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt16_releasing(_:_:)
  public func store_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int16"
    // CHECK: builtin "atomicstore_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt16_sequential(_:_:)
  public func store_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int16"
    // CHECK: builtin "atomicstore_seqcst_Int16"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt8_relaxed(_:_:)
  public func store_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) {
    // CHECK: builtin "atomicstore_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt8_releasing(_:_:)
  public func store_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int8"
    // CHECK: builtin "atomicstore_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UInt8_sequential(_:_:)
  public func store_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Int8"
    // CHECK: builtin "atomicstore_seqcst_Int8"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeRawPointer_relaxed(_:_:)
  public func store_UnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeRawPointer_releasing(_:_:)
  public func store_UnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeRawPointer_sequential(_:_:)
  public func store_UnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutableRawPointer_relaxed(_:_:)
  public func store_UnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutableRawPointer_releasing(_:_:)
  public func store_UnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutableRawPointer_sequential(_:_:)
  public func store_UnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafePointer_relaxed(_:_:)
  public func store_UnsafePointer_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafePointer_releasing(_:_:)
  public func store_UnsafePointer_releasing(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafePointer_sequential(_:_:)
  public func store_UnsafePointer_sequential(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutablePointer_relaxed(_:_:)
  public func store_UnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutablePointer_releasing(_:_:)
  public func store_UnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_UnsafeMutablePointer_sequential(_:_:)
  public func store_UnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Unmanaged_relaxed(_:_:)
  public func store_Unmanaged_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Unmanaged_releasing(_:_:)
  public func store_Unmanaged_releasing(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_Unmanaged_sequential(_:_:)
  public func store_Unmanaged_sequential(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeRawPointer_relaxed(_:_:)
  public func store_OptionalUnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeRawPointer_releasing(_:_:)
  public func store_OptionalUnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeRawPointer_sequential(_:_:)
  public func store_OptionalUnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutableRawPointer_relaxed(_:_:)
  public func store_OptionalUnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutableRawPointer_releasing(_:_:)
  public func store_OptionalUnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutableRawPointer_sequential(_:_:)
  public func store_OptionalUnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafePointer_relaxed(_:_:)
  public func store_OptionalUnsafePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafePointer_releasing(_:_:)
  public func store_OptionalUnsafePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafePointer_sequential(_:_:)
  public func store_OptionalUnsafePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutablePointer_relaxed(_:_:)
  public func store_OptionalUnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutablePointer_releasing(_:_:)
  public func store_OptionalUnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnsafeMutablePointer_sequential(_:_:)
  public func store_OptionalUnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnmanaged_relaxed(_:_:)
  public func store_OptionalUnmanaged_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) {
    // CHECK: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnmanaged_releasing(_:_:)
  public func store_OptionalUnmanaged_releasing(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // CHECK: builtin "atomicstore_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.store_OptionalUnmanaged_sequential(_:_:)
  public func store_OptionalUnmanaged_sequential(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) {
    // EXCLUSIONS-NOT: builtin "atomicstore_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicstore_release_Word"
    // CHECK: builtin "atomicstore_seqcst_Word"
    value.store(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int_relaxed(_:_:)
  public func exchange_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) -> Int  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int_acquiring(_:_:)
  public func exchange_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) -> Int  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int_releasing(_:_:)
  public func exchange_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) -> Int  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int_acquiringAndReleasing(_:_:)
  public func exchange_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) -> Int  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int_sequential(_:_:)
  public func exchange_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ desired: Int
  ) -> Int  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int64_relaxed(_:_:)
  public func exchange_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) -> Int64  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int64_acquiring(_:_:)
  public func exchange_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) -> Int64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int64_releasing(_:_:)
  public func exchange_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) -> Int64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // CHECK: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int64_acquiringAndReleasing(_:_:)
  public func exchange_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) -> Int64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int64_sequential(_:_:)
  public func exchange_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ desired: Int64
  ) -> Int64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int32_relaxed(_:_:)
  public func exchange_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) -> Int32  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int32_acquiring(_:_:)
  public func exchange_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) -> Int32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int32_releasing(_:_:)
  public func exchange_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) -> Int32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // CHECK: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int32_acquiringAndReleasing(_:_:)
  public func exchange_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) -> Int32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int32_sequential(_:_:)
  public func exchange_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ desired: Int32
  ) -> Int32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int16_relaxed(_:_:)
  public func exchange_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) -> Int16  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int16_acquiring(_:_:)
  public func exchange_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) -> Int16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int16_releasing(_:_:)
  public func exchange_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) -> Int16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // CHECK: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int16_acquiringAndReleasing(_:_:)
  public func exchange_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) -> Int16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int16_sequential(_:_:)
  public func exchange_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ desired: Int16
  ) -> Int16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int8_relaxed(_:_:)
  public func exchange_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) -> Int8  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int8_acquiring(_:_:)
  public func exchange_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) -> Int8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int8_releasing(_:_:)
  public func exchange_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) -> Int8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // CHECK: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int8_acquiringAndReleasing(_:_:)
  public func exchange_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) -> Int8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Int8_sequential(_:_:)
  public func exchange_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ desired: Int8
  ) -> Int8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt_relaxed(_:_:)
  public func exchange_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) -> UInt  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt_acquiring(_:_:)
  public func exchange_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) -> UInt  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt_releasing(_:_:)
  public func exchange_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) -> UInt  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt_acquiringAndReleasing(_:_:)
  public func exchange_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) -> UInt  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt_sequential(_:_:)
  public func exchange_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ desired: UInt
  ) -> UInt  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt64_relaxed(_:_:)
  public func exchange_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) -> UInt64  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt64_acquiring(_:_:)
  public func exchange_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) -> UInt64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt64_releasing(_:_:)
  public func exchange_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) -> UInt64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // CHECK: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt64_acquiringAndReleasing(_:_:)
  public func exchange_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) -> UInt64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt64_sequential(_:_:)
  public func exchange_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ desired: UInt64
  ) -> UInt64  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int64"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int64"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt32_relaxed(_:_:)
  public func exchange_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) -> UInt32  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt32_acquiring(_:_:)
  public func exchange_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) -> UInt32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt32_releasing(_:_:)
  public func exchange_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) -> UInt32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // CHECK: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt32_acquiringAndReleasing(_:_:)
  public func exchange_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) -> UInt32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt32_sequential(_:_:)
  public func exchange_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ desired: UInt32
  ) -> UInt32  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int32"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int32"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt16_relaxed(_:_:)
  public func exchange_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) -> UInt16  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt16_acquiring(_:_:)
  public func exchange_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) -> UInt16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt16_releasing(_:_:)
  public func exchange_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) -> UInt16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // CHECK: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt16_acquiringAndReleasing(_:_:)
  public func exchange_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) -> UInt16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt16_sequential(_:_:)
  public func exchange_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ desired: UInt16
  ) -> UInt16  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int16"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int16"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt8_relaxed(_:_:)
  public func exchange_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) -> UInt8  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt8_acquiring(_:_:)
  public func exchange_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) -> UInt8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // CHECK: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt8_releasing(_:_:)
  public func exchange_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) -> UInt8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // CHECK: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt8_acquiringAndReleasing(_:_:)
  public func exchange_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) -> UInt8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UInt8_sequential(_:_:)
  public func exchange_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ desired: UInt8
  ) -> UInt8  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Int8"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Int8"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeRawPointer_relaxed(_:_:)
  public func exchange_UnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) -> UnsafeRawPointer  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeRawPointer_acquiring(_:_:)
  public func exchange_UnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) -> UnsafeRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeRawPointer_releasing(_:_:)
  public func exchange_UnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) -> UnsafeRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeRawPointer_acquiringAndReleasing(_:_:)
  public func exchange_UnsafeRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) -> UnsafeRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeRawPointer_sequential(_:_:)
  public func exchange_UnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ desired: UnsafeRawPointer
  ) -> UnsafeRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutableRawPointer_relaxed(_:_:)
  public func exchange_UnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) -> UnsafeMutableRawPointer  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutableRawPointer_acquiring(_:_:)
  public func exchange_UnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) -> UnsafeMutableRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutableRawPointer_releasing(_:_:)
  public func exchange_UnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) -> UnsafeMutableRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutableRawPointer_acquiringAndReleasing(_:_:)
  public func exchange_UnsafeMutableRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) -> UnsafeMutableRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutableRawPointer_sequential(_:_:)
  public func exchange_UnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ desired: UnsafeMutableRawPointer
  ) -> UnsafeMutableRawPointer  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafePointer_relaxed(_:_:)
  public func exchange_UnsafePointer_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) -> UnsafePointer<Foo>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafePointer_acquiring(_:_:)
  public func exchange_UnsafePointer_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) -> UnsafePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafePointer_releasing(_:_:)
  public func exchange_UnsafePointer_releasing(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) -> UnsafePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafePointer_acquiringAndReleasing(_:_:)
  public func exchange_UnsafePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) -> UnsafePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafePointer_sequential(_:_:)
  public func exchange_UnsafePointer_sequential(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ desired: UnsafePointer<Foo>
  ) -> UnsafePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutablePointer_relaxed(_:_:)
  public func exchange_UnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> UnsafeMutablePointer<Foo>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutablePointer_acquiring(_:_:)
  public func exchange_UnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> UnsafeMutablePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutablePointer_releasing(_:_:)
  public func exchange_UnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> UnsafeMutablePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutablePointer_acquiringAndReleasing(_:_:)
  public func exchange_UnsafeMutablePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> UnsafeMutablePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_UnsafeMutablePointer_sequential(_:_:)
  public func exchange_UnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> UnsafeMutablePointer<Foo>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Unmanaged_relaxed(_:_:)
  public func exchange_Unmanaged_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) -> Unmanaged<Bar>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Unmanaged_acquiring(_:_:)
  public func exchange_Unmanaged_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) -> Unmanaged<Bar>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Unmanaged_releasing(_:_:)
  public func exchange_Unmanaged_releasing(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) -> Unmanaged<Bar>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Unmanaged_acquiringAndReleasing(_:_:)
  public func exchange_Unmanaged_acquiringAndReleasing(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) -> Unmanaged<Bar>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_Unmanaged_sequential(_:_:)
  public func exchange_Unmanaged_sequential(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ desired: Unmanaged<Bar>
  ) -> Unmanaged<Bar>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeRawPointer_relaxed(_:_:)
  public func exchange_OptionalUnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> Optional<UnsafeRawPointer>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeRawPointer_acquiring(_:_:)
  public func exchange_OptionalUnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> Optional<UnsafeRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeRawPointer_releasing(_:_:)
  public func exchange_OptionalUnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> Optional<UnsafeRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeRawPointer_acquiringAndReleasing(_:_:)
  public func exchange_OptionalUnsafeRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> Optional<UnsafeRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeRawPointer_sequential(_:_:)
  public func exchange_OptionalUnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> Optional<UnsafeRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutableRawPointer_relaxed(_:_:)
  public func exchange_OptionalUnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> Optional<UnsafeMutableRawPointer>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutableRawPointer_acquiring(_:_:)
  public func exchange_OptionalUnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> Optional<UnsafeMutableRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutableRawPointer_releasing(_:_:)
  public func exchange_OptionalUnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> Optional<UnsafeMutableRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutableRawPointer_acquiringAndReleasing(_:_:)
  public func exchange_OptionalUnsafeMutableRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> Optional<UnsafeMutableRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutableRawPointer_sequential(_:_:)
  public func exchange_OptionalUnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> Optional<UnsafeMutableRawPointer>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafePointer_relaxed(_:_:)
  public func exchange_OptionalUnsafePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> Optional<UnsafePointer<Foo>>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafePointer_acquiring(_:_:)
  public func exchange_OptionalUnsafePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> Optional<UnsafePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafePointer_releasing(_:_:)
  public func exchange_OptionalUnsafePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> Optional<UnsafePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafePointer_acquiringAndReleasing(_:_:)
  public func exchange_OptionalUnsafePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> Optional<UnsafePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafePointer_sequential(_:_:)
  public func exchange_OptionalUnsafePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> Optional<UnsafePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutablePointer_relaxed(_:_:)
  public func exchange_OptionalUnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> Optional<UnsafeMutablePointer<Foo>>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutablePointer_acquiring(_:_:)
  public func exchange_OptionalUnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> Optional<UnsafeMutablePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutablePointer_releasing(_:_:)
  public func exchange_OptionalUnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> Optional<UnsafeMutablePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutablePointer_acquiringAndReleasing(_:_:)
  public func exchange_OptionalUnsafeMutablePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> Optional<UnsafeMutablePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnsafeMutablePointer_sequential(_:_:)
  public func exchange_OptionalUnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> Optional<UnsafeMutablePointer<Foo>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnmanaged_relaxed(_:_:)
  public func exchange_OptionalUnmanaged_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> Optional<Unmanaged<Bar>>  {
    // CHECK: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnmanaged_acquiring(_:_:)
  public func exchange_OptionalUnmanaged_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> Optional<Unmanaged<Bar>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // CHECK: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnmanaged_releasing(_:_:)
  public func exchange_OptionalUnmanaged_releasing(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> Optional<Unmanaged<Bar>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // CHECK: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnmanaged_acquiringAndReleasing(_:_:)
  public func exchange_OptionalUnmanaged_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> Optional<Unmanaged<Bar>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // CHECK: builtin "atomicrmw_xchg_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.exchange_OptionalUnmanaged_sequential(_:_:)
  public func exchange_OptionalUnmanaged_sequential(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> Optional<Unmanaged<Bar>>  {
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xchg_acqrel_Word"
    // CHECK: builtin "atomicrmw_xchg_seqcst_Word"
    return value.exchange(desired, ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int_relaxed(_:_:_:)
  public func compareExchange_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int_acquiring(_:_:_:)
  public func compareExchange_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int_releasing(_:_:_:)
  public func compareExchange_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int_sequential(_:_:_:)
  public func compareExchange_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int64_relaxed(_:_:_:)
  public func compareExchange_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int64_acquiring(_:_:_:)
  public func compareExchange_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int64_releasing(_:_:_:)
  public func compareExchange_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_release_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int64_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int64_sequential(_:_:_:)
  public func compareExchange_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int32_relaxed(_:_:_:)
  public func compareExchange_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int32_acquiring(_:_:_:)
  public func compareExchange_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int32_releasing(_:_:_:)
  public func compareExchange_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_release_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int32_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int32_sequential(_:_:_:)
  public func compareExchange_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int16_relaxed(_:_:_:)
  public func compareExchange_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int16_acquiring(_:_:_:)
  public func compareExchange_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int16_releasing(_:_:_:)
  public func compareExchange_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_release_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int16_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int16_sequential(_:_:_:)
  public func compareExchange_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int8_relaxed(_:_:_:)
  public func compareExchange_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int8_acquiring(_:_:_:)
  public func compareExchange_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int8_releasing(_:_:_:)
  public func compareExchange_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_release_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int8_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Int8_sequential(_:_:_:)
  public func compareExchange_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt_relaxed(_:_:_:)
  public func compareExchange_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt_acquiring(_:_:_:)
  public func compareExchange_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt_releasing(_:_:_:)
  public func compareExchange_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt_sequential(_:_:_:)
  public func compareExchange_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt64_relaxed(_:_:_:)
  public func compareExchange_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt64_acquiring(_:_:_:)
  public func compareExchange_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt64_releasing(_:_:_:)
  public func compareExchange_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_release_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt64_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt64_sequential(_:_:_:)
  public func compareExchange_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt32_relaxed(_:_:_:)
  public func compareExchange_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt32_acquiring(_:_:_:)
  public func compareExchange_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt32_releasing(_:_:_:)
  public func compareExchange_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_release_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt32_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt32_sequential(_:_:_:)
  public func compareExchange_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt16_relaxed(_:_:_:)
  public func compareExchange_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt16_acquiring(_:_:_:)
  public func compareExchange_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt16_releasing(_:_:_:)
  public func compareExchange_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_release_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt16_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt16_sequential(_:_:_:)
  public func compareExchange_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt8_relaxed(_:_:_:)
  public func compareExchange_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt8_acquiring(_:_:_:)
  public func compareExchange_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_acquire_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt8_releasing(_:_:_:)
  public func compareExchange_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_release_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt8_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UInt8_sequential(_:_:_:)
  public func compareExchange_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeRawPointer_relaxed(_:_:_:)
  public func compareExchange_UnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeRawPointer_acquiring(_:_:_:)
  public func compareExchange_UnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeRawPointer_releasing(_:_:_:)
  public func compareExchange_UnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeRawPointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UnsafeRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeRawPointer_sequential(_:_:_:)
  public func compareExchange_UnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutableRawPointer_relaxed(_:_:_:)
  public func compareExchange_UnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutableRawPointer_acquiring(_:_:_:)
  public func compareExchange_UnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutableRawPointer_releasing(_:_:_:)
  public func compareExchange_UnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutableRawPointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UnsafeMutableRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutableRawPointer_sequential(_:_:_:)
  public func compareExchange_UnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafePointer_relaxed(_:_:_:)
  public func compareExchange_UnsafePointer_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafePointer_acquiring(_:_:_:)
  public func compareExchange_UnsafePointer_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafePointer_releasing(_:_:_:)
  public func compareExchange_UnsafePointer_releasing(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafePointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UnsafePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafePointer_sequential(_:_:_:)
  public func compareExchange_UnsafePointer_sequential(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutablePointer_relaxed(_:_:_:)
  public func compareExchange_UnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutablePointer_acquiring(_:_:_:)
  public func compareExchange_UnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutablePointer_releasing(_:_:_:)
  public func compareExchange_UnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutablePointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_UnsafeMutablePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_UnsafeMutablePointer_sequential(_:_:_:)
  public func compareExchange_UnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Unmanaged_relaxed(_:_:_:)
  public func compareExchange_Unmanaged_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Unmanaged_acquiring(_:_:_:)
  public func compareExchange_Unmanaged_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Unmanaged_releasing(_:_:_:)
  public func compareExchange_Unmanaged_releasing(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Unmanaged_acquiringAndReleasing(_:_:_:)
  public func compareExchange_Unmanaged_acquiringAndReleasing(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_Unmanaged_sequential(_:_:_:)
  public func compareExchange_Unmanaged_sequential(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeRawPointer_relaxed(_:_:_:)
  public func compareExchange_OptionalUnsafeRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeRawPointer_acquiring(_:_:_:)
  public func compareExchange_OptionalUnsafeRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeRawPointer_releasing(_:_:_:)
  public func compareExchange_OptionalUnsafeRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeRawPointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_OptionalUnsafeRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeRawPointer_sequential(_:_:_:)
  public func compareExchange_OptionalUnsafeRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutableRawPointer_relaxed(_:_:_:)
  public func compareExchange_OptionalUnsafeMutableRawPointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutableRawPointer_acquiring(_:_:_:)
  public func compareExchange_OptionalUnsafeMutableRawPointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutableRawPointer_releasing(_:_:_:)
  public func compareExchange_OptionalUnsafeMutableRawPointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutableRawPointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_OptionalUnsafeMutableRawPointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutableRawPointer_sequential(_:_:_:)
  public func compareExchange_OptionalUnsafeMutableRawPointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafePointer_relaxed(_:_:_:)
  public func compareExchange_OptionalUnsafePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafePointer_acquiring(_:_:_:)
  public func compareExchange_OptionalUnsafePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafePointer_releasing(_:_:_:)
  public func compareExchange_OptionalUnsafePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafePointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_OptionalUnsafePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafePointer_sequential(_:_:_:)
  public func compareExchange_OptionalUnsafePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutablePointer_relaxed(_:_:_:)
  public func compareExchange_OptionalUnsafeMutablePointer_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutablePointer_acquiring(_:_:_:)
  public func compareExchange_OptionalUnsafeMutablePointer_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutablePointer_releasing(_:_:_:)
  public func compareExchange_OptionalUnsafeMutablePointer_releasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutablePointer_acquiringAndReleasing(_:_:_:)
  public func compareExchange_OptionalUnsafeMutablePointer_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnsafeMutablePointer_sequential(_:_:_:)
  public func compareExchange_OptionalUnsafeMutablePointer_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnmanaged_relaxed(_:_:_:)
  public func compareExchange_OptionalUnmanaged_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnmanaged_acquiring(_:_:_:)
  public func compareExchange_OptionalUnmanaged_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnmanaged_releasing(_:_:_:)
  public func compareExchange_OptionalUnmanaged_releasing(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_release_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnmanaged_acquiringAndReleasing(_:_:_:)
  public func compareExchange_OptionalUnmanaged_acquiringAndReleasing(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange_OptionalUnmanaged_sequential(_:_:_:)
  public func compareExchange_OptionalUnmanaged_sequential(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // ---------------------------------------------------------------------------
  // FIXME: There are 15 valid combinations of success/failure orderings;
  // here we're only testing 6 of them.

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Int_relaxed_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Int_acquiring_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Int_acquiring_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_sequential_acquiring(_:_:_:)
  public func compareExchange2_Int_sequential_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_releasing_acquiring(_:_:_:)
  public func compareExchange2_Int_releasing_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_relaxed_sequential(_:_:_:)
  public func compareExchange2_Int_relaxed_sequential(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Int64_relaxed_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Int64_acquiring_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Int64_acquiring_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_sequential_acquiring(_:_:_:)
  public func compareExchange2_Int64_sequential_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_releasing_acquiring(_:_:_:)
  public func compareExchange2_Int64_releasing_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_relaxed_sequential(_:_:_:)
  public func compareExchange2_Int64_relaxed_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Int32_relaxed_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Int32_acquiring_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Int32_acquiring_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_sequential_acquiring(_:_:_:)
  public func compareExchange2_Int32_sequential_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_releasing_acquiring(_:_:_:)
  public func compareExchange2_Int32_releasing_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_relaxed_sequential(_:_:_:)
  public func compareExchange2_Int32_relaxed_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Int16_relaxed_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Int16_acquiring_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Int16_acquiring_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_sequential_acquiring(_:_:_:)
  public func compareExchange2_Int16_sequential_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_releasing_acquiring(_:_:_:)
  public func compareExchange2_Int16_releasing_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_relaxed_sequential(_:_:_:)
  public func compareExchange2_Int16_relaxed_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Int8_relaxed_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Int8_acquiring_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Int8_acquiring_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_sequential_acquiring(_:_:_:)
  public func compareExchange2_Int8_sequential_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_releasing_acquiring(_:_:_:)
  public func compareExchange2_Int8_releasing_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_relaxed_sequential(_:_:_:)
  public func compareExchange2_Int8_relaxed_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UInt_relaxed_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UInt_acquiring_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UInt_acquiring_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_sequential_acquiring(_:_:_:)
  public func compareExchange2_UInt_sequential_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_releasing_acquiring(_:_:_:)
  public func compareExchange2_UInt_releasing_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_relaxed_sequential(_:_:_:)
  public func compareExchange2_UInt_relaxed_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UInt64_relaxed_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UInt64_acquiring_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UInt64_acquiring_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_sequential_acquiring(_:_:_:)
  public func compareExchange2_UInt64_sequential_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_releasing_acquiring(_:_:_:)
  public func compareExchange2_UInt64_releasing_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_relaxed_sequential(_:_:_:)
  public func compareExchange2_UInt64_relaxed_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int64"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UInt32_relaxed_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UInt32_acquiring_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UInt32_acquiring_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_sequential_acquiring(_:_:_:)
  public func compareExchange2_UInt32_sequential_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_releasing_acquiring(_:_:_:)
  public func compareExchange2_UInt32_releasing_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_relaxed_sequential(_:_:_:)
  public func compareExchange2_UInt32_relaxed_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int32"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UInt16_relaxed_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UInt16_acquiring_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UInt16_acquiring_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_sequential_acquiring(_:_:_:)
  public func compareExchange2_UInt16_sequential_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_releasing_acquiring(_:_:_:)
  public func compareExchange2_UInt16_releasing_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_relaxed_sequential(_:_:_:)
  public func compareExchange2_UInt16_relaxed_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int16"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UInt8_relaxed_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UInt8_acquiring_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UInt8_acquiring_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_sequential_acquiring(_:_:_:)
  public func compareExchange2_UInt8_sequential_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_releasing_acquiring(_:_:_:)
  public func compareExchange2_UInt8_releasing_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_relaxed_sequential(_:_:_:)
  public func compareExchange2_UInt8_relaxed_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Int8"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_relaxed_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_acquiring_relaxed(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_acquiring_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_sequential_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_releasing_acquiring(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_relaxed_sequential(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_relaxed_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_acquiring_relaxed(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_acquiring_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_sequential_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_releasing_acquiring(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_relaxed_sequential(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UnsafePointer_relaxed_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UnsafePointer_acquiring_relaxed(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UnsafePointer_acquiring_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_UnsafePointer_sequential_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_UnsafePointer_releasing_acquiring(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_UnsafePointer_relaxed_sequential(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_relaxed_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_acquiring_relaxed(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_acquiring_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_sequential_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_releasing_acquiring(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_relaxed_sequential(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_relaxed_relaxed(_:_:_:)
  public func compareExchange2_Unmanaged_relaxed_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_acquiring_relaxed(_:_:_:)
  public func compareExchange2_Unmanaged_acquiring_relaxed(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_acquiring_acquiring(_:_:_:)
  public func compareExchange2_Unmanaged_acquiring_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_sequential_acquiring(_:_:_:)
  public func compareExchange2_Unmanaged_sequential_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_releasing_acquiring(_:_:_:)
  public func compareExchange2_Unmanaged_releasing_acquiring(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_relaxed_sequential(_:_:_:)
  public func compareExchange2_Unmanaged_relaxed_sequential(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_relaxed_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_acquiring_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_acquiring_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_sequential_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_releasing_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_relaxed_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_sequential_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_releasing_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_relaxed_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_acquiring_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_acquiring_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_sequential_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_releasing_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_relaxed_sequential(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_relaxed_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_relaxed_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_acquiring_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_acquiring_relaxed(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_acquiring_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_acquiring_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_sequential_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_sequential_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_releasing_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_releasing_acquiring(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_relaxed_sequential(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_relaxed_sequential(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_relaxed_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_relaxed_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_acquiring_relaxed(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_acquiring_relaxed(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_acquiring_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_acquiring_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_sequential_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_sequential_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_releasing_acquiring(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_releasing_acquiring(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_relaxed_sequential(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_relaxed_sequential(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_Word"
    return value.compareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------
  // FIXME: There are 15 valid combinations of success/failure orderings;
  // here we're only testing 6 of them.

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Int_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Int_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Int_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Int_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Int_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Int_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Int>,
    _ expected: Int,
    _ desired: Int
  ) -> (exchanged: Bool, original: Int)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Int64_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Int64_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Int64_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Int64_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Int64_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int64_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Int64_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Int64>,
    _ expected: Int64,
    _ desired: Int64
  ) -> (exchanged: Bool, original: Int64)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Int32_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Int32_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Int32_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Int32_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Int32_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int32_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Int32_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Int32>,
    _ expected: Int32,
    _ desired: Int32
  ) -> (exchanged: Bool, original: Int32)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Int16_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Int16_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Int16_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Int16_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Int16_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int16_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Int16_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Int16>,
    _ expected: Int16,
    _ desired: Int16
  ) -> (exchanged: Bool, original: Int16)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Int8_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Int8_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Int8_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Int8_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Int8_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Int8_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Int8_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Int8>,
    _ expected: Int8,
    _ desired: Int8
  ) -> (exchanged: Bool, original: Int8)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UInt_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UInt>,
    _ expected: UInt,
    _ desired: UInt
  ) -> (exchanged: Bool, original: UInt)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt64_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt64_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt64_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt64_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt64_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt64_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UInt64_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UInt64>,
    _ expected: UInt64,
    _ desired: UInt64
  ) -> (exchanged: Bool, original: UInt64)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int64"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int64"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt32_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt32_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt32_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt32_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt32_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt32_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UInt32_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UInt32>,
    _ expected: UInt32,
    _ desired: UInt32
  ) -> (exchanged: Bool, original: UInt32)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int32"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int32"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt16_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt16_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt16_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt16_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt16_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt16_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UInt16_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UInt16>,
    _ expected: UInt16,
    _ desired: UInt16
  ) -> (exchanged: Bool, original: UInt16)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int16"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int16"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt8_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UInt8_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt8_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt8_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UInt8_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UInt8_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UInt8_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UInt8>,
    _ expected: UInt8,
    _ desired: UInt8
  ) -> (exchanged: Bool, original: UInt8)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Int8"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Int8"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeRawPointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UnsafeRawPointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UnsafeRawPointer>,
    _ expected: UnsafeRawPointer,
    _ desired: UnsafeRawPointer
  ) -> (exchanged: Bool, original: UnsafeRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutableRawPointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UnsafeMutableRawPointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UnsafeMutableRawPointer>,
    _ expected: UnsafeMutableRawPointer,
    _ desired: UnsafeMutableRawPointer
  ) -> (exchanged: Bool, original: UnsafeMutableRawPointer)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafePointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UnsafePointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UnsafePointer<Foo>>,
    _ expected: UnsafePointer<Foo>,
    _ desired: UnsafePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_UnsafeMutablePointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_UnsafeMutablePointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<UnsafeMutablePointer<Foo>>,
    _ expected: UnsafeMutablePointer<Foo>,
    _ desired: UnsafeMutablePointer<Foo>
  ) -> (exchanged: Bool, original: UnsafeMutablePointer<Foo>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_Unmanaged_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_Unmanaged_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_Unmanaged_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_Unmanaged_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_Unmanaged_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_Unmanaged_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_Unmanaged_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Unmanaged<Bar>>,
    _ expected: Unmanaged<Bar>,
    _ desired: Unmanaged<Bar>
  ) -> (exchanged: Bool, original: Unmanaged<Bar>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeRawPointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeRawPointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Optional<UnsafeRawPointer>>,
    _ expected: Optional<UnsafeRawPointer>,
    _ desired: Optional<UnsafeRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutableRawPointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutableRawPointer>>,
    _ expected: Optional<UnsafeMutableRawPointer>,
    _ desired: Optional<UnsafeMutableRawPointer>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutableRawPointer>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafePointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafePointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Optional<UnsafePointer<Foo>>>,
    _ expected: Optional<UnsafePointer<Foo>>,
    _ desired: Optional<UnsafePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnsafeMutablePointer_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_OptionalUnsafeMutablePointer_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Optional<UnsafeMutablePointer<Foo>>>,
    _ expected: Optional<UnsafeMutablePointer<Foo>>,
    _ desired: Optional<UnsafeMutablePointer<Foo>>
  ) -> (exchanged: Bool, original: Optional<UnsafeMutablePointer<Foo>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_relaxed_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_relaxed_relaxed_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_monotonic_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_acquiring_relaxed_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_acquiring_relaxed_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_acquire_monotonic_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^m][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_acquiring_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_acquiring_acquiring_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_acquire_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_sequential_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_sequential_acquiring_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // CHECK: builtin "cmpxchg_seqcst_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^a][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding


  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_releasing_acquiring_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_releasing_acquiring_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // FIXME: This should be checking for "cmpxchg_release_acquire", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_acqrel_acquire_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[^a][a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.compareExchange2_OptionalUnmanaged_relaxed_sequential_weak(_:_:_:)
  public func compareExchange2_OptionalUnmanaged_relaxed_sequential_weak(
    _ value: UnsafeAtomic<Optional<Unmanaged<Bar>>>,
    _ expected: Optional<Unmanaged<Bar>>,
    _ desired: Optional<Unmanaged<Bar>>
  ) -> (exchanged: Bool, original: Optional<Unmanaged<Bar>>)  {
    // FIXME: This should be checking for "cmpxchg_monotonic_seqcst", but we don't
    // support arbitrary failure orderings yet, so internally we promote success
    // orderings to be at least as strong as the failure ordering.

    // CHECK: builtin "cmpxchg_seqcst_seqcst_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_monotonic_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acquire_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_release_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_acqrel_{{[a-z0-9_]*}}_weak_Word"
    // EXCLUSIONS-NOT: builtin "cmpxchg_seqcst_{{[^s][a-z0-9_]*}}_weak_Word"
    return value.weakCompareExchange(
      expected: expected,
      desired: desired,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int_relaxed(_:_:)
  public func loadThenWrappingIncrement_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int_acquiring(_:_:)
  public func loadThenWrappingIncrement_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int_releasing(_:_:)
  public func loadThenWrappingIncrement_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int_sequential(_:_:)
  public func loadThenWrappingIncrement_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int_relaxed(_:_:)
  public func loadThenWrappingDecrement_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int_acquiring(_:_:)
  public func loadThenWrappingDecrement_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int_releasing(_:_:)
  public func loadThenWrappingDecrement_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int_sequential(_:_:)
  public func loadThenWrappingDecrement_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int_relaxed(_:_:)
  public func loadThenBitwiseAnd_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int_acquiring(_:_:)
  public func loadThenBitwiseAnd_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int_releasing(_:_:)
  public func loadThenBitwiseAnd_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int_sequential(_:_:)
  public func loadThenBitwiseAnd_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int_relaxed(_:_:)
  public func loadThenBitwiseOr_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int_acquiring(_:_:)
  public func loadThenBitwiseOr_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int_releasing(_:_:)
  public func loadThenBitwiseOr_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int_sequential(_:_:)
  public func loadThenBitwiseOr_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int_relaxed(_:_:)
  public func loadThenBitwiseXor_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int_acquiring(_:_:)
  public func loadThenBitwiseXor_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int_releasing(_:_:)
  public func loadThenBitwiseXor_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int_sequential(_:_:)
  public func loadThenBitwiseXor_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int_relaxed(_:_:)
  public func wrappingIncrementThenLoad_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int_acquiring(_:_:)
  public func wrappingIncrementThenLoad_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int_releasing(_:_:)
  public func wrappingIncrementThenLoad_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int_sequential(_:_:)
  public func wrappingIncrementThenLoad_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_add_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int_relaxed(_:_:)
  public func wrappingDecrementThenLoad_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int_acquiring(_:_:)
  public func wrappingDecrementThenLoad_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int_releasing(_:_:)
  public func wrappingDecrementThenLoad_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int_sequential(_:_:)
  public func wrappingDecrementThenLoad_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_sub_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int_relaxed(_:_:)
  public func bitwiseAndThenLoad_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int_acquiring(_:_:)
  public func bitwiseAndThenLoad_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int_releasing(_:_:)
  public func bitwiseAndThenLoad_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int_sequential(_:_:)
  public func bitwiseAndThenLoad_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_and_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int_relaxed(_:_:)
  public func bitwiseOrThenLoad_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int_acquiring(_:_:)
  public func bitwiseOrThenLoad_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int_releasing(_:_:)
  public func bitwiseOrThenLoad_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int_sequential(_:_:)
  public func bitwiseOrThenLoad_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_or_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int_relaxed(_:_:)
  public func bitwiseXorThenLoad_Int_relaxed(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int_acquiring(_:_:)
  public func bitwiseXorThenLoad_Int_acquiring(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int_releasing(_:_:)
  public func bitwiseXorThenLoad_Int_releasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_Int_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int_sequential(_:_:)
  public func bitwiseXorThenLoad_Int_sequential(
    _ value: UnsafeAtomic<Int>,
    _ operand: Int
  ) -> Int {
    // CHECK: builtin "atomicrmw_xor_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int64_relaxed(_:_:)
  public func loadThenWrappingIncrement_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int64_acquiring(_:_:)
  public func loadThenWrappingIncrement_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int64_releasing(_:_:)
  public func loadThenWrappingIncrement_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int64_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int64_sequential(_:_:)
  public func loadThenWrappingIncrement_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int64_relaxed(_:_:)
  public func loadThenWrappingDecrement_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int64_acquiring(_:_:)
  public func loadThenWrappingDecrement_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int64_releasing(_:_:)
  public func loadThenWrappingDecrement_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int64_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int64_sequential(_:_:)
  public func loadThenWrappingDecrement_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int64_relaxed(_:_:)
  public func loadThenBitwiseAnd_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int64_acquiring(_:_:)
  public func loadThenBitwiseAnd_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int64_releasing(_:_:)
  public func loadThenBitwiseAnd_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int64_sequential(_:_:)
  public func loadThenBitwiseAnd_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int64_relaxed(_:_:)
  public func loadThenBitwiseOr_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int64_acquiring(_:_:)
  public func loadThenBitwiseOr_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int64_releasing(_:_:)
  public func loadThenBitwiseOr_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int64_sequential(_:_:)
  public func loadThenBitwiseOr_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int64_relaxed(_:_:)
  public func loadThenBitwiseXor_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int64_acquiring(_:_:)
  public func loadThenBitwiseXor_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int64_releasing(_:_:)
  public func loadThenBitwiseXor_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int64_sequential(_:_:)
  public func loadThenBitwiseXor_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int64_relaxed(_:_:)
  public func wrappingIncrementThenLoad_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int64_acquiring(_:_:)
  public func wrappingIncrementThenLoad_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int64_releasing(_:_:)
  public func wrappingIncrementThenLoad_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int64_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int64_sequential(_:_:)
  public func wrappingIncrementThenLoad_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int64_relaxed(_:_:)
  public func wrappingDecrementThenLoad_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int64_acquiring(_:_:)
  public func wrappingDecrementThenLoad_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int64_releasing(_:_:)
  public func wrappingDecrementThenLoad_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int64_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int64_sequential(_:_:)
  public func wrappingDecrementThenLoad_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int64_relaxed(_:_:)
  public func bitwiseAndThenLoad_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int64_acquiring(_:_:)
  public func bitwiseAndThenLoad_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int64_releasing(_:_:)
  public func bitwiseAndThenLoad_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int64_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int64_sequential(_:_:)
  public func bitwiseAndThenLoad_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int64_relaxed(_:_:)
  public func bitwiseOrThenLoad_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int64_acquiring(_:_:)
  public func bitwiseOrThenLoad_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int64_releasing(_:_:)
  public func bitwiseOrThenLoad_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int64_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int64_sequential(_:_:)
  public func bitwiseOrThenLoad_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int64_relaxed(_:_:)
  public func bitwiseXorThenLoad_Int64_relaxed(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int64_acquiring(_:_:)
  public func bitwiseXorThenLoad_Int64_acquiring(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int64_releasing(_:_:)
  public func bitwiseXorThenLoad_Int64_releasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int64_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_Int64_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int64_sequential(_:_:)
  public func bitwiseXorThenLoad_Int64_sequential(
    _ value: UnsafeAtomic<Int64>,
    _ operand: Int64
  ) -> Int64 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int32_relaxed(_:_:)
  public func loadThenWrappingIncrement_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int32_acquiring(_:_:)
  public func loadThenWrappingIncrement_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int32_releasing(_:_:)
  public func loadThenWrappingIncrement_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int32_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int32_sequential(_:_:)
  public func loadThenWrappingIncrement_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int32_relaxed(_:_:)
  public func loadThenWrappingDecrement_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int32_acquiring(_:_:)
  public func loadThenWrappingDecrement_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int32_releasing(_:_:)
  public func loadThenWrappingDecrement_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int32_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int32_sequential(_:_:)
  public func loadThenWrappingDecrement_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int32_relaxed(_:_:)
  public func loadThenBitwiseAnd_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int32_acquiring(_:_:)
  public func loadThenBitwiseAnd_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int32_releasing(_:_:)
  public func loadThenBitwiseAnd_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int32_sequential(_:_:)
  public func loadThenBitwiseAnd_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int32_relaxed(_:_:)
  public func loadThenBitwiseOr_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int32_acquiring(_:_:)
  public func loadThenBitwiseOr_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int32_releasing(_:_:)
  public func loadThenBitwiseOr_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int32_sequential(_:_:)
  public func loadThenBitwiseOr_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int32_relaxed(_:_:)
  public func loadThenBitwiseXor_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int32_acquiring(_:_:)
  public func loadThenBitwiseXor_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int32_releasing(_:_:)
  public func loadThenBitwiseXor_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int32_sequential(_:_:)
  public func loadThenBitwiseXor_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int32_relaxed(_:_:)
  public func wrappingIncrementThenLoad_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int32_acquiring(_:_:)
  public func wrappingIncrementThenLoad_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int32_releasing(_:_:)
  public func wrappingIncrementThenLoad_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int32_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int32_sequential(_:_:)
  public func wrappingIncrementThenLoad_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int32_relaxed(_:_:)
  public func wrappingDecrementThenLoad_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int32_acquiring(_:_:)
  public func wrappingDecrementThenLoad_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int32_releasing(_:_:)
  public func wrappingDecrementThenLoad_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int32_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int32_sequential(_:_:)
  public func wrappingDecrementThenLoad_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int32_relaxed(_:_:)
  public func bitwiseAndThenLoad_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int32_acquiring(_:_:)
  public func bitwiseAndThenLoad_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int32_releasing(_:_:)
  public func bitwiseAndThenLoad_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int32_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int32_sequential(_:_:)
  public func bitwiseAndThenLoad_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int32_relaxed(_:_:)
  public func bitwiseOrThenLoad_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int32_acquiring(_:_:)
  public func bitwiseOrThenLoad_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int32_releasing(_:_:)
  public func bitwiseOrThenLoad_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int32_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int32_sequential(_:_:)
  public func bitwiseOrThenLoad_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int32_relaxed(_:_:)
  public func bitwiseXorThenLoad_Int32_relaxed(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int32_acquiring(_:_:)
  public func bitwiseXorThenLoad_Int32_acquiring(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int32_releasing(_:_:)
  public func bitwiseXorThenLoad_Int32_releasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int32_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_Int32_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int32_sequential(_:_:)
  public func bitwiseXorThenLoad_Int32_sequential(
    _ value: UnsafeAtomic<Int32>,
    _ operand: Int32
  ) -> Int32 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int16_relaxed(_:_:)
  public func loadThenWrappingIncrement_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int16_acquiring(_:_:)
  public func loadThenWrappingIncrement_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int16_releasing(_:_:)
  public func loadThenWrappingIncrement_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int16_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int16_sequential(_:_:)
  public func loadThenWrappingIncrement_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int16_relaxed(_:_:)
  public func loadThenWrappingDecrement_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int16_acquiring(_:_:)
  public func loadThenWrappingDecrement_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int16_releasing(_:_:)
  public func loadThenWrappingDecrement_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int16_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int16_sequential(_:_:)
  public func loadThenWrappingDecrement_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int16_relaxed(_:_:)
  public func loadThenBitwiseAnd_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int16_acquiring(_:_:)
  public func loadThenBitwiseAnd_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int16_releasing(_:_:)
  public func loadThenBitwiseAnd_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int16_sequential(_:_:)
  public func loadThenBitwiseAnd_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int16_relaxed(_:_:)
  public func loadThenBitwiseOr_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int16_acquiring(_:_:)
  public func loadThenBitwiseOr_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int16_releasing(_:_:)
  public func loadThenBitwiseOr_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int16_sequential(_:_:)
  public func loadThenBitwiseOr_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int16_relaxed(_:_:)
  public func loadThenBitwiseXor_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int16_acquiring(_:_:)
  public func loadThenBitwiseXor_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int16_releasing(_:_:)
  public func loadThenBitwiseXor_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int16_sequential(_:_:)
  public func loadThenBitwiseXor_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int16_relaxed(_:_:)
  public func wrappingIncrementThenLoad_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int16_acquiring(_:_:)
  public func wrappingIncrementThenLoad_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int16_releasing(_:_:)
  public func wrappingIncrementThenLoad_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int16_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int16_sequential(_:_:)
  public func wrappingIncrementThenLoad_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int16_relaxed(_:_:)
  public func wrappingDecrementThenLoad_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int16_acquiring(_:_:)
  public func wrappingDecrementThenLoad_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int16_releasing(_:_:)
  public func wrappingDecrementThenLoad_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int16_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int16_sequential(_:_:)
  public func wrappingDecrementThenLoad_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int16_relaxed(_:_:)
  public func bitwiseAndThenLoad_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int16_acquiring(_:_:)
  public func bitwiseAndThenLoad_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int16_releasing(_:_:)
  public func bitwiseAndThenLoad_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int16_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int16_sequential(_:_:)
  public func bitwiseAndThenLoad_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int16_relaxed(_:_:)
  public func bitwiseOrThenLoad_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int16_acquiring(_:_:)
  public func bitwiseOrThenLoad_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int16_releasing(_:_:)
  public func bitwiseOrThenLoad_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int16_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int16_sequential(_:_:)
  public func bitwiseOrThenLoad_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int16_relaxed(_:_:)
  public func bitwiseXorThenLoad_Int16_relaxed(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int16_acquiring(_:_:)
  public func bitwiseXorThenLoad_Int16_acquiring(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int16_releasing(_:_:)
  public func bitwiseXorThenLoad_Int16_releasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int16_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_Int16_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int16_sequential(_:_:)
  public func bitwiseXorThenLoad_Int16_sequential(
    _ value: UnsafeAtomic<Int16>,
    _ operand: Int16
  ) -> Int16 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int8_relaxed(_:_:)
  public func loadThenWrappingIncrement_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int8_acquiring(_:_:)
  public func loadThenWrappingIncrement_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int8_releasing(_:_:)
  public func loadThenWrappingIncrement_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int8_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_Int8_sequential(_:_:)
  public func loadThenWrappingIncrement_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int8_relaxed(_:_:)
  public func loadThenWrappingDecrement_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int8_acquiring(_:_:)
  public func loadThenWrappingDecrement_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int8_releasing(_:_:)
  public func loadThenWrappingDecrement_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int8_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_Int8_sequential(_:_:)
  public func loadThenWrappingDecrement_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int8_relaxed(_:_:)
  public func loadThenBitwiseAnd_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int8_acquiring(_:_:)
  public func loadThenBitwiseAnd_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int8_releasing(_:_:)
  public func loadThenBitwiseAnd_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_Int8_sequential(_:_:)
  public func loadThenBitwiseAnd_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int8_relaxed(_:_:)
  public func loadThenBitwiseOr_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int8_acquiring(_:_:)
  public func loadThenBitwiseOr_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int8_releasing(_:_:)
  public func loadThenBitwiseOr_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_Int8_sequential(_:_:)
  public func loadThenBitwiseOr_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int8_relaxed(_:_:)
  public func loadThenBitwiseXor_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int8_acquiring(_:_:)
  public func loadThenBitwiseXor_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int8_releasing(_:_:)
  public func loadThenBitwiseXor_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_Int8_sequential(_:_:)
  public func loadThenBitwiseXor_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int8_relaxed(_:_:)
  public func wrappingIncrementThenLoad_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int8_acquiring(_:_:)
  public func wrappingIncrementThenLoad_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int8_releasing(_:_:)
  public func wrappingIncrementThenLoad_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int8_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_Int8_sequential(_:_:)
  public func wrappingIncrementThenLoad_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int8_relaxed(_:_:)
  public func wrappingDecrementThenLoad_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int8_acquiring(_:_:)
  public func wrappingDecrementThenLoad_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int8_releasing(_:_:)
  public func wrappingDecrementThenLoad_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int8_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_Int8_sequential(_:_:)
  public func wrappingDecrementThenLoad_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int8_relaxed(_:_:)
  public func bitwiseAndThenLoad_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int8_acquiring(_:_:)
  public func bitwiseAndThenLoad_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int8_releasing(_:_:)
  public func bitwiseAndThenLoad_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int8_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_Int8_sequential(_:_:)
  public func bitwiseAndThenLoad_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int8_relaxed(_:_:)
  public func bitwiseOrThenLoad_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int8_acquiring(_:_:)
  public func bitwiseOrThenLoad_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int8_releasing(_:_:)
  public func bitwiseOrThenLoad_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int8_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_Int8_sequential(_:_:)
  public func bitwiseOrThenLoad_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int8_relaxed(_:_:)
  public func bitwiseXorThenLoad_Int8_relaxed(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int8_acquiring(_:_:)
  public func bitwiseXorThenLoad_Int8_acquiring(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int8_releasing(_:_:)
  public func bitwiseXorThenLoad_Int8_releasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int8_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_Int8_acquiringAndReleasing(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_Int8_sequential(_:_:)
  public func bitwiseXorThenLoad_Int8_sequential(
    _ value: UnsafeAtomic<Int8>,
    _ operand: Int8
  ) -> Int8 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt_relaxed(_:_:)
  public func loadThenWrappingIncrement_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt_acquiring(_:_:)
  public func loadThenWrappingIncrement_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt_releasing(_:_:)
  public func loadThenWrappingIncrement_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt_sequential(_:_:)
  public func loadThenWrappingIncrement_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt_relaxed(_:_:)
  public func loadThenWrappingDecrement_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt_acquiring(_:_:)
  public func loadThenWrappingDecrement_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt_releasing(_:_:)
  public func loadThenWrappingDecrement_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt_sequential(_:_:)
  public func loadThenWrappingDecrement_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt_relaxed(_:_:)
  public func loadThenBitwiseAnd_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt_acquiring(_:_:)
  public func loadThenBitwiseAnd_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt_releasing(_:_:)
  public func loadThenBitwiseAnd_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt_sequential(_:_:)
  public func loadThenBitwiseAnd_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt_relaxed(_:_:)
  public func loadThenBitwiseOr_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt_acquiring(_:_:)
  public func loadThenBitwiseOr_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt_releasing(_:_:)
  public func loadThenBitwiseOr_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt_sequential(_:_:)
  public func loadThenBitwiseOr_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt_relaxed(_:_:)
  public func loadThenBitwiseXor_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt_acquiring(_:_:)
  public func loadThenBitwiseXor_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt_releasing(_:_:)
  public func loadThenBitwiseXor_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt_sequential(_:_:)
  public func loadThenBitwiseXor_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt_relaxed(_:_:)
  public func wrappingIncrementThenLoad_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt_acquiring(_:_:)
  public func wrappingIncrementThenLoad_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt_releasing(_:_:)
  public func wrappingIncrementThenLoad_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Word"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt_sequential(_:_:)
  public func wrappingIncrementThenLoad_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_add_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Word"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt_relaxed(_:_:)
  public func wrappingDecrementThenLoad_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt_acquiring(_:_:)
  public func wrappingDecrementThenLoad_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt_releasing(_:_:)
  public func wrappingDecrementThenLoad_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Word"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt_sequential(_:_:)
  public func wrappingDecrementThenLoad_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_sub_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Word"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt_relaxed(_:_:)
  public func bitwiseAndThenLoad_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt_acquiring(_:_:)
  public func bitwiseAndThenLoad_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt_releasing(_:_:)
  public func bitwiseAndThenLoad_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Word"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt_sequential(_:_:)
  public func bitwiseAndThenLoad_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_and_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Word"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt_relaxed(_:_:)
  public func bitwiseOrThenLoad_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt_acquiring(_:_:)
  public func bitwiseOrThenLoad_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt_releasing(_:_:)
  public func bitwiseOrThenLoad_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Word"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt_sequential(_:_:)
  public func bitwiseOrThenLoad_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_or_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Word"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt_relaxed(_:_:)
  public func bitwiseXorThenLoad_UInt_relaxed(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt_acquiring(_:_:)
  public func bitwiseXorThenLoad_UInt_acquiring(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt_releasing(_:_:)
  public func bitwiseXorThenLoad_UInt_releasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_UInt_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_acqrel_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Word"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt_sequential(_:_:)
  public func bitwiseXorThenLoad_UInt_sequential(
    _ value: UnsafeAtomic<UInt>,
    _ operand: UInt
  ) -> UInt {
    // CHECK: builtin "atomicrmw_xor_seqcst_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Word"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Word"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt64_relaxed(_:_:)
  public func loadThenWrappingIncrement_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt64_acquiring(_:_:)
  public func loadThenWrappingIncrement_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt64_releasing(_:_:)
  public func loadThenWrappingIncrement_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt64_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt64_sequential(_:_:)
  public func loadThenWrappingIncrement_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt64_relaxed(_:_:)
  public func loadThenWrappingDecrement_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt64_acquiring(_:_:)
  public func loadThenWrappingDecrement_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt64_releasing(_:_:)
  public func loadThenWrappingDecrement_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt64_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt64_sequential(_:_:)
  public func loadThenWrappingDecrement_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt64_relaxed(_:_:)
  public func loadThenBitwiseAnd_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt64_acquiring(_:_:)
  public func loadThenBitwiseAnd_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt64_releasing(_:_:)
  public func loadThenBitwiseAnd_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt64_sequential(_:_:)
  public func loadThenBitwiseAnd_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt64_relaxed(_:_:)
  public func loadThenBitwiseOr_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt64_acquiring(_:_:)
  public func loadThenBitwiseOr_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt64_releasing(_:_:)
  public func loadThenBitwiseOr_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt64_sequential(_:_:)
  public func loadThenBitwiseOr_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt64_relaxed(_:_:)
  public func loadThenBitwiseXor_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt64_acquiring(_:_:)
  public func loadThenBitwiseXor_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt64_releasing(_:_:)
  public func loadThenBitwiseXor_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt64_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt64_sequential(_:_:)
  public func loadThenBitwiseXor_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt64_relaxed(_:_:)
  public func wrappingIncrementThenLoad_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt64_acquiring(_:_:)
  public func wrappingIncrementThenLoad_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt64_releasing(_:_:)
  public func wrappingIncrementThenLoad_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt64_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int64"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt64_sequential(_:_:)
  public func wrappingIncrementThenLoad_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int64"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt64_relaxed(_:_:)
  public func wrappingDecrementThenLoad_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt64_acquiring(_:_:)
  public func wrappingDecrementThenLoad_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt64_releasing(_:_:)
  public func wrappingDecrementThenLoad_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt64_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int64"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt64_sequential(_:_:)
  public func wrappingDecrementThenLoad_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int64"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt64_relaxed(_:_:)
  public func bitwiseAndThenLoad_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt64_acquiring(_:_:)
  public func bitwiseAndThenLoad_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt64_releasing(_:_:)
  public func bitwiseAndThenLoad_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt64_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int64"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt64_sequential(_:_:)
  public func bitwiseAndThenLoad_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int64"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt64_relaxed(_:_:)
  public func bitwiseOrThenLoad_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt64_acquiring(_:_:)
  public func bitwiseOrThenLoad_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt64_releasing(_:_:)
  public func bitwiseOrThenLoad_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt64_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int64"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt64_sequential(_:_:)
  public func bitwiseOrThenLoad_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int64"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt64_relaxed(_:_:)
  public func bitwiseXorThenLoad_UInt64_relaxed(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt64_acquiring(_:_:)
  public func bitwiseXorThenLoad_UInt64_acquiring(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt64_releasing(_:_:)
  public func bitwiseXorThenLoad_UInt64_releasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt64_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_UInt64_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int64"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt64_sequential(_:_:)
  public func bitwiseXorThenLoad_UInt64_sequential(
    _ value: UnsafeAtomic<UInt64>,
    _ operand: UInt64
  ) -> UInt64 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int64"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int64"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt32_relaxed(_:_:)
  public func loadThenWrappingIncrement_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt32_acquiring(_:_:)
  public func loadThenWrappingIncrement_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt32_releasing(_:_:)
  public func loadThenWrappingIncrement_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt32_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt32_sequential(_:_:)
  public func loadThenWrappingIncrement_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt32_relaxed(_:_:)
  public func loadThenWrappingDecrement_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt32_acquiring(_:_:)
  public func loadThenWrappingDecrement_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt32_releasing(_:_:)
  public func loadThenWrappingDecrement_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt32_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt32_sequential(_:_:)
  public func loadThenWrappingDecrement_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt32_relaxed(_:_:)
  public func loadThenBitwiseAnd_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt32_acquiring(_:_:)
  public func loadThenBitwiseAnd_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt32_releasing(_:_:)
  public func loadThenBitwiseAnd_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt32_sequential(_:_:)
  public func loadThenBitwiseAnd_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt32_relaxed(_:_:)
  public func loadThenBitwiseOr_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt32_acquiring(_:_:)
  public func loadThenBitwiseOr_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt32_releasing(_:_:)
  public func loadThenBitwiseOr_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt32_sequential(_:_:)
  public func loadThenBitwiseOr_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt32_relaxed(_:_:)
  public func loadThenBitwiseXor_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt32_acquiring(_:_:)
  public func loadThenBitwiseXor_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt32_releasing(_:_:)
  public func loadThenBitwiseXor_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt32_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt32_sequential(_:_:)
  public func loadThenBitwiseXor_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt32_relaxed(_:_:)
  public func wrappingIncrementThenLoad_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt32_acquiring(_:_:)
  public func wrappingIncrementThenLoad_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt32_releasing(_:_:)
  public func wrappingIncrementThenLoad_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt32_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int32"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt32_sequential(_:_:)
  public func wrappingIncrementThenLoad_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int32"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt32_relaxed(_:_:)
  public func wrappingDecrementThenLoad_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt32_acquiring(_:_:)
  public func wrappingDecrementThenLoad_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt32_releasing(_:_:)
  public func wrappingDecrementThenLoad_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt32_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int32"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt32_sequential(_:_:)
  public func wrappingDecrementThenLoad_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int32"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt32_relaxed(_:_:)
  public func bitwiseAndThenLoad_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt32_acquiring(_:_:)
  public func bitwiseAndThenLoad_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt32_releasing(_:_:)
  public func bitwiseAndThenLoad_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt32_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int32"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt32_sequential(_:_:)
  public func bitwiseAndThenLoad_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int32"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt32_relaxed(_:_:)
  public func bitwiseOrThenLoad_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt32_acquiring(_:_:)
  public func bitwiseOrThenLoad_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt32_releasing(_:_:)
  public func bitwiseOrThenLoad_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt32_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int32"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt32_sequential(_:_:)
  public func bitwiseOrThenLoad_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int32"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt32_relaxed(_:_:)
  public func bitwiseXorThenLoad_UInt32_relaxed(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt32_acquiring(_:_:)
  public func bitwiseXorThenLoad_UInt32_acquiring(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt32_releasing(_:_:)
  public func bitwiseXorThenLoad_UInt32_releasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt32_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_UInt32_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int32"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt32_sequential(_:_:)
  public func bitwiseXorThenLoad_UInt32_sequential(
    _ value: UnsafeAtomic<UInt32>,
    _ operand: UInt32
  ) -> UInt32 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int32"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int32"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt16_relaxed(_:_:)
  public func loadThenWrappingIncrement_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt16_acquiring(_:_:)
  public func loadThenWrappingIncrement_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt16_releasing(_:_:)
  public func loadThenWrappingIncrement_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt16_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt16_sequential(_:_:)
  public func loadThenWrappingIncrement_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt16_relaxed(_:_:)
  public func loadThenWrappingDecrement_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt16_acquiring(_:_:)
  public func loadThenWrappingDecrement_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt16_releasing(_:_:)
  public func loadThenWrappingDecrement_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt16_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt16_sequential(_:_:)
  public func loadThenWrappingDecrement_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt16_relaxed(_:_:)
  public func loadThenBitwiseAnd_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt16_acquiring(_:_:)
  public func loadThenBitwiseAnd_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt16_releasing(_:_:)
  public func loadThenBitwiseAnd_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt16_sequential(_:_:)
  public func loadThenBitwiseAnd_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt16_relaxed(_:_:)
  public func loadThenBitwiseOr_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt16_acquiring(_:_:)
  public func loadThenBitwiseOr_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt16_releasing(_:_:)
  public func loadThenBitwiseOr_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt16_sequential(_:_:)
  public func loadThenBitwiseOr_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt16_relaxed(_:_:)
  public func loadThenBitwiseXor_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt16_acquiring(_:_:)
  public func loadThenBitwiseXor_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt16_releasing(_:_:)
  public func loadThenBitwiseXor_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt16_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt16_sequential(_:_:)
  public func loadThenBitwiseXor_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt16_relaxed(_:_:)
  public func wrappingIncrementThenLoad_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt16_acquiring(_:_:)
  public func wrappingIncrementThenLoad_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt16_releasing(_:_:)
  public func wrappingIncrementThenLoad_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt16_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int16"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt16_sequential(_:_:)
  public func wrappingIncrementThenLoad_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int16"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt16_relaxed(_:_:)
  public func wrappingDecrementThenLoad_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt16_acquiring(_:_:)
  public func wrappingDecrementThenLoad_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt16_releasing(_:_:)
  public func wrappingDecrementThenLoad_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt16_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int16"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt16_sequential(_:_:)
  public func wrappingDecrementThenLoad_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int16"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt16_relaxed(_:_:)
  public func bitwiseAndThenLoad_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt16_acquiring(_:_:)
  public func bitwiseAndThenLoad_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt16_releasing(_:_:)
  public func bitwiseAndThenLoad_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt16_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int16"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt16_sequential(_:_:)
  public func bitwiseAndThenLoad_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int16"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt16_relaxed(_:_:)
  public func bitwiseOrThenLoad_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt16_acquiring(_:_:)
  public func bitwiseOrThenLoad_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt16_releasing(_:_:)
  public func bitwiseOrThenLoad_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt16_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int16"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt16_sequential(_:_:)
  public func bitwiseOrThenLoad_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int16"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt16_relaxed(_:_:)
  public func bitwiseXorThenLoad_UInt16_relaxed(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt16_acquiring(_:_:)
  public func bitwiseXorThenLoad_UInt16_acquiring(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt16_releasing(_:_:)
  public func bitwiseXorThenLoad_UInt16_releasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt16_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_UInt16_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int16"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt16_sequential(_:_:)
  public func bitwiseXorThenLoad_UInt16_sequential(
    _ value: UnsafeAtomic<UInt16>,
    _ operand: UInt16
  ) -> UInt16 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int16"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int16"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt8_relaxed(_:_:)
  public func loadThenWrappingIncrement_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt8_acquiring(_:_:)
  public func loadThenWrappingIncrement_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt8_releasing(_:_:)
  public func loadThenWrappingIncrement_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt8_acquiringAndReleasing(_:_:)
  public func loadThenWrappingIncrement_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingIncrement_UInt8_sequential(_:_:)
  public func loadThenWrappingIncrement_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    return value.loadThenWrappingIncrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt8_relaxed(_:_:)
  public func loadThenWrappingDecrement_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt8_acquiring(_:_:)
  public func loadThenWrappingDecrement_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt8_releasing(_:_:)
  public func loadThenWrappingDecrement_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt8_acquiringAndReleasing(_:_:)
  public func loadThenWrappingDecrement_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenWrappingDecrement_UInt8_sequential(_:_:)
  public func loadThenWrappingDecrement_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    return value.loadThenWrappingDecrement(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt8_relaxed(_:_:)
  public func loadThenBitwiseAnd_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt8_acquiring(_:_:)
  public func loadThenBitwiseAnd_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt8_releasing(_:_:)
  public func loadThenBitwiseAnd_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseAnd_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseAnd_UInt8_sequential(_:_:)
  public func loadThenBitwiseAnd_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    return value.loadThenBitwiseAnd(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt8_relaxed(_:_:)
  public func loadThenBitwiseOr_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt8_acquiring(_:_:)
  public func loadThenBitwiseOr_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt8_releasing(_:_:)
  public func loadThenBitwiseOr_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseOr_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseOr_UInt8_sequential(_:_:)
  public func loadThenBitwiseOr_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    return value.loadThenBitwiseOr(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt8_relaxed(_:_:)
  public func loadThenBitwiseXor_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt8_acquiring(_:_:)
  public func loadThenBitwiseXor_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt8_releasing(_:_:)
  public func loadThenBitwiseXor_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt8_acquiringAndReleasing(_:_:)
  public func loadThenBitwiseXor_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.loadThenBitwiseXor_UInt8_sequential(_:_:)
  public func loadThenBitwiseXor_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    return value.loadThenBitwiseXor(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt8_relaxed(_:_:)
  public func wrappingIncrementThenLoad_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt8_acquiring(_:_:)
  public func wrappingIncrementThenLoad_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt8_releasing(_:_:)
  public func wrappingIncrementThenLoad_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt8_acquiringAndReleasing(_:_:)
  public func wrappingIncrementThenLoad_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_seqcst_Int8"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingIncrementThenLoad_UInt8_sequential(_:_:)
  public func wrappingIncrementThenLoad_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_add_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_add_acqrel_Int8"
    return value.wrappingIncrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt8_relaxed(_:_:)
  public func wrappingDecrementThenLoad_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt8_acquiring(_:_:)
  public func wrappingDecrementThenLoad_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt8_releasing(_:_:)
  public func wrappingDecrementThenLoad_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(by: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt8_acquiringAndReleasing(_:_:)
  public func wrappingDecrementThenLoad_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_seqcst_Int8"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.wrappingDecrementThenLoad_UInt8_sequential(_:_:)
  public func wrappingDecrementThenLoad_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_sub_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_sub_acqrel_Int8"
    return value.wrappingDecrementThenLoad(
      by: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt8_relaxed(_:_:)
  public func bitwiseAndThenLoad_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt8_acquiring(_:_:)
  public func bitwiseAndThenLoad_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt8_releasing(_:_:)
  public func bitwiseAndThenLoad_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt8_acquiringAndReleasing(_:_:)
  public func bitwiseAndThenLoad_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_seqcst_Int8"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseAndThenLoad_UInt8_sequential(_:_:)
  public func bitwiseAndThenLoad_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_and_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_and_acqrel_Int8"
    return value.bitwiseAndThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt8_relaxed(_:_:)
  public func bitwiseOrThenLoad_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt8_acquiring(_:_:)
  public func bitwiseOrThenLoad_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt8_releasing(_:_:)
  public func bitwiseOrThenLoad_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt8_acquiringAndReleasing(_:_:)
  public func bitwiseOrThenLoad_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_seqcst_Int8"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseOrThenLoad_UInt8_sequential(_:_:)
  public func bitwiseOrThenLoad_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_or_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_or_acqrel_Int8"
    return value.bitwiseOrThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt8_relaxed(_:_:)
  public func bitwiseXorThenLoad_UInt8_relaxed(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .relaxed)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt8_acquiring(_:_:)
  public func bitwiseXorThenLoad_UInt8_acquiring(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .acquiring)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt8_releasing(_:_:)
  public func bitwiseXorThenLoad_UInt8_releasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(with: operand, ordering: .releasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt8_acquiringAndReleasing(_:_:)
  public func bitwiseXorThenLoad_UInt8_acquiringAndReleasing(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_acqrel_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_seqcst_Int8"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .acquiringAndReleasing)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // SECTIONING-LABEL: // AtomicFoldingTests.bitwiseXorThenLoad_UInt8_sequential(_:_:)
  public func bitwiseXorThenLoad_UInt8_sequential(
    _ value: UnsafeAtomic<UInt8>,
    _ operand: UInt8
  ) -> UInt8 {
    // CHECK: builtin "atomicrmw_xor_seqcst_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_monotonic_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acquire_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_release_Int8"
    // EXCLUSIONS-NOT: builtin "atomicrmw_xor_acqrel_Int8"
    return value.bitwiseXorThenLoad(
      with: operand,
      ordering: .sequentiallyConsistent)
  }
  // SECTIONING-LABEL: } // end sil function '$s14AtomicsFolding

  // ---------------------------------------------------------------------------
}
