//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import XCTest
import Atomics

/// Exercises all operations in a single-threaded context, verifying
/// they provide the expected results.
class BasicAtomicUInt32Tests: XCTestCase {

  func test_create_destroy() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), 23)
  }

  func test_load_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), 23)
  }

  func test_load_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .acquiring), 12)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .acquiring), 23)
  }

  func test_load_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .sequentiallyConsistent), 12)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .sequentiallyConsistent), 23)
  }


  func test_store_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    v.store(23, ordering: .relaxed)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    w.store(12, ordering: .relaxed)
    XCTAssertEqual(w.load(ordering: .relaxed), 12)
  }

  func test_store_releasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    v.store(23, ordering: .releasing)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    w.store(12, ordering: .releasing)
    XCTAssertEqual(w.load(ordering: .relaxed), 12)
  }

  func test_store_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }
    v.store(23, ordering: .sequentiallyConsistent)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    let w: UnsafeAtomic<UInt32> = .create(23)
    defer { w.destroy() }
    w.store(12, ordering: .sequentiallyConsistent)
    XCTAssertEqual(w.load(ordering: .relaxed), 12)
  }


  func test_exchange_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(12, ordering: .relaxed), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    XCTAssertEqual(v.exchange(23, ordering: .relaxed), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    XCTAssertEqual(v.exchange(23, ordering: .relaxed), 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)
  }

  func test_exchange_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(12, ordering: .acquiring), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    XCTAssertEqual(v.exchange(23, ordering: .acquiring), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    XCTAssertEqual(v.exchange(23, ordering: .acquiring), 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)
  }

  func test_exchange_releasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(12, ordering: .releasing), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    XCTAssertEqual(v.exchange(23, ordering: .releasing), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    XCTAssertEqual(v.exchange(23, ordering: .releasing), 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)
  }

  func test_exchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(12, ordering: .acquiringAndReleasing), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    XCTAssertEqual(v.exchange(23, ordering: .acquiringAndReleasing), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    XCTAssertEqual(v.exchange(23, ordering: .acquiringAndReleasing), 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)
  }

  func test_exchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(12, ordering: .sequentiallyConsistent), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    XCTAssertEqual(v.exchange(23, ordering: .sequentiallyConsistent), 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    XCTAssertEqual(v.exchange(23, ordering: .sequentiallyConsistent), 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)
  }


  func test_compareExchange_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_releasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }


  func test_weakCompareExchange_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_releasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }


  func test_compareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_compareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.compareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }


  func test_weakCompareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }

  func test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<UInt32> = .create(12)
    defer { v.destroy() }

    var (exchanged, original): (Bool, UInt32)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 12,
        desired: 23,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    (exchanged, original) = v.weakCompareExchange(
      expected: 12,
      desired: 23,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 23)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: 23,
        desired: 12,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, 23)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)

    (exchanged, original) = v.weakCompareExchange(
      expected: 23,
      desired: 12,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, 12)
    XCTAssertEqual(v.load(ordering: .relaxed), 12)
  }




// Integer operations
  func test_loadThenWrappingIncrement_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingIncrement(by: b, ordering: .relaxed)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingIncrement(by: c, ordering: .relaxed)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingIncrement_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingIncrement(by: b, ordering: .acquiring)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingIncrement(by: c, ordering: .acquiring)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingIncrement_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingIncrement(by: b, ordering: .releasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingIncrement(by: c, ordering: .releasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingIncrement_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingIncrement(by: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingIncrement(by: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingIncrement_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingIncrement(by: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingIncrement(by: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingDecrement_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingDecrement(by: b, ordering: .relaxed)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingDecrement(by: c, ordering: .relaxed)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingDecrement_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingDecrement(by: b, ordering: .acquiring)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingDecrement(by: c, ordering: .acquiring)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingDecrement_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingDecrement(by: b, ordering: .releasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingDecrement(by: c, ordering: .releasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingDecrement_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingDecrement(by: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingDecrement(by: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenWrappingDecrement_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenWrappingDecrement(by: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenWrappingDecrement(by: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseAnd_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseAnd(with: b, ordering: .relaxed)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseAnd(with: c, ordering: .relaxed)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseAnd_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseAnd(with: b, ordering: .acquiring)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseAnd(with: c, ordering: .acquiring)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseAnd_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseAnd(with: b, ordering: .releasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseAnd(with: c, ordering: .releasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseAnd_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseAnd(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseAnd(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseAnd_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseAnd(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseAnd(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseOr_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseOr(with: b, ordering: .relaxed)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseOr(with: c, ordering: .relaxed)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseOr_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseOr(with: b, ordering: .acquiring)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseOr(with: c, ordering: .acquiring)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseOr_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseOr(with: b, ordering: .releasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseOr(with: c, ordering: .releasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseOr_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseOr(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseOr(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseOr_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseOr(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseOr(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseXor_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseXor(with: b, ordering: .relaxed)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseXor(with: c, ordering: .relaxed)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseXor_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseXor(with: b, ordering: .acquiring)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseXor(with: c, ordering: .acquiring)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseXor_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseXor(with: b, ordering: .releasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseXor(with: c, ordering: .releasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseXor_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseXor(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseXor(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_loadThenBitwiseXor_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let old1: UInt32 = v.loadThenBitwiseXor(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old1, a)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let old2: UInt32 = v.loadThenBitwiseXor(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(old2, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }


  func test_wrappingIncrementThenLoad_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingIncrementThenLoad(by: b, ordering: .relaxed)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingIncrementThenLoad(by: c, ordering: .relaxed)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingIncrementThenLoad_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingIncrementThenLoad(by: b, ordering: .acquiring)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingIncrementThenLoad(by: c, ordering: .acquiring)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingIncrementThenLoad_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingIncrementThenLoad(by: b, ordering: .releasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingIncrementThenLoad(by: c, ordering: .releasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingIncrementThenLoad_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingIncrementThenLoad(by: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingIncrementThenLoad(by: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingIncrementThenLoad_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &+ b
    let result2: UInt32 = result1 &+ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingIncrementThenLoad(by: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingIncrementThenLoad(by: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingDecrementThenLoad_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingDecrementThenLoad(by: b, ordering: .relaxed)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingDecrementThenLoad(by: c, ordering: .relaxed)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingDecrementThenLoad_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingDecrementThenLoad(by: b, ordering: .acquiring)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingDecrementThenLoad(by: c, ordering: .acquiring)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingDecrementThenLoad_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingDecrementThenLoad(by: b, ordering: .releasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingDecrementThenLoad(by: c, ordering: .releasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingDecrementThenLoad_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingDecrementThenLoad(by: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingDecrementThenLoad(by: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_wrappingDecrementThenLoad_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a &- b
    let result2: UInt32 = result1 &- c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.wrappingDecrementThenLoad(by: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.wrappingDecrementThenLoad(by: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseAndThenLoad_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseAndThenLoad(with: b, ordering: .relaxed)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseAndThenLoad(with: c, ordering: .relaxed)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseAndThenLoad_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseAndThenLoad(with: b, ordering: .acquiring)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseAndThenLoad(with: c, ordering: .acquiring)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseAndThenLoad_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseAndThenLoad(with: b, ordering: .releasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseAndThenLoad(with: c, ordering: .releasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseAndThenLoad_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseAndThenLoad(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseAndThenLoad(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseAndThenLoad_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a & b
    let result2: UInt32 = result1 & c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseAndThenLoad(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseAndThenLoad(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseOrThenLoad_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseOrThenLoad(with: b, ordering: .relaxed)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseOrThenLoad(with: c, ordering: .relaxed)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseOrThenLoad_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseOrThenLoad(with: b, ordering: .acquiring)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseOrThenLoad(with: c, ordering: .acquiring)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseOrThenLoad_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseOrThenLoad(with: b, ordering: .releasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseOrThenLoad(with: c, ordering: .releasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseOrThenLoad_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseOrThenLoad(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseOrThenLoad(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseOrThenLoad_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a | b
    let result2: UInt32 = result1 | c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseOrThenLoad(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseOrThenLoad(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseXorThenLoad_relaxed() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseXorThenLoad(with: b, ordering: .relaxed)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseXorThenLoad(with: c, ordering: .relaxed)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseXorThenLoad_acquiring() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseXorThenLoad(with: b, ordering: .acquiring)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseXorThenLoad(with: c, ordering: .acquiring)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseXorThenLoad_releasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseXorThenLoad(with: b, ordering: .releasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseXorThenLoad(with: c, ordering: .releasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseXorThenLoad_acquiringAndReleasing() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseXorThenLoad(with: b, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseXorThenLoad(with: c, ordering: .acquiringAndReleasing)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }

  func test_bitwiseXorThenLoad_sequentiallyConsistent() {
    let a: UInt32 = 3
    let b: UInt32 = 8
    let c: UInt32 = 12
    let result1: UInt32 = a ^ b
    let result2: UInt32 = result1 ^ c

    let v: UnsafeAtomic<UInt32> = .create(a)
    defer { v.destroy() }

    let new1: UInt32 = v.bitwiseXorThenLoad(with: b, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new1, result1)
    XCTAssertEqual(v.load(ordering: .relaxed), result1)

    let new2: UInt32 = v.bitwiseXorThenLoad(with: c, ordering: .sequentiallyConsistent)
    XCTAssertEqual(new2, result2)
    XCTAssertEqual(v.load(ordering: .relaxed), result2)
  }


#if MANUAL_TEST_DISCOVERY
  public static var allTests: [(String, (BasicAtomicUInt32Tests) -> () -> ())] = [
    ("test_create_destroy", test_create_destroy),
    ("test_load_relaxed", test_load_relaxed),
    ("test_load_acquiring", test_load_acquiring),
    ("test_load_sequentiallyConsistent", test_load_sequentiallyConsistent),
    ("test_store_relaxed", test_store_relaxed),
    ("test_store_releasing", test_store_releasing),
    ("test_store_sequentiallyConsistent", test_store_sequentiallyConsistent),
    ("test_exchange_relaxed", test_exchange_relaxed),
    ("test_exchange_acquiring", test_exchange_acquiring),
    ("test_exchange_releasing", test_exchange_releasing),
    ("test_exchange_acquiringAndReleasing", test_exchange_acquiringAndReleasing),
    ("test_exchange_sequentiallyConsistent", test_exchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed", test_compareExchange_relaxed),
    ("test_compareExchange_acquiring", test_compareExchange_acquiring),
    ("test_compareExchange_releasing", test_compareExchange_releasing),
    ("test_compareExchange_acquiringAndReleasing", test_compareExchange_acquiringAndReleasing),
    ("test_compareExchange_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed_relaxed", test_compareExchange_relaxed_relaxed),
    ("test_compareExchange_relaxed_acquiring", test_compareExchange_relaxed_acquiring),
    ("test_compareExchange_relaxed_sequentiallyConsistent", test_compareExchange_relaxed_sequentiallyConsistent),
    ("test_compareExchange_acquiring_relaxed", test_compareExchange_acquiring_relaxed),
    ("test_compareExchange_acquiring_acquiring", test_compareExchange_acquiring_acquiring),
    ("test_compareExchange_acquiring_sequentiallyConsistent", test_compareExchange_acquiring_sequentiallyConsistent),
    ("test_compareExchange_releasing_relaxed", test_compareExchange_releasing_relaxed),
    ("test_compareExchange_releasing_acquiring", test_compareExchange_releasing_acquiring),
    ("test_compareExchange_releasing_sequentiallyConsistent", test_compareExchange_releasing_sequentiallyConsistent),
    ("test_compareExchange_acquiringAndReleasing_relaxed", test_compareExchange_acquiringAndReleasing_relaxed),
    ("test_compareExchange_acquiringAndReleasing_acquiring", test_compareExchange_acquiringAndReleasing_acquiring),
    ("test_compareExchange_acquiringAndReleasing_sequentiallyConsistent", test_compareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_compareExchange_sequentiallyConsistent_relaxed", test_compareExchange_sequentiallyConsistent_relaxed),
    ("test_compareExchange_sequentiallyConsistent_acquiring", test_compareExchange_sequentiallyConsistent_acquiring),
    ("test_compareExchange_sequentiallyConsistent_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_weakCompareExchange_relaxed_relaxed", test_weakCompareExchange_relaxed_relaxed),
    ("test_weakCompareExchange_relaxed_acquiring", test_weakCompareExchange_relaxed_acquiring),
    ("test_weakCompareExchange_relaxed_sequentiallyConsistent", test_weakCompareExchange_relaxed_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiring_relaxed", test_weakCompareExchange_acquiring_relaxed),
    ("test_weakCompareExchange_acquiring_acquiring", test_weakCompareExchange_acquiring_acquiring),
    ("test_weakCompareExchange_acquiring_sequentiallyConsistent", test_weakCompareExchange_acquiring_sequentiallyConsistent),
    ("test_weakCompareExchange_releasing_relaxed", test_weakCompareExchange_releasing_relaxed),
    ("test_weakCompareExchange_releasing_acquiring", test_weakCompareExchange_releasing_acquiring),
    ("test_weakCompareExchange_releasing_sequentiallyConsistent", test_weakCompareExchange_releasing_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiringAndReleasing_relaxed", test_weakCompareExchange_acquiringAndReleasing_relaxed),
    ("test_weakCompareExchange_acquiringAndReleasing_acquiring", test_weakCompareExchange_acquiringAndReleasing_acquiring),
    ("test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent", test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_weakCompareExchange_sequentiallyConsistent_relaxed", test_weakCompareExchange_sequentiallyConsistent_relaxed),
    ("test_weakCompareExchange_sequentiallyConsistent_acquiring", test_weakCompareExchange_sequentiallyConsistent_acquiring),
    ("test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent", test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_loadThenWrappingIncrement_relaxed", test_loadThenWrappingIncrement_relaxed),
    ("test_loadThenWrappingIncrement_acquiring", test_loadThenWrappingIncrement_acquiring),
    ("test_loadThenWrappingIncrement_releasing", test_loadThenWrappingIncrement_releasing),
    ("test_loadThenWrappingIncrement_acquiringAndReleasing", test_loadThenWrappingIncrement_acquiringAndReleasing),
    ("test_loadThenWrappingIncrement_sequentiallyConsistent", test_loadThenWrappingIncrement_sequentiallyConsistent),
    ("test_loadThenWrappingDecrement_relaxed", test_loadThenWrappingDecrement_relaxed),
    ("test_loadThenWrappingDecrement_acquiring", test_loadThenWrappingDecrement_acquiring),
    ("test_loadThenWrappingDecrement_releasing", test_loadThenWrappingDecrement_releasing),
    ("test_loadThenWrappingDecrement_acquiringAndReleasing", test_loadThenWrappingDecrement_acquiringAndReleasing),
    ("test_loadThenWrappingDecrement_sequentiallyConsistent", test_loadThenWrappingDecrement_sequentiallyConsistent),
    ("test_loadThenBitwiseAnd_relaxed", test_loadThenBitwiseAnd_relaxed),
    ("test_loadThenBitwiseAnd_acquiring", test_loadThenBitwiseAnd_acquiring),
    ("test_loadThenBitwiseAnd_releasing", test_loadThenBitwiseAnd_releasing),
    ("test_loadThenBitwiseAnd_acquiringAndReleasing", test_loadThenBitwiseAnd_acquiringAndReleasing),
    ("test_loadThenBitwiseAnd_sequentiallyConsistent", test_loadThenBitwiseAnd_sequentiallyConsistent),
    ("test_loadThenBitwiseOr_relaxed", test_loadThenBitwiseOr_relaxed),
    ("test_loadThenBitwiseOr_acquiring", test_loadThenBitwiseOr_acquiring),
    ("test_loadThenBitwiseOr_releasing", test_loadThenBitwiseOr_releasing),
    ("test_loadThenBitwiseOr_acquiringAndReleasing", test_loadThenBitwiseOr_acquiringAndReleasing),
    ("test_loadThenBitwiseOr_sequentiallyConsistent", test_loadThenBitwiseOr_sequentiallyConsistent),
    ("test_loadThenBitwiseXor_relaxed", test_loadThenBitwiseXor_relaxed),
    ("test_loadThenBitwiseXor_acquiring", test_loadThenBitwiseXor_acquiring),
    ("test_loadThenBitwiseXor_releasing", test_loadThenBitwiseXor_releasing),
    ("test_loadThenBitwiseXor_acquiringAndReleasing", test_loadThenBitwiseXor_acquiringAndReleasing),
    ("test_loadThenBitwiseXor_sequentiallyConsistent", test_loadThenBitwiseXor_sequentiallyConsistent),
    ("test_wrappingIncrementThenLoad_relaxed", test_wrappingIncrementThenLoad_relaxed),
    ("test_wrappingIncrementThenLoad_acquiring", test_wrappingIncrementThenLoad_acquiring),
    ("test_wrappingIncrementThenLoad_releasing", test_wrappingIncrementThenLoad_releasing),
    ("test_wrappingIncrementThenLoad_acquiringAndReleasing", test_wrappingIncrementThenLoad_acquiringAndReleasing),
    ("test_wrappingIncrementThenLoad_sequentiallyConsistent", test_wrappingIncrementThenLoad_sequentiallyConsistent),
    ("test_wrappingDecrementThenLoad_relaxed", test_wrappingDecrementThenLoad_relaxed),
    ("test_wrappingDecrementThenLoad_acquiring", test_wrappingDecrementThenLoad_acquiring),
    ("test_wrappingDecrementThenLoad_releasing", test_wrappingDecrementThenLoad_releasing),
    ("test_wrappingDecrementThenLoad_acquiringAndReleasing", test_wrappingDecrementThenLoad_acquiringAndReleasing),
    ("test_wrappingDecrementThenLoad_sequentiallyConsistent", test_wrappingDecrementThenLoad_sequentiallyConsistent),
    ("test_bitwiseAndThenLoad_relaxed", test_bitwiseAndThenLoad_relaxed),
    ("test_bitwiseAndThenLoad_acquiring", test_bitwiseAndThenLoad_acquiring),
    ("test_bitwiseAndThenLoad_releasing", test_bitwiseAndThenLoad_releasing),
    ("test_bitwiseAndThenLoad_acquiringAndReleasing", test_bitwiseAndThenLoad_acquiringAndReleasing),
    ("test_bitwiseAndThenLoad_sequentiallyConsistent", test_bitwiseAndThenLoad_sequentiallyConsistent),
    ("test_bitwiseOrThenLoad_relaxed", test_bitwiseOrThenLoad_relaxed),
    ("test_bitwiseOrThenLoad_acquiring", test_bitwiseOrThenLoad_acquiring),
    ("test_bitwiseOrThenLoad_releasing", test_bitwiseOrThenLoad_releasing),
    ("test_bitwiseOrThenLoad_acquiringAndReleasing", test_bitwiseOrThenLoad_acquiringAndReleasing),
    ("test_bitwiseOrThenLoad_sequentiallyConsistent", test_bitwiseOrThenLoad_sequentiallyConsistent),
    ("test_bitwiseXorThenLoad_relaxed", test_bitwiseXorThenLoad_relaxed),
    ("test_bitwiseXorThenLoad_acquiring", test_bitwiseXorThenLoad_acquiring),
    ("test_bitwiseXorThenLoad_releasing", test_bitwiseXorThenLoad_releasing),
    ("test_bitwiseXorThenLoad_acquiringAndReleasing", test_bitwiseXorThenLoad_acquiringAndReleasing),
    ("test_bitwiseXorThenLoad_sequentiallyConsistent", test_bitwiseXorThenLoad_sequentiallyConsistent),
  ]
#endif
}

