//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import XCTest
import Atomics

/// Exercises all operations in a single-threaded context, verifying
/// they provide the expected results.
class BasicAtomicOptionalRawRepresentableTests: XCTestCase {

  func test_create_destroy() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), nil)
  }

  func test_load_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), nil)
  }

  func test_load_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .acquiring), Hyacinth.bucket)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .acquiring), nil)
  }

  func test_load_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .sequentiallyConsistent), Hyacinth.bucket)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .sequentiallyConsistent), nil)
  }


  func test_store_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    v.store(nil, ordering: .relaxed)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    w.store(Hyacinth.bucket, ordering: .relaxed)
    XCTAssertEqual(w.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_store_releasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    v.store(nil, ordering: .releasing)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    w.store(Hyacinth.bucket, ordering: .releasing)
    XCTAssertEqual(w.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_store_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }
    v.store(nil, ordering: .sequentiallyConsistent)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    let w: UnsafeAtomic<Hyacinth?> = .create(nil)
    defer { w.destroy() }
    w.store(Hyacinth.bucket, ordering: .sequentiallyConsistent)
    XCTAssertEqual(w.load(ordering: .relaxed), Hyacinth.bucket)
  }


  func test_exchange_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(Hyacinth.bucket, ordering: .relaxed), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    XCTAssertEqual(v.exchange(nil, ordering: .relaxed), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    XCTAssertEqual(v.exchange(nil, ordering: .relaxed), nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)
  }

  func test_exchange_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(Hyacinth.bucket, ordering: .acquiring), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    XCTAssertEqual(v.exchange(nil, ordering: .acquiring), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    XCTAssertEqual(v.exchange(nil, ordering: .acquiring), nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)
  }

  func test_exchange_releasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(Hyacinth.bucket, ordering: .releasing), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    XCTAssertEqual(v.exchange(nil, ordering: .releasing), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    XCTAssertEqual(v.exchange(nil, ordering: .releasing), nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)
  }

  func test_exchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(Hyacinth.bucket, ordering: .acquiringAndReleasing), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    XCTAssertEqual(v.exchange(nil, ordering: .acquiringAndReleasing), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    XCTAssertEqual(v.exchange(nil, ordering: .acquiringAndReleasing), nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)
  }

  func test_exchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(Hyacinth.bucket, ordering: .sequentiallyConsistent), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    XCTAssertEqual(v.exchange(nil, ordering: .sequentiallyConsistent), Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    XCTAssertEqual(v.exchange(nil, ordering: .sequentiallyConsistent), nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)
  }


  func test_compareExchange_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_releasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }


  func test_weakCompareExchange_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_releasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }


  func test_compareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_compareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.compareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }


  func test_weakCompareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }

  func test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<Hyacinth?> = .create(Hyacinth.bucket)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Hyacinth?)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: Hyacinth.bucket,
        desired: nil,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    (exchanged, original) = v.weakCompareExchange(
      expected: Hyacinth.bucket,
      desired: nil,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), nil)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: nil,
        desired: Hyacinth.bucket,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, nil)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)

    (exchanged, original) = v.weakCompareExchange(
      expected: nil,
      desired: Hyacinth.bucket,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, Hyacinth.bucket)
    XCTAssertEqual(v.load(ordering: .relaxed), Hyacinth.bucket)
  }





#if MANUAL_TEST_DISCOVERY
  public static var allTests: [(String, (BasicAtomicOptionalRawRepresentableTests) -> () -> ())] = [
    ("test_create_destroy", test_create_destroy),
    ("test_load_relaxed", test_load_relaxed),
    ("test_load_acquiring", test_load_acquiring),
    ("test_load_sequentiallyConsistent", test_load_sequentiallyConsistent),
    ("test_store_relaxed", test_store_relaxed),
    ("test_store_releasing", test_store_releasing),
    ("test_store_sequentiallyConsistent", test_store_sequentiallyConsistent),
    ("test_exchange_relaxed", test_exchange_relaxed),
    ("test_exchange_acquiring", test_exchange_acquiring),
    ("test_exchange_releasing", test_exchange_releasing),
    ("test_exchange_acquiringAndReleasing", test_exchange_acquiringAndReleasing),
    ("test_exchange_sequentiallyConsistent", test_exchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed", test_compareExchange_relaxed),
    ("test_compareExchange_acquiring", test_compareExchange_acquiring),
    ("test_compareExchange_releasing", test_compareExchange_releasing),
    ("test_compareExchange_acquiringAndReleasing", test_compareExchange_acquiringAndReleasing),
    ("test_compareExchange_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed_relaxed", test_compareExchange_relaxed_relaxed),
    ("test_compareExchange_relaxed_acquiring", test_compareExchange_relaxed_acquiring),
    ("test_compareExchange_relaxed_sequentiallyConsistent", test_compareExchange_relaxed_sequentiallyConsistent),
    ("test_compareExchange_acquiring_relaxed", test_compareExchange_acquiring_relaxed),
    ("test_compareExchange_acquiring_acquiring", test_compareExchange_acquiring_acquiring),
    ("test_compareExchange_acquiring_sequentiallyConsistent", test_compareExchange_acquiring_sequentiallyConsistent),
    ("test_compareExchange_releasing_relaxed", test_compareExchange_releasing_relaxed),
    ("test_compareExchange_releasing_acquiring", test_compareExchange_releasing_acquiring),
    ("test_compareExchange_releasing_sequentiallyConsistent", test_compareExchange_releasing_sequentiallyConsistent),
    ("test_compareExchange_acquiringAndReleasing_relaxed", test_compareExchange_acquiringAndReleasing_relaxed),
    ("test_compareExchange_acquiringAndReleasing_acquiring", test_compareExchange_acquiringAndReleasing_acquiring),
    ("test_compareExchange_acquiringAndReleasing_sequentiallyConsistent", test_compareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_compareExchange_sequentiallyConsistent_relaxed", test_compareExchange_sequentiallyConsistent_relaxed),
    ("test_compareExchange_sequentiallyConsistent_acquiring", test_compareExchange_sequentiallyConsistent_acquiring),
    ("test_compareExchange_sequentiallyConsistent_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_weakCompareExchange_relaxed_relaxed", test_weakCompareExchange_relaxed_relaxed),
    ("test_weakCompareExchange_relaxed_acquiring", test_weakCompareExchange_relaxed_acquiring),
    ("test_weakCompareExchange_relaxed_sequentiallyConsistent", test_weakCompareExchange_relaxed_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiring_relaxed", test_weakCompareExchange_acquiring_relaxed),
    ("test_weakCompareExchange_acquiring_acquiring", test_weakCompareExchange_acquiring_acquiring),
    ("test_weakCompareExchange_acquiring_sequentiallyConsistent", test_weakCompareExchange_acquiring_sequentiallyConsistent),
    ("test_weakCompareExchange_releasing_relaxed", test_weakCompareExchange_releasing_relaxed),
    ("test_weakCompareExchange_releasing_acquiring", test_weakCompareExchange_releasing_acquiring),
    ("test_weakCompareExchange_releasing_sequentiallyConsistent", test_weakCompareExchange_releasing_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiringAndReleasing_relaxed", test_weakCompareExchange_acquiringAndReleasing_relaxed),
    ("test_weakCompareExchange_acquiringAndReleasing_acquiring", test_weakCompareExchange_acquiringAndReleasing_acquiring),
    ("test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent", test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_weakCompareExchange_sequentiallyConsistent_relaxed", test_weakCompareExchange_sequentiallyConsistent_relaxed),
    ("test_weakCompareExchange_sequentiallyConsistent_acquiring", test_weakCompareExchange_sequentiallyConsistent_acquiring),
    ("test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent", test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent),
  ]
#endif
}

