//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import XCTest
import Atomics

/// Exercises all operations in a single-threaded context, verifying
/// they provide the expected results.
class BasicAtomicDoubleWordTests: XCTestCase {

  func test_create_destroy() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_load_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_load_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .acquiring), DoubleWord(first: 100, second: 64))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .acquiring), DoubleWord(first: 50, second: 32))
  }

  func test_load_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .sequentiallyConsistent), DoubleWord(first: 100, second: 64))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .sequentiallyConsistent), DoubleWord(first: 50, second: 32))
  }


  func test_store_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    v.store(DoubleWord(first: 50, second: 32), ordering: .relaxed)
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    w.store(DoubleWord(first: 100, second: 64), ordering: .relaxed)
    XCTAssertEqual(w.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_store_releasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    v.store(DoubleWord(first: 50, second: 32), ordering: .releasing)
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    w.store(DoubleWord(first: 100, second: 64), ordering: .releasing)
    XCTAssertEqual(w.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_store_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }
    v.store(DoubleWord(first: 50, second: 32), ordering: .sequentiallyConsistent)
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    let w: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 50, second: 32))
    defer { w.destroy() }
    w.store(DoubleWord(first: 100, second: 64), ordering: .sequentiallyConsistent)
    XCTAssertEqual(w.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }


  func test_exchange_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(DoubleWord(first: 100, second: 64), ordering: .relaxed), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .relaxed), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .relaxed), DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_exchange_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(DoubleWord(first: 100, second: 64), ordering: .acquiring), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .acquiring), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .acquiring), DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_exchange_releasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(DoubleWord(first: 100, second: 64), ordering: .releasing), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .releasing), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .releasing), DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_exchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(DoubleWord(first: 100, second: 64), ordering: .acquiringAndReleasing), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .acquiringAndReleasing), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .acquiringAndReleasing), DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }

  func test_exchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(DoubleWord(first: 100, second: 64), ordering: .sequentiallyConsistent), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .sequentiallyConsistent), DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    XCTAssertEqual(v.exchange(DoubleWord(first: 50, second: 32), ordering: .sequentiallyConsistent), DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))
  }


  func test_compareExchange_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_releasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }


  func test_weakCompareExchange_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_releasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }


  func test_compareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_compareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.compareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }


  func test_weakCompareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }

  func test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<DoubleWord> = .create(DoubleWord(first: 100, second: 64))
    defer { v.destroy() }

    var (exchanged, original): (Bool, DoubleWord)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 100, second: 64),
        desired: DoubleWord(first: 50, second: 32),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 100, second: 64),
      desired: DoubleWord(first: 50, second: 32),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 50, second: 32))

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: DoubleWord(first: 50, second: 32),
        desired: DoubleWord(first: 100, second: 64),
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, DoubleWord(first: 50, second: 32))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))

    (exchanged, original) = v.weakCompareExchange(
      expected: DoubleWord(first: 50, second: 32),
      desired: DoubleWord(first: 100, second: 64),
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, DoubleWord(first: 100, second: 64))
    XCTAssertEqual(v.load(ordering: .relaxed), DoubleWord(first: 100, second: 64))
  }





#if MANUAL_TEST_DISCOVERY
  public static var allTests: [(String, (BasicAtomicDoubleWordTests) -> () -> ())] = [
    ("test_create_destroy", test_create_destroy),
    ("test_load_relaxed", test_load_relaxed),
    ("test_load_acquiring", test_load_acquiring),
    ("test_load_sequentiallyConsistent", test_load_sequentiallyConsistent),
    ("test_store_relaxed", test_store_relaxed),
    ("test_store_releasing", test_store_releasing),
    ("test_store_sequentiallyConsistent", test_store_sequentiallyConsistent),
    ("test_exchange_relaxed", test_exchange_relaxed),
    ("test_exchange_acquiring", test_exchange_acquiring),
    ("test_exchange_releasing", test_exchange_releasing),
    ("test_exchange_acquiringAndReleasing", test_exchange_acquiringAndReleasing),
    ("test_exchange_sequentiallyConsistent", test_exchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed", test_compareExchange_relaxed),
    ("test_compareExchange_acquiring", test_compareExchange_acquiring),
    ("test_compareExchange_releasing", test_compareExchange_releasing),
    ("test_compareExchange_acquiringAndReleasing", test_compareExchange_acquiringAndReleasing),
    ("test_compareExchange_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed_relaxed", test_compareExchange_relaxed_relaxed),
    ("test_compareExchange_relaxed_acquiring", test_compareExchange_relaxed_acquiring),
    ("test_compareExchange_relaxed_sequentiallyConsistent", test_compareExchange_relaxed_sequentiallyConsistent),
    ("test_compareExchange_acquiring_relaxed", test_compareExchange_acquiring_relaxed),
    ("test_compareExchange_acquiring_acquiring", test_compareExchange_acquiring_acquiring),
    ("test_compareExchange_acquiring_sequentiallyConsistent", test_compareExchange_acquiring_sequentiallyConsistent),
    ("test_compareExchange_releasing_relaxed", test_compareExchange_releasing_relaxed),
    ("test_compareExchange_releasing_acquiring", test_compareExchange_releasing_acquiring),
    ("test_compareExchange_releasing_sequentiallyConsistent", test_compareExchange_releasing_sequentiallyConsistent),
    ("test_compareExchange_acquiringAndReleasing_relaxed", test_compareExchange_acquiringAndReleasing_relaxed),
    ("test_compareExchange_acquiringAndReleasing_acquiring", test_compareExchange_acquiringAndReleasing_acquiring),
    ("test_compareExchange_acquiringAndReleasing_sequentiallyConsistent", test_compareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_compareExchange_sequentiallyConsistent_relaxed", test_compareExchange_sequentiallyConsistent_relaxed),
    ("test_compareExchange_sequentiallyConsistent_acquiring", test_compareExchange_sequentiallyConsistent_acquiring),
    ("test_compareExchange_sequentiallyConsistent_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_weakCompareExchange_relaxed_relaxed", test_weakCompareExchange_relaxed_relaxed),
    ("test_weakCompareExchange_relaxed_acquiring", test_weakCompareExchange_relaxed_acquiring),
    ("test_weakCompareExchange_relaxed_sequentiallyConsistent", test_weakCompareExchange_relaxed_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiring_relaxed", test_weakCompareExchange_acquiring_relaxed),
    ("test_weakCompareExchange_acquiring_acquiring", test_weakCompareExchange_acquiring_acquiring),
    ("test_weakCompareExchange_acquiring_sequentiallyConsistent", test_weakCompareExchange_acquiring_sequentiallyConsistent),
    ("test_weakCompareExchange_releasing_relaxed", test_weakCompareExchange_releasing_relaxed),
    ("test_weakCompareExchange_releasing_acquiring", test_weakCompareExchange_releasing_acquiring),
    ("test_weakCompareExchange_releasing_sequentiallyConsistent", test_weakCompareExchange_releasing_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiringAndReleasing_relaxed", test_weakCompareExchange_acquiringAndReleasing_relaxed),
    ("test_weakCompareExchange_acquiringAndReleasing_acquiring", test_weakCompareExchange_acquiringAndReleasing_acquiring),
    ("test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent", test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_weakCompareExchange_sequentiallyConsistent_relaxed", test_weakCompareExchange_sequentiallyConsistent_relaxed),
    ("test_weakCompareExchange_sequentiallyConsistent_acquiring", test_weakCompareExchange_sequentiallyConsistent_acquiring),
    ("test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent", test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent),
  ]
#endif
}

