//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import XCTest
import Atomics

/// Exercises all operations in a single-threaded context, verifying
/// they provide the expected results.
class BasicAtomicBoolTests: XCTestCase {

  func test_create_destroy() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), false)
  }

  func test_load_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .relaxed), false)
  }

  func test_load_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .acquiring), true)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .acquiring), false)
  }

  func test_load_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    XCTAssertEqual(v.load(ordering: .sequentiallyConsistent), true)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    XCTAssertEqual(w.load(ordering: .sequentiallyConsistent), false)
  }


  func test_store_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    v.store(false, ordering: .relaxed)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    w.store(true, ordering: .relaxed)
    XCTAssertEqual(w.load(ordering: .relaxed), true)
  }

  func test_store_releasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    v.store(false, ordering: .releasing)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    w.store(true, ordering: .releasing)
    XCTAssertEqual(w.load(ordering: .relaxed), true)
  }

  func test_store_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }
    v.store(false, ordering: .sequentiallyConsistent)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    let w: UnsafeAtomic<Bool> = .create(false)
    defer { w.destroy() }
    w.store(true, ordering: .sequentiallyConsistent)
    XCTAssertEqual(w.load(ordering: .relaxed), true)
  }


  func test_exchange_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(true, ordering: .relaxed), true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    XCTAssertEqual(v.exchange(false, ordering: .relaxed), true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    XCTAssertEqual(v.exchange(false, ordering: .relaxed), false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)
  }

  func test_exchange_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(true, ordering: .acquiring), true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    XCTAssertEqual(v.exchange(false, ordering: .acquiring), true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    XCTAssertEqual(v.exchange(false, ordering: .acquiring), false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)
  }

  func test_exchange_releasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(true, ordering: .releasing), true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    XCTAssertEqual(v.exchange(false, ordering: .releasing), true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    XCTAssertEqual(v.exchange(false, ordering: .releasing), false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)
  }

  func test_exchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(true, ordering: .acquiringAndReleasing), true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    XCTAssertEqual(v.exchange(false, ordering: .acquiringAndReleasing), true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    XCTAssertEqual(v.exchange(false, ordering: .acquiringAndReleasing), false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)
  }

  func test_exchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    XCTAssertEqual(v.exchange(true, ordering: .sequentiallyConsistent), true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    XCTAssertEqual(v.exchange(false, ordering: .sequentiallyConsistent), true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    XCTAssertEqual(v.exchange(false, ordering: .sequentiallyConsistent), false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)
  }


  func test_compareExchange_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_releasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .releasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .acquiringAndReleasing)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }


  func test_weakCompareExchange_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        ordering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      ordering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        ordering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      ordering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_releasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        ordering: .releasing)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      ordering: .releasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiringAndReleasing() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        ordering: .acquiringAndReleasing)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      ordering: .acquiringAndReleasing)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        ordering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      ordering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }


  func test_compareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_compareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertTrue(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.compareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }


  func test_weakCompareExchange_relaxed_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .relaxed,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_relaxed_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .relaxed,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_relaxed_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .relaxed,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .relaxed,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiring_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiring,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiring_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiring,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiring_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiring,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiring,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_releasing_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .releasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_releasing_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .releasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_releasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .releasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .releasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiringAndReleasing_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiringAndReleasing_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .acquiringAndReleasing,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .acquiringAndReleasing,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_sequentiallyConsistent_relaxed() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .relaxed)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .relaxed)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_sequentiallyConsistent_acquiring() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .acquiring)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .acquiring)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }

  func test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent() {
    let v: UnsafeAtomic<Bool> = .create(true)
    defer { v.destroy() }

    var (exchanged, original): (Bool, Bool)
    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: true,
        desired: false,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    (exchanged, original) = v.weakCompareExchange(
      expected: true,
      desired: false,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), false)

    repeat {
      (exchanged, original) = v.weakCompareExchange(
        expected: false,
        desired: true,
        successOrdering: .sequentiallyConsistent,
        failureOrdering: .sequentiallyConsistent)
    } while !exchanged
    XCTAssertEqual(original, false)
    XCTAssertEqual(v.load(ordering: .relaxed), true)

    (exchanged, original) = v.weakCompareExchange(
      expected: false,
      desired: true,
      successOrdering: .sequentiallyConsistent,
      failureOrdering: .sequentiallyConsistent)
    XCTAssertFalse(exchanged)
    XCTAssertEqual(original, true)
    XCTAssertEqual(v.load(ordering: .relaxed), true)
  }



  // Bool operations
  func test_loadThenLogicalAnd_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalAnd(with: b, ordering: .relaxed)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalAnd_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalAnd(with: b, ordering: .acquiring)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalAnd_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalAnd(with: b, ordering: .releasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalAnd_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalAnd(with: b, ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalAnd_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalAnd(with: b, ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalOr_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalOr(with: b, ordering: .relaxed)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalOr_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalOr(with: b, ordering: .acquiring)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalOr_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalOr(with: b, ordering: .releasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalOr_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalOr(with: b, ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalOr_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalOr(with: b, ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalXor_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalXor(with: b, ordering: .relaxed)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalXor_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalXor(with: b, ordering: .acquiring)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalXor_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalXor(with: b, ordering: .releasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalXor_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalXor(with: b, ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_loadThenLogicalXor_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.loadThenLogicalXor(with: b, ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }


  func test_logicalAndThenLoad_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalAndThenLoad(
          with: b,
          ordering: .relaxed)
        XCTAssertEqual(r, a && b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalAndThenLoad_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalAndThenLoad(
          with: b,
          ordering: .acquiring)
        XCTAssertEqual(r, a && b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalAndThenLoad_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalAndThenLoad(
          with: b,
          ordering: .releasing)
        XCTAssertEqual(r, a && b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalAndThenLoad_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalAndThenLoad(
          with: b,
          ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a && b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalAndThenLoad_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalAndThenLoad(
          with: b,
          ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a && b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a && b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalOrThenLoad_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalOrThenLoad(
          with: b,
          ordering: .relaxed)
        XCTAssertEqual(r, a || b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalOrThenLoad_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalOrThenLoad(
          with: b,
          ordering: .acquiring)
        XCTAssertEqual(r, a || b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalOrThenLoad_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalOrThenLoad(
          with: b,
          ordering: .releasing)
        XCTAssertEqual(r, a || b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalOrThenLoad_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalOrThenLoad(
          with: b,
          ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a || b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalOrThenLoad_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalOrThenLoad(
          with: b,
          ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a || b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a || b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalXorThenLoad_relaxed() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalXorThenLoad(
          with: b,
          ordering: .relaxed)
        XCTAssertEqual(r, a != b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalXorThenLoad_acquiring() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalXorThenLoad(
          with: b,
          ordering: .acquiring)
        XCTAssertEqual(r, a != b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalXorThenLoad_releasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalXorThenLoad(
          with: b,
          ordering: .releasing)
        XCTAssertEqual(r, a != b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalXorThenLoad_acquiringAndReleasing() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalXorThenLoad(
          with: b,
          ordering: .acquiringAndReleasing)
        XCTAssertEqual(r, a != b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }

  func test_logicalXorThenLoad_sequentiallyConsistent() {
    let v = UnsafeAtomic<Bool>.create(false)
    defer { v.destroy() }

    // The truth tables are super tiny, so just check every value
    for a in [false, true] {
      for b in [false, true] {
        v.store(a, ordering: .relaxed)
        let r = v.logicalXorThenLoad(
          with: b,
          ordering: .sequentiallyConsistent)
        XCTAssertEqual(r, a != b, "a = \(a), b = \(b)")
        XCTAssertEqual(
          v.load(ordering: .relaxed),
          a != b,
          "a = \(a), b =\(b)")
      }
    }
  }



#if MANUAL_TEST_DISCOVERY
  public static var allTests: [(String, (BasicAtomicBoolTests) -> () -> ())] = [
    ("test_create_destroy", test_create_destroy),
    ("test_load_relaxed", test_load_relaxed),
    ("test_load_acquiring", test_load_acquiring),
    ("test_load_sequentiallyConsistent", test_load_sequentiallyConsistent),
    ("test_store_relaxed", test_store_relaxed),
    ("test_store_releasing", test_store_releasing),
    ("test_store_sequentiallyConsistent", test_store_sequentiallyConsistent),
    ("test_exchange_relaxed", test_exchange_relaxed),
    ("test_exchange_acquiring", test_exchange_acquiring),
    ("test_exchange_releasing", test_exchange_releasing),
    ("test_exchange_acquiringAndReleasing", test_exchange_acquiringAndReleasing),
    ("test_exchange_sequentiallyConsistent", test_exchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed", test_compareExchange_relaxed),
    ("test_compareExchange_acquiring", test_compareExchange_acquiring),
    ("test_compareExchange_releasing", test_compareExchange_releasing),
    ("test_compareExchange_acquiringAndReleasing", test_compareExchange_acquiringAndReleasing),
    ("test_compareExchange_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent),
    ("test_compareExchange_relaxed_relaxed", test_compareExchange_relaxed_relaxed),
    ("test_compareExchange_relaxed_acquiring", test_compareExchange_relaxed_acquiring),
    ("test_compareExchange_relaxed_sequentiallyConsistent", test_compareExchange_relaxed_sequentiallyConsistent),
    ("test_compareExchange_acquiring_relaxed", test_compareExchange_acquiring_relaxed),
    ("test_compareExchange_acquiring_acquiring", test_compareExchange_acquiring_acquiring),
    ("test_compareExchange_acquiring_sequentiallyConsistent", test_compareExchange_acquiring_sequentiallyConsistent),
    ("test_compareExchange_releasing_relaxed", test_compareExchange_releasing_relaxed),
    ("test_compareExchange_releasing_acquiring", test_compareExchange_releasing_acquiring),
    ("test_compareExchange_releasing_sequentiallyConsistent", test_compareExchange_releasing_sequentiallyConsistent),
    ("test_compareExchange_acquiringAndReleasing_relaxed", test_compareExchange_acquiringAndReleasing_relaxed),
    ("test_compareExchange_acquiringAndReleasing_acquiring", test_compareExchange_acquiringAndReleasing_acquiring),
    ("test_compareExchange_acquiringAndReleasing_sequentiallyConsistent", test_compareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_compareExchange_sequentiallyConsistent_relaxed", test_compareExchange_sequentiallyConsistent_relaxed),
    ("test_compareExchange_sequentiallyConsistent_acquiring", test_compareExchange_sequentiallyConsistent_acquiring),
    ("test_compareExchange_sequentiallyConsistent_sequentiallyConsistent", test_compareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_weakCompareExchange_relaxed_relaxed", test_weakCompareExchange_relaxed_relaxed),
    ("test_weakCompareExchange_relaxed_acquiring", test_weakCompareExchange_relaxed_acquiring),
    ("test_weakCompareExchange_relaxed_sequentiallyConsistent", test_weakCompareExchange_relaxed_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiring_relaxed", test_weakCompareExchange_acquiring_relaxed),
    ("test_weakCompareExchange_acquiring_acquiring", test_weakCompareExchange_acquiring_acquiring),
    ("test_weakCompareExchange_acquiring_sequentiallyConsistent", test_weakCompareExchange_acquiring_sequentiallyConsistent),
    ("test_weakCompareExchange_releasing_relaxed", test_weakCompareExchange_releasing_relaxed),
    ("test_weakCompareExchange_releasing_acquiring", test_weakCompareExchange_releasing_acquiring),
    ("test_weakCompareExchange_releasing_sequentiallyConsistent", test_weakCompareExchange_releasing_sequentiallyConsistent),
    ("test_weakCompareExchange_acquiringAndReleasing_relaxed", test_weakCompareExchange_acquiringAndReleasing_relaxed),
    ("test_weakCompareExchange_acquiringAndReleasing_acquiring", test_weakCompareExchange_acquiringAndReleasing_acquiring),
    ("test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent", test_weakCompareExchange_acquiringAndReleasing_sequentiallyConsistent),
    ("test_weakCompareExchange_sequentiallyConsistent_relaxed", test_weakCompareExchange_sequentiallyConsistent_relaxed),
    ("test_weakCompareExchange_sequentiallyConsistent_acquiring", test_weakCompareExchange_sequentiallyConsistent_acquiring),
    ("test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent", test_weakCompareExchange_sequentiallyConsistent_sequentiallyConsistent),
    ("test_loadThenLogicalAnd_relaxed", test_loadThenLogicalAnd_relaxed),
    ("test_loadThenLogicalAnd_acquiring", test_loadThenLogicalAnd_acquiring),
    ("test_loadThenLogicalAnd_releasing", test_loadThenLogicalAnd_releasing),
    ("test_loadThenLogicalAnd_acquiringAndReleasing", test_loadThenLogicalAnd_acquiringAndReleasing),
    ("test_loadThenLogicalAnd_sequentiallyConsistent", test_loadThenLogicalAnd_sequentiallyConsistent),
    ("test_loadThenLogicalOr_relaxed", test_loadThenLogicalOr_relaxed),
    ("test_loadThenLogicalOr_acquiring", test_loadThenLogicalOr_acquiring),
    ("test_loadThenLogicalOr_releasing", test_loadThenLogicalOr_releasing),
    ("test_loadThenLogicalOr_acquiringAndReleasing", test_loadThenLogicalOr_acquiringAndReleasing),
    ("test_loadThenLogicalOr_sequentiallyConsistent", test_loadThenLogicalOr_sequentiallyConsistent),
    ("test_loadThenLogicalXor_relaxed", test_loadThenLogicalXor_relaxed),
    ("test_loadThenLogicalXor_acquiring", test_loadThenLogicalXor_acquiring),
    ("test_loadThenLogicalXor_releasing", test_loadThenLogicalXor_releasing),
    ("test_loadThenLogicalXor_acquiringAndReleasing", test_loadThenLogicalXor_acquiringAndReleasing),
    ("test_loadThenLogicalXor_sequentiallyConsistent", test_loadThenLogicalXor_sequentiallyConsistent),
    ("test_logicalAndThenLoad_relaxed", test_logicalAndThenLoad_relaxed),
    ("test_logicalAndThenLoad_acquiring", test_logicalAndThenLoad_acquiring),
    ("test_logicalAndThenLoad_releasing", test_logicalAndThenLoad_releasing),
    ("test_logicalAndThenLoad_acquiringAndReleasing", test_logicalAndThenLoad_acquiringAndReleasing),
    ("test_logicalAndThenLoad_sequentiallyConsistent", test_logicalAndThenLoad_sequentiallyConsistent),
    ("test_logicalOrThenLoad_relaxed", test_logicalOrThenLoad_relaxed),
    ("test_logicalOrThenLoad_acquiring", test_logicalOrThenLoad_acquiring),
    ("test_logicalOrThenLoad_releasing", test_logicalOrThenLoad_releasing),
    ("test_logicalOrThenLoad_acquiringAndReleasing", test_logicalOrThenLoad_acquiringAndReleasing),
    ("test_logicalOrThenLoad_sequentiallyConsistent", test_logicalOrThenLoad_sequentiallyConsistent),
    ("test_logicalXorThenLoad_relaxed", test_logicalXorThenLoad_relaxed),
    ("test_logicalXorThenLoad_acquiring", test_logicalXorThenLoad_acquiring),
    ("test_logicalXorThenLoad_releasing", test_logicalXorThenLoad_releasing),
    ("test_logicalXorThenLoad_acquiringAndReleasing", test_logicalXorThenLoad_acquiringAndReleasing),
    ("test_logicalXorThenLoad_sequentiallyConsistent", test_logicalXorThenLoad_sequentiallyConsistent),
  ]
#endif
}

