//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


extension UnsafeAtomic where Value: AtomicInteger {
  /// Perform an atomic wrapping add operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenWrappingIncrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping subtract operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenWrappingDecrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseAnd(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseOr(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseXor(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping add operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingIncrementThenLoad(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
    return original &+ operand
  }

  /// Perform an atomic wrapping subtract operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingDecrementThenLoad(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
    return original &- operand
  }

  /// Perform an atomic bitwise AND operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseAndThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original & operand
  }

  /// Perform an atomic bitwise OR operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseOrThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original | operand
  }

  /// Perform an atomic bitwise XOR operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseXorThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original ^ operand
  }


  /// Perform an atomic wrapping increment operation applying the
  /// specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+=` operator does on `Int` values.
  ///
  /// - Parameter operand: The value to add to the current value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingIncrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) {
    _ = _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping decrement operation applying the
  /// specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-=` operator does on `Int` values.
  ///
  /// - Parameter operand: The value to subtract from the current value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingDecrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) {
    _ = _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }
}
extension ManagedAtomic where Value: AtomicInteger {
  /// Perform an atomic wrapping add operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenWrappingIncrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping subtract operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenWrappingDecrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseAnd(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseOr(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic bitwise XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenBitwiseXor(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _Storage.atomicLoadThenBitwiseXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping add operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingIncrementThenLoad(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
    return original &+ operand
  }

  /// Perform an atomic wrapping subtract operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-` operator does on `Int` values.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingDecrementThenLoad(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
    return original &- operand
  }

  /// Perform an atomic bitwise AND operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseAndThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original & operand
  }

  /// Perform an atomic bitwise OR operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseOrThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original | operand
  }

  /// Perform an atomic bitwise XOR operation and return the new value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: An integer value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The new value after the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func bitwiseXorThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = _Storage.atomicLoadThenBitwiseXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original ^ operand
  }


  /// Perform an atomic wrapping increment operation applying the
  /// specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&+=` operator does on `Int` values.
  ///
  /// - Parameter operand: The value to add to the current value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingIncrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) {
    _ = _Storage.atomicLoadThenWrappingIncrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }

  /// Perform an atomic wrapping decrement operation applying the
  /// specified memory ordering.
  ///
  /// Note: This operation silently wraps around on overflow, like the
  /// `&-=` operator does on `Int` values.
  ///
  /// - Parameter operand: The value to subtract from the current value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func wrappingDecrement(
    by operand: Value = 1,
    ordering: AtomicUpdateOrdering
  ) {
    _ = _Storage.atomicLoadThenWrappingDecrement(
      by: operand,
      at: _ptr,
      ordering: ordering)
  }
}
