//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2025 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


extension UnsafeRawPointer: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UnsafeRawPointer

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeRawPointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeRawPointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeRawPointer(bitPattern: bits)!
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = Int(bitPattern: value)
    return _Storage(bits._value)
  }
}

extension UnsafeRawPointer.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let v = _extract(pointer)._atomicExchange(
      _encode(desired), ordering: ordering)
    return _decode(v)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafeMutableRawPointer: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UnsafeMutableRawPointer

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutableRawPointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeMutableRawPointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeMutableRawPointer(bitPattern: bits)!
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = Int(bitPattern: value)
    return _Storage(bits._value)
  }
}

extension UnsafeMutableRawPointer.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let v = _extract(pointer)._atomicExchange(
      _encode(desired), ordering: ordering)
    return _decode(v)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafePointer: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UnsafePointer

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafePointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafePointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafePointer(bitPattern: bits)!
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = Int(bitPattern: value)
    return _Storage(bits._value)
  }
}

extension UnsafePointer.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let v = _extract(pointer)._atomicExchange(
      _encode(desired), ordering: ordering)
    return _decode(v)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafeMutablePointer: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UnsafeMutablePointer

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeMutablePointer.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeMutablePointer(bitPattern: bits)!
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = Int(bitPattern: value)
    return _Storage(bits._value)
  }
}

extension UnsafeMutablePointer.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let v = _extract(pointer)._atomicExchange(
      _encode(desired), ordering: ordering)
    return _decode(v)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension Unmanaged: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Unmanaged

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension Unmanaged.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension Unmanaged.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return Unmanaged.fromOpaque(UnsafeRawPointer(bitPattern: bits)!)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = Int(bitPattern: value.toOpaque())
    return _Storage(bits._value)
  }
}

extension Unmanaged.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let v = _extract(pointer)._atomicExchange(
      _encode(desired), ordering: ordering)
    return _decode(v)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}


extension UnsafeRawPointer: AtomicOptionalWrappable {
  @frozen
  public struct AtomicOptionalRepresentation {
    public typealias Value = UnsafeRawPointer?

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @inline(__always) @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @inline(__always) @_alwaysEmitIntoClient
    public func dispose() -> Value {
      Self._decode(_storage)
    }
  }
}

extension UnsafeRawPointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeRawPointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeRawPointer(bitPattern: bits)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = value.map { Int(bitPattern: $0) } ?? 0
    return _Storage(bits._value)
  }
}

extension UnsafeRawPointer.AtomicOptionalRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicExchange(_encode(desired), ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafeMutableRawPointer: AtomicOptionalWrappable {
  @frozen
  public struct AtomicOptionalRepresentation {
    public typealias Value = UnsafeMutableRawPointer?

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @inline(__always) @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @inline(__always) @_alwaysEmitIntoClient
    public func dispose() -> Value {
      Self._decode(_storage)
    }
  }
}

extension UnsafeMutableRawPointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeMutableRawPointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeMutableRawPointer(bitPattern: bits)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = value.map { Int(bitPattern: $0) } ?? 0
    return _Storage(bits._value)
  }
}

extension UnsafeMutableRawPointer.AtomicOptionalRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicExchange(_encode(desired), ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafePointer: AtomicOptionalWrappable {
  @frozen
  public struct AtomicOptionalRepresentation {
    public typealias Value = UnsafePointer?

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @inline(__always) @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @inline(__always) @_alwaysEmitIntoClient
    public func dispose() -> Value {
      Self._decode(_storage)
    }
  }
}

extension UnsafePointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafePointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafePointer(bitPattern: bits)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = value.map { Int(bitPattern: $0) } ?? 0
    return _Storage(bits._value)
  }
}

extension UnsafePointer.AtomicOptionalRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicExchange(_encode(desired), ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension UnsafeMutablePointer: AtomicOptionalWrappable {
  @frozen
  public struct AtomicOptionalRepresentation {
    public typealias Value = UnsafeMutablePointer?

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @inline(__always) @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @inline(__always) @_alwaysEmitIntoClient
    public func dispose() -> Value {
      Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension UnsafeMutablePointer.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    return UnsafeMutablePointer(bitPattern: bits)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = value.map { Int(bitPattern: $0) } ?? 0
    return _Storage(bits._value)
  }
}

extension UnsafeMutablePointer.AtomicOptionalRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicExchange(_encode(desired), ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
extension Unmanaged: AtomicOptionalWrappable {
  @frozen
  public struct AtomicOptionalRepresentation {
    public typealias Value = Unmanaged?

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal let _storage: _Storage

    @inline(__always) @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @inline(__always) @_alwaysEmitIntoClient
    public func dispose() -> Value {
      Self._decode(_storage)
    }
  }
}

extension Unmanaged.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal static func _extract(
    _ ptr: UnsafeMutablePointer<Self>
  ) -> UnsafeMutablePointer<_Storage> {
    // `Self` is layout-compatible with its only stored property.
    return UnsafeMutableRawPointer(ptr)
      .assumingMemoryBound(to: _Storage.self)
  }
}

extension Unmanaged.AtomicOptionalRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal static func _decode(_ storage: _Storage) -> Value {
    let bits = Int(storage._value)
    guard let opaque = UnsafeRawPointer(bitPattern: bits) else {
      return nil
    }
    return Unmanaged.fromOpaque(opaque)
  }

  @_transparent @_alwaysEmitIntoClient
  internal static func _encode(_ value: Value) -> _Storage {
    let bits = value.map { Int(bitPattern: $0.toOpaque())} ?? 0
    return _Storage(bits._value)
  }
}

extension Unmanaged.AtomicOptionalRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicLoad(ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    _extract(pointer)._atomicStore(_encode(desired), ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    _decode(_extract(pointer)._atomicExchange(_encode(desired), ordering: ordering))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      ordering: ordering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Value,
    desired: Value,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Value) {
    let (exchanged, original) = _extract(pointer)._atomicWeakCompareExchange(
      expected: _encode(expected),
      desired: _encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (exchanged, _decode(original))
  }
}
