//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2025 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################



extension Int8: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Int8

    @usableFromInline
    internal typealias _Storage = _AtomicInt8Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == Int8.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Int8.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Int8.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension Int8.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Int8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Int8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int8,
    desired: Int8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Int8) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int8,
    desired: Int8,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int8) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Int8,
    desired: Int8,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int8) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension Int8: AtomicInteger {}

extension Int8.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: Int8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: Int8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: Int8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: Int8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: Int8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int8 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension Int16: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Int16

    @usableFromInline
    internal typealias _Storage = _AtomicInt16Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == Int16.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Int16.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Int16.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension Int16.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Int16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Int16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int16,
    desired: Int16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Int16) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int16,
    desired: Int16,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int16) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Int16,
    desired: Int16,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int16) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension Int16: AtomicInteger {}

extension Int16.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: Int16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: Int16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: Int16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: Int16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: Int16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int16 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension Int32: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Int32

    @usableFromInline
    internal typealias _Storage = _AtomicInt32Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == Int32.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Int32.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Int32.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension Int32.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Int32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Int32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int32,
    desired: Int32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Int32) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int32,
    desired: Int32,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int32) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Int32,
    desired: Int32,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int32) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension Int32: AtomicInteger {}

extension Int32.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: Int32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: Int32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: Int32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: Int32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: Int32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int32 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension Int64: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Int64

    @usableFromInline
    internal typealias _Storage = _AtomicInt64Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == Int64.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Int64.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Int64.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension Int64.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Int64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Int64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int64,
    desired: Int64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Int64) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int64,
    desired: Int64,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int64) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Int64,
    desired: Int64,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int64) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension Int64: AtomicInteger {}

extension Int64.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: Int64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: Int64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: Int64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: Int64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: Int64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int64 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension UInt8: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UInt8

    @usableFromInline
    internal typealias _Storage = _AtomicInt8Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == UInt8.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `UInt8.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension UInt8.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension UInt8.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: UInt8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: UInt8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt8,
    desired: UInt8,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: UInt8) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt8,
    desired: UInt8,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt8) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: UInt8,
    desired: UInt8,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt8) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension UInt8: AtomicInteger {}

extension UInt8.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: UInt8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: UInt8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: UInt8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: UInt8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: UInt8 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt8 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension UInt16: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UInt16

    @usableFromInline
    internal typealias _Storage = _AtomicInt16Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == UInt16.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `UInt16.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension UInt16.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension UInt16.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: UInt16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: UInt16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt16,
    desired: UInt16,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: UInt16) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt16,
    desired: UInt16,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt16) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: UInt16,
    desired: UInt16,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt16) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension UInt16: AtomicInteger {}

extension UInt16.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: UInt16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: UInt16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: UInt16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: UInt16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: UInt16 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt16 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension UInt32: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UInt32

    @usableFromInline
    internal typealias _Storage = _AtomicInt32Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == UInt32.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `UInt32.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension UInt32.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension UInt32.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: UInt32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: UInt32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt32,
    desired: UInt32,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: UInt32) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt32,
    desired: UInt32,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt32) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: UInt32,
    desired: UInt32,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt32) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension UInt32: AtomicInteger {}

extension UInt32.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: UInt32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: UInt32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: UInt32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: UInt32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: UInt32 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt32 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension UInt64: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UInt64

    @usableFromInline
    internal typealias _Storage = _AtomicInt64Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == UInt64.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `UInt64.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension UInt64.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension UInt64.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: UInt64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: UInt64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt64,
    desired: UInt64,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: UInt64) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt64,
    desired: UInt64,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt64) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: UInt64,
    desired: UInt64,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt64) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension UInt64: AtomicInteger {}

extension UInt64.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: UInt64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: UInt64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: UInt64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: UInt64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: UInt64 = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt64 {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension Int: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Int

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == Int.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Int.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Int.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension Int.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: Int,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: Int,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int,
    desired: Int,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Int) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Int,
    desired: Int,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Int,
    desired: Int,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Int) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension Int: AtomicInteger {}

extension Int.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: Int = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: Int = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: Int = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: Int = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: Int = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Int {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension UInt: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = UInt

    @usableFromInline
    internal typealias _Storage = _AtomicIntStorage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == UInt.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `UInt.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension UInt.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension UInt.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: UInt,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: UInt,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt,
    desired: UInt,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: UInt) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: UInt,
    desired: UInt,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: UInt,
    desired: UInt,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: UInt) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}

extension UInt: AtomicInteger {}

extension UInt.AtomicRepresentation: AtomicIntegerStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingIncrement(
    by operand: UInt = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoadThenWrappingIncrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenWrappingDecrement(
    by operand: UInt = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoadThenWrappingDecrement(
      by: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseAnd(
    with operand: UInt = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoadThenBitwiseAnd(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseOr(
    with operand: UInt = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoadThenBitwiseOr(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  @discardableResult
  public static func atomicLoadThenBitwiseXor(
    with operand: UInt = 1,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> UInt {
    let r = pointer._extract._atomicLoadThenBitwiseXor(
      with: Self._encode(operand), ordering: ordering)
    return Self._decode(r)
  }

}



extension DoubleWord: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = DoubleWord

    @usableFromInline
    internal typealias _Storage = _AtomicDoubleWordStorage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Value) {
      _storage = Self._encode(value)
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return Self._decode(_storage)
    }
  }
}

extension UnsafeMutablePointer
where Pointee == DoubleWord.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `DoubleWord.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension DoubleWord.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  static func _decode(_ storage: _Storage) -> Value {
    return Value(storage._value)
  }

  @_transparent @_alwaysEmitIntoClient
  static func _encode(_ value: Value) -> _Storage {
    return _Storage(value._value)
  }
}

extension DoubleWord.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicLoadOrdering
  ) -> DoubleWord {
    let r = pointer._extract._atomicLoad(ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: DoubleWord,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      Self._encode(desired),
      ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: DoubleWord,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> DoubleWord {
    let r = pointer._extract._atomicExchange(
      Self._encode(desired),
      ordering: ordering)
    return Self._decode(r)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: DoubleWord,
    desired: DoubleWord,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: DoubleWord) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      ordering: ordering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: DoubleWord,
    desired: DoubleWord,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: DoubleWord) {
    let r = pointer._extract._atomicCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: DoubleWord,
    desired: DoubleWord,
    at pointer: UnsafeMutablePointer<Self>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: DoubleWord) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: Self._encode(expected),
      desired: Self._encode(desired),
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, Self._decode(r.original))
  }
}


