//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift Atomics open source project
//
// Copyright (c) 2020 - 2025 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//


// #############################################################################
// #                                                                           #
// #            DO NOT EDIT THIS FILE; IT IS AUTOGENERATED.                    #
// #                                                                           #
// #############################################################################


import Builtin

extension Bool {
  @_alwaysEmitIntoClient
  @_transparent
  internal init(_ builtin: Builtin.Int1) {
    self = unsafeBitCast(builtin, to: Bool.self)
  }
}

extension Bool: AtomicValue {
  @frozen
  public struct AtomicRepresentation {
    public typealias Value = Bool

    @usableFromInline
    internal typealias _Storage = _AtomicInt8Storage

    @usableFromInline
    internal var _storage: _Storage

    @_transparent @_alwaysEmitIntoClient
    public init(_ value: Bool) {
      _storage = value._atomicRepresentation
    }

    @_transparent @_alwaysEmitIntoClient
    public func dispose() -> Value {
      return _storage._decodeBool
    }
  }
}

extension Bool {
  @_transparent @_alwaysEmitIntoClient
  internal var _atomicRepresentation: _AtomicInt8Storage {
    let v: Int8 = (self ? 1 : 0)
    return .init(v._value)
  }
}

extension _AtomicInt8Storage {
  @_transparent @_alwaysEmitIntoClient
  internal var _decodeBool: Bool {
    (Int8(self._value) & 1) != 0
  }
}

extension UnsafeMutablePointer
where Pointee == Bool.AtomicRepresentation {
  @_transparent @_alwaysEmitIntoClient
  @usableFromInline
  internal var _extract: UnsafeMutablePointer<Pointee._Storage> {
    // `Bool.AtomicRepresentation` is layout-compatible with
    // its only stored property.
    UnsafeMutableRawPointer(self).assumingMemoryBound(to: Pointee._Storage.self)
  }
}

extension Bool.AtomicRepresentation: AtomicStorage {
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoad(
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    ordering: AtomicLoadOrdering
  ) -> Bool {
    pointer._extract._atomicLoad(ordering: ordering)._decodeBool
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicStore(
    _ desired: __owned Bool,
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    ordering: AtomicStoreOrdering
  ) {
    pointer._extract._atomicStore(
      desired._atomicRepresentation, ordering: ordering)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicExchange(
    _ desired: __owned Bool,
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    ordering: AtomicUpdateOrdering
  ) -> Bool {
    pointer._extract._atomicExchange(
      desired._atomicRepresentation, ordering: ordering
    )._decodeBool
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Bool,
    desired: __owned Bool,
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    ordering: AtomicUpdateOrdering
  ) -> (exchanged: Bool, original: Bool) {
    let r = pointer._extract._atomicCompareExchange(
      expected: expected._atomicRepresentation,
      desired: desired._atomicRepresentation,
      ordering: ordering)
    return (r.exchanged, r.original._decodeBool)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicCompareExchange(
    expected: Bool,
    desired: __owned Bool,
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Bool) {
    let r = pointer._extract._atomicCompareExchange(
      expected: expected._atomicRepresentation,
      desired: desired._atomicRepresentation,
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, r.original._decodeBool)
  }

  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicWeakCompareExchange(
    expected: Bool,
    desired: __owned Bool,
    at pointer: UnsafeMutablePointer<Bool.AtomicRepresentation>,
    successOrdering: AtomicUpdateOrdering,
    failureOrdering: AtomicLoadOrdering
  ) -> (exchanged: Bool, original: Bool) {
    let r = pointer._extract._atomicWeakCompareExchange(
      expected: expected._atomicRepresentation,
      desired: desired._atomicRepresentation,
      successOrdering: successOrdering,
      failureOrdering: failureOrdering)
    return (r.exchanged, r.original._decodeBool)
  }
}


// MARK: - Additional operations

extension Bool.AtomicRepresentation {
  /// Perform an atomic logical AND operation on the value referenced by
  /// `pointer` and return the original value, applying the specified memory
  /// ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter pointer: A memory location previously initialized with a value
  ///   returned by `prepareAtomicRepresentation(for:)`.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoadThenLogicalAnd(
    with operand: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    pointer._extract._atomicLoadThenBitwiseAnd(
      with: operand._atomicRepresentation, ordering: ordering
    )._decodeBool
  }
  /// Perform an atomic logical OR operation on the value referenced by
  /// `pointer` and return the original value, applying the specified memory
  /// ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter pointer: A memory location previously initialized with a value
  ///   returned by `prepareAtomicRepresentation(for:)`.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoadThenLogicalOr(
    with operand: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    pointer._extract._atomicLoadThenBitwiseOr(
      with: operand._atomicRepresentation, ordering: ordering
    )._decodeBool
  }
  /// Perform an atomic logical XOR operation on the value referenced by
  /// `pointer` and return the original value, applying the specified memory
  /// ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter pointer: A memory location previously initialized with a value
  ///   returned by `prepareAtomicRepresentation(for:)`.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public static func atomicLoadThenLogicalXor(
    with operand: Value,
    at pointer: UnsafeMutablePointer<Self>,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    pointer._extract._atomicLoadThenBitwiseXor(
      with: operand._atomicRepresentation, ordering: ordering
    )._decodeBool
  }
}

extension UnsafeAtomic where Value == Bool {
  /// Perform an atomic logical AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalAnd(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
  /// Perform an atomic logical OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalOr(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
  /// Perform an atomic logical XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalXor(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
}

extension UnsafeAtomic where Value == Bool {
  /// Perform an atomic logical AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalAndThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original && operand
  }

  /// Perform an atomic logical OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalOrThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original || operand
  }

  /// Perform an atomic logical XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalXorThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original != operand
  }

}
extension ManagedAtomic where Value == Bool {
  /// Perform an atomic logical AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalAnd(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
  /// Perform an atomic logical OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalOr(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
  /// Perform an atomic logical XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func loadThenLogicalXor(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    Value.AtomicRepresentation.atomicLoadThenLogicalXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
  }
}

extension ManagedAtomic where Value == Bool {
  /// Perform an atomic logical AND operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalAndThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalAnd(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original && operand
  }

  /// Perform an atomic logical OR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalOrThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalOr(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original || operand
  }

  /// Perform an atomic logical XOR operation and return the original value, applying
  /// the specified memory ordering.
  ///
  /// - Parameter operand: A boolean value.
  /// - Parameter ordering: The memory ordering to apply on this operation.
  /// - Returns: The original value before the operation.
  @_semantics("atomics.requires_constant_orderings")
  @_transparent @_alwaysEmitIntoClient
  public func logicalXorThenLoad(
    with operand: Value,
    ordering: AtomicUpdateOrdering
  ) -> Value {
    let original = Value.AtomicRepresentation.atomicLoadThenLogicalXor(
      with: operand,
      at: _ptr,
      ordering: ordering)
    return original != operand
  }

}
