import { ng } from '../../utils/process';
import { writeFile } from '../../utils/fs';

export default async function () {
  await writeFile(
    'src/app/app.component.spec.ts',
    `
  import { TestBed } from '@angular/core/testing';
  import { AppComponent } from './app.component';

  describe('AppComponent', () => {
    beforeAll(() => {
      jasmine.clock().install();
    });

    afterAll(() => {
      jasmine.clock().uninstall();
    });

    beforeEach(() => TestBed.configureTestingModule({
      imports: [AppComponent]
    }));

    it('should create the app', () => {
      const fixture = TestBed.createComponent(AppComponent);
      expect(fixture.componentInstance).toBeTruthy();
    });
  });
  `,
  );

  await ng('test', '--watch=false');
}
