var index =
[
    [ "Introduction", "index.html#autotoc_md306", null ],
    [ "About the Documentation", "index.html#autotoc_md307", null ],
    [ "About GBDK", "index.html#autotoc_md308", null ],
    [ "Historical Info and Links", "index.html#autotoc_md309", null ],
    [ "Getting Started", "docs_getting_started.html", [
      [ "1. Download a Release and unzip it", "docs_getting_started.html#autotoc_md9", [
        [ "Known Issue: Windows and folder names with spaces on non-C drives", "docs_getting_started.html#autotoc_md10", null ]
      ] ],
      [ "2. Compile Example projects", "docs_getting_started.html#autotoc_md11", [
        [ "Windows (without Make installed):", "docs_getting_started.html#autotoc_md12", null ],
        [ "Linux / macOS / Windows with Make installed:", "docs_getting_started.html#autotoc_md13", [
          [ "macOS security warnings", "docs_getting_started.html#autotoc_md14", null ]
        ] ]
      ] ],
      [ "3. Use a Template", "docs_getting_started.html#autotoc_md15", null ],
      [ "4. If you use GBTD / GBMB, get the fixed version", "docs_getting_started.html#autotoc_md16", null ],
      [ "5. Review Coding Guidelines", "docs_getting_started.html#autotoc_md17", null ],
      [ "6. Hardware and Resources", "docs_getting_started.html#autotoc_md18", null ],
      [ "7. Set up C Source debugging", "docs_getting_started.html#autotoc_md19", null ],
      [ "8. Try a GBDK Tutorial", "docs_getting_started.html#autotoc_md20", null ],
      [ "9. Read up!", "docs_getting_started.html#autotoc_md21", null ],
      [ "10. Need help?", "docs_getting_started.html#autotoc_md22", null ],
      [ "Migrating From Pre-GBDK-2020 Tutorials", "docs_getting_started.html#autotoc_md23", [
        [ "Also see:", "docs_getting_started.html#autotoc_md24", null ],
        [ "Use auto-banking", "docs_getting_started.html#autotoc_md25", null ],
        [ "Non-standard types (UINT8, etc)", "docs_getting_started.html#autotoc_md26", null ],
        [ "If using GBTD / GBMB, get the fixed version", "docs_getting_started.html#autotoc_md27", null ],
        [ "LCC and SDCC flags that are not needed", "docs_getting_started.html#autotoc_md28", null ],
        [ "ROM Header Settings (such as Color, SGB, etc)", "docs_getting_started.html#autotoc_md29", null ],
        [ "GBDK Header include changes", "docs_getting_started.html#autotoc_md30", null ],
        [ "Include .h headers, not .c source files", "docs_getting_started.html#autotoc_md31", null ],
        [ "Use the Template Projects", "docs_getting_started.html#autotoc_md32", null ],
        [ "Use hUGEtracker instead of gbt_player", "docs_getting_started.html#autotoc_md33", null ]
      ] ]
    ] ],
    [ "Links, Tools and Debugging", "docs_links_and_tools.html", [
      [ "SDCC Compiler Suite User Manual", "docs_links_and_tools.html#autotoc_md34", null ],
      [ "Getting Help", "docs_links_and_tools.html#autotoc_md35", null ],
      [ "Game Boy Documentation", "docs_links_and_tools.html#autotoc_md36", null ],
      [ "Sega Master System / Game Gear Documentation", "docs_links_and_tools.html#autotoc_md37", null ],
      [ "Mega Duck / Cougar Boy Documentation", "docs_links_and_tools.html#autotoc_md38", null ],
      [ "Tutorials", "docs_links_and_tools.html#autotoc_md39", null ],
      [ "Example code", "docs_links_and_tools.html#autotoc_md40", null ],
      [ "Graphics Tools", "docs_links_and_tools.html#autotoc_md41", null ],
      [ "Music And Sound Effects for the Game Boy", "docs_links_and_tools.html#autotoc_md42", null ],
      [ "Music And Sound Effects for the SMS/Game Gear", "docs_links_and_tools.html#autotoc_md43", null ],
      [ "Emulators", "docs_links_and_tools.html#autotoc_md44", null ],
      [ "Debugging tools", "docs_links_and_tools.html#autotoc_md45", null ],
      [ "Optimizing Assembly", "docs_links_and_tools.html#autotoc_md46", null ],
      [ "Continuous Integration and Deployment", "docs_links_and_tools.html#autotoc_md47", null ]
    ] ],
    [ "Using GBDK", "docs_using_gbdk.html", [
      [ "Interrupts", "docs_using_gbdk.html#autotoc_md48", [
        [ "Available Interrupts", "docs_using_gbdk.html#autotoc_md49", null ],
        [ "Adding your own interrupt handler", "docs_using_gbdk.html#autotoc_md50", null ],
        [ "Using your own Interrupt Dispatcher", "docs_using_gbdk.html#autotoc_md51", null ],
        [ "Returning from Interrupts and STAT mode", "docs_using_gbdk.html#autotoc_md52", null ]
      ] ],
      [ "What GBDK does automatically and behind the scenes", "docs_using_gbdk.html#autotoc_md53", [
        [ "NES console", "docs_using_gbdk.html#autotoc_md54", null ],
        [ "OAM (VRAM Sprite Attribute Table)", "docs_using_gbdk.html#autotoc_md55", null ],
        [ "Graphics Tile Maps and Data on Startup", "docs_using_gbdk.html#autotoc_md56", null ],
        [ "Font tiles when using stdio.h", "docs_using_gbdk.html#autotoc_md57", null ],
        [ "Default Interrupt Service Handlers (ISRs)", "docs_using_gbdk.html#autotoc_md58", null ],
        [ "Ensuring Safe Access to Graphics Memory", "docs_using_gbdk.html#autotoc_md59", null ]
      ] ],
      [ "Compression", "docs_using_gbdk.html#autotoc_md60", null ],
      [ "Copying Functions to RAM and HIRAM", "docs_using_gbdk.html#autotoc_md61", null ],
      [ "Mixing C and Assembly", "docs_using_gbdk.html#autotoc_md62", [
        [ "Inline ASM within C source files", "docs_using_gbdk.html#autotoc_md63", null ],
        [ "In Separate ASM files", "docs_using_gbdk.html#autotoc_md64", null ]
      ] ],
      [ "Including binary files in C source with incbin", "docs_using_gbdk.html#autotoc_md65", null ],
      [ "Known Issues and Limitations", "docs_using_gbdk.html#autotoc_md66", [
        [ "SDCC", "docs_using_gbdk.html#autotoc_md67", null ]
      ] ]
    ] ],
    [ "Coding Guidelines", "docs_coding_guidelines.html", [
      [ "Learning C / C fundamentals", "docs_coding_guidelines.html#autotoc_md68", [
        [ "General C tutorials", "docs_coding_guidelines.html#autotoc_md69", null ],
        [ "Embedded C introductions", "docs_coding_guidelines.html#autotoc_md70", null ],
        [ "Game Boy games in C", "docs_coding_guidelines.html#autotoc_md71", null ]
      ] ],
      [ "Understanding the hardware", "docs_coding_guidelines.html#autotoc_md72", null ],
      [ "Writing optimal C code for the Game Boy and SDCC", "docs_coding_guidelines.html#autotoc_md73", [
        [ "Tools", "docs_coding_guidelines.html#autotoc_md74", [
          [ "GBTD / GBMB, Arrays and the \"const\" keyword", "docs_coding_guidelines.html#autotoc_md75", null ]
        ] ],
        [ "Avoid Reading from VRAM", "docs_coding_guidelines.html#autotoc_md76", null ],
        [ "Variables", "docs_coding_guidelines.html#autotoc_md77", null ],
        [ "Code structure", "docs_coding_guidelines.html#autotoc_md78", null ],
        [ "GBDK API/Library", "docs_coding_guidelines.html#autotoc_md79", null ],
        [ "Toolchain", "docs_coding_guidelines.html#autotoc_md80", null ],
        [ "Constants, Signed-ness and Overflows", "docs_coding_guidelines.html#autotoc_md81", null ],
        [ "Chars and vararg functions", "docs_coding_guidelines.html#autotoc_md82", [
          [ "Chars", "docs_coding_guidelines.html#autotoc_md83", null ]
        ] ]
      ] ],
      [ "When C isn't fast enough", "docs_coding_guidelines.html#autotoc_md84", [
        [ "Reusable Local Labels and Inline ASM", "docs_coding_guidelines.html#autotoc_md85", null ],
        [ "Variables and registers", "docs_coding_guidelines.html#autotoc_md86", null ],
        [ "Segments / Areas", "docs_coding_guidelines.html#autotoc_md87", null ],
        [ "Calling convention", "docs_coding_guidelines.html#autotoc_md88", [
          [ "Banked Calling Convention", "docs_coding_guidelines.html#autotoc_md89", null ]
        ] ]
      ] ]
    ] ],
    [ "ROM/RAM Banking and MBCs", "docs_rombanking_mbcs.html", [
      [ "ROM/RAM Banking and MBCs (Memory Bank Controllers)", "docs_rombanking_mbcs.html#autotoc_md90", [
        [ "Non-banked cartridges", "docs_rombanking_mbcs.html#autotoc_md91", null ],
        [ "MBC Banked cartridges (Memory Bank Controllers)", "docs_rombanking_mbcs.html#autotoc_md92", null ],
        [ "Recommended MBC type", "docs_rombanking_mbcs.html#autotoc_md93", [
          [ "Bank 0 Size Limit and Overflows When Using MBCs", "docs_rombanking_mbcs.html#autotoc_md94", null ],
          [ "Conserving Bank 0 for Important Functions and Data", "docs_rombanking_mbcs.html#autotoc_md95", null ]
        ] ]
      ] ],
      [ "Working with Banks", "docs_rombanking_mbcs.html#autotoc_md96", [
        [ "Setting the ROM bank for a Source file", "docs_rombanking_mbcs.html#autotoc_md97", null ],
        [ "Setting the RAM bank for a Source file", "docs_rombanking_mbcs.html#autotoc_md98", null ],
        [ "Setting the MBC and number of ROM & RAM banks available", "docs_rombanking_mbcs.html#autotoc_md99", null ],
        [ "MBC Type Chart", "docs_rombanking_mbcs.html#autotoc_md100", null ],
        [ "Getting Bank Numbers", "docs_rombanking_mbcs.html#autotoc_md101", null ],
        [ "Banking and Functions", "docs_rombanking_mbcs.html#autotoc_md102", [
          [ "BANKED/NONBANKED Keywords for Functions", "docs_rombanking_mbcs.html#autotoc_md103", null ],
          [ "Banked Function Calls", "docs_rombanking_mbcs.html#autotoc_md104", null ]
        ] ],
        [ "Const Data (Variables in ROM)", "docs_rombanking_mbcs.html#autotoc_md105", null ],
        [ "Variables in RAM", "docs_rombanking_mbcs.html#autotoc_md106", null ],
        [ "Far Pointers", "docs_rombanking_mbcs.html#autotoc_md107", null ],
        [ "Bank switching", "docs_rombanking_mbcs.html#autotoc_md108", null ],
        [ "Wrapper Function for Accessing Banked Data", "docs_rombanking_mbcs.html#autotoc_md109", null ],
        [ "Currently active bank: CURRENT_BANK", "docs_rombanking_mbcs.html#autotoc_md110", null ]
      ] ],
      [ "Auto-Banking", "docs_rombanking_mbcs.html#autotoc_md111", null ],
      [ "Errors related to banking (overflow, multiple writes to same location)", "docs_rombanking_mbcs.html#autotoc_md112", null ],
      [ "Bank space usage", "docs_rombanking_mbcs.html#autotoc_md113", [
        [ "Other important notes", "docs_rombanking_mbcs.html#autotoc_md114", null ]
      ] ],
      [ "Banking example projects", "docs_rombanking_mbcs.html#autotoc_md115", null ],
      [ "SMS/Game Gear Banking", "docs_rombanking_mbcs.html#autotoc_md116", [
        [ "Auto-Banking", "docs_rombanking_mbcs.html#autotoc_md117", null ]
      ] ]
    ] ],
    [ "Supported Consoles & Cross Compiling", "docs_supported_consoles.html", [
      [ "Consoles Supported by GBDK", "docs_supported_consoles.html#autotoc_md146", null ],
      [ "Cross Compiling for Different Consoles", "docs_supported_consoles.html#autotoc_md147", [
        [ "lcc", "docs_supported_consoles.html#autotoc_md148", null ],
        [ "sdcc", "docs_supported_consoles.html#autotoc_md149", null ],
        [ "Console Port and Platform Settings", "docs_supported_consoles.html#autotoc_md150", null ]
      ] ],
      [ "Cross-Platform Constants", "docs_supported_consoles.html#autotoc_md151", [
        [ "Console Identifiers", "docs_supported_consoles.html#autotoc_md152", null ],
        [ "Console Hardware Properties", "docs_supported_consoles.html#autotoc_md153", null ]
      ] ],
      [ "Using <gbdk/...> headers", "docs_supported_consoles.html#autotoc_md154", null ],
      [ "Cross Platform Example Projects", "docs_supported_consoles.html#autotoc_md155", [
        [ "Cross Platform Asset Example", "docs_supported_consoles.html#autotoc_md156", null ]
      ] ],
      [ "Hardware Summaries", "docs_supported_consoles.html#autotoc_md157", [
        [ "Safe VRAM / Display Controller Access", "docs_supported_consoles.html#autotoc_md158", null ]
      ] ],
      [ "Using Game Boy Color (GBC/CGB) Features", "docs_supported_consoles.html#autotoc_md159", [
        [ "Differences Versus the Regular Game Boy (DMG/GBP/SGB)", "docs_supported_consoles.html#autotoc_md160", null ],
        [ "Game Boy Color features in GBDK", "docs_supported_consoles.html#autotoc_md161", null ],
        [ "CGB Examples", "docs_supported_consoles.html#autotoc_md162", null ]
      ] ],
      [ "Porting Between Supported Consoles", "docs_supported_consoles.html#autotoc_md163", [
        [ "From Game Boy to Analogue Pocket", "docs_supported_consoles.html#autotoc_md164", [
          [ "Official differences:", "docs_supported_consoles.html#autotoc_md165", null ],
          [ "Observed differences:", "docs_supported_consoles.html#autotoc_md166", null ],
          [ "Registers and Flags", "docs_supported_consoles.html#autotoc_md167", null ],
          [ "Boot logo", "docs_supported_consoles.html#autotoc_md168", null ]
        ] ],
        [ "From Game Boy to SMS/GG", "docs_supported_consoles.html#autotoc_md169", [
          [ "RAM Banks", "docs_supported_consoles.html#autotoc_md170", null ],
          [ "Tile Data and Tile Map loading", "docs_supported_consoles.html#autotoc_md171", [
            [ "Tile and Map Data in 2bpp Game Boy Format", "docs_supported_consoles.html#autotoc_md172", null ],
            [ "Tile and Map Data in Native Format", "docs_supported_consoles.html#autotoc_md173", null ]
          ] ],
          [ "Colors and Palettes", "docs_supported_consoles.html#autotoc_md174", [
            [ "Emulated Game Boy Color map attributes on the SMS/Game Gear", "docs_supported_consoles.html#autotoc_md175", null ]
          ] ]
        ] ],
        [ "From Game Boy to NES", "docs_supported_consoles.html#autotoc_md176", [
          [ "Mapper", "docs_supported_consoles.html#autotoc_md177", null ],
          [ "Buffered mode vs direct mode", "docs_supported_consoles.html#autotoc_md178", [
            [ "Buffered mode implementation details", "docs_supported_consoles.html#autotoc_md179", null ],
            [ "Direct mode implementation details", "docs_supported_consoles.html#autotoc_md180", null ],
            [ "Caveat: Write appropriate global backdrop before turning display off", "docs_supported_consoles.html#autotoc_md181", null ]
          ] ],
          [ "Shadow PPU registers", "docs_supported_consoles.html#autotoc_md182", null ],
          [ "Implementation of (fake) vbl / lcd handlers", "docs_supported_consoles.html#autotoc_md183", null ],
          [ "Caveat: Make sure to call vsync on every frame", "docs_supported_consoles.html#autotoc_md184", null ],
          [ "Implementation of timer handler", "docs_supported_consoles.html#autotoc_md185", null ],
          [ "Tile Data and Tile Map loading", "docs_supported_consoles.html#autotoc_md186", [
            [ "Tile and Map Data in 2bpp Game Boy Format", "docs_supported_consoles.html#autotoc_md187", null ],
            [ "Tile and Map Data in Native Format", "docs_supported_consoles.html#autotoc_md188", null ],
            [ "Game Boy Color map attributes on the NES", "docs_supported_consoles.html#autotoc_md189", null ]
          ] ]
        ] ],
        [ "From Game Boy to Mega Duck / Cougar Boy", "docs_supported_consoles.html#autotoc_md190", [
          [ "Summary of Hardware changes:", "docs_supported_consoles.html#autotoc_md191", null ],
          [ "Best Practices", "docs_supported_consoles.html#autotoc_md192", null ],
          [ "Sound Register Value Changes", "docs_supported_consoles.html#autotoc_md193", null ],
          [ "Graphics Register Bit Changes", "docs_supported_consoles.html#autotoc_md194", null ],
          [ "Detailed Register Address Changes", "docs_supported_consoles.html#autotoc_md195", null ]
        ] ]
      ] ]
    ] ],
    [ "GBDK Toolchain", "docs_toolchain.html", [
      [ "Overview", "docs_toolchain.html#autotoc_md118", null ],
      [ "Data Types", "docs_toolchain.html#autotoc_md119", null ],
      [ "Changing Important Addresses", "docs_toolchain.html#autotoc_md120", null ],
      [ "Compiling programs", "docs_toolchain.html#autotoc_md121", [
        [ "Makefiles", "docs_toolchain.html#Makefiles", null ],
        [ "Using Makefiles", "docs_toolchain.html#autotoc_md122", null ],
        [ "Linker Files and ROM Auto Banking", "docs_toolchain.html#autotoc_md123", null ]
      ] ],
      [ "Build Tools", "docs_toolchain.html#autotoc_md124", [
        [ "lcc", "docs_toolchain.html#autotoc_md125", null ],
        [ "sdcc", "docs_toolchain.html#autotoc_md126", null ],
        [ "sdasgb", "docs_toolchain.html#autotoc_md127", null ],
        [ "bankpack", "docs_toolchain.html#autotoc_md128", null ],
        [ "sdldgb", "docs_toolchain.html#autotoc_md129", null ],
        [ "ihxcheck", "docs_toolchain.html#autotoc_md130", null ],
        [ "makebin", "docs_toolchain.html#autotoc_md131", null ]
      ] ],
      [ "GBDK Utilities", "docs_toolchain.html#autotoc_md132", [
        [ "GBCompress", "docs_toolchain.html#autotoc_md133", null ],
        [ "png2asset", "docs_toolchain.html#autotoc_md134", [
          [ "Working with png2asset", "docs_toolchain.html#autotoc_md135", [
            [ "Terminology", "docs_toolchain.html#autotoc_md136", null ],
            [ "Conversion Process", "docs_toolchain.html#autotoc_md137", null ],
            [ "Maps", "docs_toolchain.html#autotoc_md138", null ],
            [ "Meta sprites", "docs_toolchain.html#autotoc_md139", null ],
            [ "Super Game Boy Borders (SGB)", "docs_toolchain.html#autotoc_md140", null ]
          ] ]
        ] ],
        [ "makecom", "docs_toolchain.html#autotoc_md141", null ],
        [ "makenes", "docs_toolchain.html#autotoc_md142", null ],
        [ "png2hicolorgb", "docs_toolchain.html#autotoc_md143", [
          [ "Additional Details", "docs_toolchain.html#autotoc_md144", null ]
        ] ],
        [ "romusage", "docs_toolchain.html#autotoc_md145", null ]
      ] ]
    ] ],
    [ "Example Programs", "docs_example_programs.html", [
      [ "banks (various projects)", "docs_example_programs.html#autotoc_md196", null ],
      [ "comm", "docs_example_programs.html#autotoc_md197", null ],
      [ "crash", "docs_example_programs.html#autotoc_md198", null ],
      [ "colorbar", "docs_example_programs.html#autotoc_md199", null ],
      [ "dscan", "docs_example_programs.html#autotoc_md200", null ],
      [ "filltest", "docs_example_programs.html#autotoc_md201", null ],
      [ "fonts", "docs_example_programs.html#autotoc_md202", null ],
      [ "galaxy", "docs_example_programs.html#autotoc_md203", null ],
      [ "gb-dtmf", "docs_example_programs.html#autotoc_md204", null ],
      [ "gbdecompress", "docs_example_programs.html#autotoc_md205", null ],
      [ "irq", "docs_example_programs.html#autotoc_md206", null ],
      [ "large map", "docs_example_programs.html#autotoc_md207", null ],
      [ "metasprites", "docs_example_programs.html#autotoc_md208", null ],
      [ "lcd isr wobble", "docs_example_programs.html#autotoc_md209", null ],
      [ "paint", "docs_example_programs.html#autotoc_md210", null ],
      [ "rand", "docs_example_programs.html#autotoc_md211", null ],
      [ "ram_fn", "docs_example_programs.html#autotoc_md212", null ],
      [ "rpn", "docs_example_programs.html#autotoc_md213", null ],
      [ "samptest", "docs_example_programs.html#autotoc_md214", null ],
      [ "sgb (various)", "docs_example_programs.html#autotoc_md215", null ],
      [ "sound", "docs_example_programs.html#autotoc_md216", null ],
      [ "space", "docs_example_programs.html#autotoc_md217", null ],
      [ "templates", "docs_example_programs.html#autotoc_md218", null ]
    ] ],
    [ "Frequently Asked Questions (FAQ)", "docs_faq.html", [
      [ "General", "docs_faq.html#autotoc_md219", null ],
      [ "Licensing", "docs_faq.html#autotoc_md220", null ],
      [ "Graphics and Resources", "docs_faq.html#autotoc_md221", null ],
      [ "ROM Header Settings", "docs_faq.html#autotoc_md222", null ],
      [ "Editors", "docs_faq.html#autotoc_md223", null ],
      [ "Errors and Warnings", "docs_faq.html#autotoc_md224", null ],
      [ "Debugging / Compiling / Toolchain", "docs_faq.html#autotoc_md225", null ],
      [ "API / Utilities", "docs_faq.html#autotoc_md226", null ]
    ] ],
    [ "Migrating to new GBDK Versions", "docs_migrating_versions.html", [
      [ "GBDK-2020 versions", "docs_migrating_versions.html#autotoc_md227", [
        [ "Porting to GBDK-2020 4.4.0", "docs_migrating_versions.html#autotoc_md228", null ],
        [ "Porting to GBDK-2020 4.3.0", "docs_migrating_versions.html#autotoc_md229", null ],
        [ "Porting to GBDK-2020 4.2.0", "docs_migrating_versions.html#autotoc_md230", null ],
        [ "Porting to GBDK-2020 4.1.1", "docs_migrating_versions.html#autotoc_md231", null ],
        [ "Porting to GBDK-2020 4.1.0", "docs_migrating_versions.html#autotoc_md232", null ],
        [ "Porting to GBDK-2020 4.0.6", "docs_migrating_versions.html#autotoc_md233", null ],
        [ "Porting to GBDK-2020 4.0.5", "docs_migrating_versions.html#autotoc_md234", null ],
        [ "Porting to GBDK-2020 4.0.4", "docs_migrating_versions.html#autotoc_md235", null ],
        [ "Porting to GBDK-2020 4.0.3", "docs_migrating_versions.html#autotoc_md236", null ],
        [ "Porting to GBDK-2020 4.0.2", "docs_migrating_versions.html#autotoc_md237", null ],
        [ "Porting to GBDK-2020 4.0.1", "docs_migrating_versions.html#autotoc_md238", null ],
        [ "Porting to GBDK-2020 4.0", "docs_migrating_versions.html#autotoc_md239", null ],
        [ "Porting to GBDK-2020 3.2", "docs_migrating_versions.html#autotoc_md240", null ],
        [ "Porting to GBDK-2020 3.1.1", "docs_migrating_versions.html#autotoc_md241", null ],
        [ "Porting to GBDK-2020 3.1", "docs_migrating_versions.html#autotoc_md242", null ],
        [ "Porting to GBDK-2020 3.0.1", "docs_migrating_versions.html#autotoc_md243", null ]
      ] ],
      [ "Historical GBDK versions", "docs_migrating_versions.html#autotoc_md245", [
        [ "GBDK 1.1 to GBDK 2.0", "docs_migrating_versions.html#autotoc_md246", null ]
      ] ]
    ] ],
    [ "GBDK Release Notes", "docs_releases.html", [
      [ "GBDK-2020 Release Notes", "docs_releases.html#autotoc_md247", [
        [ "GBDK-2020 4.4.0", "docs_releases.html#autotoc_md248", null ],
        [ "GBDK-2020 4.3.0", "docs_releases.html#autotoc_md249", null ],
        [ "GBDK-2020 4.2.0", "docs_releases.html#autotoc_md250", null ],
        [ "GBDK-2020 4.1.1", "docs_releases.html#autotoc_md251", null ],
        [ "GBDK-2020 4.1.0", "docs_releases.html#autotoc_md252", null ],
        [ "GBDK-2020 4.0.6", "docs_releases.html#autotoc_md253", null ],
        [ "GBDK-2020 4.0.5", "docs_releases.html#autotoc_md254", null ],
        [ "GBDK-2020 4.0.4", "docs_releases.html#autotoc_md255", null ],
        [ "GBDK-2020 4.0.3", "docs_releases.html#autotoc_md256", null ],
        [ "GBDK-2020 4.0.2", "docs_releases.html#autotoc_md257", null ],
        [ "GBDK-2020 4.0.1", "docs_releases.html#autotoc_md258", null ],
        [ "GBDK-2020 4.0", "docs_releases.html#autotoc_md259", null ],
        [ "GBDK-2020 3.2", "docs_releases.html#autotoc_md260", null ],
        [ "GBDK-2020 3.1.1", "docs_releases.html#autotoc_md261", null ],
        [ "GBDK-2020 3.1", "docs_releases.html#autotoc_md262", null ],
        [ "GBDK-2020 3.0.1", "docs_releases.html#autotoc_md263", null ],
        [ "GBDK-2020 3.0", "docs_releases.html#autotoc_md264", null ]
      ] ],
      [ "Historical GBDK Release Notes", "docs_releases.html#autotoc_md265", [
        [ "GBDK 2.96", "docs_releases.html#autotoc_md266", null ],
        [ "GBDK 2.95-3", "docs_releases.html#autotoc_md267", null ],
        [ "GBDK 2.95-2", "docs_releases.html#autotoc_md268", null ],
        [ "GBDK 2.95", "docs_releases.html#autotoc_md269", null ],
        [ "GBDK 2.94", "docs_releases.html#autotoc_md270", null ],
        [ "GBDK 2.93", "docs_releases.html#autotoc_md271", null ],
        [ "GBDK 2.92-2 for win32", "docs_releases.html#autotoc_md272", null ],
        [ "GBDK 2.92", "docs_releases.html#autotoc_md273", null ],
        [ "GBDK 2.91", "docs_releases.html#autotoc_md274", null ],
        [ "GBDK 2.1.5", "docs_releases.html#autotoc_md275", null ],
        [ "GBDK 2.0b11 (DOS binary only) - 24 November 1997", "docs_releases.html#autotoc_md276", null ],
        [ "GBDK 2.0b10 (DOS binary only) - 6 November 1997", "docs_releases.html#autotoc_md277", null ],
        [ "GBDK 2.0b9 (DOS binary only)", "docs_releases.html#autotoc_md278", null ],
        [ "GBDK 2.0b8 (DOS binary only)", "docs_releases.html#autotoc_md279", null ],
        [ "GBDK 2.0b7 (DOS binary only)", "docs_releases.html#autotoc_md280", null ],
        [ "GBDK 2.0b6", "docs_releases.html#autotoc_md281", null ],
        [ "GBDK 2.0b5", "docs_releases.html#autotoc_md282", null ],
        [ "GBDK 2.0b4", "docs_releases.html#autotoc_md283", null ],
        [ "GBDK 2.0b3", "docs_releases.html#autotoc_md284", null ],
        [ "GBDK 2.0b2", "docs_releases.html#autotoc_md285", null ],
        [ "GBDK 2.0b1", "docs_releases.html#autotoc_md286", null ],
        [ "GBDK 1.1", "docs_releases.html#autotoc_md287", null ],
        [ "GBDK 1.0-1 1996", "docs_releases.html#autotoc_md288", null ]
      ] ]
    ] ],
    [ "Toolchain settings", "docs_toolchain_settings.html", [
      [ "lcc settings", "docs_toolchain_settings.html#autotoc_md289", null ],
      [ "sdcc settings", "docs_toolchain_settings.html#autotoc_md290", null ],
      [ "sdasgb settings", "docs_toolchain_settings.html#autotoc_md291", null ],
      [ "sdasz80 settings", "docs_toolchain_settings.html#autotoc_md292", null ],
      [ "sdas6500 settings", "docs_toolchain_settings.html#autotoc_md293", null ],
      [ "bankpack settings", "docs_toolchain_settings.html#autotoc_md294", null ],
      [ "sdldgb settings", "docs_toolchain_settings.html#autotoc_md295", null ],
      [ "sdldz80 settings", "docs_toolchain_settings.html#autotoc_md296", null ],
      [ "sdld6808 settings", "docs_toolchain_settings.html#autotoc_md297", null ],
      [ "ihxcheck settings", "docs_toolchain_settings.html#autotoc_md298", null ],
      [ "makebin settings", "docs_toolchain_settings.html#autotoc_md299", null ],
      [ "makecom settings", "docs_toolchain_settings.html#autotoc_md300", null ],
      [ "makenes settings", "docs_toolchain_settings.html#autotoc_md301", null ],
      [ "gbcompress settings", "docs_toolchain_settings.html#autotoc_md302", null ],
      [ "png2asset settings", "docs_toolchain_settings.html#autotoc_md303", null ],
      [ "png2hicolorgb settings", "docs_toolchain_settings.html#autotoc_md304", null ],
      [ "romusage settings", "docs_toolchain_settings.html#autotoc_md305", null ]
    ] ]
];