// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

/******************************************************************************/
//
//                             DO NOT MODIFY
//          This file has been generated by the UIElementsGenerator tool
//              See StyleGroupStructsCsGenerator class for details
//
/******************************************************************************/
using System;
using System.Collections.Generic;

namespace UnityEngine.UIElements
{
    internal interface IStyleDataGroup<T>
    {
        T Copy();
        void CopyFrom(ref T other);
    }

    internal struct InheritedData : IStyleDataGroup<InheritedData>, IEquatable<InheritedData>
    {
        public Color color;
        public Length fontSize;
        public Length letterSpacing;
        public TextShadow textShadow;
        public EditorTextRenderingMode unityEditorTextRenderingMode;
        public Font unityFont;
        public FontDefinition unityFontDefinition;
        public FontStyle unityFontStyleAndWeight;
        public Length unityParagraphSpacing;
        public TextAnchor unityTextAlign;
        public TextGeneratorType unityTextGenerator;
        public Color unityTextOutlineColor;
        public float unityTextOutlineWidth;
        public Visibility visibility;
        public WhiteSpace whiteSpace;
        public Length wordSpacing;

        public InheritedData Copy()
        {
            return this;
        }

        public void CopyFrom(ref InheritedData other)
        {
            this = other;
        }

        public static bool operator ==(InheritedData lhs, InheritedData rhs)
        {
            return lhs.color == rhs.color &&
                lhs.fontSize == rhs.fontSize &&
                lhs.letterSpacing == rhs.letterSpacing &&
                lhs.textShadow == rhs.textShadow &&
                lhs.unityEditorTextRenderingMode == rhs.unityEditorTextRenderingMode &&
                lhs.unityFont == rhs.unityFont &&
                lhs.unityFontDefinition == rhs.unityFontDefinition &&
                lhs.unityFontStyleAndWeight == rhs.unityFontStyleAndWeight &&
                lhs.unityParagraphSpacing == rhs.unityParagraphSpacing &&
                lhs.unityTextAlign == rhs.unityTextAlign &&
                lhs.unityTextGenerator == rhs.unityTextGenerator &&
                lhs.unityTextOutlineColor == rhs.unityTextOutlineColor &&
                lhs.unityTextOutlineWidth == rhs.unityTextOutlineWidth &&
                lhs.visibility == rhs.visibility &&
                lhs.whiteSpace == rhs.whiteSpace &&
                lhs.wordSpacing == rhs.wordSpacing;
        }

        public static bool operator !=(InheritedData lhs, InheritedData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(InheritedData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is InheritedData &&
                Equals((InheritedData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = color.GetHashCode();
                hashCode = (hashCode * 397) ^ fontSize.GetHashCode();
                hashCode = (hashCode * 397) ^ letterSpacing.GetHashCode();
                hashCode = (hashCode * 397) ^ textShadow.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)unityEditorTextRenderingMode;
                hashCode = (hashCode * 397) ^ (unityFont == null ? 0 : unityFont.GetHashCode());
                hashCode = (hashCode * 397) ^ unityFontDefinition.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)unityFontStyleAndWeight;
                hashCode = (hashCode * 397) ^ unityParagraphSpacing.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)unityTextAlign;
                hashCode = (hashCode * 397) ^ (int)unityTextGenerator;
                hashCode = (hashCode * 397) ^ unityTextOutlineColor.GetHashCode();
                hashCode = (hashCode * 397) ^ unityTextOutlineWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)visibility;
                hashCode = (hashCode * 397) ^ (int)whiteSpace;
                hashCode = (hashCode * 397) ^ wordSpacing.GetHashCode();
                return hashCode;
            }
        }
    }

    internal struct LayoutData : IStyleDataGroup<LayoutData>, IEquatable<LayoutData>
    {
        public Align alignContent;
        public Align alignItems;
        public Align alignSelf;
        public float borderBottomWidth;
        public float borderLeftWidth;
        public float borderRightWidth;
        public float borderTopWidth;
        public Length bottom;
        public DisplayStyle display;
        public Length flexBasis;
        public FlexDirection flexDirection;
        public float flexGrow;
        public float flexShrink;
        public Wrap flexWrap;
        public Length height;
        public Justify justifyContent;
        public Length left;
        public Length marginBottom;
        public Length marginLeft;
        public Length marginRight;
        public Length marginTop;
        public Length maxHeight;
        public Length maxWidth;
        public Length minHeight;
        public Length minWidth;
        public Length paddingBottom;
        public Length paddingLeft;
        public Length paddingRight;
        public Length paddingTop;
        public Position position;
        public Length right;
        public Length top;
        public Length width;

        public LayoutData Copy()
        {
            return this;
        }

        public void CopyFrom(ref LayoutData other)
        {
            this = other;
        }

        public static bool operator ==(LayoutData lhs, LayoutData rhs)
        {
            return lhs.alignContent == rhs.alignContent &&
                lhs.alignItems == rhs.alignItems &&
                lhs.alignSelf == rhs.alignSelf &&
                lhs.borderBottomWidth == rhs.borderBottomWidth &&
                lhs.borderLeftWidth == rhs.borderLeftWidth &&
                lhs.borderRightWidth == rhs.borderRightWidth &&
                lhs.borderTopWidth == rhs.borderTopWidth &&
                lhs.bottom == rhs.bottom &&
                lhs.display == rhs.display &&
                lhs.flexBasis == rhs.flexBasis &&
                lhs.flexDirection == rhs.flexDirection &&
                lhs.flexGrow == rhs.flexGrow &&
                lhs.flexShrink == rhs.flexShrink &&
                lhs.flexWrap == rhs.flexWrap &&
                lhs.height == rhs.height &&
                lhs.justifyContent == rhs.justifyContent &&
                lhs.left == rhs.left &&
                lhs.marginBottom == rhs.marginBottom &&
                lhs.marginLeft == rhs.marginLeft &&
                lhs.marginRight == rhs.marginRight &&
                lhs.marginTop == rhs.marginTop &&
                lhs.maxHeight == rhs.maxHeight &&
                lhs.maxWidth == rhs.maxWidth &&
                lhs.minHeight == rhs.minHeight &&
                lhs.minWidth == rhs.minWidth &&
                lhs.paddingBottom == rhs.paddingBottom &&
                lhs.paddingLeft == rhs.paddingLeft &&
                lhs.paddingRight == rhs.paddingRight &&
                lhs.paddingTop == rhs.paddingTop &&
                lhs.position == rhs.position &&
                lhs.right == rhs.right &&
                lhs.top == rhs.top &&
                lhs.width == rhs.width;
        }

        public static bool operator !=(LayoutData lhs, LayoutData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(LayoutData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is LayoutData &&
                Equals((LayoutData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = (int)alignContent;
                hashCode = (hashCode * 397) ^ (int)alignItems;
                hashCode = (hashCode * 397) ^ (int)alignSelf;
                hashCode = (hashCode * 397) ^ borderBottomWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ borderLeftWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ borderRightWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ borderTopWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ bottom.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)display;
                hashCode = (hashCode * 397) ^ flexBasis.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)flexDirection;
                hashCode = (hashCode * 397) ^ flexGrow.GetHashCode();
                hashCode = (hashCode * 397) ^ flexShrink.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)flexWrap;
                hashCode = (hashCode * 397) ^ height.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)justifyContent;
                hashCode = (hashCode * 397) ^ left.GetHashCode();
                hashCode = (hashCode * 397) ^ marginBottom.GetHashCode();
                hashCode = (hashCode * 397) ^ marginLeft.GetHashCode();
                hashCode = (hashCode * 397) ^ marginRight.GetHashCode();
                hashCode = (hashCode * 397) ^ marginTop.GetHashCode();
                hashCode = (hashCode * 397) ^ maxHeight.GetHashCode();
                hashCode = (hashCode * 397) ^ maxWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ minHeight.GetHashCode();
                hashCode = (hashCode * 397) ^ minWidth.GetHashCode();
                hashCode = (hashCode * 397) ^ paddingBottom.GetHashCode();
                hashCode = (hashCode * 397) ^ paddingLeft.GetHashCode();
                hashCode = (hashCode * 397) ^ paddingRight.GetHashCode();
                hashCode = (hashCode * 397) ^ paddingTop.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)position;
                hashCode = (hashCode * 397) ^ right.GetHashCode();
                hashCode = (hashCode * 397) ^ top.GetHashCode();
                hashCode = (hashCode * 397) ^ width.GetHashCode();
                return hashCode;
            }
        }
    }

    internal struct RareData : IStyleDataGroup<RareData>, IEquatable<RareData>
    {
        public Cursor cursor;
        public TextOverflow textOverflow;
        public Color unityBackgroundImageTintColor;
        public OverflowClipBox unityOverflowClipBox;
        public int unitySliceBottom;
        public int unitySliceLeft;
        public int unitySliceRight;
        public float unitySliceScale;
        public int unitySliceTop;
        public SliceType unitySliceType;
        public TextAutoSize unityTextAutoSize;
        public TextOverflowPosition unityTextOverflowPosition;

        public RareData Copy()
        {
            return this;
        }

        public void CopyFrom(ref RareData other)
        {
            this = other;
        }

        public static bool operator ==(RareData lhs, RareData rhs)
        {
            return lhs.cursor == rhs.cursor &&
                lhs.textOverflow == rhs.textOverflow &&
                lhs.unityBackgroundImageTintColor == rhs.unityBackgroundImageTintColor &&
                lhs.unityOverflowClipBox == rhs.unityOverflowClipBox &&
                lhs.unitySliceBottom == rhs.unitySliceBottom &&
                lhs.unitySliceLeft == rhs.unitySliceLeft &&
                lhs.unitySliceRight == rhs.unitySliceRight &&
                lhs.unitySliceScale == rhs.unitySliceScale &&
                lhs.unitySliceTop == rhs.unitySliceTop &&
                lhs.unitySliceType == rhs.unitySliceType &&
                lhs.unityTextAutoSize == rhs.unityTextAutoSize &&
                lhs.unityTextOverflowPosition == rhs.unityTextOverflowPosition;
        }

        public static bool operator !=(RareData lhs, RareData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(RareData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is RareData &&
                Equals((RareData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = cursor.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)textOverflow;
                hashCode = (hashCode * 397) ^ unityBackgroundImageTintColor.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)unityOverflowClipBox;
                hashCode = (hashCode * 397) ^ unitySliceBottom;
                hashCode = (hashCode * 397) ^ unitySliceLeft;
                hashCode = (hashCode * 397) ^ unitySliceRight;
                hashCode = (hashCode * 397) ^ unitySliceScale.GetHashCode();
                hashCode = (hashCode * 397) ^ unitySliceTop;
                hashCode = (hashCode * 397) ^ (int)unitySliceType;
                hashCode = (hashCode * 397) ^ unityTextAutoSize.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)unityTextOverflowPosition;
                return hashCode;
            }
        }
    }

    internal struct TransformData : IStyleDataGroup<TransformData>, IEquatable<TransformData>
    {
        public Rotate rotate;
        public Scale scale;
        public TransformOrigin transformOrigin;
        public Translate translate;

        public TransformData Copy()
        {
            return this;
        }

        public void CopyFrom(ref TransformData other)
        {
            this = other;
        }

        public static bool operator ==(TransformData lhs, TransformData rhs)
        {
            return lhs.rotate == rhs.rotate &&
                lhs.scale == rhs.scale &&
                lhs.transformOrigin == rhs.transformOrigin &&
                lhs.translate == rhs.translate;
        }

        public static bool operator !=(TransformData lhs, TransformData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(TransformData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is TransformData &&
                Equals((TransformData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = rotate.GetHashCode();
                hashCode = (hashCode * 397) ^ scale.GetHashCode();
                hashCode = (hashCode * 397) ^ transformOrigin.GetHashCode();
                hashCode = (hashCode * 397) ^ translate.GetHashCode();
                return hashCode;
            }
        }
    }

    [UnityEngine.Bindings.VisibleToOtherModules("UnityEditor.UIBuilderModule")]
    internal struct TransitionData : IStyleDataGroup<TransitionData>, IEquatable<TransitionData>
    {
        public List<TimeValue> transitionDelay;
        public List<TimeValue> transitionDuration;
        public List<StylePropertyName> transitionProperty;
        public List<EasingFunction> transitionTimingFunction;

        public TransitionData Copy()
        {
            var data = new TransitionData();
            data.transitionDelay = new List<TimeValue>(transitionDelay);
            data.transitionDuration = new List<TimeValue>(transitionDuration);
            data.transitionProperty = new List<StylePropertyName>(transitionProperty);
            data.transitionTimingFunction = new List<EasingFunction>(transitionTimingFunction);
            return data;
        }

        public void CopyFrom(ref TransitionData other)
        {
            if (!ReferenceEquals(transitionDelay, other.transitionDelay))
            {
                transitionDelay.Clear();
                transitionDelay.AddRange(other.transitionDelay);
            }

            if (!ReferenceEquals(transitionDuration, other.transitionDuration))
            {
                transitionDuration.Clear();
                transitionDuration.AddRange(other.transitionDuration);
            }

            if (!ReferenceEquals(transitionProperty, other.transitionProperty))
            {
                transitionProperty.Clear();
                transitionProperty.AddRange(other.transitionProperty);
            }

            if (!ReferenceEquals(transitionTimingFunction, other.transitionTimingFunction))
            {
                transitionTimingFunction.Clear();
                transitionTimingFunction.AddRange(other.transitionTimingFunction);
            }
        }

        public static bool operator ==(TransitionData lhs, TransitionData rhs)
        {
            return lhs.transitionDelay == rhs.transitionDelay &&
                lhs.transitionDuration == rhs.transitionDuration &&
                lhs.transitionProperty == rhs.transitionProperty &&
                lhs.transitionTimingFunction == rhs.transitionTimingFunction;
        }

        public static bool operator !=(TransitionData lhs, TransitionData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(TransitionData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is TransitionData &&
                Equals((TransitionData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = transitionDelay.GetHashCode();
                hashCode = (hashCode * 397) ^ transitionDuration.GetHashCode();
                hashCode = (hashCode * 397) ^ transitionProperty.GetHashCode();
                hashCode = (hashCode * 397) ^ transitionTimingFunction.GetHashCode();
                return hashCode;
            }
        }
    }

    internal struct VisualData : IStyleDataGroup<VisualData>, IEquatable<VisualData>
    {
        public Color backgroundColor;
        public Background backgroundImage;
        public BackgroundPosition backgroundPositionX;
        public BackgroundPosition backgroundPositionY;
        public BackgroundRepeat backgroundRepeat;
        public BackgroundSize backgroundSize;
        public Color borderBottomColor;
        public Length borderBottomLeftRadius;
        public Length borderBottomRightRadius;
        public Color borderLeftColor;
        public Color borderRightColor;
        public Color borderTopColor;
        public Length borderTopLeftRadius;
        public Length borderTopRightRadius;
        public float opacity;
        public OverflowInternal overflow;

        public VisualData Copy()
        {
            return this;
        }

        public void CopyFrom(ref VisualData other)
        {
            this = other;
        }

        public static bool operator ==(VisualData lhs, VisualData rhs)
        {
            return lhs.backgroundColor == rhs.backgroundColor &&
                lhs.backgroundImage == rhs.backgroundImage &&
                lhs.backgroundPositionX == rhs.backgroundPositionX &&
                lhs.backgroundPositionY == rhs.backgroundPositionY &&
                lhs.backgroundRepeat == rhs.backgroundRepeat &&
                lhs.backgroundSize == rhs.backgroundSize &&
                lhs.borderBottomColor == rhs.borderBottomColor &&
                lhs.borderBottomLeftRadius == rhs.borderBottomLeftRadius &&
                lhs.borderBottomRightRadius == rhs.borderBottomRightRadius &&
                lhs.borderLeftColor == rhs.borderLeftColor &&
                lhs.borderRightColor == rhs.borderRightColor &&
                lhs.borderTopColor == rhs.borderTopColor &&
                lhs.borderTopLeftRadius == rhs.borderTopLeftRadius &&
                lhs.borderTopRightRadius == rhs.borderTopRightRadius &&
                lhs.opacity == rhs.opacity &&
                lhs.overflow == rhs.overflow;
        }

        public static bool operator !=(VisualData lhs, VisualData rhs)
        {
            return !(lhs == rhs);
        }

        public bool Equals(VisualData other)
        {
            return other == this;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj))
                return false;
            return obj is VisualData &&
                Equals((VisualData)obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                var hashCode = backgroundColor.GetHashCode();
                hashCode = (hashCode * 397) ^ backgroundImage.GetHashCode();
                hashCode = (hashCode * 397) ^ backgroundPositionX.GetHashCode();
                hashCode = (hashCode * 397) ^ backgroundPositionY.GetHashCode();
                hashCode = (hashCode * 397) ^ backgroundRepeat.GetHashCode();
                hashCode = (hashCode * 397) ^ backgroundSize.GetHashCode();
                hashCode = (hashCode * 397) ^ borderBottomColor.GetHashCode();
                hashCode = (hashCode * 397) ^ borderBottomLeftRadius.GetHashCode();
                hashCode = (hashCode * 397) ^ borderBottomRightRadius.GetHashCode();
                hashCode = (hashCode * 397) ^ borderLeftColor.GetHashCode();
                hashCode = (hashCode * 397) ^ borderRightColor.GetHashCode();
                hashCode = (hashCode * 397) ^ borderTopColor.GetHashCode();
                hashCode = (hashCode * 397) ^ borderTopLeftRadius.GetHashCode();
                hashCode = (hashCode * 397) ^ borderTopRightRadius.GetHashCode();
                hashCode = (hashCode * 397) ^ opacity.GetHashCode();
                hashCode = (hashCode * 397) ^ (int)overflow;
                return hashCode;
            }
        }
    }
}
