// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

/******************************************************************************/
//
//                             DO NOT MODIFY
//          This file has been generated by the UIElementsGenerator tool
//              See ComputedStyleCsGenerator class for details
//
/******************************************************************************/
using System;
using System.Collections.Generic;
using UnityEngine.UIElements.StyleSheets;
using UnityEngine.UIElements.Layout;

namespace UnityEngine.UIElements
{
    internal partial struct ComputedStyle
    {
        public StyleDataRef<InheritedData> inheritedData;
        public StyleDataRef<LayoutData> layoutData;
        public StyleDataRef<RareData> rareData;
        public StyleDataRef<TransformData> transformData;
        public StyleDataRef<TransitionData> transitionData;
        public StyleDataRef<VisualData> visualData;

        public Dictionary<string, StylePropertyValue> customProperties;
        public Int64 matchingRulesHash;
        public float dpiScaling;
        public ComputedTransitionProperty[] computedTransitions;

        public Align alignContent => layoutData.Read().alignContent;
        public Align alignItems => layoutData.Read().alignItems;
        public Align alignSelf => layoutData.Read().alignSelf;
        public Color backgroundColor => visualData.Read().backgroundColor;
        public Background backgroundImage => visualData.Read().backgroundImage;
        public BackgroundPosition backgroundPositionX => visualData.Read().backgroundPositionX;
        public BackgroundPosition backgroundPositionY => visualData.Read().backgroundPositionY;
        public BackgroundRepeat backgroundRepeat => visualData.Read().backgroundRepeat;
        public BackgroundSize backgroundSize => visualData.Read().backgroundSize;
        public Color borderBottomColor => visualData.Read().borderBottomColor;
        public Length borderBottomLeftRadius => visualData.Read().borderBottomLeftRadius;
        public Length borderBottomRightRadius => visualData.Read().borderBottomRightRadius;
        public float borderBottomWidth => layoutData.Read().borderBottomWidth;
        public Color borderLeftColor => visualData.Read().borderLeftColor;
        public float borderLeftWidth => layoutData.Read().borderLeftWidth;
        public Color borderRightColor => visualData.Read().borderRightColor;
        public float borderRightWidth => layoutData.Read().borderRightWidth;
        public Color borderTopColor => visualData.Read().borderTopColor;
        public Length borderTopLeftRadius => visualData.Read().borderTopLeftRadius;
        public Length borderTopRightRadius => visualData.Read().borderTopRightRadius;
        public float borderTopWidth => layoutData.Read().borderTopWidth;
        public Length bottom => layoutData.Read().bottom;
        public Color color => inheritedData.Read().color;
        public Cursor cursor => rareData.Read().cursor;
        public DisplayStyle display => layoutData.Read().display;
        public Length flexBasis => layoutData.Read().flexBasis;
        public FlexDirection flexDirection => layoutData.Read().flexDirection;
        public float flexGrow => layoutData.Read().flexGrow;
        public float flexShrink => layoutData.Read().flexShrink;
        public Wrap flexWrap => layoutData.Read().flexWrap;
        public Length fontSize => inheritedData.Read().fontSize;
        public Length height => layoutData.Read().height;
        public Justify justifyContent => layoutData.Read().justifyContent;
        public Length left => layoutData.Read().left;
        public Length letterSpacing => inheritedData.Read().letterSpacing;
        public Length marginBottom => layoutData.Read().marginBottom;
        public Length marginLeft => layoutData.Read().marginLeft;
        public Length marginRight => layoutData.Read().marginRight;
        public Length marginTop => layoutData.Read().marginTop;
        public Length maxHeight => layoutData.Read().maxHeight;
        public Length maxWidth => layoutData.Read().maxWidth;
        public Length minHeight => layoutData.Read().minHeight;
        public Length minWidth => layoutData.Read().minWidth;
        public float opacity => visualData.Read().opacity;
        public OverflowInternal overflow => visualData.Read().overflow;
        public Length paddingBottom => layoutData.Read().paddingBottom;
        public Length paddingLeft => layoutData.Read().paddingLeft;
        public Length paddingRight => layoutData.Read().paddingRight;
        public Length paddingTop => layoutData.Read().paddingTop;
        public Position position => layoutData.Read().position;
        public Length right => layoutData.Read().right;
        public Rotate rotate => transformData.Read().rotate;
        public Scale scale => transformData.Read().scale;
        public TextOverflow textOverflow => rareData.Read().textOverflow;
        public TextShadow textShadow => inheritedData.Read().textShadow;
        public Length top => layoutData.Read().top;
        public TransformOrigin transformOrigin => transformData.Read().transformOrigin;
        public List<TimeValue> transitionDelay => transitionData.Read().transitionDelay;
        public List<TimeValue> transitionDuration => transitionData.Read().transitionDuration;
        public List<StylePropertyName> transitionProperty => transitionData.Read().transitionProperty;
        public List<EasingFunction> transitionTimingFunction => transitionData.Read().transitionTimingFunction;
        public Translate translate => transformData.Read().translate;
        public Color unityBackgroundImageTintColor => rareData.Read().unityBackgroundImageTintColor;
        public EditorTextRenderingMode unityEditorTextRenderingMode => inheritedData.Read().unityEditorTextRenderingMode;
        public Font unityFont => inheritedData.Read().unityFont;
        public FontDefinition unityFontDefinition => inheritedData.Read().unityFontDefinition;
        public FontStyle unityFontStyleAndWeight => inheritedData.Read().unityFontStyleAndWeight;
        public OverflowClipBox unityOverflowClipBox => rareData.Read().unityOverflowClipBox;
        public Length unityParagraphSpacing => inheritedData.Read().unityParagraphSpacing;
        public int unitySliceBottom => rareData.Read().unitySliceBottom;
        public int unitySliceLeft => rareData.Read().unitySliceLeft;
        public int unitySliceRight => rareData.Read().unitySliceRight;
        public float unitySliceScale => rareData.Read().unitySliceScale;
        public int unitySliceTop => rareData.Read().unitySliceTop;
        public SliceType unitySliceType => rareData.Read().unitySliceType;
        public TextAnchor unityTextAlign => inheritedData.Read().unityTextAlign;
        public TextAutoSize unityTextAutoSize => rareData.Read().unityTextAutoSize;
        public TextGeneratorType unityTextGenerator => inheritedData.Read().unityTextGenerator;
        public Color unityTextOutlineColor => inheritedData.Read().unityTextOutlineColor;
        public float unityTextOutlineWidth => inheritedData.Read().unityTextOutlineWidth;
        public TextOverflowPosition unityTextOverflowPosition => rareData.Read().unityTextOverflowPosition;
        public Visibility visibility => inheritedData.Read().visibility;
        public WhiteSpace whiteSpace => inheritedData.Read().whiteSpace;
        public Length width => layoutData.Read().width;
        public Length wordSpacing => inheritedData.Read().wordSpacing;

        public static ComputedStyle Create(ref ComputedStyle parentStyle)
        {
            ref var initialStyle = ref InitialStyle.Get();
            var cs = new ComputedStyle{dpiScaling = 1f};
            cs.inheritedData = parentStyle.inheritedData.Acquire();
            cs.layoutData = initialStyle.layoutData.Acquire();
            cs.rareData = initialStyle.rareData.Acquire();
            cs.transformData = initialStyle.transformData.Acquire();
            cs.transitionData = initialStyle.transitionData.Acquire();
            cs.visualData = initialStyle.visualData.Acquire();
            return cs;
        }

        public static ComputedStyle CreateInitial()
        {
            var cs = new ComputedStyle{dpiScaling = 1f};
            cs.inheritedData = StyleDataRef<InheritedData>.Create();
            cs.layoutData = StyleDataRef<LayoutData>.Create();
            cs.rareData = StyleDataRef<RareData>.Create();
            cs.transformData = StyleDataRef<TransformData>.Create();
            cs.transitionData = StyleDataRef<TransitionData>.Create();
            cs.visualData = StyleDataRef<VisualData>.Create();
            return cs;
        }

        public ComputedStyle Acquire()
        {
            inheritedData.Acquire();
            layoutData.Acquire();
            rareData.Acquire();
            transformData.Acquire();
            transitionData.Acquire();
            visualData.Acquire();
            return this;
        }

        public void Release()
        {
            inheritedData.Release();
            layoutData.Release();
            rareData.Release();
            transformData.Release();
            transitionData.Release();
            visualData.Release();
        }

        public void CopyFrom(ref ComputedStyle other)
        {
            inheritedData.CopyFrom(other.inheritedData);
            layoutData.CopyFrom(other.layoutData);
            rareData.CopyFrom(other.rareData);
            transformData.CopyFrom(other.transformData);
            transitionData.CopyFrom(other.transitionData);
            visualData.CopyFrom(other.visualData);

            customProperties = other.customProperties;
            matchingRulesHash = other.matchingRulesHash;
            dpiScaling = other.dpiScaling;
            computedTransitions = other.computedTransitions;
        }

        public void ApplyProperties(StylePropertyReader reader, ref ComputedStyle parentStyle)
        {
            for (var id = reader.propertyId; reader.property != null; id = reader.MoveNextProperty())
            {
                if (ApplyGlobalKeyword(reader, ref parentStyle))
                    continue;
                switch (id)
                {
                    case StylePropertyId.AlignContent:
                        layoutData.Write().alignContent = (Align)reader.ReadEnum(StyleEnumType.Align, 0);
                        break;
                    case StylePropertyId.AlignItems:
                        layoutData.Write().alignItems = (Align)reader.ReadEnum(StyleEnumType.Align, 0);
                        break;
                    case StylePropertyId.AlignSelf:
                        layoutData.Write().alignSelf = (Align)reader.ReadEnum(StyleEnumType.Align, 0);
                        break;
                    case StylePropertyId.All:
                        break;
                    case StylePropertyId.BackgroundColor:
                        visualData.Write().backgroundColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.BackgroundImage:
                        visualData.Write().backgroundImage = reader.ReadBackground(0);
                        break;
                    case StylePropertyId.BackgroundPosition:
                        ShorthandApplicator.ApplyBackgroundPosition(reader, ref this);
                        break;
                    case StylePropertyId.BackgroundPositionX:
                        visualData.Write().backgroundPositionX = reader.ReadBackgroundPositionX(0);
                        break;
                    case StylePropertyId.BackgroundPositionY:
                        visualData.Write().backgroundPositionY = reader.ReadBackgroundPositionY(0);
                        break;
                    case StylePropertyId.BackgroundRepeat:
                        visualData.Write().backgroundRepeat = reader.ReadBackgroundRepeat(0);
                        break;
                    case StylePropertyId.BackgroundSize:
                        visualData.Write().backgroundSize = reader.ReadBackgroundSize(0);
                        break;
                    case StylePropertyId.BorderBottomColor:
                        visualData.Write().borderBottomColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.BorderBottomLeftRadius:
                        visualData.Write().borderBottomLeftRadius = reader.ReadLength(0);
                        break;
                    case StylePropertyId.BorderBottomRightRadius:
                        visualData.Write().borderBottomRightRadius = reader.ReadLength(0);
                        break;
                    case StylePropertyId.BorderBottomWidth:
                        layoutData.Write().borderBottomWidth = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.BorderColor:
                        ShorthandApplicator.ApplyBorderColor(reader, ref this);
                        break;
                    case StylePropertyId.BorderLeftColor:
                        visualData.Write().borderLeftColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.BorderLeftWidth:
                        layoutData.Write().borderLeftWidth = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.BorderRadius:
                        ShorthandApplicator.ApplyBorderRadius(reader, ref this);
                        break;
                    case StylePropertyId.BorderRightColor:
                        visualData.Write().borderRightColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.BorderRightWidth:
                        layoutData.Write().borderRightWidth = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.BorderTopColor:
                        visualData.Write().borderTopColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.BorderTopLeftRadius:
                        visualData.Write().borderTopLeftRadius = reader.ReadLength(0);
                        break;
                    case StylePropertyId.BorderTopRightRadius:
                        visualData.Write().borderTopRightRadius = reader.ReadLength(0);
                        break;
                    case StylePropertyId.BorderTopWidth:
                        layoutData.Write().borderTopWidth = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.BorderWidth:
                        ShorthandApplicator.ApplyBorderWidth(reader, ref this);
                        break;
                    case StylePropertyId.Bottom:
                        layoutData.Write().bottom = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Color:
                        inheritedData.Write().color = reader.ReadColor(0);
                        break;
                    case StylePropertyId.Cursor:
                        rareData.Write().cursor = reader.ReadCursor(0);
                        break;
                    case StylePropertyId.Display:
                        layoutData.Write().display = (DisplayStyle)reader.ReadEnum(StyleEnumType.DisplayStyle, 0);
                        break;
                    case StylePropertyId.Flex:
                        ShorthandApplicator.ApplyFlex(reader, ref this);
                        break;
                    case StylePropertyId.FlexBasis:
                        layoutData.Write().flexBasis = reader.ReadLength(0);
                        break;
                    case StylePropertyId.FlexDirection:
                        layoutData.Write().flexDirection = (FlexDirection)reader.ReadEnum(StyleEnumType.FlexDirection, 0);
                        break;
                    case StylePropertyId.FlexGrow:
                        layoutData.Write().flexGrow = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.FlexShrink:
                        layoutData.Write().flexShrink = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.FlexWrap:
                        layoutData.Write().flexWrap = (Wrap)reader.ReadEnum(StyleEnumType.Wrap, 0);
                        break;
                    case StylePropertyId.FontSize:
                        inheritedData.Write().fontSize = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Height:
                        layoutData.Write().height = reader.ReadLength(0);
                        break;
                    case StylePropertyId.JustifyContent:
                        layoutData.Write().justifyContent = (Justify)reader.ReadEnum(StyleEnumType.Justify, 0);
                        break;
                    case StylePropertyId.Left:
                        layoutData.Write().left = reader.ReadLength(0);
                        break;
                    case StylePropertyId.LetterSpacing:
                        inheritedData.Write().letterSpacing = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Margin:
                        ShorthandApplicator.ApplyMargin(reader, ref this);
                        break;
                    case StylePropertyId.MarginBottom:
                        layoutData.Write().marginBottom = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MarginLeft:
                        layoutData.Write().marginLeft = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MarginRight:
                        layoutData.Write().marginRight = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MarginTop:
                        layoutData.Write().marginTop = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MaxHeight:
                        layoutData.Write().maxHeight = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MaxWidth:
                        layoutData.Write().maxWidth = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MinHeight:
                        layoutData.Write().minHeight = reader.ReadLength(0);
                        break;
                    case StylePropertyId.MinWidth:
                        layoutData.Write().minWidth = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Opacity:
                        visualData.Write().opacity = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.Overflow:
                        visualData.Write().overflow = (OverflowInternal)reader.ReadEnum(StyleEnumType.OverflowInternal, 0);
                        break;
                    case StylePropertyId.Padding:
                        ShorthandApplicator.ApplyPadding(reader, ref this);
                        break;
                    case StylePropertyId.PaddingBottom:
                        layoutData.Write().paddingBottom = reader.ReadLength(0);
                        break;
                    case StylePropertyId.PaddingLeft:
                        layoutData.Write().paddingLeft = reader.ReadLength(0);
                        break;
                    case StylePropertyId.PaddingRight:
                        layoutData.Write().paddingRight = reader.ReadLength(0);
                        break;
                    case StylePropertyId.PaddingTop:
                        layoutData.Write().paddingTop = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Position:
                        layoutData.Write().position = (Position)reader.ReadEnum(StyleEnumType.Position, 0);
                        break;
                    case StylePropertyId.Right:
                        layoutData.Write().right = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Rotate:
                        transformData.Write().rotate = reader.ReadRotate(0);
                        break;
                    case StylePropertyId.Scale:
                        transformData.Write().scale = reader.ReadScale(0);
                        break;
                    case StylePropertyId.TextOverflow:
                        rareData.Write().textOverflow = (TextOverflow)reader.ReadEnum(StyleEnumType.TextOverflow, 0);
                        break;
                    case StylePropertyId.TextShadow:
                        inheritedData.Write().textShadow = reader.ReadTextShadow(0);
                        break;
                    case StylePropertyId.Top:
                        layoutData.Write().top = reader.ReadLength(0);
                        break;
                    case StylePropertyId.TransformOrigin:
                        transformData.Write().transformOrigin = reader.ReadTransformOrigin(0);
                        break;
                    case StylePropertyId.Transition:
                        ShorthandApplicator.ApplyTransition(reader, ref this);
                        break;
                    case StylePropertyId.TransitionDelay:
                        reader.ReadListTimeValue(transitionData.Write().transitionDelay, 0);
                        ResetComputedTransitions();
                        break;
                    case StylePropertyId.TransitionDuration:
                        reader.ReadListTimeValue(transitionData.Write().transitionDuration, 0);
                        ResetComputedTransitions();
                        break;
                    case StylePropertyId.TransitionProperty:
                        reader.ReadListStylePropertyName(transitionData.Write().transitionProperty, 0);
                        ResetComputedTransitions();
                        break;
                    case StylePropertyId.TransitionTimingFunction:
                        reader.ReadListEasingFunction(transitionData.Write().transitionTimingFunction, 0);
                        ResetComputedTransitions();
                        break;
                    case StylePropertyId.Translate:
                        transformData.Write().translate = reader.ReadTranslate(0);
                        break;
                    case StylePropertyId.UnityBackgroundImageTintColor:
                        rareData.Write().unityBackgroundImageTintColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.UnityBackgroundScaleMode:
                        ShorthandApplicator.ApplyUnityBackgroundScaleMode(reader, ref this);
                        break;
                    case StylePropertyId.UnityEditorTextRenderingMode:
                        inheritedData.Write().unityEditorTextRenderingMode = (EditorTextRenderingMode)reader.ReadEnum(StyleEnumType.EditorTextRenderingMode, 0);
                        break;
                    case StylePropertyId.UnityFont:
                        inheritedData.Write().unityFont = reader.ReadFont(0);
                        break;
                    case StylePropertyId.UnityFontDefinition:
                        inheritedData.Write().unityFontDefinition = reader.ReadFontDefinition(0);
                        break;
                    case StylePropertyId.UnityFontStyleAndWeight:
                        inheritedData.Write().unityFontStyleAndWeight = (FontStyle)reader.ReadEnum(StyleEnumType.FontStyle, 0);
                        break;
                    case StylePropertyId.UnityOverflowClipBox:
                        rareData.Write().unityOverflowClipBox = (OverflowClipBox)reader.ReadEnum(StyleEnumType.OverflowClipBox, 0);
                        break;
                    case StylePropertyId.UnityParagraphSpacing:
                        inheritedData.Write().unityParagraphSpacing = reader.ReadLength(0);
                        break;
                    case StylePropertyId.UnitySliceBottom:
                        rareData.Write().unitySliceBottom = reader.ReadInt(0);
                        break;
                    case StylePropertyId.UnitySliceLeft:
                        rareData.Write().unitySliceLeft = reader.ReadInt(0);
                        break;
                    case StylePropertyId.UnitySliceRight:
                        rareData.Write().unitySliceRight = reader.ReadInt(0);
                        break;
                    case StylePropertyId.UnitySliceScale:
                        rareData.Write().unitySliceScale = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.UnitySliceTop:
                        rareData.Write().unitySliceTop = reader.ReadInt(0);
                        break;
                    case StylePropertyId.UnitySliceType:
                        rareData.Write().unitySliceType = (SliceType)reader.ReadEnum(StyleEnumType.SliceType, 0);
                        break;
                    case StylePropertyId.UnityTextAlign:
                        inheritedData.Write().unityTextAlign = (TextAnchor)reader.ReadEnum(StyleEnumType.TextAnchor, 0);
                        break;
                    case StylePropertyId.UnityTextAutoSize:
                        rareData.Write().unityTextAutoSize = reader.ReadTextAutoSize(0);
                        break;
                    case StylePropertyId.UnityTextGenerator:
                        inheritedData.Write().unityTextGenerator = (TextGeneratorType)reader.ReadEnum(StyleEnumType.TextGeneratorType, 0);
                        break;
                    case StylePropertyId.UnityTextOutline:
                        ShorthandApplicator.ApplyUnityTextOutline(reader, ref this);
                        break;
                    case StylePropertyId.UnityTextOutlineColor:
                        inheritedData.Write().unityTextOutlineColor = reader.ReadColor(0);
                        break;
                    case StylePropertyId.UnityTextOutlineWidth:
                        inheritedData.Write().unityTextOutlineWidth = reader.ReadFloat(0);
                        break;
                    case StylePropertyId.UnityTextOverflowPosition:
                        rareData.Write().unityTextOverflowPosition = (TextOverflowPosition)reader.ReadEnum(StyleEnumType.TextOverflowPosition, 0);
                        break;
                    case StylePropertyId.Visibility:
                        inheritedData.Write().visibility = (Visibility)reader.ReadEnum(StyleEnumType.Visibility, 0);
                        break;
                    case StylePropertyId.WhiteSpace:
                        inheritedData.Write().whiteSpace = (WhiteSpace)reader.ReadEnum(StyleEnumType.WhiteSpace, 0);
                        break;
                    case StylePropertyId.Width:
                        layoutData.Write().width = reader.ReadLength(0);
                        break;
                    case StylePropertyId.WordSpacing:
                        inheritedData.Write().wordSpacing = reader.ReadLength(0);
                        break;
                    case StylePropertyId.Custom:
                        ApplyCustomStyleProperty(reader);
                        break;
                    case StylePropertyId.Unknown:
                        break;
                    default:
                        Debug.LogAssertion($"Unknown property id {id}");
                        break;
                }
            }
        }

        public void ApplyStyleValue(StyleValue sv, ref ComputedStyle parentStyle)
        {
            if (ApplyGlobalKeyword(sv.id, sv.keyword, ref parentStyle))
                return;
            switch (sv.id)
            {
                case StylePropertyId.AlignContent:
                    layoutData.Write().alignContent = (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        layoutData.Write().alignContent = Align.Auto;
                    break;
                case StylePropertyId.AlignItems:
                    layoutData.Write().alignItems = (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        layoutData.Write().alignItems = Align.Auto;
                    break;
                case StylePropertyId.AlignSelf:
                    layoutData.Write().alignSelf = (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        layoutData.Write().alignSelf = Align.Auto;
                    break;
                case StylePropertyId.BackgroundColor:
                    visualData.Write().backgroundColor = sv.color;
                    break;
                case StylePropertyId.BackgroundImage:
                    visualData.Write().backgroundImage = sv.resource.IsAllocated ? Background.FromObject(sv.resource.Target) : new Background();
                    break;
                case StylePropertyId.BackgroundPositionX:
                    visualData.Write().backgroundPositionX = sv.position;
                    break;
                case StylePropertyId.BackgroundPositionY:
                    visualData.Write().backgroundPositionY = sv.position;
                    break;
                case StylePropertyId.BackgroundRepeat:
                    visualData.Write().backgroundRepeat = sv.repeat;
                    break;
                case StylePropertyId.BorderBottomColor:
                    visualData.Write().borderBottomColor = sv.color;
                    break;
                case StylePropertyId.BorderBottomLeftRadius:
                    visualData.Write().borderBottomLeftRadius = sv.length;
                    break;
                case StylePropertyId.BorderBottomRightRadius:
                    visualData.Write().borderBottomRightRadius = sv.length;
                    break;
                case StylePropertyId.BorderBottomWidth:
                    layoutData.Write().borderBottomWidth = sv.number;
                    break;
                case StylePropertyId.BorderLeftColor:
                    visualData.Write().borderLeftColor = sv.color;
                    break;
                case StylePropertyId.BorderLeftWidth:
                    layoutData.Write().borderLeftWidth = sv.number;
                    break;
                case StylePropertyId.BorderRightColor:
                    visualData.Write().borderRightColor = sv.color;
                    break;
                case StylePropertyId.BorderRightWidth:
                    layoutData.Write().borderRightWidth = sv.number;
                    break;
                case StylePropertyId.BorderTopColor:
                    visualData.Write().borderTopColor = sv.color;
                    break;
                case StylePropertyId.BorderTopLeftRadius:
                    visualData.Write().borderTopLeftRadius = sv.length;
                    break;
                case StylePropertyId.BorderTopRightRadius:
                    visualData.Write().borderTopRightRadius = sv.length;
                    break;
                case StylePropertyId.BorderTopWidth:
                    layoutData.Write().borderTopWidth = sv.number;
                    break;
                case StylePropertyId.Bottom:
                    layoutData.Write().bottom = sv.length;
                    break;
                case StylePropertyId.Color:
                    inheritedData.Write().color = sv.color;
                    break;
                case StylePropertyId.Display:
                    layoutData.Write().display = (DisplayStyle)sv.number;
                    if (sv.keyword == StyleKeyword.None)
                        layoutData.Write().display = DisplayStyle.None;
                    break;
                case StylePropertyId.FlexBasis:
                    layoutData.Write().flexBasis = sv.length;
                    break;
                case StylePropertyId.FlexDirection:
                    layoutData.Write().flexDirection = (FlexDirection)sv.number;
                    break;
                case StylePropertyId.FlexGrow:
                    layoutData.Write().flexGrow = sv.number;
                    break;
                case StylePropertyId.FlexShrink:
                    layoutData.Write().flexShrink = sv.number;
                    break;
                case StylePropertyId.FlexWrap:
                    layoutData.Write().flexWrap = (Wrap)sv.number;
                    break;
                case StylePropertyId.FontSize:
                    inheritedData.Write().fontSize = sv.length;
                    break;
                case StylePropertyId.Height:
                    layoutData.Write().height = sv.length;
                    break;
                case StylePropertyId.JustifyContent:
                    layoutData.Write().justifyContent = (Justify)sv.number;
                    break;
                case StylePropertyId.Left:
                    layoutData.Write().left = sv.length;
                    break;
                case StylePropertyId.LetterSpacing:
                    inheritedData.Write().letterSpacing = sv.length;
                    break;
                case StylePropertyId.MarginBottom:
                    layoutData.Write().marginBottom = sv.length;
                    break;
                case StylePropertyId.MarginLeft:
                    layoutData.Write().marginLeft = sv.length;
                    break;
                case StylePropertyId.MarginRight:
                    layoutData.Write().marginRight = sv.length;
                    break;
                case StylePropertyId.MarginTop:
                    layoutData.Write().marginTop = sv.length;
                    break;
                case StylePropertyId.MaxHeight:
                    layoutData.Write().maxHeight = sv.length;
                    break;
                case StylePropertyId.MaxWidth:
                    layoutData.Write().maxWidth = sv.length;
                    break;
                case StylePropertyId.MinHeight:
                    layoutData.Write().minHeight = sv.length;
                    break;
                case StylePropertyId.MinWidth:
                    layoutData.Write().minWidth = sv.length;
                    break;
                case StylePropertyId.Opacity:
                    visualData.Write().opacity = sv.number;
                    break;
                case StylePropertyId.Overflow:
                    visualData.Write().overflow = (OverflowInternal)sv.number;
                    break;
                case StylePropertyId.PaddingBottom:
                    layoutData.Write().paddingBottom = sv.length;
                    break;
                case StylePropertyId.PaddingLeft:
                    layoutData.Write().paddingLeft = sv.length;
                    break;
                case StylePropertyId.PaddingRight:
                    layoutData.Write().paddingRight = sv.length;
                    break;
                case StylePropertyId.PaddingTop:
                    layoutData.Write().paddingTop = sv.length;
                    break;
                case StylePropertyId.Position:
                    layoutData.Write().position = (Position)sv.number;
                    break;
                case StylePropertyId.Right:
                    layoutData.Write().right = sv.length;
                    break;
                case StylePropertyId.TextOverflow:
                    rareData.Write().textOverflow = (TextOverflow)sv.number;
                    break;
                case StylePropertyId.Top:
                    layoutData.Write().top = sv.length;
                    break;
                case StylePropertyId.UnityBackgroundImageTintColor:
                    rareData.Write().unityBackgroundImageTintColor = sv.color;
                    break;
                case StylePropertyId.UnityEditorTextRenderingMode:
                    inheritedData.Write().unityEditorTextRenderingMode = (EditorTextRenderingMode)sv.number;
                    break;
                case StylePropertyId.UnityFont:
                    inheritedData.Write().unityFont = sv.resource.IsAllocated ? sv.resource.Target as Font : null;
                    break;
                case StylePropertyId.UnityFontDefinition:
                    inheritedData.Write().unityFontDefinition = sv.resource.IsAllocated ? FontDefinition.FromObject(sv.resource.Target) : new FontDefinition();
                    break;
                case StylePropertyId.UnityFontStyleAndWeight:
                    inheritedData.Write().unityFontStyleAndWeight = (FontStyle)sv.number;
                    break;
                case StylePropertyId.UnityOverflowClipBox:
                    rareData.Write().unityOverflowClipBox = (OverflowClipBox)sv.number;
                    break;
                case StylePropertyId.UnityParagraphSpacing:
                    inheritedData.Write().unityParagraphSpacing = sv.length;
                    break;
                case StylePropertyId.UnitySliceBottom:
                    rareData.Write().unitySliceBottom = (int)sv.number;
                    break;
                case StylePropertyId.UnitySliceLeft:
                    rareData.Write().unitySliceLeft = (int)sv.number;
                    break;
                case StylePropertyId.UnitySliceRight:
                    rareData.Write().unitySliceRight = (int)sv.number;
                    break;
                case StylePropertyId.UnitySliceScale:
                    rareData.Write().unitySliceScale = sv.number;
                    break;
                case StylePropertyId.UnitySliceTop:
                    rareData.Write().unitySliceTop = (int)sv.number;
                    break;
                case StylePropertyId.UnitySliceType:
                    rareData.Write().unitySliceType = (SliceType)sv.number;
                    break;
                case StylePropertyId.UnityTextAlign:
                    inheritedData.Write().unityTextAlign = (TextAnchor)sv.number;
                    break;
                case StylePropertyId.UnityTextGenerator:
                    inheritedData.Write().unityTextGenerator = (TextGeneratorType)sv.number;
                    break;
                case StylePropertyId.UnityTextOutlineColor:
                    inheritedData.Write().unityTextOutlineColor = sv.color;
                    break;
                case StylePropertyId.UnityTextOutlineWidth:
                    inheritedData.Write().unityTextOutlineWidth = sv.number;
                    break;
                case StylePropertyId.UnityTextOverflowPosition:
                    rareData.Write().unityTextOverflowPosition = (TextOverflowPosition)sv.number;
                    break;
                case StylePropertyId.Visibility:
                    inheritedData.Write().visibility = (Visibility)sv.number;
                    break;
                case StylePropertyId.WhiteSpace:
                    inheritedData.Write().whiteSpace = (WhiteSpace)sv.number;
                    break;
                case StylePropertyId.Width:
                    layoutData.Write().width = sv.length;
                    break;
                case StylePropertyId.WordSpacing:
                    inheritedData.Write().wordSpacing = sv.length;
                    break;
                default:
                    Debug.LogAssertion($"Unexpected property id {sv.id}");
                    break;
            }
        }

        public void ApplyStyleValueManaged(StyleValueManaged sv, ref ComputedStyle parentStyle)
        {
            if (ApplyGlobalKeyword(sv.id, sv.keyword, ref parentStyle))
                return;
            switch (sv.id)
            {
                case StylePropertyId.TransitionDelay:
                    if (sv.value == null)
                        transitionData.Write().transitionDelay.CopyFrom(InitialStyle.transitionDelay);
                    else
                        transitionData.Write().transitionDelay = sv.value as List<TimeValue>;
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionDuration:
                    if (sv.value == null)
                        transitionData.Write().transitionDuration.CopyFrom(InitialStyle.transitionDuration);
                    else
                        transitionData.Write().transitionDuration = sv.value as List<TimeValue>;
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionProperty:
                    if (sv.value == null)
                        transitionData.Write().transitionProperty.CopyFrom(InitialStyle.transitionProperty);
                    else
                        transitionData.Write().transitionProperty = sv.value as List<StylePropertyName>;
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionTimingFunction:
                    if (sv.value == null)
                        transitionData.Write().transitionTimingFunction.CopyFrom(InitialStyle.transitionTimingFunction);
                    else
                        transitionData.Write().transitionTimingFunction = sv.value as List<EasingFunction>;
                    ResetComputedTransitions();
                    break;
                default:
                    Debug.LogAssertion($"Unexpected property id {sv.id}");
                    break;
            }
        }

        public void ApplyStyleCursor(Cursor cursor)
        {
            rareData.Write().cursor = cursor;
        }

        public void ApplyStyleTextShadow(TextShadow st)
        {
            inheritedData.Write().textShadow = st;
        }

        public void ApplyStyleTextAutoSize(TextAutoSize st)
        {
            rareData.Write().unityTextAutoSize = st;
        }

        public void ApplyFromComputedStyle(StylePropertyId id, ref ComputedStyle other)
        {
            switch (id)
            {
                case StylePropertyId.AlignContent:
                    layoutData.Write().alignContent = other.layoutData.Read().alignContent;
                    break;
                case StylePropertyId.AlignItems:
                    layoutData.Write().alignItems = other.layoutData.Read().alignItems;
                    break;
                case StylePropertyId.AlignSelf:
                    layoutData.Write().alignSelf = other.layoutData.Read().alignSelf;
                    break;
                case StylePropertyId.BackgroundColor:
                    visualData.Write().backgroundColor = other.visualData.Read().backgroundColor;
                    break;
                case StylePropertyId.BackgroundImage:
                    visualData.Write().backgroundImage = other.visualData.Read().backgroundImage;
                    break;
                case StylePropertyId.BackgroundPositionX:
                    visualData.Write().backgroundPositionX = other.visualData.Read().backgroundPositionX;
                    break;
                case StylePropertyId.BackgroundPositionY:
                    visualData.Write().backgroundPositionY = other.visualData.Read().backgroundPositionY;
                    break;
                case StylePropertyId.BackgroundRepeat:
                    visualData.Write().backgroundRepeat = other.visualData.Read().backgroundRepeat;
                    break;
                case StylePropertyId.BackgroundSize:
                    visualData.Write().backgroundSize = other.visualData.Read().backgroundSize;
                    break;
                case StylePropertyId.BorderBottomColor:
                    visualData.Write().borderBottomColor = other.visualData.Read().borderBottomColor;
                    break;
                case StylePropertyId.BorderBottomLeftRadius:
                    visualData.Write().borderBottomLeftRadius = other.visualData.Read().borderBottomLeftRadius;
                    break;
                case StylePropertyId.BorderBottomRightRadius:
                    visualData.Write().borderBottomRightRadius = other.visualData.Read().borderBottomRightRadius;
                    break;
                case StylePropertyId.BorderBottomWidth:
                    layoutData.Write().borderBottomWidth = other.layoutData.Read().borderBottomWidth;
                    break;
                case StylePropertyId.BorderLeftColor:
                    visualData.Write().borderLeftColor = other.visualData.Read().borderLeftColor;
                    break;
                case StylePropertyId.BorderLeftWidth:
                    layoutData.Write().borderLeftWidth = other.layoutData.Read().borderLeftWidth;
                    break;
                case StylePropertyId.BorderRightColor:
                    visualData.Write().borderRightColor = other.visualData.Read().borderRightColor;
                    break;
                case StylePropertyId.BorderRightWidth:
                    layoutData.Write().borderRightWidth = other.layoutData.Read().borderRightWidth;
                    break;
                case StylePropertyId.BorderTopColor:
                    visualData.Write().borderTopColor = other.visualData.Read().borderTopColor;
                    break;
                case StylePropertyId.BorderTopLeftRadius:
                    visualData.Write().borderTopLeftRadius = other.visualData.Read().borderTopLeftRadius;
                    break;
                case StylePropertyId.BorderTopRightRadius:
                    visualData.Write().borderTopRightRadius = other.visualData.Read().borderTopRightRadius;
                    break;
                case StylePropertyId.BorderTopWidth:
                    layoutData.Write().borderTopWidth = other.layoutData.Read().borderTopWidth;
                    break;
                case StylePropertyId.Bottom:
                    layoutData.Write().bottom = other.layoutData.Read().bottom;
                    break;
                case StylePropertyId.Color:
                    inheritedData.Write().color = other.inheritedData.Read().color;
                    break;
                case StylePropertyId.Cursor:
                    rareData.Write().cursor = other.rareData.Read().cursor;
                    break;
                case StylePropertyId.Display:
                    layoutData.Write().display = other.layoutData.Read().display;
                    break;
                case StylePropertyId.FlexBasis:
                    layoutData.Write().flexBasis = other.layoutData.Read().flexBasis;
                    break;
                case StylePropertyId.FlexDirection:
                    layoutData.Write().flexDirection = other.layoutData.Read().flexDirection;
                    break;
                case StylePropertyId.FlexGrow:
                    layoutData.Write().flexGrow = other.layoutData.Read().flexGrow;
                    break;
                case StylePropertyId.FlexShrink:
                    layoutData.Write().flexShrink = other.layoutData.Read().flexShrink;
                    break;
                case StylePropertyId.FlexWrap:
                    layoutData.Write().flexWrap = other.layoutData.Read().flexWrap;
                    break;
                case StylePropertyId.FontSize:
                    inheritedData.Write().fontSize = other.inheritedData.Read().fontSize;
                    break;
                case StylePropertyId.Height:
                    layoutData.Write().height = other.layoutData.Read().height;
                    break;
                case StylePropertyId.JustifyContent:
                    layoutData.Write().justifyContent = other.layoutData.Read().justifyContent;
                    break;
                case StylePropertyId.Left:
                    layoutData.Write().left = other.layoutData.Read().left;
                    break;
                case StylePropertyId.LetterSpacing:
                    inheritedData.Write().letterSpacing = other.inheritedData.Read().letterSpacing;
                    break;
                case StylePropertyId.MarginBottom:
                    layoutData.Write().marginBottom = other.layoutData.Read().marginBottom;
                    break;
                case StylePropertyId.MarginLeft:
                    layoutData.Write().marginLeft = other.layoutData.Read().marginLeft;
                    break;
                case StylePropertyId.MarginRight:
                    layoutData.Write().marginRight = other.layoutData.Read().marginRight;
                    break;
                case StylePropertyId.MarginTop:
                    layoutData.Write().marginTop = other.layoutData.Read().marginTop;
                    break;
                case StylePropertyId.MaxHeight:
                    layoutData.Write().maxHeight = other.layoutData.Read().maxHeight;
                    break;
                case StylePropertyId.MaxWidth:
                    layoutData.Write().maxWidth = other.layoutData.Read().maxWidth;
                    break;
                case StylePropertyId.MinHeight:
                    layoutData.Write().minHeight = other.layoutData.Read().minHeight;
                    break;
                case StylePropertyId.MinWidth:
                    layoutData.Write().minWidth = other.layoutData.Read().minWidth;
                    break;
                case StylePropertyId.Opacity:
                    visualData.Write().opacity = other.visualData.Read().opacity;
                    break;
                case StylePropertyId.Overflow:
                    visualData.Write().overflow = other.visualData.Read().overflow;
                    break;
                case StylePropertyId.PaddingBottom:
                    layoutData.Write().paddingBottom = other.layoutData.Read().paddingBottom;
                    break;
                case StylePropertyId.PaddingLeft:
                    layoutData.Write().paddingLeft = other.layoutData.Read().paddingLeft;
                    break;
                case StylePropertyId.PaddingRight:
                    layoutData.Write().paddingRight = other.layoutData.Read().paddingRight;
                    break;
                case StylePropertyId.PaddingTop:
                    layoutData.Write().paddingTop = other.layoutData.Read().paddingTop;
                    break;
                case StylePropertyId.Position:
                    layoutData.Write().position = other.layoutData.Read().position;
                    break;
                case StylePropertyId.Right:
                    layoutData.Write().right = other.layoutData.Read().right;
                    break;
                case StylePropertyId.Rotate:
                    transformData.Write().rotate = other.transformData.Read().rotate;
                    break;
                case StylePropertyId.Scale:
                    transformData.Write().scale = other.transformData.Read().scale;
                    break;
                case StylePropertyId.TextOverflow:
                    rareData.Write().textOverflow = other.rareData.Read().textOverflow;
                    break;
                case StylePropertyId.TextShadow:
                    inheritedData.Write().textShadow = other.inheritedData.Read().textShadow;
                    break;
                case StylePropertyId.Top:
                    layoutData.Write().top = other.layoutData.Read().top;
                    break;
                case StylePropertyId.TransformOrigin:
                    transformData.Write().transformOrigin = other.transformData.Read().transformOrigin;
                    break;
                case StylePropertyId.TransitionDelay:
                    transitionData.Write().transitionDelay.CopyFrom(other.transitionData.Read().transitionDelay);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionDuration:
                    transitionData.Write().transitionDuration.CopyFrom(other.transitionData.Read().transitionDuration);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionProperty:
                    transitionData.Write().transitionProperty.CopyFrom(other.transitionData.Read().transitionProperty);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionTimingFunction:
                    transitionData.Write().transitionTimingFunction.CopyFrom(other.transitionData.Read().transitionTimingFunction);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.Translate:
                    transformData.Write().translate = other.transformData.Read().translate;
                    break;
                case StylePropertyId.UnityBackgroundImageTintColor:
                    rareData.Write().unityBackgroundImageTintColor = other.rareData.Read().unityBackgroundImageTintColor;
                    break;
                case StylePropertyId.UnityEditorTextRenderingMode:
                    inheritedData.Write().unityEditorTextRenderingMode = other.inheritedData.Read().unityEditorTextRenderingMode;
                    break;
                case StylePropertyId.UnityFont:
                    inheritedData.Write().unityFont = other.inheritedData.Read().unityFont;
                    break;
                case StylePropertyId.UnityFontDefinition:
                    inheritedData.Write().unityFontDefinition = other.inheritedData.Read().unityFontDefinition;
                    break;
                case StylePropertyId.UnityFontStyleAndWeight:
                    inheritedData.Write().unityFontStyleAndWeight = other.inheritedData.Read().unityFontStyleAndWeight;
                    break;
                case StylePropertyId.UnityOverflowClipBox:
                    rareData.Write().unityOverflowClipBox = other.rareData.Read().unityOverflowClipBox;
                    break;
                case StylePropertyId.UnityParagraphSpacing:
                    inheritedData.Write().unityParagraphSpacing = other.inheritedData.Read().unityParagraphSpacing;
                    break;
                case StylePropertyId.UnitySliceBottom:
                    rareData.Write().unitySliceBottom = other.rareData.Read().unitySliceBottom;
                    break;
                case StylePropertyId.UnitySliceLeft:
                    rareData.Write().unitySliceLeft = other.rareData.Read().unitySliceLeft;
                    break;
                case StylePropertyId.UnitySliceRight:
                    rareData.Write().unitySliceRight = other.rareData.Read().unitySliceRight;
                    break;
                case StylePropertyId.UnitySliceScale:
                    rareData.Write().unitySliceScale = other.rareData.Read().unitySliceScale;
                    break;
                case StylePropertyId.UnitySliceTop:
                    rareData.Write().unitySliceTop = other.rareData.Read().unitySliceTop;
                    break;
                case StylePropertyId.UnitySliceType:
                    rareData.Write().unitySliceType = other.rareData.Read().unitySliceType;
                    break;
                case StylePropertyId.UnityTextAlign:
                    inheritedData.Write().unityTextAlign = other.inheritedData.Read().unityTextAlign;
                    break;
                case StylePropertyId.UnityTextAutoSize:
                    rareData.Write().unityTextAutoSize = other.rareData.Read().unityTextAutoSize;
                    break;
                case StylePropertyId.UnityTextGenerator:
                    inheritedData.Write().unityTextGenerator = other.inheritedData.Read().unityTextGenerator;
                    break;
                case StylePropertyId.UnityTextOutlineColor:
                    inheritedData.Write().unityTextOutlineColor = other.inheritedData.Read().unityTextOutlineColor;
                    break;
                case StylePropertyId.UnityTextOutlineWidth:
                    inheritedData.Write().unityTextOutlineWidth = other.inheritedData.Read().unityTextOutlineWidth;
                    break;
                case StylePropertyId.UnityTextOverflowPosition:
                    rareData.Write().unityTextOverflowPosition = other.rareData.Read().unityTextOverflowPosition;
                    break;
                case StylePropertyId.Visibility:
                    inheritedData.Write().visibility = other.inheritedData.Read().visibility;
                    break;
                case StylePropertyId.WhiteSpace:
                    inheritedData.Write().whiteSpace = other.inheritedData.Read().whiteSpace;
                    break;
                case StylePropertyId.Width:
                    layoutData.Write().width = other.layoutData.Read().width;
                    break;
                case StylePropertyId.WordSpacing:
                    inheritedData.Write().wordSpacing = other.inheritedData.Read().wordSpacing;
                    break;
                default:
                    Debug.LogAssertion($"Unexpected property id {id}");
                    break;
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Length newValue)
        {
            switch (id)
            {
                case StylePropertyId.BorderBottomLeftRadius:
                    visualData.Write().borderBottomLeftRadius = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderRadius | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderBottomRightRadius:
                    visualData.Write().borderBottomRightRadius = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderRadius | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderTopLeftRadius:
                    visualData.Write().borderTopLeftRadius = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderRadius | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderTopRightRadius:
                    visualData.Write().borderTopRightRadius = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderRadius | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.Bottom:
                    layoutData.Write().bottom = newValue;
                    ve.layoutNode.Bottom = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.FlexBasis:
                    layoutData.Write().flexBasis = newValue;
                    ve.layoutNode.FlexBasis = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.FontSize:
                    inheritedData.Write().fontSize = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                case StylePropertyId.Height:
                    layoutData.Write().height = newValue;
                    ve.layoutNode.Height = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.Left:
                    layoutData.Write().left = newValue;
                    ve.layoutNode.Left = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.LetterSpacing:
                    inheritedData.Write().letterSpacing = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                case StylePropertyId.MarginBottom:
                    layoutData.Write().marginBottom = newValue;
                    ve.layoutNode.MarginBottom = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MarginLeft:
                    layoutData.Write().marginLeft = newValue;
                    ve.layoutNode.MarginLeft = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MarginRight:
                    layoutData.Write().marginRight = newValue;
                    ve.layoutNode.MarginRight = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MarginTop:
                    layoutData.Write().marginTop = newValue;
                    ve.layoutNode.MarginTop = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MaxHeight:
                    layoutData.Write().maxHeight = newValue;
                    ve.layoutNode.MaxHeight = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MaxWidth:
                    layoutData.Write().maxWidth = newValue;
                    ve.layoutNode.MaxWidth = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MinHeight:
                    layoutData.Write().minHeight = newValue;
                    ve.layoutNode.MinHeight = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.MinWidth:
                    layoutData.Write().minWidth = newValue;
                    ve.layoutNode.MinWidth = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.PaddingBottom:
                    layoutData.Write().paddingBottom = newValue;
                    ve.layoutNode.PaddingBottom = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.PaddingLeft:
                    layoutData.Write().paddingLeft = newValue;
                    ve.layoutNode.PaddingLeft = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.PaddingRight:
                    layoutData.Write().paddingRight = newValue;
                    ve.layoutNode.PaddingRight = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.PaddingTop:
                    layoutData.Write().paddingTop = newValue;
                    ve.layoutNode.PaddingTop = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.Right:
                    layoutData.Write().right = newValue;
                    ve.layoutNode.Right = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.Top:
                    layoutData.Write().top = newValue;
                    ve.layoutNode.Top = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.UnityParagraphSpacing:
                    inheritedData.Write().unityParagraphSpacing = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                case StylePropertyId.Width:
                    layoutData.Write().width = newValue;
                    ve.layoutNode.Width = newValue.ToLayoutValue();
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.WordSpacing:
                    inheritedData.Write().wordSpacing = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Length' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, float newValue)
        {
            switch (id)
            {
                case StylePropertyId.BorderBottomWidth:
                    layoutData.Write().borderBottomWidth = newValue;
                    ve.layoutNode.BorderBottomWidth = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderWidth | VersionChangeType.Layout | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderLeftWidth:
                    layoutData.Write().borderLeftWidth = newValue;
                    ve.layoutNode.BorderLeftWidth = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderWidth | VersionChangeType.Layout | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderRightWidth:
                    layoutData.Write().borderRightWidth = newValue;
                    ve.layoutNode.BorderRightWidth = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderWidth | VersionChangeType.Layout | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.BorderTopWidth:
                    layoutData.Write().borderTopWidth = newValue;
                    ve.layoutNode.BorderTopWidth = newValue;
                    ve.IncrementVersion(VersionChangeType.BorderWidth | VersionChangeType.Layout | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.FlexGrow:
                    layoutData.Write().flexGrow = newValue;
                    ve.layoutNode.FlexGrow = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.FlexShrink:
                    layoutData.Write().flexShrink = newValue;
                    ve.layoutNode.FlexShrink = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout);
                    break;
                case StylePropertyId.Opacity:
                    visualData.Write().opacity = newValue;
                    ve.IncrementVersion(VersionChangeType.Opacity);
                    break;
                case StylePropertyId.UnitySliceScale:
                    rareData.Write().unitySliceScale = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint);
                    break;
                case StylePropertyId.UnityTextOutlineWidth:
                    inheritedData.Write().unityTextOutlineWidth = newValue;
                    ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'float' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, int newValue)
        {
            switch (id)
            {
                case StylePropertyId.AlignContent:
                    if (layoutData.Read().alignContent != (Align)newValue)
                    {
                        layoutData.Write().alignContent = (Align)newValue;
                        ve.layoutNode.AlignContent = (LayoutAlign)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.AlignItems:
                    if (layoutData.Read().alignItems != (Align)newValue)
                    {
                        layoutData.Write().alignItems = (Align)newValue;
                        ve.layoutNode.AlignItems = (LayoutAlign)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.AlignSelf:
                    if (layoutData.Read().alignSelf != (Align)newValue)
                    {
                        layoutData.Write().alignSelf = (Align)newValue;
                        ve.layoutNode.AlignSelf = (LayoutAlign)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.FlexDirection:
                    if (layoutData.Read().flexDirection != (FlexDirection)newValue)
                    {
                        layoutData.Write().flexDirection = (FlexDirection)newValue;
                        ve.layoutNode.FlexDirection = (LayoutFlexDirection)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.FlexWrap:
                    if (layoutData.Read().flexWrap != (Wrap)newValue)
                    {
                        layoutData.Write().flexWrap = (Wrap)newValue;
                        ve.layoutNode.Wrap = (LayoutWrap)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.JustifyContent:
                    if (layoutData.Read().justifyContent != (Justify)newValue)
                    {
                        layoutData.Write().justifyContent = (Justify)newValue;
                        ve.layoutNode.JustifyContent = (LayoutJustify)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.Overflow:
                    if (visualData.Read().overflow != (OverflowInternal)newValue)
                    {
                        visualData.Write().overflow = (OverflowInternal)newValue;
                        ve.layoutNode.Overflow = (LayoutOverflow)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Overflow);
                    }

                    break;
                case StylePropertyId.Position:
                    if (layoutData.Read().position != (Position)newValue)
                    {
                        layoutData.Write().position = (Position)newValue;
                        ve.layoutNode.PositionType = (LayoutPositionType)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout);
                    }

                    break;
                case StylePropertyId.TextOverflow:
                    if (rareData.Read().textOverflow != (TextOverflow)newValue)
                    {
                        rareData.Write().textOverflow = (TextOverflow)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint);
                    }

                    break;
                case StylePropertyId.UnityFontStyleAndWeight:
                    if (inheritedData.Read().unityFontStyleAndWeight != (FontStyle)newValue)
                    {
                        inheritedData.Write().unityFontStyleAndWeight = (FontStyle)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    }

                    break;
                case StylePropertyId.UnityOverflowClipBox:
                    if (rareData.Read().unityOverflowClipBox != (OverflowClipBox)newValue)
                    {
                        rareData.Write().unityOverflowClipBox = (OverflowClipBox)newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                case StylePropertyId.UnitySliceBottom:
                    rareData.Write().unitySliceBottom = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint);
                    break;
                case StylePropertyId.UnitySliceLeft:
                    rareData.Write().unitySliceLeft = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint);
                    break;
                case StylePropertyId.UnitySliceRight:
                    rareData.Write().unitySliceRight = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint);
                    break;
                case StylePropertyId.UnitySliceTop:
                    rareData.Write().unitySliceTop = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint);
                    break;
                case StylePropertyId.UnitySliceType:
                    if (rareData.Read().unitySliceType != (SliceType)newValue)
                    {
                        rareData.Write().unitySliceType = (SliceType)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint);
                    }

                    break;
                case StylePropertyId.UnityTextAlign:
                    if (inheritedData.Read().unityTextAlign != (TextAnchor)newValue)
                    {
                        inheritedData.Write().unityTextAlign = (TextAnchor)newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    }

                    break;
                case StylePropertyId.UnityTextOverflowPosition:
                    if (rareData.Read().unityTextOverflowPosition != (TextOverflowPosition)newValue)
                    {
                        rareData.Write().unityTextOverflowPosition = (TextOverflowPosition)newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                case StylePropertyId.Visibility:
                    if (inheritedData.Read().visibility != (Visibility)newValue)
                    {
                        inheritedData.Write().visibility = (Visibility)newValue;
                        ve.IncrementVersion(VersionChangeType.Picking | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    }

                    break;
                case StylePropertyId.WhiteSpace:
                    if (inheritedData.Read().whiteSpace != (WhiteSpace)newValue)
                    {
                        inheritedData.Write().whiteSpace = (WhiteSpace)newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.StyleSheet);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'int' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, BackgroundPosition newValue)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundPositionX:
                    if (visualData.Read().backgroundPositionX != newValue)
                    {
                        visualData.Write().backgroundPositionX = newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                case StylePropertyId.BackgroundPositionY:
                    if (visualData.Read().backgroundPositionY != newValue)
                    {
                        visualData.Write().backgroundPositionY = newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'BackgroundPosition' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, BackgroundRepeat newValue)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundRepeat:
                    if (visualData.Read().backgroundRepeat != newValue)
                    {
                        visualData.Write().backgroundRepeat = newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'BackgroundRepeat' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, BackgroundSize newValue)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundSize:
                    visualData.Write().backgroundSize = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'BackgroundSize' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Color newValue)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundColor:
                    visualData.Write().backgroundColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.BorderBottomColor:
                    visualData.Write().borderBottomColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.BorderLeftColor:
                    visualData.Write().borderLeftColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.BorderRightColor:
                    visualData.Write().borderRightColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.BorderTopColor:
                    visualData.Write().borderTopColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.Color:
                    inheritedData.Write().color = newValue;
                    ve.IncrementVersion(VersionChangeType.Color | VersionChangeType.StyleSheet);
                    break;
                case StylePropertyId.UnityBackgroundImageTintColor:
                    rareData.Write().unityBackgroundImageTintColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Color);
                    break;
                case StylePropertyId.UnityTextOutlineColor:
                    inheritedData.Write().unityTextOutlineColor = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Color' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Background newValue)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundImage:
                    if (visualData.Read().backgroundImage != newValue)
                    {
                        visualData.Write().backgroundImage = newValue;
                        ve.IncrementVersion(VersionChangeType.Repaint);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Background' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Font newValue)
        {
            switch (id)
            {
                case StylePropertyId.UnityFont:
                    if (inheritedData.Read().unityFont != newValue)
                    {
                        inheritedData.Write().unityFont = newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Font' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, FontDefinition newValue)
        {
            switch (id)
            {
                case StylePropertyId.UnityFontDefinition:
                    if (inheritedData.Read().unityFontDefinition != newValue)
                    {
                        inheritedData.Write().unityFontDefinition = newValue;
                        ve.IncrementVersion(VersionChangeType.Layout | VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    }

                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'FontDefinition' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, TextShadow newValue)
        {
            switch (id)
            {
                case StylePropertyId.TextShadow:
                    inheritedData.Write().textShadow = newValue;
                    ve.IncrementVersion(VersionChangeType.Repaint | VersionChangeType.StyleSheet);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'TextShadow' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Translate newValue)
        {
            switch (id)
            {
                case StylePropertyId.Translate:
                    transformData.Write().translate = newValue;
                    ve.IncrementVersion(VersionChangeType.Transform);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Translate' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, TransformOrigin newValue)
        {
            switch (id)
            {
                case StylePropertyId.TransformOrigin:
                    transformData.Write().transformOrigin = newValue;
                    ve.IncrementVersion(VersionChangeType.Transform);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'TransformOrigin' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Rotate newValue)
        {
            switch (id)
            {
                case StylePropertyId.Rotate:
                    transformData.Write().rotate = newValue;
                    ve.IncrementVersion(VersionChangeType.Transform);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Rotate' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public void ApplyPropertyAnimation(VisualElement ve, StylePropertyId id, Scale newValue)
        {
            switch (id)
            {
                case StylePropertyId.Scale:
                    transformData.Write().scale = newValue;
                    ve.IncrementVersion(VersionChangeType.Transform);
                    break;
                default:
                    throw new ArgumentException("Invalid animation property id. Can't apply value of type 'Scale' to property '" + id + "'. Please make sure that this property is animatable.", nameof(id));
            }
        }

        public static bool StartAnimation(VisualElement element, StylePropertyId id, ref ComputedStyle oldStyle, ref ComputedStyle newStyle, int durationMs, int delayMs, Func<float, float> easingCurve)
        {
            switch (id)
            {
                case StylePropertyId.AlignContent:
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignContent, (int)oldStyle.layoutData.Read().alignContent, (int)newStyle.layoutData.Read().alignContent, durationMs, delayMs, easingCurve);
                case StylePropertyId.AlignItems:
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignItems, (int)oldStyle.layoutData.Read().alignItems, (int)newStyle.layoutData.Read().alignItems, durationMs, delayMs, easingCurve);
                case StylePropertyId.AlignSelf:
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignSelf, (int)oldStyle.layoutData.Read().alignSelf, (int)newStyle.layoutData.Read().alignSelf, durationMs, delayMs, easingCurve);
                case StylePropertyId.All:
                    return StartAnimationAllProperty(element, ref oldStyle, ref newStyle, durationMs, delayMs, easingCurve);
                case StylePropertyId.BackgroundColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.BackgroundColor, oldStyle.visualData.Read().backgroundColor, newStyle.visualData.Read().backgroundColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BackgroundImage:
                    return element.styleAnimation.Start(StylePropertyId.BackgroundImage, oldStyle.visualData.Read().backgroundImage, newStyle.visualData.Read().backgroundImage, durationMs, delayMs, easingCurve);
                case StylePropertyId.BackgroundPosition:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionX, oldStyle.visualData.Read().backgroundPositionX, newStyle.visualData.Read().backgroundPositionX, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionY, oldStyle.visualData.Read().backgroundPositionY, newStyle.visualData.Read().backgroundPositionY, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.BackgroundPositionX:
                    return element.styleAnimation.Start(StylePropertyId.BackgroundPositionX, oldStyle.visualData.Read().backgroundPositionX, newStyle.visualData.Read().backgroundPositionX, durationMs, delayMs, easingCurve);
                case StylePropertyId.BackgroundPositionY:
                    return element.styleAnimation.Start(StylePropertyId.BackgroundPositionY, oldStyle.visualData.Read().backgroundPositionY, newStyle.visualData.Read().backgroundPositionY, durationMs, delayMs, easingCurve);
                case StylePropertyId.BackgroundRepeat:
                    return element.styleAnimation.Start(StylePropertyId.BackgroundRepeat, oldStyle.visualData.Read().backgroundRepeat, newStyle.visualData.Read().backgroundRepeat, durationMs, delayMs, easingCurve);
                case StylePropertyId.BackgroundSize:
                    return element.styleAnimation.Start(StylePropertyId.BackgroundSize, oldStyle.visualData.Read().backgroundSize, newStyle.visualData.Read().backgroundSize, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderBottomColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.BorderBottomColor, oldStyle.visualData.Read().borderBottomColor, newStyle.visualData.Read().borderBottomColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderBottomLeftRadius:
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomLeftRadius, oldStyle.visualData.Read().borderBottomLeftRadius, newStyle.visualData.Read().borderBottomLeftRadius, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderBottomRightRadius:
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomRightRadius, oldStyle.visualData.Read().borderBottomRightRadius, newStyle.visualData.Read().borderBottomRightRadius, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderBottomWidth:
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomWidth, oldStyle.layoutData.Read().borderBottomWidth, newStyle.layoutData.Read().borderBottomWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderColor:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopColor, oldStyle.visualData.Read().borderTopColor, newStyle.visualData.Read().borderTopColor, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderRightColor, oldStyle.visualData.Read().borderRightColor, newStyle.visualData.Read().borderRightColor, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomColor, oldStyle.visualData.Read().borderBottomColor, newStyle.visualData.Read().borderBottomColor, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderLeftColor, oldStyle.visualData.Read().borderLeftColor, newStyle.visualData.Read().borderLeftColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderLeftColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.BorderLeftColor, oldStyle.visualData.Read().borderLeftColor, newStyle.visualData.Read().borderLeftColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderLeftWidth:
                    return element.styleAnimation.Start(StylePropertyId.BorderLeftWidth, oldStyle.layoutData.Read().borderLeftWidth, newStyle.layoutData.Read().borderLeftWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderRadius:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopLeftRadius, oldStyle.visualData.Read().borderTopLeftRadius, newStyle.visualData.Read().borderTopLeftRadius, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopRightRadius, oldStyle.visualData.Read().borderTopRightRadius, newStyle.visualData.Read().borderTopRightRadius, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomRightRadius, oldStyle.visualData.Read().borderBottomRightRadius, newStyle.visualData.Read().borderBottomRightRadius, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomLeftRadius, oldStyle.visualData.Read().borderBottomLeftRadius, newStyle.visualData.Read().borderBottomLeftRadius, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.BorderRightColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.BorderRightColor, oldStyle.visualData.Read().borderRightColor, newStyle.visualData.Read().borderRightColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderRightWidth:
                    return element.styleAnimation.Start(StylePropertyId.BorderRightWidth, oldStyle.layoutData.Read().borderRightWidth, newStyle.layoutData.Read().borderRightWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderTopColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.BorderTopColor, oldStyle.visualData.Read().borderTopColor, newStyle.visualData.Read().borderTopColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderTopLeftRadius:
                    return element.styleAnimation.Start(StylePropertyId.BorderTopLeftRadius, oldStyle.visualData.Read().borderTopLeftRadius, newStyle.visualData.Read().borderTopLeftRadius, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderTopRightRadius:
                    return element.styleAnimation.Start(StylePropertyId.BorderTopRightRadius, oldStyle.visualData.Read().borderTopRightRadius, newStyle.visualData.Read().borderTopRightRadius, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderTopWidth:
                    return element.styleAnimation.Start(StylePropertyId.BorderTopWidth, oldStyle.layoutData.Read().borderTopWidth, newStyle.layoutData.Read().borderTopWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.BorderWidth:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopWidth, oldStyle.layoutData.Read().borderTopWidth, newStyle.layoutData.Read().borderTopWidth, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderRightWidth, oldStyle.layoutData.Read().borderRightWidth, newStyle.layoutData.Read().borderRightWidth, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomWidth, oldStyle.layoutData.Read().borderBottomWidth, newStyle.layoutData.Read().borderBottomWidth, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BorderLeftWidth, oldStyle.layoutData.Read().borderLeftWidth, newStyle.layoutData.Read().borderLeftWidth, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.Bottom:
                    return element.styleAnimation.Start(StylePropertyId.Bottom, oldStyle.layoutData.Read().bottom, newStyle.layoutData.Read().bottom, durationMs, delayMs, easingCurve);
                case StylePropertyId.Color:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.Color, oldStyle.inheritedData.Read().color, newStyle.inheritedData.Read().color, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.Flex:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.FlexGrow, oldStyle.layoutData.Read().flexGrow, newStyle.layoutData.Read().flexGrow, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.FlexShrink, oldStyle.layoutData.Read().flexShrink, newStyle.layoutData.Read().flexShrink, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.FlexBasis, oldStyle.layoutData.Read().flexBasis, newStyle.layoutData.Read().flexBasis, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.FlexBasis:
                    return element.styleAnimation.Start(StylePropertyId.FlexBasis, oldStyle.layoutData.Read().flexBasis, newStyle.layoutData.Read().flexBasis, durationMs, delayMs, easingCurve);
                case StylePropertyId.FlexDirection:
                    return element.styleAnimation.StartEnum(StylePropertyId.FlexDirection, (int)oldStyle.layoutData.Read().flexDirection, (int)newStyle.layoutData.Read().flexDirection, durationMs, delayMs, easingCurve);
                case StylePropertyId.FlexGrow:
                    return element.styleAnimation.Start(StylePropertyId.FlexGrow, oldStyle.layoutData.Read().flexGrow, newStyle.layoutData.Read().flexGrow, durationMs, delayMs, easingCurve);
                case StylePropertyId.FlexShrink:
                    return element.styleAnimation.Start(StylePropertyId.FlexShrink, oldStyle.layoutData.Read().flexShrink, newStyle.layoutData.Read().flexShrink, durationMs, delayMs, easingCurve);
                case StylePropertyId.FlexWrap:
                    return element.styleAnimation.StartEnum(StylePropertyId.FlexWrap, (int)oldStyle.layoutData.Read().flexWrap, (int)newStyle.layoutData.Read().flexWrap, durationMs, delayMs, easingCurve);
                case StylePropertyId.FontSize:
                    return element.styleAnimation.Start(StylePropertyId.FontSize, oldStyle.inheritedData.Read().fontSize, newStyle.inheritedData.Read().fontSize, durationMs, delayMs, easingCurve);
                case StylePropertyId.Height:
                    return element.styleAnimation.Start(StylePropertyId.Height, oldStyle.layoutData.Read().height, newStyle.layoutData.Read().height, durationMs, delayMs, easingCurve);
                case StylePropertyId.JustifyContent:
                    return element.styleAnimation.StartEnum(StylePropertyId.JustifyContent, (int)oldStyle.layoutData.Read().justifyContent, (int)newStyle.layoutData.Read().justifyContent, durationMs, delayMs, easingCurve);
                case StylePropertyId.Left:
                    return element.styleAnimation.Start(StylePropertyId.Left, oldStyle.layoutData.Read().left, newStyle.layoutData.Read().left, durationMs, delayMs, easingCurve);
                case StylePropertyId.LetterSpacing:
                    return element.styleAnimation.Start(StylePropertyId.LetterSpacing, oldStyle.inheritedData.Read().letterSpacing, newStyle.inheritedData.Read().letterSpacing, durationMs, delayMs, easingCurve);
                case StylePropertyId.Margin:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.MarginTop, oldStyle.layoutData.Read().marginTop, newStyle.layoutData.Read().marginTop, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.MarginRight, oldStyle.layoutData.Read().marginRight, newStyle.layoutData.Read().marginRight, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.MarginBottom, oldStyle.layoutData.Read().marginBottom, newStyle.layoutData.Read().marginBottom, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.MarginLeft, oldStyle.layoutData.Read().marginLeft, newStyle.layoutData.Read().marginLeft, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.MarginBottom:
                    return element.styleAnimation.Start(StylePropertyId.MarginBottom, oldStyle.layoutData.Read().marginBottom, newStyle.layoutData.Read().marginBottom, durationMs, delayMs, easingCurve);
                case StylePropertyId.MarginLeft:
                    return element.styleAnimation.Start(StylePropertyId.MarginLeft, oldStyle.layoutData.Read().marginLeft, newStyle.layoutData.Read().marginLeft, durationMs, delayMs, easingCurve);
                case StylePropertyId.MarginRight:
                    return element.styleAnimation.Start(StylePropertyId.MarginRight, oldStyle.layoutData.Read().marginRight, newStyle.layoutData.Read().marginRight, durationMs, delayMs, easingCurve);
                case StylePropertyId.MarginTop:
                    return element.styleAnimation.Start(StylePropertyId.MarginTop, oldStyle.layoutData.Read().marginTop, newStyle.layoutData.Read().marginTop, durationMs, delayMs, easingCurve);
                case StylePropertyId.MaxHeight:
                    return element.styleAnimation.Start(StylePropertyId.MaxHeight, oldStyle.layoutData.Read().maxHeight, newStyle.layoutData.Read().maxHeight, durationMs, delayMs, easingCurve);
                case StylePropertyId.MaxWidth:
                    return element.styleAnimation.Start(StylePropertyId.MaxWidth, oldStyle.layoutData.Read().maxWidth, newStyle.layoutData.Read().maxWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.MinHeight:
                    return element.styleAnimation.Start(StylePropertyId.MinHeight, oldStyle.layoutData.Read().minHeight, newStyle.layoutData.Read().minHeight, durationMs, delayMs, easingCurve);
                case StylePropertyId.MinWidth:
                    return element.styleAnimation.Start(StylePropertyId.MinWidth, oldStyle.layoutData.Read().minWidth, newStyle.layoutData.Read().minWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.Opacity:
                    return element.styleAnimation.Start(StylePropertyId.Opacity, oldStyle.visualData.Read().opacity, newStyle.visualData.Read().opacity, durationMs, delayMs, easingCurve);
                case StylePropertyId.Overflow:
                    return element.styleAnimation.StartEnum(StylePropertyId.Overflow, (int)oldStyle.visualData.Read().overflow, (int)newStyle.visualData.Read().overflow, durationMs, delayMs, easingCurve);
                case StylePropertyId.Padding:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingTop, oldStyle.layoutData.Read().paddingTop, newStyle.layoutData.Read().paddingTop, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingRight, oldStyle.layoutData.Read().paddingRight, newStyle.layoutData.Read().paddingRight, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingBottom, oldStyle.layoutData.Read().paddingBottom, newStyle.layoutData.Read().paddingBottom, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingLeft, oldStyle.layoutData.Read().paddingLeft, newStyle.layoutData.Read().paddingLeft, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.PaddingBottom:
                    return element.styleAnimation.Start(StylePropertyId.PaddingBottom, oldStyle.layoutData.Read().paddingBottom, newStyle.layoutData.Read().paddingBottom, durationMs, delayMs, easingCurve);
                case StylePropertyId.PaddingLeft:
                    return element.styleAnimation.Start(StylePropertyId.PaddingLeft, oldStyle.layoutData.Read().paddingLeft, newStyle.layoutData.Read().paddingLeft, durationMs, delayMs, easingCurve);
                case StylePropertyId.PaddingRight:
                    return element.styleAnimation.Start(StylePropertyId.PaddingRight, oldStyle.layoutData.Read().paddingRight, newStyle.layoutData.Read().paddingRight, durationMs, delayMs, easingCurve);
                case StylePropertyId.PaddingTop:
                    return element.styleAnimation.Start(StylePropertyId.PaddingTop, oldStyle.layoutData.Read().paddingTop, newStyle.layoutData.Read().paddingTop, durationMs, delayMs, easingCurve);
                case StylePropertyId.Position:
                    return element.styleAnimation.StartEnum(StylePropertyId.Position, (int)oldStyle.layoutData.Read().position, (int)newStyle.layoutData.Read().position, durationMs, delayMs, easingCurve);
                case StylePropertyId.Right:
                    return element.styleAnimation.Start(StylePropertyId.Right, oldStyle.layoutData.Read().right, newStyle.layoutData.Read().right, durationMs, delayMs, easingCurve);
                case StylePropertyId.Rotate:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.Rotate, oldStyle.transformData.Read().rotate, newStyle.transformData.Read().rotate, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicTransform) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicTransform;
                    }

                    return result;
                }

                case StylePropertyId.Scale:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.Scale, oldStyle.transformData.Read().scale, newStyle.transformData.Read().scale, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicTransform) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicTransform;
                    }

                    return result;
                }

                case StylePropertyId.TextOverflow:
                    return element.styleAnimation.StartEnum(StylePropertyId.TextOverflow, (int)oldStyle.rareData.Read().textOverflow, (int)newStyle.rareData.Read().textOverflow, durationMs, delayMs, easingCurve);
                case StylePropertyId.TextShadow:
                    return element.styleAnimation.Start(StylePropertyId.TextShadow, oldStyle.inheritedData.Read().textShadow, newStyle.inheritedData.Read().textShadow, durationMs, delayMs, easingCurve);
                case StylePropertyId.Top:
                    return element.styleAnimation.Start(StylePropertyId.Top, oldStyle.layoutData.Read().top, newStyle.layoutData.Read().top, durationMs, delayMs, easingCurve);
                case StylePropertyId.TransformOrigin:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.TransformOrigin, oldStyle.transformData.Read().transformOrigin, newStyle.transformData.Read().transformOrigin, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicTransform) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicTransform;
                    }

                    return result;
                }

                case StylePropertyId.Translate:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.Translate, oldStyle.transformData.Read().translate, newStyle.transformData.Read().translate, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicTransform) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicTransform;
                    }

                    return result;
                }

                case StylePropertyId.UnityBackgroundImageTintColor:
                {
                    var result = element.styleAnimation.Start(StylePropertyId.UnityBackgroundImageTintColor, oldStyle.rareData.Read().unityBackgroundImageTintColor, newStyle.rareData.Read().unityBackgroundImageTintColor, durationMs, delayMs, easingCurve);

                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.UnityBackgroundScaleMode:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionX, oldStyle.visualData.Read().backgroundPositionX, newStyle.visualData.Read().backgroundPositionX, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionY, oldStyle.visualData.Read().backgroundPositionY, newStyle.visualData.Read().backgroundPositionY, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundRepeat, oldStyle.visualData.Read().backgroundRepeat, newStyle.visualData.Read().backgroundRepeat, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundSize, oldStyle.visualData.Read().backgroundSize, newStyle.visualData.Read().backgroundSize, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.UnityFont:
                    return element.styleAnimation.Start(StylePropertyId.UnityFont, oldStyle.inheritedData.Read().unityFont, newStyle.inheritedData.Read().unityFont, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityFontDefinition:
                    return element.styleAnimation.Start(StylePropertyId.UnityFontDefinition, oldStyle.inheritedData.Read().unityFontDefinition, newStyle.inheritedData.Read().unityFontDefinition, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityFontStyleAndWeight:
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityFontStyleAndWeight, (int)oldStyle.inheritedData.Read().unityFontStyleAndWeight, (int)newStyle.inheritedData.Read().unityFontStyleAndWeight, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityOverflowClipBox:
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityOverflowClipBox, (int)oldStyle.rareData.Read().unityOverflowClipBox, (int)newStyle.rareData.Read().unityOverflowClipBox, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityParagraphSpacing:
                    return element.styleAnimation.Start(StylePropertyId.UnityParagraphSpacing, oldStyle.inheritedData.Read().unityParagraphSpacing, newStyle.inheritedData.Read().unityParagraphSpacing, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceBottom:
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceBottom, oldStyle.rareData.Read().unitySliceBottom, newStyle.rareData.Read().unitySliceBottom, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceLeft:
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceLeft, oldStyle.rareData.Read().unitySliceLeft, newStyle.rareData.Read().unitySliceLeft, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceRight:
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceRight, oldStyle.rareData.Read().unitySliceRight, newStyle.rareData.Read().unitySliceRight, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceScale:
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceScale, oldStyle.rareData.Read().unitySliceScale, newStyle.rareData.Read().unitySliceScale, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceTop:
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceTop, oldStyle.rareData.Read().unitySliceTop, newStyle.rareData.Read().unitySliceTop, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnitySliceType:
                    return element.styleAnimation.StartEnum(StylePropertyId.UnitySliceType, (int)oldStyle.rareData.Read().unitySliceType, (int)newStyle.rareData.Read().unitySliceType, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityTextAlign:
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityTextAlign, (int)oldStyle.inheritedData.Read().unityTextAlign, (int)newStyle.inheritedData.Read().unityTextAlign, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityTextOutline:
                {
                    bool result = false;
                    result |= element.styleAnimation.Start(StylePropertyId.UnityTextOutlineColor, oldStyle.inheritedData.Read().unityTextOutlineColor, newStyle.inheritedData.Read().unityTextOutlineColor, durationMs, delayMs, easingCurve);
                    result |= element.styleAnimation.Start(StylePropertyId.UnityTextOutlineWidth, oldStyle.inheritedData.Read().unityTextOutlineWidth, newStyle.inheritedData.Read().unityTextOutlineWidth, durationMs, delayMs, easingCurve);
                    return result;
                }

                case StylePropertyId.UnityTextOutlineColor:
                    return element.styleAnimation.Start(StylePropertyId.UnityTextOutlineColor, oldStyle.inheritedData.Read().unityTextOutlineColor, newStyle.inheritedData.Read().unityTextOutlineColor, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityTextOutlineWidth:
                    return element.styleAnimation.Start(StylePropertyId.UnityTextOutlineWidth, oldStyle.inheritedData.Read().unityTextOutlineWidth, newStyle.inheritedData.Read().unityTextOutlineWidth, durationMs, delayMs, easingCurve);
                case StylePropertyId.UnityTextOverflowPosition:
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityTextOverflowPosition, (int)oldStyle.rareData.Read().unityTextOverflowPosition, (int)newStyle.rareData.Read().unityTextOverflowPosition, durationMs, delayMs, easingCurve);
                case StylePropertyId.Visibility:
                    return element.styleAnimation.StartEnum(StylePropertyId.Visibility, (int)oldStyle.inheritedData.Read().visibility, (int)newStyle.inheritedData.Read().visibility, durationMs, delayMs, easingCurve);
                case StylePropertyId.WhiteSpace:
                    return element.styleAnimation.StartEnum(StylePropertyId.WhiteSpace, (int)oldStyle.inheritedData.Read().whiteSpace, (int)newStyle.inheritedData.Read().whiteSpace, durationMs, delayMs, easingCurve);
                case StylePropertyId.Width:
                    return element.styleAnimation.Start(StylePropertyId.Width, oldStyle.layoutData.Read().width, newStyle.layoutData.Read().width, durationMs, delayMs, easingCurve);
                case StylePropertyId.WordSpacing:
                    return element.styleAnimation.Start(StylePropertyId.WordSpacing, oldStyle.inheritedData.Read().wordSpacing, newStyle.inheritedData.Read().wordSpacing, durationMs, delayMs, easingCurve);
                default:
                    return false;
            }
        }

        public static bool StartAnimationAllProperty(VisualElement element, ref ComputedStyle oldStyle, ref ComputedStyle newStyle, int durationMs, int delayMs, Func<float, float> easingCurve)
        {
            bool result = false;
            UsageHints usageHints = UsageHints.None;

            bool hasRunningAnimation = element.hasRunningAnimations;
            if (hasRunningAnimation ||
                !oldStyle.inheritedData.Equals(newStyle.inheritedData))
            {
                ref readonly var oldData = ref oldStyle.inheritedData.Read();
                ref readonly var newData = ref newStyle.inheritedData.Read();
                if (hasRunningAnimation ||
                    oldData.color != newData.color)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.Color, oldData.color, newData.color, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.fontSize != newData.fontSize)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.FontSize, oldData.fontSize, newData.fontSize, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.letterSpacing != newData.letterSpacing)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.LetterSpacing, oldData.letterSpacing, newData.letterSpacing, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.textShadow != newData.textShadow)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.TextShadow, oldData.textShadow, newData.textShadow, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityFont != newData.unityFont)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnityFont, oldData.unityFont, newData.unityFont, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityFontDefinition != newData.unityFontDefinition)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnityFontDefinition, oldData.unityFontDefinition, newData.unityFontDefinition, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityFontStyleAndWeight != newData.unityFontStyleAndWeight)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.UnityFontStyleAndWeight, (int)oldData.unityFontStyleAndWeight, (int)newData.unityFontStyleAndWeight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityParagraphSpacing != newData.unityParagraphSpacing)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnityParagraphSpacing, oldData.unityParagraphSpacing, newData.unityParagraphSpacing, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityTextAlign != newData.unityTextAlign)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.UnityTextAlign, (int)oldData.unityTextAlign, (int)newData.unityTextAlign, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityTextOutlineColor != newData.unityTextOutlineColor)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnityTextOutlineColor, oldData.unityTextOutlineColor, newData.unityTextOutlineColor, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityTextOutlineWidth != newData.unityTextOutlineWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnityTextOutlineWidth, oldData.unityTextOutlineWidth, newData.unityTextOutlineWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.visibility != newData.visibility)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.Visibility, (int)oldData.visibility, (int)newData.visibility, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.whiteSpace != newData.whiteSpace)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.WhiteSpace, (int)oldData.whiteSpace, (int)newData.whiteSpace, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.wordSpacing != newData.wordSpacing)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.WordSpacing, oldData.wordSpacing, newData.wordSpacing, durationMs, delayMs, easingCurve);
                }
            }

            if (hasRunningAnimation ||
                !oldStyle.layoutData.Equals(newStyle.layoutData))
            {
                ref readonly var oldData = ref oldStyle.layoutData.Read();
                ref readonly var newData = ref newStyle.layoutData.Read();
                if (hasRunningAnimation ||
                    oldData.alignContent != newData.alignContent)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.AlignContent, (int)oldData.alignContent, (int)newData.alignContent, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.alignItems != newData.alignItems)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.AlignItems, (int)oldData.alignItems, (int)newData.alignItems, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.alignSelf != newData.alignSelf)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.AlignSelf, (int)oldData.alignSelf, (int)newData.alignSelf, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderBottomWidth != newData.borderBottomWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomWidth, oldData.borderBottomWidth, newData.borderBottomWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderLeftWidth != newData.borderLeftWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderLeftWidth, oldData.borderLeftWidth, newData.borderLeftWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderRightWidth != newData.borderRightWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderRightWidth, oldData.borderRightWidth, newData.borderRightWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderTopWidth != newData.borderTopWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopWidth, oldData.borderTopWidth, newData.borderTopWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.bottom != newData.bottom)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Bottom, oldData.bottom, newData.bottom, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.flexBasis != newData.flexBasis)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.FlexBasis, oldData.flexBasis, newData.flexBasis, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.flexDirection != newData.flexDirection)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.FlexDirection, (int)oldData.flexDirection, (int)newData.flexDirection, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.flexGrow != newData.flexGrow)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.FlexGrow, oldData.flexGrow, newData.flexGrow, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.flexShrink != newData.flexShrink)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.FlexShrink, oldData.flexShrink, newData.flexShrink, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.flexWrap != newData.flexWrap)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.FlexWrap, (int)oldData.flexWrap, (int)newData.flexWrap, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.height != newData.height)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Height, oldData.height, newData.height, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.justifyContent != newData.justifyContent)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.JustifyContent, (int)oldData.justifyContent, (int)newData.justifyContent, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.left != newData.left)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Left, oldData.left, newData.left, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.marginBottom != newData.marginBottom)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MarginBottom, oldData.marginBottom, newData.marginBottom, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.marginLeft != newData.marginLeft)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MarginLeft, oldData.marginLeft, newData.marginLeft, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.marginRight != newData.marginRight)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MarginRight, oldData.marginRight, newData.marginRight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.marginTop != newData.marginTop)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MarginTop, oldData.marginTop, newData.marginTop, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.maxHeight != newData.maxHeight)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MaxHeight, oldData.maxHeight, newData.maxHeight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.maxWidth != newData.maxWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MaxWidth, oldData.maxWidth, newData.maxWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.minHeight != newData.minHeight)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MinHeight, oldData.minHeight, newData.minHeight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.minWidth != newData.minWidth)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.MinWidth, oldData.minWidth, newData.minWidth, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.paddingBottom != newData.paddingBottom)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingBottom, oldData.paddingBottom, newData.paddingBottom, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.paddingLeft != newData.paddingLeft)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingLeft, oldData.paddingLeft, newData.paddingLeft, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.paddingRight != newData.paddingRight)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingRight, oldData.paddingRight, newData.paddingRight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.paddingTop != newData.paddingTop)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.PaddingTop, oldData.paddingTop, newData.paddingTop, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.position != newData.position)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.Position, (int)oldData.position, (int)newData.position, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.right != newData.right)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Right, oldData.right, newData.right, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.top != newData.top)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Top, oldData.top, newData.top, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.width != newData.width)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Width, oldData.width, newData.width, durationMs, delayMs, easingCurve);
                }
            }

            if (hasRunningAnimation ||
                !oldStyle.rareData.Equals(newStyle.rareData))
            {
                ref readonly var oldData = ref oldStyle.rareData.Read();
                ref readonly var newData = ref newStyle.rareData.Read();
                if (hasRunningAnimation ||
                    oldData.textOverflow != newData.textOverflow)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.TextOverflow, (int)oldData.textOverflow, (int)newData.textOverflow, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityBackgroundImageTintColor != newData.unityBackgroundImageTintColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.UnityBackgroundImageTintColor, oldData.unityBackgroundImageTintColor, newData.unityBackgroundImageTintColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.unityOverflowClipBox != newData.unityOverflowClipBox)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.UnityOverflowClipBox, (int)oldData.unityOverflowClipBox, (int)newData.unityOverflowClipBox, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceBottom != newData.unitySliceBottom)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnitySliceBottom, oldData.unitySliceBottom, newData.unitySliceBottom, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceLeft != newData.unitySliceLeft)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnitySliceLeft, oldData.unitySliceLeft, newData.unitySliceLeft, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceRight != newData.unitySliceRight)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnitySliceRight, oldData.unitySliceRight, newData.unitySliceRight, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceScale != newData.unitySliceScale)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnitySliceScale, oldData.unitySliceScale, newData.unitySliceScale, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceTop != newData.unitySliceTop)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.UnitySliceTop, oldData.unitySliceTop, newData.unitySliceTop, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unitySliceType != newData.unitySliceType)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.UnitySliceType, (int)oldData.unitySliceType, (int)newData.unitySliceType, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.unityTextOverflowPosition != newData.unityTextOverflowPosition)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.UnityTextOverflowPosition, (int)oldData.unityTextOverflowPosition, (int)newData.unityTextOverflowPosition, durationMs, delayMs, easingCurve);
                }
            }

            if (hasRunningAnimation ||
                !oldStyle.transformData.Equals(newStyle.transformData))
            {
                ref readonly var oldData = ref oldStyle.transformData.Read();
                ref readonly var newData = ref newStyle.transformData.Read();
                if (hasRunningAnimation ||
                    oldData.rotate != newData.rotate)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.Rotate, oldData.rotate, newData.rotate, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicTransform;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.scale != newData.scale)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.Scale, oldData.scale, newData.scale, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicTransform;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.transformOrigin != newData.transformOrigin)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.TransformOrigin, oldData.transformOrigin, newData.transformOrigin, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicTransform;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.translate != newData.translate)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.Translate, oldData.translate, newData.translate, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicTransform;
                    }

                    result |= partialResult;
                }
            }

            if (hasRunningAnimation ||
                !oldStyle.visualData.Equals(newStyle.visualData))
            {
                ref readonly var oldData = ref oldStyle.visualData.Read();
                ref readonly var newData = ref newStyle.visualData.Read();
                if (hasRunningAnimation ||
                    oldData.backgroundColor != newData.backgroundColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.BackgroundColor, oldData.backgroundColor, newData.backgroundColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.backgroundImage != newData.backgroundImage)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundImage, oldData.backgroundImage, newData.backgroundImage, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.backgroundPositionX != newData.backgroundPositionX)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionX, oldData.backgroundPositionX, newData.backgroundPositionX, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.backgroundPositionY != newData.backgroundPositionY)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundPositionY, oldData.backgroundPositionY, newData.backgroundPositionY, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.backgroundRepeat != newData.backgroundRepeat)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundRepeat, oldData.backgroundRepeat, newData.backgroundRepeat, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.backgroundSize != newData.backgroundSize)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BackgroundSize, oldData.backgroundSize, newData.backgroundSize, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderBottomColor != newData.borderBottomColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.BorderBottomColor, oldData.borderBottomColor, newData.borderBottomColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.borderBottomLeftRadius != newData.borderBottomLeftRadius)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomLeftRadius, oldData.borderBottomLeftRadius, newData.borderBottomLeftRadius, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderBottomRightRadius != newData.borderBottomRightRadius)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderBottomRightRadius, oldData.borderBottomRightRadius, newData.borderBottomRightRadius, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderLeftColor != newData.borderLeftColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.BorderLeftColor, oldData.borderLeftColor, newData.borderLeftColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.borderRightColor != newData.borderRightColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.BorderRightColor, oldData.borderRightColor, newData.borderRightColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.borderTopColor != newData.borderTopColor)
                {
                    bool partialResult = element.styleAnimation.Start(StylePropertyId.BorderTopColor, oldData.borderTopColor, newData.borderTopColor, durationMs, delayMs, easingCurve);
                    if (partialResult)
                    {
                        usageHints |= UsageHints.DynamicColor;
                    }

                    result |= partialResult;
                }

                if (hasRunningAnimation ||
                    oldData.borderTopLeftRadius != newData.borderTopLeftRadius)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopLeftRadius, oldData.borderTopLeftRadius, newData.borderTopLeftRadius, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.borderTopRightRadius != newData.borderTopRightRadius)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.BorderTopRightRadius, oldData.borderTopRightRadius, newData.borderTopRightRadius, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.opacity != newData.opacity)
                {
                    result |= element.styleAnimation.Start(StylePropertyId.Opacity, oldData.opacity, newData.opacity, durationMs, delayMs, easingCurve);
                }

                if (hasRunningAnimation ||
                    oldData.overflow != newData.overflow)
                {
                    result |= element.styleAnimation.StartEnum(StylePropertyId.Overflow, (int)oldData.overflow, (int)newData.overflow, durationMs, delayMs, easingCurve);
                }
            }

            if (usageHints != UsageHints.None)
            {
                element.usageHints |= usageHints;
            }

            return result;
        }

        public static bool StartAnimationInline(VisualElement element, StylePropertyId id, ref ComputedStyle computedStyle, StyleValue sv, int durationMs, int delayMs, Func<float, float> easingCurve)
        {
            switch (id)
            {
                case StylePropertyId.AlignContent:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.alignContent : (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        to = Align.Auto;
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignContent, (int)computedStyle.layoutData.Read().alignContent, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.AlignItems:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.alignItems : (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        to = Align.Auto;
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignItems, (int)computedStyle.layoutData.Read().alignItems, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.AlignSelf:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.alignSelf : (Align)sv.number;
                    if (sv.keyword == StyleKeyword.Auto)
                        to = Align.Auto;
                    return element.styleAnimation.StartEnum(StylePropertyId.AlignSelf, (int)computedStyle.layoutData.Read().alignSelf, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BackgroundColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.backgroundColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.BackgroundColor, computedStyle.visualData.Read().backgroundColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BackgroundImage:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.backgroundImage : sv.resource.IsAllocated ? Background.FromObject(sv.resource.Target) : new Background();
                    return element.styleAnimation.Start(StylePropertyId.BackgroundImage, computedStyle.visualData.Read().backgroundImage, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BackgroundPositionX:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.backgroundPositionX : sv.position;
                    return element.styleAnimation.Start(StylePropertyId.BackgroundPositionX, computedStyle.visualData.Read().backgroundPositionX, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BackgroundPositionY:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.backgroundPositionY : sv.position;
                    return element.styleAnimation.Start(StylePropertyId.BackgroundPositionY, computedStyle.visualData.Read().backgroundPositionY, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BackgroundRepeat:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.backgroundRepeat : sv.repeat;
                    return element.styleAnimation.Start(StylePropertyId.BackgroundRepeat, computedStyle.visualData.Read().backgroundRepeat, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderBottomColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderBottomColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.BorderBottomColor, computedStyle.visualData.Read().borderBottomColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderBottomLeftRadius:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderBottomLeftRadius : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomLeftRadius, computedStyle.visualData.Read().borderBottomLeftRadius, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderBottomRightRadius:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderBottomRightRadius : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomRightRadius, computedStyle.visualData.Read().borderBottomRightRadius, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderBottomWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderBottomWidth : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.BorderBottomWidth, computedStyle.layoutData.Read().borderBottomWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderLeftColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderLeftColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.BorderLeftColor, computedStyle.visualData.Read().borderLeftColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderLeftWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderLeftWidth : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.BorderLeftWidth, computedStyle.layoutData.Read().borderLeftWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderRightColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderRightColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.BorderRightColor, computedStyle.visualData.Read().borderRightColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderRightWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderRightWidth : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.BorderRightWidth, computedStyle.layoutData.Read().borderRightWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderTopColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderTopColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.BorderTopColor, computedStyle.visualData.Read().borderTopColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.BorderTopLeftRadius:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderTopLeftRadius : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.BorderTopLeftRadius, computedStyle.visualData.Read().borderTopLeftRadius, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderTopRightRadius:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderTopRightRadius : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.BorderTopRightRadius, computedStyle.visualData.Read().borderTopRightRadius, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.BorderTopWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.borderTopWidth : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.BorderTopWidth, computedStyle.layoutData.Read().borderTopWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Bottom:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.bottom : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Bottom, computedStyle.layoutData.Read().bottom, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Color:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.color : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.Color, computedStyle.inheritedData.Read().color, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.FlexBasis:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.flexBasis : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.FlexBasis, computedStyle.layoutData.Read().flexBasis, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.FlexDirection:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.flexDirection : (FlexDirection)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.FlexDirection, (int)computedStyle.layoutData.Read().flexDirection, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.FlexGrow:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.flexGrow : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.FlexGrow, computedStyle.layoutData.Read().flexGrow, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.FlexShrink:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.flexShrink : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.FlexShrink, computedStyle.layoutData.Read().flexShrink, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.FlexWrap:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.flexWrap : (Wrap)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.FlexWrap, (int)computedStyle.layoutData.Read().flexWrap, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.FontSize:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.fontSize : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.FontSize, computedStyle.inheritedData.Read().fontSize, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Height:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.height : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Height, computedStyle.layoutData.Read().height, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.JustifyContent:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.justifyContent : (Justify)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.JustifyContent, (int)computedStyle.layoutData.Read().justifyContent, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Left:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.left : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Left, computedStyle.layoutData.Read().left, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.LetterSpacing:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.letterSpacing : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.LetterSpacing, computedStyle.inheritedData.Read().letterSpacing, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MarginBottom:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.marginBottom : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MarginBottom, computedStyle.layoutData.Read().marginBottom, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MarginLeft:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.marginLeft : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MarginLeft, computedStyle.layoutData.Read().marginLeft, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MarginRight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.marginRight : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MarginRight, computedStyle.layoutData.Read().marginRight, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MarginTop:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.marginTop : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MarginTop, computedStyle.layoutData.Read().marginTop, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MaxHeight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.maxHeight : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MaxHeight, computedStyle.layoutData.Read().maxHeight, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MaxWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.maxWidth : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MaxWidth, computedStyle.layoutData.Read().maxWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MinHeight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.minHeight : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MinHeight, computedStyle.layoutData.Read().minHeight, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.MinWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.minWidth : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.MinWidth, computedStyle.layoutData.Read().minWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Opacity:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.opacity : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.Opacity, computedStyle.visualData.Read().opacity, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Overflow:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.overflow : (OverflowInternal)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.Overflow, (int)computedStyle.visualData.Read().overflow, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.PaddingBottom:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.paddingBottom : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.PaddingBottom, computedStyle.layoutData.Read().paddingBottom, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.PaddingLeft:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.paddingLeft : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.PaddingLeft, computedStyle.layoutData.Read().paddingLeft, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.PaddingRight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.paddingRight : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.PaddingRight, computedStyle.layoutData.Read().paddingRight, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.PaddingTop:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.paddingTop : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.PaddingTop, computedStyle.layoutData.Read().paddingTop, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Position:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.position : (Position)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.Position, (int)computedStyle.layoutData.Read().position, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Right:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.right : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Right, computedStyle.layoutData.Read().right, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.TextOverflow:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.textOverflow : (TextOverflow)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.TextOverflow, (int)computedStyle.rareData.Read().textOverflow, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Top:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.top : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Top, computedStyle.layoutData.Read().top, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityBackgroundImageTintColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityBackgroundImageTintColor : sv.color;
                    bool result = element.styleAnimation.Start(StylePropertyId.UnityBackgroundImageTintColor, computedStyle.rareData.Read().unityBackgroundImageTintColor, to, durationMs, delayMs, easingCurve);
                    if (result && (element.usageHints & UsageHints.DynamicColor) == 0)
                    {
                        element.usageHints |= UsageHints.DynamicColor;
                    }

                    return result;
                }

                case StylePropertyId.UnityFont:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityFont : sv.resource.IsAllocated ? sv.resource.Target as Font : null;
                    return element.styleAnimation.Start(StylePropertyId.UnityFont, computedStyle.inheritedData.Read().unityFont, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityFontDefinition:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityFontDefinition : sv.resource.IsAllocated ? FontDefinition.FromObject(sv.resource.Target) : new FontDefinition();
                    return element.styleAnimation.Start(StylePropertyId.UnityFontDefinition, computedStyle.inheritedData.Read().unityFontDefinition, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityFontStyleAndWeight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityFontStyleAndWeight : (FontStyle)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityFontStyleAndWeight, (int)computedStyle.inheritedData.Read().unityFontStyleAndWeight, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityOverflowClipBox:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityOverflowClipBox : (OverflowClipBox)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityOverflowClipBox, (int)computedStyle.rareData.Read().unityOverflowClipBox, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityParagraphSpacing:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityParagraphSpacing : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.UnityParagraphSpacing, computedStyle.inheritedData.Read().unityParagraphSpacing, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceBottom:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceBottom : (int)sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceBottom, computedStyle.rareData.Read().unitySliceBottom, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceLeft:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceLeft : (int)sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceLeft, computedStyle.rareData.Read().unitySliceLeft, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceRight:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceRight : (int)sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceRight, computedStyle.rareData.Read().unitySliceRight, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceScale:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceScale : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceScale, computedStyle.rareData.Read().unitySliceScale, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceTop:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceTop : (int)sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnitySliceTop, computedStyle.rareData.Read().unitySliceTop, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnitySliceType:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unitySliceType : (SliceType)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.UnitySliceType, (int)computedStyle.rareData.Read().unitySliceType, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityTextAlign:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityTextAlign : (TextAnchor)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityTextAlign, (int)computedStyle.inheritedData.Read().unityTextAlign, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityTextOutlineColor:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityTextOutlineColor : sv.color;
                    return element.styleAnimation.Start(StylePropertyId.UnityTextOutlineColor, computedStyle.inheritedData.Read().unityTextOutlineColor, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityTextOutlineWidth:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityTextOutlineWidth : sv.number;
                    return element.styleAnimation.Start(StylePropertyId.UnityTextOutlineWidth, computedStyle.inheritedData.Read().unityTextOutlineWidth, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.UnityTextOverflowPosition:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.unityTextOverflowPosition : (TextOverflowPosition)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.UnityTextOverflowPosition, (int)computedStyle.rareData.Read().unityTextOverflowPosition, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Visibility:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.visibility : (Visibility)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.Visibility, (int)computedStyle.inheritedData.Read().visibility, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.WhiteSpace:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.whiteSpace : (WhiteSpace)sv.number;
                    return element.styleAnimation.StartEnum(StylePropertyId.WhiteSpace, (int)computedStyle.inheritedData.Read().whiteSpace, (int)to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.Width:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.width : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.Width, computedStyle.layoutData.Read().width, to, durationMs, delayMs, easingCurve);
                }

                case StylePropertyId.WordSpacing:
                {
                    var to = sv.keyword == StyleKeyword.Initial ? InitialStyle.wordSpacing : sv.length;
                    return element.styleAnimation.Start(StylePropertyId.WordSpacing, computedStyle.inheritedData.Read().wordSpacing, to, durationMs, delayMs, easingCurve);
                }

                default:
                    return false;
            }
        }

        public void ApplyStyleTransformOrigin(TransformOrigin st)
        {
            transformData.Write().transformOrigin = st;
        }

        public void ApplyStyleTranslate(Translate translateValue)
        {
            transformData.Write().translate = translateValue;
        }

        public void ApplyStyleRotate(Rotate rotateValue)
        {
            transformData.Write().rotate = rotateValue;
        }

        public void ApplyStyleScale(Scale scaleValue)
        {
            transformData.Write().scale = scaleValue;
        }

        public void ApplyStyleBackgroundSize(BackgroundSize backgroundSizeValue)
        {
            visualData.Write().backgroundSize = backgroundSizeValue;
        }

        public void ApplyInitialValue(StylePropertyReader reader)
        {
            switch (reader.propertyId)
            {
                case StylePropertyId.Custom:
                    RemoveCustomStyleProperty(reader);
                    break;
                case StylePropertyId.All:
                    ApplyAllPropertyInitial();
                    break;
                default:
                    ApplyInitialValue(reader.propertyId);
                    break;
            }
        }

        public void ApplyInitialValue(StylePropertyId id)
        {
            switch (id)
            {
                case StylePropertyId.AlignContent:
                    layoutData.Write().alignContent = InitialStyle.alignContent;
                    break;
                case StylePropertyId.AlignItems:
                    layoutData.Write().alignItems = InitialStyle.alignItems;
                    break;
                case StylePropertyId.AlignSelf:
                    layoutData.Write().alignSelf = InitialStyle.alignSelf;
                    break;
                case StylePropertyId.All:
                    break;
                case StylePropertyId.BackgroundColor:
                    visualData.Write().backgroundColor = InitialStyle.backgroundColor;
                    break;
                case StylePropertyId.BackgroundImage:
                    visualData.Write().backgroundImage = InitialStyle.backgroundImage;
                    break;
                case StylePropertyId.BackgroundPosition:
                    visualData.Write().backgroundPositionX = InitialStyle.backgroundPositionX;
                    visualData.Write().backgroundPositionY = InitialStyle.backgroundPositionY;
                    break;
                case StylePropertyId.BackgroundPositionX:
                    visualData.Write().backgroundPositionX = InitialStyle.backgroundPositionX;
                    break;
                case StylePropertyId.BackgroundPositionY:
                    visualData.Write().backgroundPositionY = InitialStyle.backgroundPositionY;
                    break;
                case StylePropertyId.BackgroundRepeat:
                    visualData.Write().backgroundRepeat = InitialStyle.backgroundRepeat;
                    break;
                case StylePropertyId.BackgroundSize:
                    visualData.Write().backgroundSize = InitialStyle.backgroundSize;
                    break;
                case StylePropertyId.BorderBottomColor:
                    visualData.Write().borderBottomColor = InitialStyle.borderBottomColor;
                    break;
                case StylePropertyId.BorderBottomLeftRadius:
                    visualData.Write().borderBottomLeftRadius = InitialStyle.borderBottomLeftRadius;
                    break;
                case StylePropertyId.BorderBottomRightRadius:
                    visualData.Write().borderBottomRightRadius = InitialStyle.borderBottomRightRadius;
                    break;
                case StylePropertyId.BorderBottomWidth:
                    layoutData.Write().borderBottomWidth = InitialStyle.borderBottomWidth;
                    break;
                case StylePropertyId.BorderColor:
                    visualData.Write().borderTopColor = InitialStyle.borderTopColor;
                    visualData.Write().borderRightColor = InitialStyle.borderRightColor;
                    visualData.Write().borderBottomColor = InitialStyle.borderBottomColor;
                    visualData.Write().borderLeftColor = InitialStyle.borderLeftColor;
                    break;
                case StylePropertyId.BorderLeftColor:
                    visualData.Write().borderLeftColor = InitialStyle.borderLeftColor;
                    break;
                case StylePropertyId.BorderLeftWidth:
                    layoutData.Write().borderLeftWidth = InitialStyle.borderLeftWidth;
                    break;
                case StylePropertyId.BorderRadius:
                    visualData.Write().borderTopLeftRadius = InitialStyle.borderTopLeftRadius;
                    visualData.Write().borderTopRightRadius = InitialStyle.borderTopRightRadius;
                    visualData.Write().borderBottomRightRadius = InitialStyle.borderBottomRightRadius;
                    visualData.Write().borderBottomLeftRadius = InitialStyle.borderBottomLeftRadius;
                    break;
                case StylePropertyId.BorderRightColor:
                    visualData.Write().borderRightColor = InitialStyle.borderRightColor;
                    break;
                case StylePropertyId.BorderRightWidth:
                    layoutData.Write().borderRightWidth = InitialStyle.borderRightWidth;
                    break;
                case StylePropertyId.BorderTopColor:
                    visualData.Write().borderTopColor = InitialStyle.borderTopColor;
                    break;
                case StylePropertyId.BorderTopLeftRadius:
                    visualData.Write().borderTopLeftRadius = InitialStyle.borderTopLeftRadius;
                    break;
                case StylePropertyId.BorderTopRightRadius:
                    visualData.Write().borderTopRightRadius = InitialStyle.borderTopRightRadius;
                    break;
                case StylePropertyId.BorderTopWidth:
                    layoutData.Write().borderTopWidth = InitialStyle.borderTopWidth;
                    break;
                case StylePropertyId.BorderWidth:
                    layoutData.Write().borderTopWidth = InitialStyle.borderTopWidth;
                    layoutData.Write().borderRightWidth = InitialStyle.borderRightWidth;
                    layoutData.Write().borderBottomWidth = InitialStyle.borderBottomWidth;
                    layoutData.Write().borderLeftWidth = InitialStyle.borderLeftWidth;
                    break;
                case StylePropertyId.Bottom:
                    layoutData.Write().bottom = InitialStyle.bottom;
                    break;
                case StylePropertyId.Color:
                    inheritedData.Write().color = InitialStyle.color;
                    break;
                case StylePropertyId.Cursor:
                    rareData.Write().cursor = InitialStyle.cursor;
                    break;
                case StylePropertyId.Display:
                    layoutData.Write().display = InitialStyle.display;
                    break;
                case StylePropertyId.Flex:
                    layoutData.Write().flexGrow = InitialStyle.flexGrow;
                    layoutData.Write().flexShrink = InitialStyle.flexShrink;
                    layoutData.Write().flexBasis = InitialStyle.flexBasis;
                    break;
                case StylePropertyId.FlexBasis:
                    layoutData.Write().flexBasis = InitialStyle.flexBasis;
                    break;
                case StylePropertyId.FlexDirection:
                    layoutData.Write().flexDirection = InitialStyle.flexDirection;
                    break;
                case StylePropertyId.FlexGrow:
                    layoutData.Write().flexGrow = InitialStyle.flexGrow;
                    break;
                case StylePropertyId.FlexShrink:
                    layoutData.Write().flexShrink = InitialStyle.flexShrink;
                    break;
                case StylePropertyId.FlexWrap:
                    layoutData.Write().flexWrap = InitialStyle.flexWrap;
                    break;
                case StylePropertyId.FontSize:
                    inheritedData.Write().fontSize = InitialStyle.fontSize;
                    break;
                case StylePropertyId.Height:
                    layoutData.Write().height = InitialStyle.height;
                    break;
                case StylePropertyId.JustifyContent:
                    layoutData.Write().justifyContent = InitialStyle.justifyContent;
                    break;
                case StylePropertyId.Left:
                    layoutData.Write().left = InitialStyle.left;
                    break;
                case StylePropertyId.LetterSpacing:
                    inheritedData.Write().letterSpacing = InitialStyle.letterSpacing;
                    break;
                case StylePropertyId.Margin:
                    layoutData.Write().marginTop = InitialStyle.marginTop;
                    layoutData.Write().marginRight = InitialStyle.marginRight;
                    layoutData.Write().marginBottom = InitialStyle.marginBottom;
                    layoutData.Write().marginLeft = InitialStyle.marginLeft;
                    break;
                case StylePropertyId.MarginBottom:
                    layoutData.Write().marginBottom = InitialStyle.marginBottom;
                    break;
                case StylePropertyId.MarginLeft:
                    layoutData.Write().marginLeft = InitialStyle.marginLeft;
                    break;
                case StylePropertyId.MarginRight:
                    layoutData.Write().marginRight = InitialStyle.marginRight;
                    break;
                case StylePropertyId.MarginTop:
                    layoutData.Write().marginTop = InitialStyle.marginTop;
                    break;
                case StylePropertyId.MaxHeight:
                    layoutData.Write().maxHeight = InitialStyle.maxHeight;
                    break;
                case StylePropertyId.MaxWidth:
                    layoutData.Write().maxWidth = InitialStyle.maxWidth;
                    break;
                case StylePropertyId.MinHeight:
                    layoutData.Write().minHeight = InitialStyle.minHeight;
                    break;
                case StylePropertyId.MinWidth:
                    layoutData.Write().minWidth = InitialStyle.minWidth;
                    break;
                case StylePropertyId.Opacity:
                    visualData.Write().opacity = InitialStyle.opacity;
                    break;
                case StylePropertyId.Overflow:
                    visualData.Write().overflow = InitialStyle.overflow;
                    break;
                case StylePropertyId.Padding:
                    layoutData.Write().paddingTop = InitialStyle.paddingTop;
                    layoutData.Write().paddingRight = InitialStyle.paddingRight;
                    layoutData.Write().paddingBottom = InitialStyle.paddingBottom;
                    layoutData.Write().paddingLeft = InitialStyle.paddingLeft;
                    break;
                case StylePropertyId.PaddingBottom:
                    layoutData.Write().paddingBottom = InitialStyle.paddingBottom;
                    break;
                case StylePropertyId.PaddingLeft:
                    layoutData.Write().paddingLeft = InitialStyle.paddingLeft;
                    break;
                case StylePropertyId.PaddingRight:
                    layoutData.Write().paddingRight = InitialStyle.paddingRight;
                    break;
                case StylePropertyId.PaddingTop:
                    layoutData.Write().paddingTop = InitialStyle.paddingTop;
                    break;
                case StylePropertyId.Position:
                    layoutData.Write().position = InitialStyle.position;
                    break;
                case StylePropertyId.Right:
                    layoutData.Write().right = InitialStyle.right;
                    break;
                case StylePropertyId.Rotate:
                    transformData.Write().rotate = InitialStyle.rotate;
                    break;
                case StylePropertyId.Scale:
                    transformData.Write().scale = InitialStyle.scale;
                    break;
                case StylePropertyId.TextOverflow:
                    rareData.Write().textOverflow = InitialStyle.textOverflow;
                    break;
                case StylePropertyId.TextShadow:
                    inheritedData.Write().textShadow = InitialStyle.textShadow;
                    break;
                case StylePropertyId.Top:
                    layoutData.Write().top = InitialStyle.top;
                    break;
                case StylePropertyId.TransformOrigin:
                    transformData.Write().transformOrigin = InitialStyle.transformOrigin;
                    break;
                case StylePropertyId.Transition:
                    transitionData.Write().transitionDelay.CopyFrom(InitialStyle.transitionDelay);
                    transitionData.Write().transitionDuration.CopyFrom(InitialStyle.transitionDuration);
                    transitionData.Write().transitionProperty.CopyFrom(InitialStyle.transitionProperty);
                    transitionData.Write().transitionTimingFunction.CopyFrom(InitialStyle.transitionTimingFunction);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionDelay:
                    transitionData.Write().transitionDelay.CopyFrom(InitialStyle.transitionDelay);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionDuration:
                    transitionData.Write().transitionDuration.CopyFrom(InitialStyle.transitionDuration);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionProperty:
                    transitionData.Write().transitionProperty.CopyFrom(InitialStyle.transitionProperty);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.TransitionTimingFunction:
                    transitionData.Write().transitionTimingFunction.CopyFrom(InitialStyle.transitionTimingFunction);
                    ResetComputedTransitions();
                    break;
                case StylePropertyId.Translate:
                    transformData.Write().translate = InitialStyle.translate;
                    break;
                case StylePropertyId.UnityBackgroundImageTintColor:
                    rareData.Write().unityBackgroundImageTintColor = InitialStyle.unityBackgroundImageTintColor;
                    break;
                case StylePropertyId.UnityBackgroundScaleMode:
                    visualData.Write().backgroundPositionX = InitialStyle.backgroundPositionX;
                    visualData.Write().backgroundPositionY = InitialStyle.backgroundPositionY;
                    visualData.Write().backgroundRepeat = InitialStyle.backgroundRepeat;
                    visualData.Write().backgroundSize = InitialStyle.backgroundSize;
                    break;
                case StylePropertyId.UnityEditorTextRenderingMode:
                    inheritedData.Write().unityEditorTextRenderingMode = InitialStyle.unityEditorTextRenderingMode;
                    break;
                case StylePropertyId.UnityFont:
                    inheritedData.Write().unityFont = InitialStyle.unityFont;
                    break;
                case StylePropertyId.UnityFontDefinition:
                    inheritedData.Write().unityFontDefinition = InitialStyle.unityFontDefinition;
                    break;
                case StylePropertyId.UnityFontStyleAndWeight:
                    inheritedData.Write().unityFontStyleAndWeight = InitialStyle.unityFontStyleAndWeight;
                    break;
                case StylePropertyId.UnityOverflowClipBox:
                    rareData.Write().unityOverflowClipBox = InitialStyle.unityOverflowClipBox;
                    break;
                case StylePropertyId.UnityParagraphSpacing:
                    inheritedData.Write().unityParagraphSpacing = InitialStyle.unityParagraphSpacing;
                    break;
                case StylePropertyId.UnitySliceBottom:
                    rareData.Write().unitySliceBottom = InitialStyle.unitySliceBottom;
                    break;
                case StylePropertyId.UnitySliceLeft:
                    rareData.Write().unitySliceLeft = InitialStyle.unitySliceLeft;
                    break;
                case StylePropertyId.UnitySliceRight:
                    rareData.Write().unitySliceRight = InitialStyle.unitySliceRight;
                    break;
                case StylePropertyId.UnitySliceScale:
                    rareData.Write().unitySliceScale = InitialStyle.unitySliceScale;
                    break;
                case StylePropertyId.UnitySliceTop:
                    rareData.Write().unitySliceTop = InitialStyle.unitySliceTop;
                    break;
                case StylePropertyId.UnitySliceType:
                    rareData.Write().unitySliceType = InitialStyle.unitySliceType;
                    break;
                case StylePropertyId.UnityTextAlign:
                    inheritedData.Write().unityTextAlign = InitialStyle.unityTextAlign;
                    break;
                case StylePropertyId.UnityTextAutoSize:
                    rareData.Write().unityTextAutoSize = InitialStyle.unityTextAutoSize;
                    break;
                case StylePropertyId.UnityTextGenerator:
                    inheritedData.Write().unityTextGenerator = InitialStyle.unityTextGenerator;
                    break;
                case StylePropertyId.UnityTextOutline:
                    inheritedData.Write().unityTextOutlineColor = InitialStyle.unityTextOutlineColor;
                    inheritedData.Write().unityTextOutlineWidth = InitialStyle.unityTextOutlineWidth;
                    break;
                case StylePropertyId.UnityTextOutlineColor:
                    inheritedData.Write().unityTextOutlineColor = InitialStyle.unityTextOutlineColor;
                    break;
                case StylePropertyId.UnityTextOutlineWidth:
                    inheritedData.Write().unityTextOutlineWidth = InitialStyle.unityTextOutlineWidth;
                    break;
                case StylePropertyId.UnityTextOverflowPosition:
                    rareData.Write().unityTextOverflowPosition = InitialStyle.unityTextOverflowPosition;
                    break;
                case StylePropertyId.Visibility:
                    inheritedData.Write().visibility = InitialStyle.visibility;
                    break;
                case StylePropertyId.WhiteSpace:
                    inheritedData.Write().whiteSpace = InitialStyle.whiteSpace;
                    break;
                case StylePropertyId.Width:
                    layoutData.Write().width = InitialStyle.width;
                    break;
                case StylePropertyId.WordSpacing:
                    inheritedData.Write().wordSpacing = InitialStyle.wordSpacing;
                    break;
                default:
                    Debug.LogAssertion($"Unexpected property id {id}");
                    break;
            }
        }

        public void ApplyUnsetValue(StylePropertyReader reader, ref ComputedStyle parentStyle)
        {
            switch (reader.propertyId)
            {
                case StylePropertyId.Custom:
                    RemoveCustomStyleProperty(reader);
                    break;
                default:
                    ApplyUnsetValue(reader.propertyId, ref parentStyle);
                    break;
            }
        }

        public void ApplyUnsetValue(StylePropertyId id, ref ComputedStyle parentStyle)
        {
            switch (id)
            {
                case StylePropertyId.Color:
                    inheritedData.Write().color = parentStyle.color;
                    break;
                case StylePropertyId.FontSize:
                    inheritedData.Write().fontSize = parentStyle.fontSize;
                    break;
                case StylePropertyId.LetterSpacing:
                    inheritedData.Write().letterSpacing = parentStyle.letterSpacing;
                    break;
                case StylePropertyId.TextShadow:
                    inheritedData.Write().textShadow = parentStyle.textShadow;
                    break;
                case StylePropertyId.UnityEditorTextRenderingMode:
                    inheritedData.Write().unityEditorTextRenderingMode = parentStyle.unityEditorTextRenderingMode;
                    break;
                case StylePropertyId.UnityFont:
                    inheritedData.Write().unityFont = parentStyle.unityFont;
                    break;
                case StylePropertyId.UnityFontDefinition:
                    inheritedData.Write().unityFontDefinition = parentStyle.unityFontDefinition;
                    break;
                case StylePropertyId.UnityFontStyleAndWeight:
                    inheritedData.Write().unityFontStyleAndWeight = parentStyle.unityFontStyleAndWeight;
                    break;
                case StylePropertyId.UnityParagraphSpacing:
                    inheritedData.Write().unityParagraphSpacing = parentStyle.unityParagraphSpacing;
                    break;
                case StylePropertyId.UnityTextAlign:
                    inheritedData.Write().unityTextAlign = parentStyle.unityTextAlign;
                    break;
                case StylePropertyId.UnityTextGenerator:
                    inheritedData.Write().unityTextGenerator = parentStyle.unityTextGenerator;
                    break;
                case StylePropertyId.UnityTextOutlineColor:
                    inheritedData.Write().unityTextOutlineColor = parentStyle.unityTextOutlineColor;
                    break;
                case StylePropertyId.UnityTextOutlineWidth:
                    inheritedData.Write().unityTextOutlineWidth = parentStyle.unityTextOutlineWidth;
                    break;
                case StylePropertyId.Visibility:
                    inheritedData.Write().visibility = parentStyle.visibility;
                    break;
                case StylePropertyId.WhiteSpace:
                    inheritedData.Write().whiteSpace = parentStyle.whiteSpace;
                    break;
                case StylePropertyId.WordSpacing:
                    inheritedData.Write().wordSpacing = parentStyle.wordSpacing;
                    break;
                default:
                    ApplyInitialValue(id);
                    break;
            }
        }

        // It's possible that the struct object (for layout data, visual data, etc) is the same on both ComputedStyle
        // instances, and when that's the case, we don't need to check the individual properties.
        // The check of each property, when necessary, is ordered in a way to try to check most common properties
        // to have their values changed first, in an effort to try to reduce the amount of comparisons done.
        // NOTE: This code is generated based on the value for compareChangesOrder on uss-properties.json
        // and StyleGroupDefinitions.s_GroupsOrder (UIElementsGenerator tool).
        public static VersionChangeType CompareChanges(ref ComputedStyle x, ref ComputedStyle y)
        {
            VersionChangeType changes = VersionChangeType.Styles;
            if (!x.layoutData.ReferenceEquals(y.layoutData))
            {
                if (x.display != y.display ||
                    x.flexGrow != y.flexGrow ||
                    x.flexShrink != y.flexShrink ||
                    x.flexWrap != y.flexWrap ||
                    x.flexDirection != y.flexDirection ||
                    x.justifyContent != y.justifyContent ||
                    x.bottom != y.bottom ||
                    x.left != y.left ||
                    x.right != y.right ||
                    x.top != y.top ||
                    x.height != y.height ||
                    x.width != y.width ||
                    x.paddingBottom != y.paddingBottom ||
                    x.paddingLeft != y.paddingLeft ||
                    x.paddingRight != y.paddingRight ||
                    x.paddingTop != y.paddingTop ||
                    x.marginBottom != y.marginBottom ||
                    x.marginLeft != y.marginLeft ||
                    x.marginRight != y.marginRight ||
                    x.marginTop != y.marginTop ||
                    x.position != y.position ||
                    x.alignContent != y.alignContent ||
                    x.alignItems != y.alignItems ||
                    x.alignSelf != y.alignSelf ||
                    x.flexBasis != y.flexBasis ||
                    x.maxHeight != y.maxHeight ||
                    x.maxWidth != y.maxWidth ||
                    x.minHeight != y.minHeight ||
                    x.minWidth != y.minWidth)
                {
                    changes |= VersionChangeType.Layout;
                }

                if (x.borderBottomWidth != y.borderBottomWidth ||
                    x.borderLeftWidth != y.borderLeftWidth ||
                    x.borderRightWidth != y.borderRightWidth ||
                    x.borderTopWidth != y.borderTopWidth)
                {
                    changes |= VersionChangeType.BorderWidth | VersionChangeType.Layout | VersionChangeType.Repaint;
                }
            }

            if (!x.inheritedData.ReferenceEquals(y.inheritedData))
            {
                if (x.color != y.color)
                {
                    changes |= VersionChangeType.Color;
                }

                if ((changes & (VersionChangeType.Layout | VersionChangeType.Repaint)) == 0 && (x.unityFont != y.unityFont ||
                    x.unityTextGenerator != y.unityTextGenerator ||
                    x.fontSize != y.fontSize ||
                    x.unityFontDefinition != y.unityFontDefinition ||
                    x.unityFontStyleAndWeight != y.unityFontStyleAndWeight ||
                    x.unityTextOutlineWidth != y.unityTextOutlineWidth ||
                    x.letterSpacing != y.letterSpacing ||
                    x.wordSpacing != y.wordSpacing ||
                    x.unityEditorTextRenderingMode != y.unityEditorTextRenderingMode ||
                    x.unityParagraphSpacing != y.unityParagraphSpacing))
                {
                    changes |= VersionChangeType.Layout | VersionChangeType.Repaint;
                }

                if ((changes & VersionChangeType.Repaint) == 0 && (x.textShadow != y.textShadow ||
                    x.unityTextAlign != y.unityTextAlign ||
                    x.unityTextOutlineColor != y.unityTextOutlineColor))
                {
                    changes |= VersionChangeType.Repaint;
                }

                if (x.visibility != y.visibility)
                {
                    changes |= VersionChangeType.Picking | VersionChangeType.Repaint;
                }

                if (x.whiteSpace != y.whiteSpace)
                {
                    changes |= VersionChangeType.Layout;
                }
            }

            if (!x.transformData.ReferenceEquals(y.transformData))
            {
                if (x.scale != y.scale ||
                    x.rotate != y.rotate ||
                    x.translate != y.translate ||
                    x.transformOrigin != y.transformOrigin)
                {
                    changes |= VersionChangeType.Transform;
                }
            }

            if (!x.transitionData.ReferenceEquals(y.transitionData))
            {
                if (!ComputedTransitionUtils.SameTransitionProperty(ref x, ref y))
                {
                    changes |= VersionChangeType.TransitionProperty;
                }
            }

            if (!x.visualData.ReferenceEquals(y.visualData))
            {
                if ((changes & VersionChangeType.Color) == 0 && (x.backgroundColor != y.backgroundColor ||
                    x.borderBottomColor != y.borderBottomColor ||
                    x.borderLeftColor != y.borderLeftColor ||
                    x.borderRightColor != y.borderRightColor ||
                    x.borderTopColor != y.borderTopColor))
                {
                    changes |= VersionChangeType.Color;
                }

                if ((changes & VersionChangeType.Repaint) == 0 && (x.backgroundImage != y.backgroundImage ||
                    x.backgroundPositionX != y.backgroundPositionX ||
                    x.backgroundPositionY != y.backgroundPositionY ||
                    x.backgroundRepeat != y.backgroundRepeat ||
                    x.backgroundSize != y.backgroundSize))
                {
                    changes |= VersionChangeType.Repaint;
                }

                if (x.borderBottomLeftRadius != y.borderBottomLeftRadius ||
                    x.borderBottomRightRadius != y.borderBottomRightRadius ||
                    x.borderTopLeftRadius != y.borderTopLeftRadius ||
                    x.borderTopRightRadius != y.borderTopRightRadius)
                {
                    changes |= VersionChangeType.BorderRadius | VersionChangeType.Repaint;
                }

                if (x.opacity != y.opacity)
                {
                    changes |= VersionChangeType.Opacity;
                }

                if (x.overflow != y.overflow)
                {
                    changes |= VersionChangeType.Layout | VersionChangeType.Overflow;
                }
            }

            if (!x.rareData.ReferenceEquals(y.rareData))
            {
                if ((changes & (VersionChangeType.Layout | VersionChangeType.Repaint)) == 0 && (x.unitySliceType != y.unitySliceType ||
                    x.textOverflow != y.textOverflow ||
                    x.unitySliceScale != y.unitySliceScale ||
                    x.unityTextAutoSize != y.unityTextAutoSize))
                {
                    changes |= VersionChangeType.Layout | VersionChangeType.Repaint;
                }

                if (x.unityBackgroundImageTintColor != y.unityBackgroundImageTintColor)
                {
                    changes |= VersionChangeType.Color;
                }

                if ((changes & VersionChangeType.Repaint) == 0 && (x.unityOverflowClipBox != y.unityOverflowClipBox ||
                    x.unitySliceBottom != y.unitySliceBottom ||
                    x.unitySliceLeft != y.unitySliceLeft ||
                    x.unitySliceRight != y.unitySliceRight ||
                    x.unitySliceTop != y.unitySliceTop ||
                    x.unityTextOverflowPosition != y.unityTextOverflowPosition))
                {
                    changes |= VersionChangeType.Repaint;
                }
            }

            return changes;
        }
    }
}
