// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

using System;
using System.Collections.Generic;
using Unity.Profiling.Editor;
using UnityEditor.Profiling;
using UnityEditorInternal.Profiling;
using UnityEngine.Profiling;

namespace UnityEditorInternal
{
    internal enum ProfilerViewType
    {
        Hierarchy = 0,
        Timeline = 1,
        RawHierarchy = 2,
        InvertedHierarchy = 3,
        TimelineV2 = 4
    }

    internal interface IProfilerWindowController
    {
        long selectedFrameIndex { get; set; }
        ProfilerModule selectedModule { get; set; }
        ProfilerModule GetProfilerModuleByType(Type T);
        ProfilerModule GetJobsProfilerModule();

        event Action frameDataViewAboutToBeDisposed;

        event Action<int, bool> currentFrameChanged;
        void SetClearOnPlay(bool enabled);
        bool GetClearOnPlay();

        HierarchyFrameDataView GetFrameDataView(string groupName, string threadName, ulong threadId, HierarchyFrameDataView.ViewModes viewMode, int profilerSortColumn, bool sortAscending);
        HierarchyFrameDataView GetFrameDataView(int threadIndex, HierarchyFrameDataView.ViewModes viewMode, int profilerSortColumn, bool sortAscending);

        bool IsRecording();
        bool ProfilerWindowOverheadIsAffectingProfilingRecordingData();

        string ConnectedTargetName { get; }
        bool ConnectedToEditor { get; }

        ProfilerProperty CreateProperty();
        ProfilerProperty CreateProperty(int sortType);

        void CloseModule(ProfilerModule module);

        void Repaint();
    }
}
