//
// File autogenerated from Include/C/Baselib_WakeupFallbackStrategy.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_WakeupFallbackStrategy.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>
        /// Can be used to control the wakeup behavior on platforms that don't support waking up a specific number of thread.
        /// Syscalls don't come for free so you need to weigh the cost of doing multiple syscalls against the cost of having lots of context switches.
        /// </summary>
        /// <remarks>
        /// There are however two easy cases.
        /// * When you only want to notify one thread use Baselib_WakeupFallbackStrategy_OneByOne.
        /// * When you want to wakeup all threads use Baselib_WakeupFallbackStrategy_All
        ///
        /// For the not so easy cases.
        /// * Use Baselib_WakeupFallbackStrategy_OneByOne when wake count is low, or significantly lower than the number of waiting threads.
        /// * Use Baselib_WakeupFallbackStrategy_All if wake count is high.
        /// </remarks>
        public enum Baselib_WakeupFallbackStrategy : Int32
        {
            /// <summary>Do one syscall for each waiting thread or notification.</summary>
            OneByOne = 0x0,
            /// <summary>Do a single syscall to wake all waiting threads.</summary>
            All = 0x1,
        }
    }
}
