//
// File autogenerated from Include/C/Baselib_ThreadLocalStorage.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_ThreadLocalStorage.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>It's guaranteed that we can allocate at least Baselib_TLS_MinimumGuaranteedSlots values on all platforms.</summary>
        public const UInt32 Baselib_TLS_MinimumGuaranteedSlots = 100;
        /// <summary>
        /// Allocates a new Thread Local Storage slot. In case of an error, abort with Baselib_ErrorCode_OutOfSystemResources will be triggered.
        /// On some platforms this might be fiber local storage.
        /// </summary>
        /// <remarks>The value of a newly create Thread Local Storage slot is guaranteed to be zero on all threads.</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UIntPtr Baselib_TLS_Alloc();
        /// <summary>Frees provided Thread Local Storage slot.</summary>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_TLS_Free(UIntPtr handle);
        /// <summary>Sets value to Thread Local Storage slot.</summary>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_TLS_Set(UIntPtr handle, UIntPtr value);
        /// <summary>Gets value from Thread Local Storage slot.</summary>
        /// <remarks>If called on just initialized variable, guaranteed to return 0.</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UIntPtr Baselib_TLS_Get(UIntPtr handle);
    }
}
