//
// File autogenerated from Include/C/Baselib_SystemSemaphore.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_SystemSemaphore.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_SystemSemaphore_Handle
        {
            public IntPtr handle;
        }
        public const int Baselib_SystemSemaphore_MaxCount = 2147483647;
        /// <summary>Creates a counting semaphore synchronization primitive.</summary>
        /// <remarks>If there are not enough system resources to create a semaphore, process abort is triggered.</remarks>
        /// <returns>A handle to a semaphore instance. Use Baselib_SystemSemaphore_Free to free the semaphore.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_SystemSemaphore_Handle Baselib_SystemSemaphore_Create();
        /// <summary>Creates a counting semaphore synchronization primitive given a memory buffer.</summary>
        /// <remarks>
        /// Semaphore is created in-place in semaphoreData and must be atleast Baselib_SystemSemaphore_PlatformSize in size.
        /// (Some platforms dont support in-place creation and this function then works the same as Baselib_SystemSemaphore_Create() )
        /// </remarks>
        /// <returns>A handle to a semaphore instance. Use Baselib_Semaphore_FreeInplace to free the semaphore.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_SystemSemaphore_Handle Baselib_SystemSemaphore_CreateInplace(IntPtr semaphoreData);
        /// <summary>Wait for semaphore token to become available</summary>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_SystemSemaphore_Acquire(Baselib_SystemSemaphore_Handle semaphore);
        /// <summary>Try to consume a token and return immediately.</summary>
        /// <returns>true if token was consumed. false if not.</returns>
        [FreeFunction(IsThreadSafe = true)]
        [return: MarshalAs(UnmanagedType.U1)]
        public static extern bool Baselib_SystemSemaphore_TryAcquire(Baselib_SystemSemaphore_Handle semaphore);
        /// <summary>Wait for semaphore token to become available</summary>
        /// <remarks>
        /// Timeout passed to this function may be subject to system clock resolution.
        /// If the system clock has a resolution of e.g. 16ms that means this function may exit with a timeout error 16ms earlier than originally scheduled.
        /// </remarks>
        /// <param name="timeout">Time to wait for token to become available.</param>
        /// <returns>true if token was consumed. false if timeout was reached.</returns>
        [FreeFunction(IsThreadSafe = true)]
        [return: MarshalAs(UnmanagedType.U1)]
        public static extern bool Baselib_SystemSemaphore_TryTimedAcquire(Baselib_SystemSemaphore_Handle semaphore, UInt32 timeoutInMilliseconds);
        /// <summary>Submit tokens to the semaphore.</summary>
        /// <remarks>
        /// Increase the number of available tokens on the semaphore by `count`. Any waiting threads will be notified there are new tokens available.
        /// If count reach `Baselib_SystemSemaphore_MaxCount` this function silently discard any overflow.
        /// Note that hitting max count may inflict a heavy performance penalty.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_SystemSemaphore_Release(Baselib_SystemSemaphore_Handle semaphore, UInt32 count);
        /// <summary>Reclaim resources and memory held by the semaphore.</summary>
        /// <remarks>If threads are waiting on the semaphore, calling free may cause process abort.</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_SystemSemaphore_Free(Baselib_SystemSemaphore_Handle semaphore);
        /// <summary>Reclaim resources held by the semaphore created using Baselib_SystemSemaphore_CreateInplace</summary>
        /// <remarks>
        /// If threads are waiting on the semaphore, calling free will trigger an assert and may cause process abort.
        /// Must not be used to free a semaphore created with Baselib_Semaphore_Create
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_SystemSemaphore_FreeInplace(Baselib_SystemSemaphore_Handle semaphore);
    }
}
