//
// File autogenerated from Include/C/Baselib_RegisteredNetwork.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_RegisteredNetwork.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>Check if registered network is emulated or natively supported.</summary>
        /// <returns>true if emulated.</returns>
        [FreeFunction(IsThreadSafe = true)]
        [return: MarshalAs(UnmanagedType.U1)]
        public static extern bool Baselib_RegisteredNetwork_IsEmulated();
        public static readonly IntPtr Baselib_RegisteredNetwork_Buffer_Id_Invalid = IntPtr.Zero;
        /// <summary>
        /// Network buffer structure.
        /// One buffer can contain multiple packets and endpoints.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_Buffer
        {
            public IntPtr id;
            public Baselib_Memory_PageAllocation allocation;
        }
        /// <summary>Create a network buffer from a set of previously allocated memory pages.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - InvalidAddressRange:       if pageAllocation is invalid
        /// </remarks>
        /// <returns>A network buffer. If registration fails, then buffer id is set to Baselib_RegisteredNetwork_Buffer_Id_Invalid.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_Buffer Baselib_RegisteredNetwork_Buffer_Register(Baselib_Memory_PageAllocation pageAllocation, Baselib_ErrorState* errorState);
        /// <summary>Deregister network buffer. Disassociate memory pages and buffer representation.</summary>
        /// <remarks>
        /// Allocated pages will stay allocated and can now be used for something else.
        /// Passing an invalid buffer results in a no-op.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_RegisteredNetwork_Buffer_Deregister(Baselib_RegisteredNetwork_Buffer buffer);
        /// <summary>Slice of a network buffer.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_BufferSlice
        {
            public IntPtr id;
            /// <summary>data of the slice</summary>
            public IntPtr data;
            /// <summary>size of the slice in bytes</summary>
            public UInt32 size;
            /// <summary>offset in main buffer</summary>
            public UInt32 offset;
        }
        /// <summary>Creates slice from network buffer</summary>
        /// <param name="buffer">Buffer to create slice from.</param>
        /// <param name="offset">Offset in buffer in bytes.</param>
        /// <param name="size">Size of the slice in bytes.</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_BufferSlice Baselib_RegisteredNetwork_BufferSlice_Create(Baselib_RegisteredNetwork_Buffer buffer, UInt32 offset, UInt32 size);
        /// <summary>Create empty slice that doesn't point to anything</summary>
        /// <remarks>Guaranteed to reference Baselib_RegisteredNetwork_Buffer_Id_Invalid and have all other values zeroed out.</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_BufferSlice Baselib_RegisteredNetwork_BufferSlice_Empty();
        /// <summary>Network endpoints are platform defined representation (sockaddr_in-like) of network address (family, ip, port).</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_Endpoint
        {
            public Baselib_RegisteredNetwork_BufferSlice slice;
        }
        /// <summary>in bytes</summary>
        public const UInt32 Baselib_RegisteredNetwork_Endpoint_MaxSize = 28;
        /// <summary>Place network address into the network buffer.</summary>
        /// <remarks>
        /// Destination must be able to accommodate Baselib_RegisteredNetwork_Endpoint_MaxSize bytes.
        ///
        /// Possible error codes:
        /// - InvalidArgument:       if dstSlice is invalid
        /// - InvalidBufferSize:     if dstSlice is smaller than Baselib_RegisteredNetwork_Endpoint_MaxSize
        /// </remarks>
        /// <param name="srcAddress">Network address to use, pass nullptr to create an empty endpoint.</param>
        /// <param name="dstSlice">Where to write encoded data.</param>
        /// <returns>Endpoint or Endpoint_Empty in case of failure.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_Endpoint Baselib_RegisteredNetwork_Endpoint_Create(Baselib_NetworkAddress* srcAddress, Baselib_RegisteredNetwork_BufferSlice dstSlice, Baselib_ErrorState* errorState);
        /// <summary>Return empty endpoint that doesn't point to anything</summary>
        /// <remarks>Guaranteed to contain Baselib_RegisteredNetwork_BufferSlice_Empty</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_Endpoint Baselib_RegisteredNetwork_Endpoint_Empty();
        /// <summary>Decode endpoint.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - InvalidArgument: if endpoint is invalid or dstAddress is null
        /// </remarks>
        /// <param name="endpoint">Endpoint to be converted.</param>
        /// <param name="dstAddress">Pointer to address to write data to.</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_RegisteredNetwork_Endpoint_GetNetworkAddress(Baselib_RegisteredNetwork_Endpoint endpoint, Baselib_NetworkAddress* dstAddress, Baselib_ErrorState* errorState);
        /// <summary>Send/receive request.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_Request
        {
            public Baselib_RegisteredNetwork_BufferSlice payload;
            /// <summary>
            /// for sending:     remote address to which the payload is sent (required for UDP)
            /// for receiving:   address from which the data was sent (optional)
            /// </summary>
            public Baselib_RegisteredNetwork_Endpoint remoteEndpoint;
            /// <summary>
            /// TODO: Not support yet. (We would also need to support this in Baselib_Socket first)
            /// for sending:     unused
            /// for receiving:   local address on which the data was received (optional)
            /// Baselib_RegisteredNetwork_Endpoint    localEndpoint;
            /// </summary>
            public IntPtr requestUserdata;
        }
        /// <summary>Success or failure of a Baselib_RegisteredNetwork_CompletionResult.</summary>
        public enum Baselib_RegisteredNetwork_CompletionStatus : Int32
        {
            /// <summary>Networking request failed.</summary>
            Failed = 0x0,
            /// <summary>Networking request successfully finished.</summary>
            Success = 0x1,
        }
        /// <summary>Result of a previously scheduled send/receive</summary>
        /// <remarks>When a networking request is completed, this is placed into an internal completion queue.</remarks>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_CompletionResult
        {
            public Baselib_RegisteredNetwork_CompletionStatus status;
            public UInt32 bytesTransferred;
            public IntPtr requestUserdata;
        }
        /// <summary>UDP connectionless socket.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_RegisteredNetwork_Socket_UDP
        {
            public IntPtr handle;
        }
        /// <summary>Creates an UDP socket with internal request and completion queues.</summary>
        /// <remarks>
        /// Known issues (behavior may change in the future):
        /// - Some platforms do not support sending zero sized UDP packets.
        ///
        /// Possible error codes:
        /// - InvalidArgument:           if bindAddress pointer is null or incompatible or both sendQueueSize and recvQueueSize are zero
        /// - EndpointInUse:             endpoint is already in use
        /// - AddressFamilyNotSupported: if the requested address family is not available.
        /// - OutOfSystemResources:      if network session limit was exceeded
        /// </remarks>
        /// <param name="bindAddress">Address to bind socket to, in connectionless UDP every socket has to be bound.</param>
        /// <param name="endpointReuse">
        /// Allows multiple sockets to be bound to the same address/port if set to AddressReuse_Allow,
        /// All sockets bound to the same address/port need to have this flag set.
        /// </param>
        /// <param name="sendQueueSize">Send queue size in amount of entries.</param>
        /// <param name="recvQueueSize">Receive queue size in amount of entries.</param>
        /// <returns>A UDP socket. If socket creation fails, socket holds a Baselib_RegisteredNetwork_Socket_UDP_InvalidHandle.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_Socket_UDP Baselib_RegisteredNetwork_Socket_UDP_Create(Baselib_NetworkAddress* bindAddress, Baselib_NetworkAddress_AddressReuse endpointReuse, UInt32 sendQueueSize, UInt32 recvQueueSize, Baselib_ErrorState* errorState);
        /// <summary>Schedules receive requests.</summary>
        /// <remarks>
        /// If requests is null or requestsCount is zero, this operation is a no-op.
        /// Note that actual receiving may be deferred until you call Baselib_RegisteredNetwork_Socket_UDP_ProcessRecv.
        /// UDP message data that doesn't fit a message buffer is silently discarded.
        ///
        /// Known issues (behavior may change in the future):
        /// - Some platforms does not support receiving zero sized UDP packets.
        ///
        /// Possible error codes:
        /// - InvalidArgument:   if socket is invalid
        /// </remarks>
        /// <param name="socket">Socket to be used.</param>
        /// <param name="requests">
        /// Array of pointers to requests. No-op if null.
        /// Request objects can be freed after the function call.
        /// </param>
        /// <param name="requestsCount">Amount of requests in the array. No-op if zero.</param>
        /// <returns>The number of scheduled items. If scheduling fails this function return zero.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_RegisteredNetwork_Socket_UDP_ScheduleRecv(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_RegisteredNetwork_Request* requests, UInt32 requestsCount, Baselib_ErrorState* errorState);
        /// <summary>Schedules send requests.</summary>
        /// <remarks>
        /// If requests is null or requestsCount is zero, this operation is a no-op.
        /// Note that actual receiving may be deferred until you call Baselib_RegisteredNetwork_Socket_UDP_ProcessSend.
        ///
        /// Possible error codes:
        /// - InvalidArgument:   if socket is invalid
        /// </remarks>
        /// <param name="socket">Socket to be used.</param>
        /// <param name="requests">
        /// Array of pointers to requests. No-op if null.
        /// Request objects can be freed after the function call.
        /// </param>
        /// <param name="requestsCount">Amount of requests in the array. No-op if zero.</param>
        /// <returns>The number of scheduled items. If scheduling fails this function return zero.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_RegisteredNetwork_Socket_UDP_ScheduleSend(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_RegisteredNetwork_Request* requests, UInt32 requestsCount, Baselib_ErrorState* errorState);
        /// <summary>Status of processing send/recv.</summary>
        public enum Baselib_RegisteredNetwork_ProcessStatus : Int32
        {
            /// <summary>No further items to process.</summary>
            /// <remarks>Note that this does not imply that all requests have been fully processed at any moment in time.</remarks>
            NonePendingImmediately = 0x0,
            /// <summary>deprecated, same as Baselib_RegisteredNetwork_ProcessStatus_NonePendingImmediately</summary>
            Done = 0x0,
            /// <summary>Should call again, there is more workload to process.</summary>
            Pending = 0x1,
        }
        /// <summary>Processes the receive queue on a socket.</summary>
        /// <remarks>
        /// Needs to be called periodically to ensure requests are processed.
        /// You should call this in loop until either your time budget is exceed or the function returns false.
        ///
        /// Platforms emulating RIO behavior with sockets, perform one receive per call until there are no more receive requests in the queue.
        /// Requests failed due to empty socket receive buffer are requeued and processed at the next call to Baselib_RegisteredNetwork_Socket_UDP_ProcessRecv.
        /// In that case Baselib_RegisteredNetwork_ProcessStatus_NonePendingImmediately is returned since an immediate retry will not have any effect.
        ///
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <returns>Baselib_RegisteredNetwork_ProcessStatus_Pending if there is more workload to process immediately, Baselib_RegisteredNetwork_ProcessStatus_NonePendingImmediately if otherwise</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_ProcessStatus Baselib_RegisteredNetwork_Socket_UDP_ProcessRecv(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_ErrorState* errorState);
        /// <summary>Processes the send queue on a socket.</summary>
        /// <remarks>
        /// Needs to be called periodically to ensure requests are processed.
        /// You should call this in loop until either your time budget is exceed or the function returns false.
        ///
        /// Platforms emulating RIO behavior with sockets, perform one send per call until there are no more send requests in the queue.
        /// Requests failed due to full socket send buffer are requeued processed at the next call to Baselib_RegisteredNetwork_Socket_UDP_ProcessSend.
        /// In that case Baselib_RegisteredNetwork_ProcessStatus_NonePendingImmediately is returned since an immediate retry will not have any effect.
        ///
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <returns>Baselib_RegisteredNetwork_ProcessStatus_Pending if there is more workload to process immediately, Baselib_RegisteredNetwork_ProcessStatus_NonePendingImmediately if otherwise</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_ProcessStatus Baselib_RegisteredNetwork_Socket_UDP_ProcessSend(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_ErrorState* errorState);
        /// <summary>Status of a recv/send completion queue.</summary>
        public enum Baselib_RegisteredNetwork_CompletionQueueStatus : Int32
        {
            /// <summary>No results are ready for dequeing.</summary>
            NoResultsAvailable = 0x0,
            /// <summary>Results are available for dequeing.</summary>
            ResultsAvailable = 0x1,
        }
        /// <summary>Wait until results appears for a previously scheduled receive.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <param name="timeoutInMilliseconds">Wait timeout.</param>
        /// <returns>Baselib_RegisteredNetwork_CompletionQueueStatus_ResultsAvailable if results are available for dequeue, Baselib_RegisteredNetwork_CompletionQueueStatus_NoResultsAvailable otherwise</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_CompletionQueueStatus Baselib_RegisteredNetwork_Socket_UDP_WaitForCompletedRecv(Baselib_RegisteredNetwork_Socket_UDP socket, UInt32 timeoutInMilliseconds, Baselib_ErrorState* errorState);
        /// <summary>Wait until results appears for a previously scheduled send.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <param name="timeoutInMilliseconds">Wait timeout.</param>
        /// <returns>Baselib_RegisteredNetwork_CompletionQueueStatus_ResultsAvailable if results are available for dequeue, Baselib_RegisteredNetwork_CompletionQueueStatus_NoResultsAvailable otherwise</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_RegisteredNetwork_CompletionQueueStatus Baselib_RegisteredNetwork_Socket_UDP_WaitForCompletedSend(Baselib_RegisteredNetwork_Socket_UDP socket, UInt32 timeoutInMilliseconds, Baselib_ErrorState* errorState);
        /// <summary>Dequeue receive result.</summary>
        /// <remarks>
        /// If you're calling this method on multiple threads for the same completion queue in parallel, it may spuriously return 0.
        ///
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <param name="results">Results array. No-op if null.</param>
        /// <param name="resultsCount">Amount of elements in results array. No-op if zero.</param>
        /// <returns>number of dequeued entries</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_RegisteredNetwork_Socket_UDP_DequeueRecv(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_RegisteredNetwork_CompletionResult* results, UInt32 resultsCount, Baselib_ErrorState* errorState);
        /// <summary>Dequeue send result.</summary>
        /// <remarks>
        /// If you're calling this method on multiple threads for the same completion queue in parallel, it may spuriously return 0.
        ///
        /// Possible error codes:
        /// - InvalidArgument:     if socket is invalid
        /// </remarks>
        /// <param name="results">Results array. No-op if null.</param>
        /// <param name="resultsCount">Amount of elements in results array. No-op if zero.</param>
        /// <returns>number of dequeued entries</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_RegisteredNetwork_Socket_UDP_DequeueSend(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_RegisteredNetwork_CompletionResult* results, UInt32 resultsCount, Baselib_ErrorState* errorState);
        /// <summary>Get bind address of udp socket.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - InvalidArgument:   if socket is invalid or if dstAddress is null
        /// </remarks>
        /// <param name="socket">Socket to be used.</param>
        /// <param name="dstAddress">Pointer to address to write data to.</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_RegisteredNetwork_Socket_UDP_GetNetworkAddress(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_NetworkAddress* dstAddress, Baselib_ErrorState* errorState);
        /// <summary>Closes UDP socket.</summary>
        /// <remarks>Passing an invalid socket handle result in a no-op.</remarks>
        /// <param name="socket">Socket to be closed.</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_RegisteredNetwork_Socket_UDP_Close(Baselib_RegisteredNetwork_Socket_UDP socket);
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_RegisteredNetwork_Socket_UDP_SetIPv4DontFragHeader(Baselib_RegisteredNetwork_Socket_UDP socket,         [MarshalAs(UnmanagedType.U1)] bool set, Baselib_ErrorState* errorState);
        [FreeFunction(IsThreadSafe = true)]
        [return: MarshalAs(UnmanagedType.U1)]
        public static extern bool Baselib_RegisteredNetwork_Socket_UDP_GetIPv4DontFragHeader(Baselib_RegisteredNetwork_Socket_UDP socket, Baselib_ErrorState* errorState);
    }
}
