//
// File autogenerated from Include/C/Baselib_NetworkAddress.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_NetworkAddress.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>Address family.</summary>
        public enum Baselib_NetworkAddress_Family : Int32
        {
            Invalid = 0x0,
            IPv4 = 0x1,
            IPv6 = 0x2,
        }
        /// <summary>Fixed size address structure, large enough to hold IPv4 and IPv6 addresses.</summary>
        [StructLayout(LayoutKind.Explicit)]
        public struct Baselib_NetworkAddress
        {
            // byte data[16];
            [FieldOffset(0)]
            public byte data0;
            [FieldOffset(1)]
            public byte data1;
            [FieldOffset(2)]
            public byte data2;
            [FieldOffset(3)]
            public byte data3;
            [FieldOffset(4)]
            public byte data4;
            [FieldOffset(5)]
            public byte data5;
            [FieldOffset(6)]
            public byte data6;
            [FieldOffset(7)]
            public byte data7;
            [FieldOffset(8)]
            public byte data8;
            [FieldOffset(9)]
            public byte data9;
            [FieldOffset(10)]
            public byte data10;
            [FieldOffset(11)]
            public byte data11;
            [FieldOffset(12)]
            public byte data12;
            [FieldOffset(13)]
            public byte data13;
            [FieldOffset(14)]
            public byte data14;
            [FieldOffset(15)]
            public byte data15;
            // byte ipv6[16];
            [FieldOffset(0)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_0;
            [FieldOffset(1)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_1;
            [FieldOffset(2)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_2;
            [FieldOffset(3)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_3;
            [FieldOffset(4)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_4;
            [FieldOffset(5)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_5;
            [FieldOffset(6)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_6;
            [FieldOffset(7)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_7;
            [FieldOffset(8)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_8;
            [FieldOffset(9)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_9;
            [FieldOffset(10)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_10;
            [FieldOffset(11)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_11;
            [FieldOffset(12)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_12;
            [FieldOffset(13)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_13;
            [FieldOffset(14)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_14;
            [FieldOffset(15)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv6_15;
            // byte ipv4[4];
            [FieldOffset(0)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv4_0;
            [FieldOffset(1)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv4_1;
            [FieldOffset(2)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv4_2;
            [FieldOffset(3)]
            [Ignore(DoesNotContributeToSize = true)]
            public byte ipv4_3;
            /// <summary>in network byte order</summary>
            // byte port[2];
            [FieldOffset(16)]
            public byte port0;
            [FieldOffset(17)]
            public byte port1;
            [FieldOffset(18)]
            public byte family;
            /// <summary>Explicit padding to allow for deterministic bitwise compare.</summary>
            [FieldOffset(19)]
            public byte _padding;
            /// <summary>
            /// Scope zone index for IPv6 (ignored for IPv4)
            /// Defaults to zero if not specified.
            /// Note that unlike the other fields in this struct, this is *not* in network byte order!
            /// </summary>
            [FieldOffset(20)]
            public UInt32 ipv6_scope_id;
        }
        /// <summary>Max length of any string representing an IP address</summary>
        public const UInt32 Baselib_NetworkAddress_IpMaxStringLength = 46;
        /// <summary>Binary encode string representation of an address.</summary>
        /// <remarks>
        /// Neither port not ipAddressBuffer scope id are parsed from the ip string.
        /// dstAddress->ipv6_scope_id is set to zero and needs to be manually set if required.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument - One or more of the input parameters are invalid
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_NetworkAddress_Encode(Baselib_NetworkAddress* dstAddress, Baselib_NetworkAddress_Family family, byte* ip, UInt16 port, Baselib_ErrorState* errorState);
        /// <summary>Decode binary representation of an address.</summary>
        /// <remarks>
        /// family, ipAddressBuffer, and port are all optional arguments.
        /// passing zero as ipAddressBufferLen is the same as passing an ipAddressBuffer nullptr.
        /// Port and IPv6 scope id are not encodeded to ipAddressBuffer.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument - srcAddress is null or otherwise invalid.
        /// - Baselib_ErrorCode_InvalidBufferSize - ipAddressBuffer is too small to hold decoded ip address.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_NetworkAddress_Decode(Baselib_NetworkAddress* srcAddress, Baselib_NetworkAddress_Family* family, byte* ipAddressBuffer, UInt32 ipAddressBufferLen, UInt16* port, Baselib_ErrorState* errorState);
        public enum Baselib_NetworkAddress_AddressReuse : Int32
        {
            DoNotAllow = 0x0,
            /// <summary>
            /// Allow multiple sockets to be bound to the same address/port.
            /// All sockets bound to the same address/port need to have this flag set.
            /// </summary>
            Allow = 0x1,
        }
    }
}
