// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

using System;
using UnityEngineInternal;
using UnityEngine.Bindings;


namespace UnityEngine.Diagnostics
{
    public enum ForcedCrashCategory
    {
        AccessViolation = 0,
        FatalError = 1,
        Abort = 2,
        PureVirtualFunction = 3,
        MonoAbort = 4
    }

    [NativeHeader("Runtime/Export/Diagnostics/DiagnosticsUtils.bindings.h")]
    [NativeHeader("Runtime/Misc/GarbageCollectSharedAssets.h")]
    public static class Utils
    {
        [FreeFunction("DiagnosticsUtils_Bindings::ForceCrash", IsThreadSafe = true, ThrowsException = true)]
        extern public static void ForceCrash(ForcedCrashCategory crashCategory);

        [FreeFunction("DiagnosticsUtils_Bindings::NativeAssert", IsThreadSafe = true)]
        extern public static void NativeAssert(string message);

        [FreeFunction("DiagnosticsUtils_Bindings::NativeError", IsThreadSafe = true)]
        extern public static void NativeError(string message);

        [FreeFunction("DiagnosticsUtils_Bindings::NativeWarning", IsThreadSafe = true)]
        extern public static void NativeWarning(string message);

        [FreeFunction("ValidateHeap")]
        extern public static void ValidateHeap();
    }
}
