// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

/******************************************************************************/
//
//                             DO NOT MODIFY
//          This file has been generated by the UIElementsGenerator tool
//              See StylePropertyUtilCsGenerator class for details
//
/******************************************************************************/
using System;
using System.Collections.Generic;

namespace UnityEngine.UIElements.StyleSheets
{
    internal static partial class StylePropertyUtil
    {
        public const int k_GroupOffset = 16;

        internal static readonly Dictionary<string, StylePropertyId> s_NameToId = new Dictionary<string, StylePropertyId>()
        {
            {"align-content", StylePropertyId.AlignContent},
            {"align-items", StylePropertyId.AlignItems},
            {"align-self", StylePropertyId.AlignSelf},
            {"all", StylePropertyId.All},
            {"background-color", StylePropertyId.BackgroundColor},
            {"background-image", StylePropertyId.BackgroundImage},
            {"background-position", StylePropertyId.BackgroundPosition},
            {"background-position-x", StylePropertyId.BackgroundPositionX},
            {"background-position-y", StylePropertyId.BackgroundPositionY},
            {"background-repeat", StylePropertyId.BackgroundRepeat},
            {"background-size", StylePropertyId.BackgroundSize},
            {"border-bottom-color", StylePropertyId.BorderBottomColor},
            {"border-bottom-left-radius", StylePropertyId.BorderBottomLeftRadius},
            {"border-bottom-right-radius", StylePropertyId.BorderBottomRightRadius},
            {"border-bottom-width", StylePropertyId.BorderBottomWidth},
            {"border-color", StylePropertyId.BorderColor},
            {"border-left-color", StylePropertyId.BorderLeftColor},
            {"border-left-width", StylePropertyId.BorderLeftWidth},
            {"border-radius", StylePropertyId.BorderRadius},
            {"border-right-color", StylePropertyId.BorderRightColor},
            {"border-right-width", StylePropertyId.BorderRightWidth},
            {"border-top-color", StylePropertyId.BorderTopColor},
            {"border-top-left-radius", StylePropertyId.BorderTopLeftRadius},
            {"border-top-right-radius", StylePropertyId.BorderTopRightRadius},
            {"border-top-width", StylePropertyId.BorderTopWidth},
            {"border-width", StylePropertyId.BorderWidth},
            {"bottom", StylePropertyId.Bottom},
            {"color", StylePropertyId.Color},
            {"cursor", StylePropertyId.Cursor},
            {"display", StylePropertyId.Display},
            {"flex", StylePropertyId.Flex},
            {"flex-basis", StylePropertyId.FlexBasis},
            {"flex-direction", StylePropertyId.FlexDirection},
            {"flex-grow", StylePropertyId.FlexGrow},
            {"flex-shrink", StylePropertyId.FlexShrink},
            {"flex-wrap", StylePropertyId.FlexWrap},
            {"font-size", StylePropertyId.FontSize},
            {"height", StylePropertyId.Height},
            {"justify-content", StylePropertyId.JustifyContent},
            {"left", StylePropertyId.Left},
            {"letter-spacing", StylePropertyId.LetterSpacing},
            {"margin", StylePropertyId.Margin},
            {"margin-bottom", StylePropertyId.MarginBottom},
            {"margin-left", StylePropertyId.MarginLeft},
            {"margin-right", StylePropertyId.MarginRight},
            {"margin-top", StylePropertyId.MarginTop},
            {"max-height", StylePropertyId.MaxHeight},
            {"max-width", StylePropertyId.MaxWidth},
            {"min-height", StylePropertyId.MinHeight},
            {"min-width", StylePropertyId.MinWidth},
            {"opacity", StylePropertyId.Opacity},
            {"overflow", StylePropertyId.Overflow},
            {"padding", StylePropertyId.Padding},
            {"padding-bottom", StylePropertyId.PaddingBottom},
            {"padding-left", StylePropertyId.PaddingLeft},
            {"padding-right", StylePropertyId.PaddingRight},
            {"padding-top", StylePropertyId.PaddingTop},
            {"position", StylePropertyId.Position},
            {"right", StylePropertyId.Right},
            {"rotate", StylePropertyId.Rotate},
            {"scale", StylePropertyId.Scale},
            {"text-overflow", StylePropertyId.TextOverflow},
            {"text-shadow", StylePropertyId.TextShadow},
            {"top", StylePropertyId.Top},
            {"transform-origin", StylePropertyId.TransformOrigin},
            {"transition", StylePropertyId.Transition},
            {"transition-delay", StylePropertyId.TransitionDelay},
            {"transition-duration", StylePropertyId.TransitionDuration},
            {"transition-property", StylePropertyId.TransitionProperty},
            {"transition-timing-function", StylePropertyId.TransitionTimingFunction},
            {"translate", StylePropertyId.Translate},
            {"-unity-background-image-tint-color", StylePropertyId.UnityBackgroundImageTintColor},
            {"-unity-background-scale-mode", StylePropertyId.UnityBackgroundScaleMode},
            {"-unity-editor-text-rendering-mode", StylePropertyId.UnityEditorTextRenderingMode},
            {"-unity-font", StylePropertyId.UnityFont},
            {"-unity-font-definition", StylePropertyId.UnityFontDefinition},
            {"-unity-font-style", StylePropertyId.UnityFontStyleAndWeight},
            {"-unity-overflow-clip-box", StylePropertyId.UnityOverflowClipBox},
            {"-unity-paragraph-spacing", StylePropertyId.UnityParagraphSpacing},
            {"-unity-slice-bottom", StylePropertyId.UnitySliceBottom},
            {"-unity-slice-left", StylePropertyId.UnitySliceLeft},
            {"-unity-slice-right", StylePropertyId.UnitySliceRight},
            {"-unity-slice-scale", StylePropertyId.UnitySliceScale},
            {"-unity-slice-top", StylePropertyId.UnitySliceTop},
            {"-unity-slice-type", StylePropertyId.UnitySliceType},
            {"-unity-text-align", StylePropertyId.UnityTextAlign},
            {"-unity-text-auto-size", StylePropertyId.UnityTextAutoSize},
            {"-unity-text-generator", StylePropertyId.UnityTextGenerator},
            {"-unity-text-outline", StylePropertyId.UnityTextOutline},
            {"-unity-text-outline-color", StylePropertyId.UnityTextOutlineColor},
            {"-unity-text-outline-width", StylePropertyId.UnityTextOutlineWidth},
            {"-unity-text-overflow-position", StylePropertyId.UnityTextOverflowPosition},
            {"visibility", StylePropertyId.Visibility},
            {"white-space", StylePropertyId.WhiteSpace},
            {"width", StylePropertyId.Width},
            {"word-spacing", StylePropertyId.WordSpacing}
        };

        internal static readonly Dictionary<StylePropertyId, string> s_IdToName = new Dictionary<StylePropertyId, string>()
        {
            {StylePropertyId.AlignContent, "align-content"},
            {StylePropertyId.AlignItems, "align-items"},
            {StylePropertyId.AlignSelf, "align-self"},
            {StylePropertyId.All, "all"},
            {StylePropertyId.BackgroundColor, "background-color"},
            {StylePropertyId.BackgroundImage, "background-image"},
            {StylePropertyId.BackgroundPosition, "background-position"},
            {StylePropertyId.BackgroundPositionX, "background-position-x"},
            {StylePropertyId.BackgroundPositionY, "background-position-y"},
            {StylePropertyId.BackgroundRepeat, "background-repeat"},
            {StylePropertyId.BackgroundSize, "background-size"},
            {StylePropertyId.BorderBottomColor, "border-bottom-color"},
            {StylePropertyId.BorderBottomLeftRadius, "border-bottom-left-radius"},
            {StylePropertyId.BorderBottomRightRadius, "border-bottom-right-radius"},
            {StylePropertyId.BorderBottomWidth, "border-bottom-width"},
            {StylePropertyId.BorderColor, "border-color"},
            {StylePropertyId.BorderLeftColor, "border-left-color"},
            {StylePropertyId.BorderLeftWidth, "border-left-width"},
            {StylePropertyId.BorderRadius, "border-radius"},
            {StylePropertyId.BorderRightColor, "border-right-color"},
            {StylePropertyId.BorderRightWidth, "border-right-width"},
            {StylePropertyId.BorderTopColor, "border-top-color"},
            {StylePropertyId.BorderTopLeftRadius, "border-top-left-radius"},
            {StylePropertyId.BorderTopRightRadius, "border-top-right-radius"},
            {StylePropertyId.BorderTopWidth, "border-top-width"},
            {StylePropertyId.BorderWidth, "border-width"},
            {StylePropertyId.Bottom, "bottom"},
            {StylePropertyId.Color, "color"},
            {StylePropertyId.Cursor, "cursor"},
            {StylePropertyId.Display, "display"},
            {StylePropertyId.Flex, "flex"},
            {StylePropertyId.FlexBasis, "flex-basis"},
            {StylePropertyId.FlexDirection, "flex-direction"},
            {StylePropertyId.FlexGrow, "flex-grow"},
            {StylePropertyId.FlexShrink, "flex-shrink"},
            {StylePropertyId.FlexWrap, "flex-wrap"},
            {StylePropertyId.FontSize, "font-size"},
            {StylePropertyId.Height, "height"},
            {StylePropertyId.JustifyContent, "justify-content"},
            {StylePropertyId.Left, "left"},
            {StylePropertyId.LetterSpacing, "letter-spacing"},
            {StylePropertyId.Margin, "margin"},
            {StylePropertyId.MarginBottom, "margin-bottom"},
            {StylePropertyId.MarginLeft, "margin-left"},
            {StylePropertyId.MarginRight, "margin-right"},
            {StylePropertyId.MarginTop, "margin-top"},
            {StylePropertyId.MaxHeight, "max-height"},
            {StylePropertyId.MaxWidth, "max-width"},
            {StylePropertyId.MinHeight, "min-height"},
            {StylePropertyId.MinWidth, "min-width"},
            {StylePropertyId.Opacity, "opacity"},
            {StylePropertyId.Overflow, "overflow"},
            {StylePropertyId.Padding, "padding"},
            {StylePropertyId.PaddingBottom, "padding-bottom"},
            {StylePropertyId.PaddingLeft, "padding-left"},
            {StylePropertyId.PaddingRight, "padding-right"},
            {StylePropertyId.PaddingTop, "padding-top"},
            {StylePropertyId.Position, "position"},
            {StylePropertyId.Right, "right"},
            {StylePropertyId.Rotate, "rotate"},
            {StylePropertyId.Scale, "scale"},
            {StylePropertyId.TextOverflow, "text-overflow"},
            {StylePropertyId.TextShadow, "text-shadow"},
            {StylePropertyId.Top, "top"},
            {StylePropertyId.TransformOrigin, "transform-origin"},
            {StylePropertyId.Transition, "transition"},
            {StylePropertyId.TransitionDelay, "transition-delay"},
            {StylePropertyId.TransitionDuration, "transition-duration"},
            {StylePropertyId.TransitionProperty, "transition-property"},
            {StylePropertyId.TransitionTimingFunction, "transition-timing-function"},
            {StylePropertyId.Translate, "translate"},
            {StylePropertyId.UnityBackgroundImageTintColor, "-unity-background-image-tint-color"},
            {StylePropertyId.UnityBackgroundScaleMode, "-unity-background-scale-mode"},
            {StylePropertyId.UnityEditorTextRenderingMode, "-unity-editor-text-rendering-mode"},
            {StylePropertyId.UnityFont, "-unity-font"},
            {StylePropertyId.UnityFontDefinition, "-unity-font-definition"},
            {StylePropertyId.UnityFontStyleAndWeight, "-unity-font-style"},
            {StylePropertyId.UnityOverflowClipBox, "-unity-overflow-clip-box"},
            {StylePropertyId.UnityParagraphSpacing, "-unity-paragraph-spacing"},
            {StylePropertyId.UnitySliceBottom, "-unity-slice-bottom"},
            {StylePropertyId.UnitySliceLeft, "-unity-slice-left"},
            {StylePropertyId.UnitySliceRight, "-unity-slice-right"},
            {StylePropertyId.UnitySliceScale, "-unity-slice-scale"},
            {StylePropertyId.UnitySliceTop, "-unity-slice-top"},
            {StylePropertyId.UnitySliceType, "-unity-slice-type"},
            {StylePropertyId.UnityTextAlign, "-unity-text-align"},
            {StylePropertyId.UnityTextAutoSize, "-unity-text-auto-size"},
            {StylePropertyId.UnityTextGenerator, "-unity-text-generator"},
            {StylePropertyId.UnityTextOutline, "-unity-text-outline"},
            {StylePropertyId.UnityTextOutlineColor, "-unity-text-outline-color"},
            {StylePropertyId.UnityTextOutlineWidth, "-unity-text-outline-width"},
            {StylePropertyId.UnityTextOverflowPosition, "-unity-text-overflow-position"},
            {StylePropertyId.Visibility, "visibility"},
            {StylePropertyId.WhiteSpace, "white-space"},
            {StylePropertyId.Width, "width"},
            {StylePropertyId.WordSpacing, "word-spacing"}
        };

        internal static readonly Dictionary<string, string> s_UssNameToCSharpName = new Dictionary<string, string>()
        {
            {"align-content", "alignContent"},
            {"align-items", "alignItems"},
            {"align-self", "alignSelf"},
            {"all", "all"},
            {"background-color", "backgroundColor"},
            {"background-image", "backgroundImage"},
            {"background-position", "backgroundPosition"},
            {"background-position-x", "backgroundPositionX"},
            {"background-position-y", "backgroundPositionY"},
            {"background-repeat", "backgroundRepeat"},
            {"background-size", "backgroundSize"},
            {"border-bottom-color", "borderBottomColor"},
            {"border-bottom-left-radius", "borderBottomLeftRadius"},
            {"border-bottom-right-radius", "borderBottomRightRadius"},
            {"border-bottom-width", "borderBottomWidth"},
            {"border-color", "borderColor"},
            {"border-left-color", "borderLeftColor"},
            {"border-left-width", "borderLeftWidth"},
            {"border-radius", "borderRadius"},
            {"border-right-color", "borderRightColor"},
            {"border-right-width", "borderRightWidth"},
            {"border-top-color", "borderTopColor"},
            {"border-top-left-radius", "borderTopLeftRadius"},
            {"border-top-right-radius", "borderTopRightRadius"},
            {"border-top-width", "borderTopWidth"},
            {"border-width", "borderWidth"},
            {"bottom", "bottom"},
            {"color", "color"},
            {"cursor", "cursor"},
            {"display", "display"},
            {"flex", "flex"},
            {"flex-basis", "flexBasis"},
            {"flex-direction", "flexDirection"},
            {"flex-grow", "flexGrow"},
            {"flex-shrink", "flexShrink"},
            {"flex-wrap", "flexWrap"},
            {"font-size", "fontSize"},
            {"height", "height"},
            {"justify-content", "justifyContent"},
            {"left", "left"},
            {"letter-spacing", "letterSpacing"},
            {"margin", "margin"},
            {"margin-bottom", "marginBottom"},
            {"margin-left", "marginLeft"},
            {"margin-right", "marginRight"},
            {"margin-top", "marginTop"},
            {"max-height", "maxHeight"},
            {"max-width", "maxWidth"},
            {"min-height", "minHeight"},
            {"min-width", "minWidth"},
            {"opacity", "opacity"},
            {"overflow", "overflow"},
            {"padding", "padding"},
            {"padding-bottom", "paddingBottom"},
            {"padding-left", "paddingLeft"},
            {"padding-right", "paddingRight"},
            {"padding-top", "paddingTop"},
            {"position", "position"},
            {"right", "right"},
            {"rotate", "rotate"},
            {"scale", "scale"},
            {"text-overflow", "textOverflow"},
            {"text-shadow", "textShadow"},
            {"top", "top"},
            {"transform-origin", "transformOrigin"},
            {"transition", "transition"},
            {"transition-delay", "transitionDelay"},
            {"transition-duration", "transitionDuration"},
            {"transition-property", "transitionProperty"},
            {"transition-timing-function", "transitionTimingFunction"},
            {"translate", "translate"},
            {"-unity-background-image-tint-color", "unityBackgroundImageTintColor"},
            {"-unity-background-scale-mode", "unityBackgroundScaleMode"},
            {"-unity-editor-text-rendering-mode", "unityEditorTextRenderingMode"},
            {"-unity-font", "unityFont"},
            {"-unity-font-definition", "unityFontDefinition"},
            {"-unity-font-style", "unityFontStyleAndWeight"},
            {"-unity-overflow-clip-box", "unityOverflowClipBox"},
            {"-unity-paragraph-spacing", "unityParagraphSpacing"},
            {"-unity-slice-bottom", "unitySliceBottom"},
            {"-unity-slice-left", "unitySliceLeft"},
            {"-unity-slice-right", "unitySliceRight"},
            {"-unity-slice-scale", "unitySliceScale"},
            {"-unity-slice-top", "unitySliceTop"},
            {"-unity-slice-type", "unitySliceType"},
            {"-unity-text-align", "unityTextAlign"},
            {"-unity-text-auto-size", "unityTextAutoSize"},
            {"-unity-text-generator", "unityTextGenerator"},
            {"-unity-text-outline", "unityTextOutline"},
            {"-unity-text-outline-color", "unityTextOutlineColor"},
            {"-unity-text-outline-width", "unityTextOutlineWidth"},
            {"-unity-text-overflow-position", "unityTextOverflowPosition"},
            {"visibility", "visibility"},
            {"white-space", "whiteSpace"},
            {"width", "width"},
            {"word-spacing", "wordSpacing"}
        };

        internal static readonly Dictionary<string, string> s_CSharpNameToUssName = new Dictionary<string, string>()
        {
            {"alignContent", "align-content"},
            {"alignItems", "align-items"},
            {"alignSelf", "align-self"},
            {"all", "all"},
            {"backgroundColor", "background-color"},
            {"backgroundImage", "background-image"},
            {"backgroundPosition", "background-position"},
            {"backgroundPositionX", "background-position-x"},
            {"backgroundPositionY", "background-position-y"},
            {"backgroundRepeat", "background-repeat"},
            {"backgroundSize", "background-size"},
            {"borderBottomColor", "border-bottom-color"},
            {"borderBottomLeftRadius", "border-bottom-left-radius"},
            {"borderBottomRightRadius", "border-bottom-right-radius"},
            {"borderBottomWidth", "border-bottom-width"},
            {"borderColor", "border-color"},
            {"borderLeftColor", "border-left-color"},
            {"borderLeftWidth", "border-left-width"},
            {"borderRadius", "border-radius"},
            {"borderRightColor", "border-right-color"},
            {"borderRightWidth", "border-right-width"},
            {"borderTopColor", "border-top-color"},
            {"borderTopLeftRadius", "border-top-left-radius"},
            {"borderTopRightRadius", "border-top-right-radius"},
            {"borderTopWidth", "border-top-width"},
            {"borderWidth", "border-width"},
            {"bottom", "bottom"},
            {"color", "color"},
            {"cursor", "cursor"},
            {"display", "display"},
            {"flex", "flex"},
            {"flexBasis", "flex-basis"},
            {"flexDirection", "flex-direction"},
            {"flexGrow", "flex-grow"},
            {"flexShrink", "flex-shrink"},
            {"flexWrap", "flex-wrap"},
            {"fontSize", "font-size"},
            {"height", "height"},
            {"justifyContent", "justify-content"},
            {"left", "left"},
            {"letterSpacing", "letter-spacing"},
            {"margin", "margin"},
            {"marginBottom", "margin-bottom"},
            {"marginLeft", "margin-left"},
            {"marginRight", "margin-right"},
            {"marginTop", "margin-top"},
            {"maxHeight", "max-height"},
            {"maxWidth", "max-width"},
            {"minHeight", "min-height"},
            {"minWidth", "min-width"},
            {"opacity", "opacity"},
            {"overflow", "overflow"},
            {"padding", "padding"},
            {"paddingBottom", "padding-bottom"},
            {"paddingLeft", "padding-left"},
            {"paddingRight", "padding-right"},
            {"paddingTop", "padding-top"},
            {"position", "position"},
            {"right", "right"},
            {"rotate", "rotate"},
            {"scale", "scale"},
            {"textOverflow", "text-overflow"},
            {"textShadow", "text-shadow"},
            {"top", "top"},
            {"transformOrigin", "transform-origin"},
            {"transition", "transition"},
            {"transitionDelay", "transition-delay"},
            {"transitionDuration", "transition-duration"},
            {"transitionProperty", "transition-property"},
            {"transitionTimingFunction", "transition-timing-function"},
            {"translate", "translate"},
            {"unityBackgroundImageTintColor", "-unity-background-image-tint-color"},
            {"unityBackgroundScaleMode", "-unity-background-scale-mode"},
            {"unityEditorTextRenderingMode", "-unity-editor-text-rendering-mode"},
            {"unityFont", "-unity-font"},
            {"unityFontDefinition", "-unity-font-definition"},
            {"unityFontStyleAndWeight", "-unity-font-style"},
            {"unityOverflowClipBox", "-unity-overflow-clip-box"},
            {"unityParagraphSpacing", "-unity-paragraph-spacing"},
            {"unitySliceBottom", "-unity-slice-bottom"},
            {"unitySliceLeft", "-unity-slice-left"},
            {"unitySliceRight", "-unity-slice-right"},
            {"unitySliceScale", "-unity-slice-scale"},
            {"unitySliceTop", "-unity-slice-top"},
            {"unitySliceType", "-unity-slice-type"},
            {"unityTextAlign", "-unity-text-align"},
            {"unityTextAutoSize", "-unity-text-auto-size"},
            {"unityTextGenerator", "-unity-text-generator"},
            {"unityTextOutline", "-unity-text-outline"},
            {"unityTextOutlineColor", "-unity-text-outline-color"},
            {"unityTextOutlineWidth", "-unity-text-outline-width"},
            {"unityTextOverflowPosition", "-unity-text-overflow-position"},
            {"visibility", "visibility"},
            {"whiteSpace", "white-space"},
            {"width", "width"},
            {"wordSpacing", "word-spacing"}
        };

        internal static readonly HashSet<StylePropertyId> s_AnimatableProperties = new HashSet<StylePropertyId>()
        {StylePropertyId.AlignContent, StylePropertyId.AlignItems, StylePropertyId.AlignSelf, StylePropertyId.All, StylePropertyId.BackgroundColor, StylePropertyId.BackgroundImage, StylePropertyId.BackgroundPosition, StylePropertyId.BackgroundPositionX, StylePropertyId.BackgroundPositionY, StylePropertyId.BackgroundRepeat, StylePropertyId.BackgroundSize, StylePropertyId.BorderBottomColor, StylePropertyId.BorderBottomLeftRadius, StylePropertyId.BorderBottomRightRadius, StylePropertyId.BorderBottomWidth, StylePropertyId.BorderColor, StylePropertyId.BorderLeftColor, StylePropertyId.BorderLeftWidth, StylePropertyId.BorderRadius, StylePropertyId.BorderRightColor, StylePropertyId.BorderRightWidth, StylePropertyId.BorderTopColor, StylePropertyId.BorderTopLeftRadius, StylePropertyId.BorderTopRightRadius, StylePropertyId.BorderTopWidth, StylePropertyId.BorderWidth, StylePropertyId.Bottom, StylePropertyId.Color, StylePropertyId.Flex, StylePropertyId.FlexBasis, StylePropertyId.FlexDirection, StylePropertyId.FlexGrow, StylePropertyId.FlexShrink, StylePropertyId.FlexWrap, StylePropertyId.FontSize, StylePropertyId.Height, StylePropertyId.JustifyContent, StylePropertyId.Left, StylePropertyId.LetterSpacing, StylePropertyId.Margin, StylePropertyId.MarginBottom, StylePropertyId.MarginLeft, StylePropertyId.MarginRight, StylePropertyId.MarginTop, StylePropertyId.MaxHeight, StylePropertyId.MaxWidth, StylePropertyId.MinHeight, StylePropertyId.MinWidth, StylePropertyId.Opacity, StylePropertyId.Overflow, StylePropertyId.Padding, StylePropertyId.PaddingBottom, StylePropertyId.PaddingLeft, StylePropertyId.PaddingRight, StylePropertyId.PaddingTop, StylePropertyId.Position, StylePropertyId.Right, StylePropertyId.Rotate, StylePropertyId.Scale, StylePropertyId.TextOverflow, StylePropertyId.TextShadow, StylePropertyId.Top, StylePropertyId.TransformOrigin, StylePropertyId.Translate, StylePropertyId.UnityBackgroundImageTintColor, StylePropertyId.UnityBackgroundScaleMode, StylePropertyId.UnityFont, StylePropertyId.UnityFontDefinition, StylePropertyId.UnityFontStyleAndWeight, StylePropertyId.UnityOverflowClipBox, StylePropertyId.UnityParagraphSpacing, StylePropertyId.UnitySliceBottom, StylePropertyId.UnitySliceLeft, StylePropertyId.UnitySliceRight, StylePropertyId.UnitySliceScale, StylePropertyId.UnitySliceTop, StylePropertyId.UnitySliceType, StylePropertyId.UnityTextAlign, StylePropertyId.UnityTextOutline, StylePropertyId.UnityTextOutlineColor, StylePropertyId.UnityTextOutlineWidth, StylePropertyId.UnityTextOverflowPosition, StylePropertyId.Visibility, StylePropertyId.WhiteSpace, StylePropertyId.Width, StylePropertyId.WordSpacing};

        internal static readonly Dictionary<StylePropertyId, UsageHints> s_AnimatableWithUsageHintProperties = new Dictionary<StylePropertyId, UsageHints>()
        {
            {StylePropertyId.BackgroundColor, UsageHints.DynamicColor},
            {StylePropertyId.BorderBottomColor, UsageHints.DynamicColor},
            {StylePropertyId.BorderColor, UsageHints.DynamicColor},
            {StylePropertyId.BorderLeftColor, UsageHints.DynamicColor},
            {StylePropertyId.BorderRightColor, UsageHints.DynamicColor},
            {StylePropertyId.BorderTopColor, UsageHints.DynamicColor},
            {StylePropertyId.Color, UsageHints.DynamicColor},
            {StylePropertyId.Rotate, UsageHints.DynamicTransform},
            {StylePropertyId.Scale, UsageHints.DynamicTransform},
            {StylePropertyId.TransformOrigin, UsageHints.DynamicTransform},
            {StylePropertyId.Translate, UsageHints.DynamicTransform},
            {StylePropertyId.UnityBackgroundImageTintColor, UsageHints.DynamicColor}
        };

        public static bool TryGetEnumIntValue(StyleEnumType enumType, string value, out int intValue)
        {
            intValue = 0;
            switch (enumType)
            {
                case StyleEnumType.Align:
                    if (string.Equals(value, "auto", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Align.Auto;
                        return true;
                    }

                    if (string.Equals(value, "flex-start", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Align.FlexStart;
                        return true;
                    }

                    if (string.Equals(value, "center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Align.Center;
                        return true;
                    }

                    if (string.Equals(value, "flex-end", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Align.FlexEnd;
                        return true;
                    }

                    if (string.Equals(value, "stretch", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Align.Stretch;
                        return true;
                    }

                    break;
                case StyleEnumType.Axis:
                    if (string.Equals(value, "x", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Axis.X;
                        return true;
                    }

                    if (string.Equals(value, "y", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Axis.Y;
                        return true;
                    }

                    if (string.Equals(value, "z", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Axis.Z;
                        return true;
                    }

                    break;
                case StyleEnumType.BackgroundPositionKeyword:
                    if (string.Equals(value, "center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundPositionKeyword.Center;
                        return true;
                    }

                    if (string.Equals(value, "top", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundPositionKeyword.Top;
                        return true;
                    }

                    if (string.Equals(value, "bottom", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundPositionKeyword.Bottom;
                        return true;
                    }

                    if (string.Equals(value, "left", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundPositionKeyword.Left;
                        return true;
                    }

                    if (string.Equals(value, "right", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundPositionKeyword.Right;
                        return true;
                    }

                    break;
                case StyleEnumType.BackgroundSizeType:
                    if (string.Equals(value, "cover", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundSizeType.Cover;
                        return true;
                    }

                    if (string.Equals(value, "contain", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)BackgroundSizeType.Contain;
                        return true;
                    }

                    break;
                case StyleEnumType.DisplayStyle:
                    if (string.Equals(value, "flex", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)DisplayStyle.Flex;
                        return true;
                    }

                    if (string.Equals(value, "none", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)DisplayStyle.None;
                        return true;
                    }

                    break;
                case StyleEnumType.EasingMode:
                    if (string.Equals(value, "ease", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.Ease;
                        return true;
                    }

                    if (string.Equals(value, "ease-in", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseIn;
                        return true;
                    }

                    if (string.Equals(value, "ease-out", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOut;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOut;
                        return true;
                    }

                    if (string.Equals(value, "linear", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.Linear;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-sine", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInSine;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-sine", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutSine;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-sine", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutSine;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-cubic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInCubic;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-cubic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutCubic;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-cubic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutCubic;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-circ", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInCirc;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-circ", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutCirc;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-circ", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutCirc;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-elastic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInElastic;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-elastic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutElastic;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-elastic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutElastic;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-back", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInBack;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-back", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutBack;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-back", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutBack;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-bounce", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInBounce;
                        return true;
                    }

                    if (string.Equals(value, "ease-out-bounce", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseOutBounce;
                        return true;
                    }

                    if (string.Equals(value, "ease-in-out-bounce", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EasingMode.EaseInOutBounce;
                        return true;
                    }

                    break;
                case StyleEnumType.EditorTextRenderingMode:
                    if (string.Equals(value, "sdf", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EditorTextRenderingMode.SDF;
                        return true;
                    }

                    if (string.Equals(value, "bitmap", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)EditorTextRenderingMode.Bitmap;
                        return true;
                    }

                    break;
                case StyleEnumType.FlexDirection:
                    if (string.Equals(value, "column", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FlexDirection.Column;
                        return true;
                    }

                    if (string.Equals(value, "column-reverse", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FlexDirection.ColumnReverse;
                        return true;
                    }

                    if (string.Equals(value, "row", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FlexDirection.Row;
                        return true;
                    }

                    if (string.Equals(value, "row-reverse", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FlexDirection.RowReverse;
                        return true;
                    }

                    break;
                case StyleEnumType.FontStyle:
                    if (string.Equals(value, "normal", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FontStyle.Normal;
                        return true;
                    }

                    if (string.Equals(value, "bold", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FontStyle.Bold;
                        return true;
                    }

                    if (string.Equals(value, "italic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FontStyle.Italic;
                        return true;
                    }

                    if (string.Equals(value, "bold-and-italic", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)FontStyle.BoldAndItalic;
                        return true;
                    }

                    break;
                case StyleEnumType.Justify:
                    if (string.Equals(value, "flex-start", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.FlexStart;
                        return true;
                    }

                    if (string.Equals(value, "center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.Center;
                        return true;
                    }

                    if (string.Equals(value, "flex-end", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.FlexEnd;
                        return true;
                    }

                    if (string.Equals(value, "space-between", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.SpaceBetween;
                        return true;
                    }

                    if (string.Equals(value, "space-around", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.SpaceAround;
                        return true;
                    }

                    if (string.Equals(value, "space-evenly", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Justify.SpaceEvenly;
                        return true;
                    }

                    break;
                case StyleEnumType.Overflow:
                    if (string.Equals(value, "visible", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Overflow.Visible;
                        return true;
                    }

                    if (string.Equals(value, "hidden", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Overflow.Hidden;
                        return true;
                    }

                    break;
                case StyleEnumType.OverflowClipBox:
                    if (string.Equals(value, "padding-box", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)OverflowClipBox.PaddingBox;
                        return true;
                    }

                    if (string.Equals(value, "content-box", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)OverflowClipBox.ContentBox;
                        return true;
                    }

                    break;
                case StyleEnumType.OverflowInternal:
                    if (string.Equals(value, "visible", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)OverflowInternal.Visible;
                        return true;
                    }

                    if (string.Equals(value, "hidden", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)OverflowInternal.Hidden;
                        return true;
                    }

                    if (string.Equals(value, "scroll", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)OverflowInternal.Scroll;
                        return true;
                    }

                    break;
                case StyleEnumType.Position:
                    if (string.Equals(value, "relative", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Position.Relative;
                        return true;
                    }

                    if (string.Equals(value, "absolute", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Position.Absolute;
                        return true;
                    }

                    break;
                case StyleEnumType.Repeat:
                    if (string.Equals(value, "no-repeat", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Repeat.NoRepeat;
                        return true;
                    }

                    if (string.Equals(value, "repeat", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Repeat.Repeat;
                        return true;
                    }

                    if (string.Equals(value, "space", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Repeat.Space;
                        return true;
                    }

                    if (string.Equals(value, "round", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Repeat.Round;
                        return true;
                    }

                    break;
                case StyleEnumType.RepeatXY:
                    if (string.Equals(value, "repeat-x", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)RepeatXY.RepeatX;
                        return true;
                    }

                    if (string.Equals(value, "repeat-y", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)RepeatXY.RepeatY;
                        return true;
                    }

                    break;
                case StyleEnumType.ScaleMode:
                    if (string.Equals(value, "stretch-to-fill", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)ScaleMode.StretchToFill;
                        return true;
                    }

                    if (string.Equals(value, "scale-and-crop", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)ScaleMode.ScaleAndCrop;
                        return true;
                    }

                    if (string.Equals(value, "scale-to-fit", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)ScaleMode.ScaleToFit;
                        return true;
                    }

                    break;
                case StyleEnumType.SliceType:
                    if (string.Equals(value, "sliced", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)SliceType.Sliced;
                        return true;
                    }

                    if (string.Equals(value, "tiled", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)SliceType.Tiled;
                        return true;
                    }

                    break;
                case StyleEnumType.TextAnchor:
                    if (string.Equals(value, "upper-left", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.UpperLeft;
                        return true;
                    }

                    if (string.Equals(value, "upper-center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.UpperCenter;
                        return true;
                    }

                    if (string.Equals(value, "upper-right", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.UpperRight;
                        return true;
                    }

                    if (string.Equals(value, "middle-left", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.MiddleLeft;
                        return true;
                    }

                    if (string.Equals(value, "middle-center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.MiddleCenter;
                        return true;
                    }

                    if (string.Equals(value, "middle-right", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.MiddleRight;
                        return true;
                    }

                    if (string.Equals(value, "lower-left", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.LowerLeft;
                        return true;
                    }

                    if (string.Equals(value, "lower-center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.LowerCenter;
                        return true;
                    }

                    if (string.Equals(value, "lower-right", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAnchor.LowerRight;
                        return true;
                    }

                    break;
                case StyleEnumType.TextAutoSizeMode:
                    if (string.Equals(value, "none", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAutoSizeMode.None;
                        return true;
                    }

                    if (string.Equals(value, "best-fit", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextAutoSizeMode.BestFit;
                        return true;
                    }

                    break;
                case StyleEnumType.TextGeneratorType:
                    if (string.Equals(value, "advanced", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextGeneratorType.Advanced;
                        return true;
                    }

                    if (string.Equals(value, "standard", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextGeneratorType.Standard;
                        return true;
                    }

                    break;
                case StyleEnumType.TextOverflow:
                    if (string.Equals(value, "clip", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextOverflow.Clip;
                        return true;
                    }

                    if (string.Equals(value, "ellipsis", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextOverflow.Ellipsis;
                        return true;
                    }

                    break;
                case StyleEnumType.TextOverflowPosition:
                    if (string.Equals(value, "start", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextOverflowPosition.Start;
                        return true;
                    }

                    if (string.Equals(value, "middle", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextOverflowPosition.Middle;
                        return true;
                    }

                    if (string.Equals(value, "end", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TextOverflowPosition.End;
                        return true;
                    }

                    break;
                case StyleEnumType.TransformOriginOffset:
                    if (string.Equals(value, "left", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TransformOriginOffset.Left;
                        return true;
                    }

                    if (string.Equals(value, "right", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TransformOriginOffset.Right;
                        return true;
                    }

                    if (string.Equals(value, "top", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TransformOriginOffset.Top;
                        return true;
                    }

                    if (string.Equals(value, "bottom", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TransformOriginOffset.Bottom;
                        return true;
                    }

                    if (string.Equals(value, "center", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)TransformOriginOffset.Center;
                        return true;
                    }

                    break;
                case StyleEnumType.Visibility:
                    if (string.Equals(value, "visible", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Visibility.Visible;
                        return true;
                    }

                    if (string.Equals(value, "hidden", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Visibility.Hidden;
                        return true;
                    }

                    break;
                case StyleEnumType.WhiteSpace:
                    if (string.Equals(value, "normal", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)WhiteSpace.Normal;
                        return true;
                    }

                    if (string.Equals(value, "nowrap", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)WhiteSpace.NoWrap;
                        return true;
                    }

                    if (string.Equals(value, "pre", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)WhiteSpace.Pre;
                        return true;
                    }

                    if (string.Equals(value, "pre-wrap", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)WhiteSpace.PreWrap;
                        return true;
                    }

                    break;
                case StyleEnumType.Wrap:
                    if (string.Equals(value, "nowrap", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Wrap.NoWrap;
                        return true;
                    }

                    if (string.Equals(value, "wrap", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Wrap.Wrap;
                        return true;
                    }

                    if (string.Equals(value, "wrap-reverse", StringComparison.OrdinalIgnoreCase))
                    {
                        intValue = (int)Wrap.WrapReverse;
                        return true;
                    }

                    break;
            }

            return false;
        }

        public static bool IsMatchingShorthand(StylePropertyId shorthand, StylePropertyId id)
        {
            switch (shorthand)
            {
                case StylePropertyId.All:
                    return true;
                case StylePropertyId.BackgroundPosition:
                    return id == StylePropertyId.BackgroundPositionX || id == StylePropertyId.BackgroundPositionY;
                case StylePropertyId.BorderColor:
                    return id == StylePropertyId.BorderTopColor || id == StylePropertyId.BorderRightColor || id == StylePropertyId.BorderBottomColor || id == StylePropertyId.BorderLeftColor;
                case StylePropertyId.BorderRadius:
                    return id == StylePropertyId.BorderTopLeftRadius || id == StylePropertyId.BorderTopRightRadius || id == StylePropertyId.BorderBottomRightRadius || id == StylePropertyId.BorderBottomLeftRadius;
                case StylePropertyId.BorderWidth:
                    return id == StylePropertyId.BorderTopWidth || id == StylePropertyId.BorderRightWidth || id == StylePropertyId.BorderBottomWidth || id == StylePropertyId.BorderLeftWidth;
                case StylePropertyId.Flex:
                    return id == StylePropertyId.FlexGrow || id == StylePropertyId.FlexShrink || id == StylePropertyId.FlexBasis;
                case StylePropertyId.Margin:
                    return id == StylePropertyId.MarginTop || id == StylePropertyId.MarginRight || id == StylePropertyId.MarginBottom || id == StylePropertyId.MarginLeft;
                case StylePropertyId.Padding:
                    return id == StylePropertyId.PaddingTop || id == StylePropertyId.PaddingRight || id == StylePropertyId.PaddingBottom || id == StylePropertyId.PaddingLeft;
                case StylePropertyId.UnityBackgroundScaleMode:
                    return id == StylePropertyId.BackgroundPositionX || id == StylePropertyId.BackgroundPositionY || id == StylePropertyId.BackgroundRepeat || id == StylePropertyId.BackgroundSize;
                case StylePropertyId.UnityTextOutline:
                    return id == StylePropertyId.UnityTextOutlineColor || id == StylePropertyId.UnityTextOutlineWidth;
                default:
                    return false;
            }
        }

        public static IEnumerable<Type> GetAllowedAssetTypesForProperty(StylePropertyId id)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundImage:
                    return Background.allowedAssetTypes;
                case StylePropertyId.Cursor:
                    return Cursor.allowedAssetTypes;
                case StylePropertyId.UnityFont:
                    return new[]{typeof(Font)};
                case StylePropertyId.UnityFontDefinition:
                    return FontDefinition.allowedAssetTypes;
                case StylePropertyId.Custom:
                    return new[]{typeof(UnityEngine.Object)};
                default:
                    return System.Linq.Enumerable.Empty<Type>();
            }
        }

        public static bool StyleValueCanHoldResource(StylePropertyId id)
        {
            switch (id)
            {
                case StylePropertyId.BackgroundImage:
                    return true;
                case StylePropertyId.Cursor:
                    return true;
                case StylePropertyId.UnityFont:
                    return true;
                case StylePropertyId.UnityFontDefinition:
                    return true;
                case StylePropertyId.Custom:
                    return true;
                default:
                    return false;
            }
        }
    }
}
