//
// File autogenerated from Include/C/Baselib_Timer.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_Timer.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>Time conversion factors.</summary>
        /// <remarks>(not an enum since Int32 can't represent Baselib_NanosecondsPerMinute)</remarks>
        public const UInt64 Baselib_SecondsPerMinute = 60;
        public const UInt64 Baselib_MillisecondsPerSecond = 1000;
        public const UInt64 Baselib_MillisecondsPerMinute = 60000;
        public const UInt64 Baselib_MicrosecondsPerMillisecond = 1000;
        public const UInt64 Baselib_MicrosecondsPerSecond = 1000000;
        public const UInt64 Baselib_MicrosecondsPerMinute = 60000000;
        public const UInt64 Baselib_NanosecondsPerMicrosecond = 1000;
        public const UInt64 Baselib_NanosecondsPerMillisecond = 1000000;
        public const UInt64 Baselib_NanosecondsPerSecond = 1000000000;
        public const UInt64 Baselib_NanosecondsPerMinute = 60000000000;
        /// <summary>Baselib_Timer_Ticks are guaranteed to be more granular than this constant.</summary>
        public const UInt64 Baselib_Timer_MaxNumberOfNanosecondsPerTick = 1000;
        /// <summary>Baselib_Timer_Ticks are guaranteed to be less granular than this constant.</summary>
        public const double Baselib_Timer_MinNumberOfNanosecondsPerTick = 0.01;
        /// <summary>When comparing results of Baselib_Timer_GetHighPrecisionTimerTicks on different threads, timestamps are strictly monotonous with a tolerance of this many nanoseconds.</summary>
        public const double Baselib_Timer_HighPrecisionTimerCrossThreadMontotonyTolerance_InNanoseconds = 100;
        /// <summary>Defines the conversion ratio from Baselib_Timer_Ticks to nanoseconds as a fraction.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Timer_TickToNanosecondConversionRatio
        {
            public UInt64 ticksToNanosecondsNumerator;
            public UInt64 ticksToNanosecondsDenominator;
        }
        /// <summary>Returns the conversion ratio between ticks and nanoseconds.</summary>
        /// <remarks>
        /// The conversion factor is guaranteed to be constant for the entire application for its entire lifetime.
        /// However, it may be different on every start of the application.
        /// </remarks>
        /// <returns>The conversion factor from ticks to nanoseconds as an integer fraction.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_Timer_TickToNanosecondConversionRatio Baselib_Timer_GetTicksToNanosecondsConversionRatio();
        /// <summary>Get the current tick count of the high precision timer.</summary>
        /// <remarks>
        /// Accuracy:
        /// It is assumed that the accuracy corresponds to the granularity of Baselib_Timer_Ticks (which is determined by Baselib_Timer_GetTicksToNanosecondsConversionRatio).
        /// However, there are no strict guarantees on the accuracy of the timer.
        ///
        /// Monotony:
        /// * ATTENTION: On some platforms this clock is suspended during application/device sleep states.
        /// * The timer is not susceptible to wall clock time changes by the user.
        /// * The timer is strictly monotonous on a thread
        /// * When comparing times from different threads, timestamps are strictly monotonous with a tolerance of Baselib_Timer_HighPrecisionTimerCrossThreadMontotonyTolerance_InNanoseconds.
        ///
        /// Known issues:
        /// * Some web browsers impose Spectre mitigation which can introduce jitter in this timer.
        /// * Some web browsers may have different timelines per thread/webworker if they are not spawned on startup (this is a bug according to newest W3C specification)
        /// </remarks>
        /// <returns>Current tick value of the high precision timer.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt64 Baselib_Timer_GetHighPrecisionTimerTicks();
        /// <summary>This function will wait for at least the requested amount of time before returning.</summary>
        /// <remarks>Unlike some implementations of 'sleep', passing 0 does NOT guarantee a thread yield and may return immediately! Use the corresponding functionality in Baselib_Thread instead.</remarks>
        /// <param name="timeInMilliseconds">Time to wait in milliseconds</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Timer_WaitForAtLeast(UInt32 timeInMilliseconds);
        /// <summary>Time since application startup in seconds.</summary>
        /// <remarks>Disregarding potential rounding errors, all threads are naturally on the same timeline (i.e. time since process start).</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern double Baselib_Timer_GetTimeSinceStartupInSeconds();
    }
}
