//
// File autogenerated from Include/C/Baselib_Socket.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_Socket.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>Socket Handle, a handle to a specific socket.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Socket_Handle
        {
            public IntPtr handle;
        }
        /// <summary>Socket protocol.</summary>
        public enum Baselib_Socket_Protocol : Int32
        {
            UDP = 0x1,
            TCP = 0x2,
        }
        /// <summary>Socket message. Used to send or receive data in message based protocols such as UDP.</summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Socket_Message
        {
            public Baselib_NetworkAddress* address;
            public IntPtr data;
            public UInt32 dataLen;
        }
        /// <summary>Create a socket.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument:           if context, family or protocol is invalid or unknown.
        /// - Baselib_ErrorCode_AddressFamilyNotSupported: if the requested address family is not available.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_Socket_Handle Baselib_Socket_Create(Baselib_NetworkAddress_Family family, Baselib_Socket_Protocol protocol, Baselib_ErrorState* errorState);
        /// <summary>Bind socket to a local address and port.</summary>
        /// <remarks>
        /// Bind can only be called once per socket.
        /// Address can either be a specific interface ip address.
        /// In case if encoded ip is nullptr / "0.0.0.0" / "::" (same as INADDR_ANY) will bind to all interfaces.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument:    Socket does not represent a valid open socket. Address pointer is null or incompatible.
        /// - Baselib_ErrorCode_AddressInUse:       Address or port is already bound by another socket, or the system is out of ephemeral ports.
        /// - Baselib_ErrorCode_AddressUnreachable: Address doesn't map to any known interface.
        /// </remarks>
        /// <param name="addressReuse">
        /// A set of sockets can be bound to the same address port combination if all
        /// sockets are bound with this flag set to AddressReuse_Allow, similar to
        /// SO_REUSEADDR+SO_REUSEPORT.
        /// Please note that setting this flag to false doesn't mean anyone is forbidden
        /// to binding to the same ip/port combo, or in other words it does NOT use
        /// SO_EXCLUSIVEADDRUSE where it's available.
        /// </param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_Bind(Baselib_Socket_Handle socket, Baselib_NetworkAddress* address, Baselib_NetworkAddress_AddressReuse addressReuse, Baselib_ErrorState* errorState);
        /// <summary>Connect a socket to a remote address.</summary>
        /// <remarks>
        /// Note that this function initiates an asynchronous connection. You must call
        /// Baselib_Socket_Poll with Baselib_Socket_PollEvents.requestedEvents =
        /// Baselib_Socket_PollEvents_Connected to wait for the connection to finish.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument:    Socket does not represent a valid socket, or socket is not a TCP socket. Address pointer is null or incompatible.
        /// - Baselib_ErrorCode_AddressUnreachable: Unable to establish a connection with peer.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_TCP_Connect(Baselib_Socket_Handle socket, Baselib_NetworkAddress* address, Baselib_NetworkAddress_AddressReuse addressReuse, Baselib_ErrorState* errorState);
        /// <summary>Bitmask of events to be used in Baselib_Socket_Poll</summary>
        public enum Baselib_Socket_PollEvents : Int32
        {
            Readable = 0x1,
            Writable = 0x2,
            /// <summary>Note: Connected cannot be set at the same time as Readable and Writable.</summary>
            Connected = 0x4,
        }
        /// <summary>Socket entry to be passed into Baselib_Socket_Poll.</summary>
        /// <remarks>
        /// Note that the name `Fd` does not refer to the fact that these are file
        /// descriptors (they are sockets), but rather the fact that nearly every socket
        /// API calls this struct "pollfd".
        /// </remarks>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Socket_PollFd
        {
            public Baselib_Socket_Handle handle;
            public Baselib_Socket_PollEvents requestedEvents;
            public Baselib_Socket_PollEvents resultEvents;
            public Baselib_ErrorState* errorState;
        }
        /// <summary>
        /// Wait for a socket being readable, writable, or an error occurs. Specific
        /// events that occurred will be set in sockets[i].resultEvents. Errors
        /// associated with particular sockets will be reported in sockets[i].errorState.
        /// </summary>
        /// <remarks>
        /// It is valid to have sockets[i].errorState to point to the same ErrorState as
        /// the outer parameter errorState - or, more generally, you may alias whatever
        /// error states within sockets[i].errorState and the parameter errorState.
        ///
        /// If timeoutInMilliseconds==0, Poll() will not block. There is no option to
        /// wait indefinitely.
        ///
        /// Possible error codes on the outer parameter errorState:
        /// - Baselib_ErrorCode_InvalidArgument: Sockets list is null. An individual socket handle is invalid. Or flags are used in an invalid combination.
        ///
        /// Possible error codes on sockets[i].errorState:
        /// - Baselib_ErrorCode_AddressUnreachable: Asynchronous Connect() failed.
        /// - Baselib_ErrorCode_Disconnected: Socket has been disconnected.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_Poll(Baselib_Socket_PollFd* sockets, UInt32 socketsCount, UInt32 timeoutInMilliseconds, Baselib_ErrorState* errorState);
        /// <summary>Get address of locally bound socket.</summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid bound socket. Address pointer is null.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_GetAddress(Baselib_Socket_Handle socket, Baselib_NetworkAddress* address, Baselib_ErrorState* errorState);
        /// <summary>
        /// Configure a TCP server socket to begin listening for incoming connections.
        /// The maximum queue size is used for each platform.
        /// </summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid socket, or socket is not a TCP socket.
        /// - Baselib_ErrorCode_AddressInUse: Another socket is already listening on the same port, or the system is out of ephemeral ports.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_TCP_Listen(Baselib_Socket_Handle socket, Baselib_ErrorState* errorState);
        /// <summary>
        /// Accept an incoming TCP connection to this server socket. When there are no
        /// incoming connections, this returns Baselib_Socket_Handle_Invalid and does not
        /// raise an error.
        /// </summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid socket, or socket is not a TCP socket.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_Socket_Handle Baselib_Socket_TCP_Accept(Baselib_Socket_Handle socket, Baselib_ErrorState* errorState);
        /// <summary>Send messages to unconnected destinations.</summary>
        /// <remarks>
        /// Socket does not need to be bound before calling SendMessages.
        /// When sending multiple messages an error may be raised after some of the messages were submitted.
        ///
        /// If the socket is not already bound to a port SendMessages will implicitly bind the socket before issuing the send operation.
        ///
        /// Warning: This function may not fail when called with a TCP socket, as it may
        /// simply ignore the address parameter, and send to whatever the socket is
        /// connected to. However, as there is no way to retreive the actual number of
        /// bytes sent with this API, its use in this manner is strongly discouraged.
        ///
        /// Known issues (behavior may change in the future):
        /// Some platforms do not support sending zero sized UDP packets.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_AddressUnreachable: Message destination is known to not be reachable from this machine.
        /// - Baselib_ErrorCode_InvalidArgument:    Socket does not represent a valid socket. Messages is `NULL` or a message has an invalid or incompatible destination.
        /// - Baselib_ErrorCode_InvalidBufferSize:  Message payload exceeds max message size.
        /// </remarks>
        /// <returns>The number of messages successfully sent. This number may be lower than messageCount if send buffer is full or an error was raised. Reported error will be about last message tried to send.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_Socket_UDP_Send(Baselib_Socket_Handle socket, Baselib_Socket_Message* messages, UInt32 messagesCount, Baselib_ErrorState* errorState);
        /// <summary>Send a message to the connected peer.</summary>
        /// <remarks>
        /// Nagle's algorithm is disabled in Baselib TCP sockets, so if making multiple
        /// small sends in quick succession, it is recommended to instead batch them in
        /// a single send call instead to improve bandwidth efficiency.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid socket, or socket is not a TCP socket. Socket validity is not checked if dataLen==0.
        /// - Baselib_ErrorCode_Disconnected: Socket has been disconnected.
        /// </remarks>
        /// <returns>The possibly-zero length of the message actually sent, which may be less than `dataLen`.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_Socket_TCP_Send(Baselib_Socket_Handle socket, IntPtr data, UInt32 dataLen, Baselib_ErrorState* errorState);
        /// <summary>Receive messages from unconnected sources.</summary>
        /// <remarks>
        /// UDP message data that doesn't fit a message buffer is silently discarded.
        ///
        /// Warning: This function may not fail when called with a TCP socket, as it may
        /// simply ignore the address parameter, and receive from whatever the socket is
        /// connected to. However, as there is no way to retreive the actual number of
        /// bytes received with this API, its use in this manner is strongly discouraged.
        ///
        /// Known issues (behavior may change in the future):
        /// If the socket is not bound to a port RecvMessages will return zero without raising an error.
        /// Some platforms does not support receiveing zero sized UDP packets.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid socket. Or messages is `NULL`.
        /// </remarks>
        /// <returns>The number of messages successfully received. This number may be lower than messageCount if recv buffer is empty or an error was raised. Reported error will be about last message tried to receive.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_Socket_UDP_Recv(Baselib_Socket_Handle socket, Baselib_Socket_Message* messages, UInt32 messagesCount, Baselib_ErrorState* errorState);
        /// <summary>
        /// Receive a message from a connected source. Note that this method differs from
        /// traditional socket APIs in that it is valid to return 0, this means that no
        /// data were received. Disconnection is detected by errorState being
        /// Baselib_ErrorCode_Disconnected.
        /// </summary>
        /// <remarks>
        /// This function may or may not work when passed a UDP socket. Graceful error
        /// handling of this case is omitted due to performance reasons.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidArgument: Socket does not represent a valid socket.
        /// - Baselib_ErrorCode_Disconnected: Socket has been disconnected.
        /// </remarks>
        /// <returns>The length of the message actually received, which may be less than `dataLen` or even zero.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern UInt32 Baselib_Socket_TCP_Recv(Baselib_Socket_Handle socket, IntPtr data, UInt32 dataLen, Baselib_ErrorState* errorState);
        /// <summary>Close socket.</summary>
        /// <remarks>Closing an already closed socket results in a no-op.</remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_Close(Baselib_Socket_Handle socket);
        /// <summary>
        /// Attempts to set the DON'T FRAGMENT header on an IPv4 socket.
        /// This prevents the packet from being fragmented along the route,
        /// which is useful for path MTU discovery and can provide improved network
        /// performance so long as no packets exceed the path MTU.
        /// Only available on IPv4 UDP sockets on certain platforms.
        /// </summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_NotSupported: The current platform does not support user setting of the Don't Fragment header.
        /// - Baselib_ErrorCode_InvalidSocketType: The socket is not a UDP socket.
        /// - Baselib_ErrorCode_InvalidAddressFamily: The socket is not an IPv4 socket.
        ///
        /// The order that these error conditions are checked is always socket type, address family, platform support.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Socket_SetIPv4DontFragHeader(Baselib_Socket_Handle socket,         [MarshalAs(UnmanagedType.U1)] bool set, Baselib_ErrorState* errorState);
        /// <summary>
        /// Retrieves the current value of the DON'T FRAGMENT header for an IPv4 socket.
        /// Only available on IPv4 UDP sockets on certain platforms.
        /// </summary>
        /// <remarks>
        /// Possible error codes:
        /// - Baselib_ErrorCode_NotSupported: The current platform does not support user setting of the Don't Fragment header.
        /// - Baselib_ErrorCode_InvalidSocketType: The socket is not a UDP socket.
        /// - Baselib_ErrorCode_InvalidAddressFamily: The socket is not an IPv4 socket.
        ///
        /// The order that these error conditions are checked is always socket type, address family, platform support.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        [return: MarshalAs(UnmanagedType.U1)]
        public static extern bool Baselib_Socket_GetIPv4DontFragHeader(Baselib_Socket_Handle socket, Baselib_ErrorState* errorState);
    }
}
