//
// File autogenerated from Include/C/Baselib_Memory.h
//

using System;
using System.Runtime.InteropServices;
using UnityEngine.Bindings;
using size_t = System.UIntPtr;

namespace Unity.Baselib.LowLevel
{
    [NativeHeader("baselib/CSharp/BindingsUnity/Baselib_Memory.gen.binding.h")]
    internal static unsafe partial class Binding
    {
        /// <summary>Max alignment that can be passed to Baselib_Memory_AlignedAlloc and Baselib_Memory_AlignedReallocate functions</summary>
        public static readonly size_t Baselib_Memory_MaxAlignment = new size_t(65536);
        /// <summary>Minimum guaranteed alignment for Baselib_Memory_Allocate/Baselib_Memory_AlignedAlloc in bytes.</summary>
        /// <remarks>
        /// Guaranteed to be at least 8.
        /// Note that on some platforms it is possible to overwrite the internally used allocator in which case this guarantee may no longer be upheld.
        /// </remarks>
        public static readonly size_t Baselib_Memory_MinGuaranteedAlignment = new size_t(8);
        /// <summary>Information about available pages sizes.</summary>
        /// <remarks>
        /// Page sizes do not reflect necessarily hardware ("physical") page sizes, but rather "virtual" page sizes that the OS is dealing with.
        /// I.e. a virtual page may refer to several hardware pages, but the OS exposes only a single state for this group of pages.
        /// </remarks>
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Memory_PageSizeInfo
        {
            /// <summary>Commonly used page size on this platform.</summary>
            public UInt64 defaultPageSize;
            /// <summary>pageSizesLen valid page sizes, ordered from small to large.</summary>
            // UInt64 pageSizes[6];
            public UInt64 pageSizes0;
            public UInt64 pageSizes1;
            public UInt64 pageSizes2;
            public UInt64 pageSizes3;
            public UInt64 pageSizes4;
            public UInt64 pageSizes5;
            public UInt64 pageSizesLen;
        }
        [StructLayout(LayoutKind.Sequential)]
        public struct Baselib_Memory_PageAllocation
        {
            public IntPtr ptr;
            public UInt64 pageSize;
            public UInt64 pageCount;
        }
        /// <summary>Fills out a Baselib_Memory_PageSizeInfo struct.</summary>
        /// <param name="outPagesSizeInfo:">Pointer to page size info struct. Passing 'nullptr' will return immediately.</param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_GetPageSizeInfo(Baselib_Memory_PageSizeInfo* outPagesSizeInfo);
        /// <summary>Allocates memory using a system allocator like malloc.</summary>
        /// <remarks>Allocation failures or invalid alignments will trigger process abort.</remarks>
        /// <param name="size">Size of the allocation. Zero is valid.</param>
        /// <returns>
        /// Unique pointer to allocation. At least aligned to by Baselib_Memory_MinGuaranteedAlignment bytes.
        /// This is true for zero sized allocations as well.
        /// </returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern IntPtr Baselib_Memory_Allocate(size_t size);
        /// <summary>Reallocates memory previously allocated by Baselib_Memory_Allocate or Baselib_Memory_Reallocate.</summary>
        /// <remarks>Allocation failures or invalid alignments will trigger process abort.</remarks>
        /// <param name="ptr">
        /// Pointer previously returned by Baselib_Memory_Allocate or Baselib_Memory_Reallocate.
        /// Reallocating an already freed pointer or a pointer that was not previously allocated by Baselib_Memory_Allocate or
        /// Baselib_Memory_Reallocate leads to undefined behavior.
        /// Passing `nullptr` yield the same result as calling Baselib_Memory_Allocate.
        /// </param>
        /// <param name="size">Size of the allocation. No special restrictions apply, zero is valid.</param>
        /// <returns>
        /// Unique pointer to allocation. At least aligned to by Baselib_Memory_MinGuaranteedAlignment bytes.
        /// This is true for zero sized allocations as well.
        /// </returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern IntPtr Baselib_Memory_Reallocate(IntPtr ptr, size_t newSize);
        /// <summary>Frees memory allocated by Baselib_Memory_Allocate Baselib_Memory_Reallocate.</summary>
        /// <param name="ptr">
        /// Pointer previously returned by Baselib_Memory_Allocate or Baselib_Memory_Reallocate.
        /// Freeing an already freed pointer or a pointer that was not previously allocated by Baselib_Memory_Allocate or Baselib_Memory_Reallocate leads to undefined behavior.
        /// Passing `nullptr` result in a no-op.
        /// </param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_Free(IntPtr ptr);
        /// <summary>Allocates memory using a system allocator like malloc and guarantees that the returned pointer is aligned to the specified alignment.</summary>
        /// <remarks>Allocation failures or invalid alignments will trigger process abort.</remarks>
        /// <param name="size">Size of the allocation. No special restrictions (like  multiples of alignment) apply, zero is valid.</param>
        /// <param name="alignment">
        /// Needs to be a power of two which is also a multiple of of pointer size (i.e. sizeof(void*)) but less or equal to Baselib_Memory_MaxAlignment.
        /// Any alignment smaller than Baselib_Memory_MinGuaranteedAlignment, will be clamped to Baselib_Memory_MinGuaranteedAlignment.
        /// </param>
        /// <returns>Unique pointer to aligned allocation. This is true for zero sized allocations as well.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern IntPtr Baselib_Memory_AlignedAllocate(size_t size, size_t alignment);
        /// <summary>Reallocates memory previously allocated by Baselib_Memory_AlignedAllocate or Baselib_Memory_AlignedReallocate.</summary>
        /// <remarks>Allocation failures or invalid alignments will trigger process abort.</remarks>
        /// <param name="ptr">
        /// Pointer previously returned by Baselib_Memory_AlignedAllocate or Baselib_Memory_AlignedReallocate.
        /// Reallocating an already freed pointer or a pointer that was not previously allocated by Baselib_Memory_AlignedAllocate or
        /// Baselib_Memory_AlignedReallocate leads to undefined behavior.
        /// Passing `nullptr` yield the same result as calling Baselib_Memory_AlignedAllocate.
        /// </param>
        /// <param name="size">Size of the allocation. No special restrictions apply, zero is valid.</param>
        /// <param name="alignment">
        /// Needs to be a power of two which is also a multiple of of pointer size (i.e. sizeof(void*)) but less or equal to Baselib_Memory_MaxAlignment.
        /// Any alignment smaller than Baselib_Memory_MinGuaranteedAlignment, will be clamped to Baselib_Memory_MinGuaranteedAlignment.
        /// </param>
        /// <returns>Unique pointer to aligned allocation. This is true for zero sized allocations as well.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern IntPtr Baselib_Memory_AlignedReallocate(IntPtr ptr, size_t newSize, size_t alignment);
        /// <summary>Frees memory allocated by Baselib_Memory_AlignedAllocate or Baselib_Memory_AlignedReallocate.</summary>
        /// <param name="ptr">
        /// Pointer previously returned by Baselib_Memory_AlignedAllocate or Baselib_Memory_AlignedReallocate.
        /// Freeing an already freed pointer or a pointer that was not previously allocated by Baselib_Memory_AlignedAllocate or Baselib_Memory_AlignedReallocate leads to undefined behavior.
        /// Passing `nullptr` result in a no-op.
        /// </param>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_AlignedFree(IntPtr ptr);
        /// <summary>Page state options</summary>
        public enum Baselib_Memory_PageState : Int32
        {
            /// <summary>
            /// The page are in a reserved state and any access will cause a seg-fault/access violation.
            /// On some platforms that support this state this may be just a hint to the OS and there is no guarantee pages in this state behave differently from Baselib_Memory_PageState_NoAccess.
            /// The Baselib implementation does a best effort and tries to ensure as best as possible that pages in this state are not commited.
            /// </summary>
            Reserved = 0x0,
            /// <summary>This is a no access page and will cause a seg-fault/access violation when accessed.</summary>
            NoAccess = 0x1,
            /// <summary>The memory can only be read.</summary>
            ReadOnly = 0x2,
            /// <summary>The memory can be read and written.</summary>
            ReadWrite = 0x4,
            /// <summary>The memory can be used to execute code and can be read.</summary>
            ReadOnly_Executable = 0x12,
            /// <summary>The memory can be used to execute code and can be both read and written.</summary>
            ReadWrite_Executable = 0x14,
        }
        /// <summary>Allocates a given number of memory pages and guarantees that the returned pointer is aligned to specified multiple of the page size.</summary>
        /// <remarks>
        /// Large alignments may lead to a significantly higher use of virtual address space than the amount of memory requested.
        /// This may result in an aligned page allocation to fail where a less/non-aligned allocation would succeed.
        /// Note that this is especially common in 32bit applications but a platform may impose additional restrictions on the size of its virtual address space.
        /// Whether a page allocation is pure virtual address space or already commited memory depends on the platform and passed page state flag.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidPageSize:         Page size doesn't match any of the available page sizes (see Baselib_Memory_GetPageSizeInfo).
        /// - Baselib_ErrorCode_InvalidPageCount:        Requested number of pages is zero.
        /// - Baselib_ErrorCode_UnsupportedAlignment:    Requested alignment is invalid.
        /// - Baselib_ErrorCode_UnsupportedPageState:    The underlying system doesn't support the requested page state (see Baselib_Memory_PageState).
        /// - Baselib_ErrorCode_OutOfMemory:             If there is not enough continuous address space available, or physical memory space when acquiring committed memory.
        /// </remarks>
        /// <param name="pageCount">Number of pages requested (each will have pageSize size)</param>
        /// <param name="alignmentInMultipleOfPageSize">
        /// Specified alignment in multiple of page sizes (a value of 1 implies alignment to page size).
        /// Value needs to be larger than zero and a power of two, otherwise UnsupportedAlignment will be raised.
        /// </param>
        /// <param name="pageState:">In which state the pages should be. Certain values may raise UnsupportedPageState on certain platforms.</param>
        /// <returns>Page allocation info or Baselib_Memory_PageAllocation_Invalid in case of an error.</returns>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_Memory_PageAllocation Baselib_Memory_AllocatePages(UInt64 pageSize, UInt64 pageCount, UInt64 alignmentInMultipleOfPageSize, Baselib_Memory_PageState pageState, Baselib_ErrorState* errorState);
        /// <summary>Allocates a given number of memory pages and guarantees that the returned pointer is aligned to specified multiple of the page size.</summary>
        /// <remarks>
        /// Identical to `Baselib_Memory_AllocatePages` with the addition of the `extPageState` parameter which extends the internally translated page state
        /// (from the `pageState` parameter) with a native page state.
        /// The `ext_page_state` value has no validation and is ultimately a bitwise OR operation applied to the internally translated native state.
        /// The only exception is when the existing native representation of `Baselib_Memory_PageState` conflicts with the extended state in which case the
        /// most permissive mode will be used. This does not affect any bit-values not conflicting with the native representation of `Baselib_Memory_PageState`.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern Baselib_Memory_PageAllocation Baselib_Memory_AllocatePagesEx(UInt64 pageSize, UInt64 pageCount, UInt64 alignmentInMultipleOfPageSize, Baselib_Memory_PageState pageState, UInt32 extPageState, Baselib_ErrorState* errorState);
        /// <summary>Releases the previously allocated pages (using either Baselib_Memory_AllocatePages)</summary>
        /// <remarks>
        /// A single call of ReleasePages must encompass all pages that were originally allocated with a single call of AllocatePages.
        /// Passing Baselib_Memory_PageAllocation with a nullptr or a zero page count result in a no-op.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidAddressRange:     Address range was detected to not match a valid allocation.
        /// CAUTION: Not all platforms are able to detect this and may either raise an error or cause undefined behavior.
        /// Note to implementors: Raising the error is strongly preferred as it helps identifying issues in user code.
        /// - Baselib_ErrorCode_InvalidPageSize:         If page size doesn't match a previous allocation at `pageAllocation.ptr`.
        ///
        /// Implementation note:
        /// We could be able to allow granular ReleasePages call, but even then only in the _allocation granularity_ which might be different from the page size.
        /// (e.g. windows page size 4k allocation granularity 64k)
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_ReleasePages(Baselib_Memory_PageAllocation pageAllocation, Baselib_ErrorState* errorState);
        /// <summary>Modifies the page state property of an already allocated virtual address range.</summary>
        /// <remarks>
        /// It is possible to modify only some of the pages allocated by Baselib_Memory_AllocatePages.
        /// Passing `nullptr` or a zero page count result in a no-op.
        ///
        /// Possible error codes:
        /// - Baselib_ErrorCode_InvalidAddressRange:     Address range is not covered by a valid allocation.
        /// Platforms that emulate page allocations (e.g. Emscripten) are not able to present this error and will pass the function call silently.
        /// - Baselib_ErrorCode_InvalidPageSize:         If page size doesn't match the previous allocation at `addressOfFirstPage`.
        /// - Baselib_ErrorCode_UnsupportedPageState:    The underlying system doesn't support the requested page state (see Baselib_Memory_PageState).
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_SetPageState(IntPtr addressOfFirstPage, UInt64 pageSize, UInt64 pageCount, Baselib_Memory_PageState pageState, Baselib_ErrorState* errorState);
        /// <summary>Modifies the page state property of an already allocated virtual address range.</summary>
        /// <remarks>
        /// Identical to `Baselib_Memory_AllocatePages` with the addition of the `extPageState` parameter which extends the internally translated page state
        /// (from the `pageState` parameter) with a native page state.
        /// The `ext_page_state` value has no validation and is ultimately a bitwise OR operation applied to the internally translated native state.
        /// The only exception is when the existing native representation of `Baselib_Memory_PageState` conflicts with the extended state in which case the
        /// most permissive mode will be used. This does not affect any bit-values not conflicting with the native representation of `Baselib_Memory_PageState`.
        /// </remarks>
        [FreeFunction(IsThreadSafe = true)]
        public static extern void Baselib_Memory_SetPageStateEx(IntPtr addressOfFirstPage, UInt64 pageSize, UInt64 pageCount, Baselib_Memory_PageState pageState, UInt32 extPageState, Baselib_ErrorState* errorState);
    }
}
