// Unity C# reference source
// Copyright (c) Unity Technologies. For terms of use, see
// https://unity3d.com/legal/licenses/Unity_Reference_Only_License

using System;
using UnityEngine;
using UnityEngine.Bindings;

using EditorGraphicsSettings = UnityEditor.Rendering.EditorGraphicsSettings;

namespace UnityEditor
{
    // deprecated in 2018.1
    [Obsolete("Use AndroidArchitecture instead. (UnityUpgradable) -> AndroidArchitecture", false)]
    public enum AndroidTargetDevice
    {
        [Obsolete("Use AndroidArchitecture.All instead. (UnityUpgradable) -> AndroidArchitecture.All", false)]
        FAT        = 0,
        //ARMv6    = 1,
        //Emulator = 2,
        [Obsolete("Use AndroidArchitecture.ARMv7 instead. (UnityUpgradable) -> AndroidArchitecture.ARMv7", false)]
        ARMv7      = 3,
        //x86      = 4,
    }
    // deprecated in 5.1.
    [Obsolete("TargetGlesGraphics is ignored, use SetGraphicsAPIs/GetGraphicsAPIs APIs", false)]
    public enum TargetGlesGraphics
    {
        OpenGLES_1_x    = 0,
        OpenGLES_2_0    = 1,
        OpenGLES_3_0    = 2,
        Automatic       = -1,
    }
    [Obsolete("TargetIOSGraphics is ignored, use SetGraphicsAPIs/GetGraphicsAPIs APIs", false)]
    public enum TargetIOSGraphics
    {
        OpenGLES_2_0    = 2,
        OpenGLES_3_0    = 3,
        Metal           = 4,
        Automatic       = -1,
    }
    // deprecated in 5.3
    [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
    [Obsolete("Use Screen.SetResolution APIs", true)]
    public enum iOSTargetResolution
    {
        Native = 0,
        ResolutionAutoPerformance = 3,
        ResolutionAutoQuality = 4,
        Resolution320p = 5,
        Resolution640p = 6,
        Resolution768p = 7
    }
    // deprecated in 5.5
    [Obsolete("targetOSVersion is obsolete, use targetOSVersionString", false)]
    public enum iOSTargetOSVersion
    {
        iOS_4_0 = 10,
        iOS_4_1 = 12,
        iOS_4_2 = 14,
        iOS_4_3 = 16,
        iOS_5_0 = 18,
        iOS_5_1 = 20,
        iOS_6_0 = 22,
        iOS_7_0 = 24,
        iOS_7_1 = 26,
        iOS_8_0 = 28,
        iOS_8_1 = 30,
        Unknown = 999,
    }

    // deprecated in 5.6
    [Flags]
    [Obsolete("Use UnityEngine.iOS.SystemGestureDeferMode instead. (UnityUpgradable) -> [UnityEngine] UnityEngine.iOS.SystemGestureDeferMode", true)]
    public enum iOSSystemGestureDeferMode: uint
    {
        None = 0,
        TopEdge = 1 << 0,
        LeftEdge = 1 << 1,
        BottomEdge = 1 << 2,
        RightEdge = 1 << 3,
        All = TopEdge | LeftEdge | BottomEdge | RightEdge
    }

    [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
    [Obsolete("AspectRatio enum has been deprecated and its functionality has been removed from Unity.", false)]
    public enum AspectRatio
    {
        // Undefined aspect ratios.
        AspectOthers = 0,

        // 4:3 aspect ratio.
        Aspect4by3 = 1,

        // 5:4 aspect ratio.
        Aspect5by4 = 2,

        // 16:10 aspect ratio.
        Aspect16by10 = 3,

        // 16:9 aspect ratio.
        Aspect16by9 = 4,
    }

    partial class PlayerSettings
    {
        // deprecated since forever
        [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
        [Obsolete("The option alwaysDisplayWatermark is deprecated and is always false", true)]
        public static bool alwaysDisplayWatermark { get { return false; } set {} }
        [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
        [Obsolete("Use AssetBundles instead for streaming data", true)]
        public static int firstStreamedLevelWithResources { get { return 0; } set {} }

        // deprecated in 5.1.
        [Obsolete("targetGlesGraphics is ignored, use SetGraphicsAPIs/GetGraphicsAPIs APIs", false)]
        public static TargetGlesGraphics targetGlesGraphics { get { return TargetGlesGraphics.Automatic; } set {} }
        [Obsolete("targetIOSGraphics is ignored, use SetGraphicsAPIs/GetGraphicsAPIs APIs", false)]
        public static TargetIOSGraphics targetIOSGraphics { get { return TargetIOSGraphics.Automatic; } set {} }

        // deprecated in 5.5
        [Obsolete("Use PlayerSettings.iOS.locationUsageDescription instead (UnityUpgradable) -> UnityEditor.PlayerSettings/iOS.locationUsageDescription", false)]
        public static string locationUsageDescription { get { return iOS.locationUsageDescription; } set { iOS.locationUsageDescription = value; } }

        // deprecated in 5.5
        [Obsolete("renderingPath is ignored, use UnityEditor.Rendering.TierSettings with UnityEditor.Rendering.SetTierSettings/GetTierSettings instead", false)]
        public static RenderingPath renderingPath { get { return EditorGraphicsSettings.GetCurrentTierSettings().renderingPath; } set {} }
        [Obsolete("mobileRenderingPath is ignored, use UnityEditor.Rendering.TierSettings with UnityEditor.Rendering.SetTierSettings/GetTierSettings instead", false)]
        public static RenderingPath mobileRenderingPath { get { return EditorGraphicsSettings.GetCurrentTierSettings().renderingPath; } set {} }

        // deprecated in 5.6
        [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
        [Obsolete("Use PlayerSettings.applicationIdentifier instead (UnityUpgradable) -> UnityEditor.PlayerSettings.applicationIdentifier", true)]
        public static string bundleIdentifier { get { return applicationIdentifier; } set { applicationIdentifier = value; } }

        [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
        [Obsolete("HasAspectRatio is deprecated, Unity supports all aspect ratios.", false)]
        public static bool HasAspectRatio(AspectRatio aspectRatio) => true;

        [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
        [Obsolete("SetAspectRatio is deprecated, Unity supports all aspect ratios.", false)]
        public static void SetAspectRatio(AspectRatio aspectRatio, bool enable) { }
    }

    partial class PlayerSettings
    {
        [Obsolete("Use PlayerSettings.Android.keystorePass instead (UnityUpgradable) -> UnityEditor.PlayerSettings/Android.keystorePass", true)]
        public static string keystorePass { get; set; }
        [Obsolete("Use PlayerSettings.Android.keyaliasPass instead (UnityUpgradable) -> UnityEditor.PlayerSettings/Android.keyaliasPass", true)]
        public static string keyaliasPass { get; set; }

        partial class Android
        {
            // deprecated in 2018.1
            [Obsolete("Use targetArchitectures instead. (UnityUpgradable) -> targetArchitectures", false)]
            public static AndroidTargetDevice targetDevice
            {
                get
                {
                    switch (targetArchitectures)
                    {
                        case AndroidArchitecture.ARMv7:
                            return AndroidTargetDevice.ARMv7;
                        default:
                            return AndroidTargetDevice.FAT;
                    }
                }
                set
                {
                    targetArchitectures = AndroidArchitecture.ARMv7;
                }
            }

            [Obsolete("minifyWithR8 is obsolete and has no effect anymore, since Android Gradle Plugin 7.0 always uses R8", false)]
            public static bool minifyWithR8 { get { return true; } set {} }

            [Obsolete("Renamed to match UI. Please use splitApplicationBinary instead. (UnityUpgradable) -> splitApplicationBinary", false)]
            public static extern bool useAPKExpansionFiles
            {
                [NativeMethod("GetAndroidSplitApplicationBinary")]
                get;
                [NativeMethod("SetAndroidSplitApplicationBinary")]
                set;
            }
        }

        partial class iOS
        {
            // deprecated in 5.0
            [Obsolete("exitOnSuspend is deprecated, use appInBackgroundBehavior", false)]
            public static bool exitOnSuspend
            {
                get { return appInBackgroundBehavior == iOSAppInBackgroundBehavior.Exit; }
                set { appInBackgroundBehavior = iOSAppInBackgroundBehavior.Exit; }
            }

            // deprecated in 5.3
            [System.ComponentModel.EditorBrowsable(System.ComponentModel.EditorBrowsableState.Never)]
            [Obsolete("Use Screen.SetResolution at runtime", true)]
            public static iOSTargetResolution targetResolution { get { return 0; } set {} }

            // deprecated in 5.5
            [Obsolete("Use PlayerSettings.muteOtherAudioSources instead (UnityUpgradable) -> UnityEditor.PlayerSettings.muteOtherAudioSources", false)]
            public static bool overrideIPodMusic { get { return PlayerSettings.muteOtherAudioSources; } set { PlayerSettings.muteOtherAudioSources = value; } }
        }
    }
}

