# SteamKit
[![Build Status (CI/CD)](https://github.com/SteamRE/SteamKit/actions/workflows/steamkit2-build.yaml/badge.svg?event=push)](https://github.com/SteamRE/SteamKit/actions/workflows/steamkit2-build.yaml)
[![NuGet](https://img.shields.io/nuget/v/SteamKit2.svg)](https://www.nuget.org/packages/SteamKit2/)
[![codecov](https://codecov.io/gh/SteamRE/SteamKit/branch/master/graph/badge.svg?token=qkJCxZI6rd)](https://codecov.io/gh/SteamRE/SteamKit)

SteamKit *(also known as SteamKit2)* is a .NET library designed to interoperate with Valve's [Steam network](https://store.steampowered.com/about). It aims to provide a simple, yet extensible, interface to perform various actions on the network.


## Getting Binaries


### Visual Studio

SteamKit is distributed as a [NuGet package](https://www.nuget.org/packages/steamkit2).

Simply install SteamKit using the package manager in Visual Studio, and NuGet will add all the required dependencies and references to your project.  
  
### Other

We additionally distribute binaries on our [releases page](https://github.com/SteamRE/SteamKit/releases).

For more information on installing SteamKit, please refer to the [Installation Guide](https://github.com/SteamRE/SteamKit/wiki/Installation) on the wiki.


## Documentation

Documentation consists primarily of XML code documentation provided with the binaries, and our [wiki](https://github.com/SteamRE/SteamKit/wiki).


## License

SteamKit is released under the [LGPL-2.1 license](https://choosealicense.com/licenses/lgpl-2.1/).


## Dependencies

In order to use SteamKit at runtime, [.NET 10.0 Runtime](https://dot.net/) or higher is required.

If you're using the SteamKit NuGet package, dependencies should be resolved for you. See the [Installation Guide](https://github.com/SteamRE/SteamKit/wiki/Installation) for more information.

To compile SteamKit, [.NET 10.0 SDK](https://dot.net/) is required.

## Discussions

If you have questions, [use the GitHub Discussions](https://github.com/SteamRE/SteamKit/discussions) section,
also try searching for an existing discussion.

IRC: irc.libera.chat / #steamre ([join via webchat](https://web.libera.chat/#steamre))

