// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("CLIENTFRIENDS_INTERFACE_VERSION001")]
	public interface IClientFriends
	{
		[VTableSlot(0)]
		string GetPersonaName();
		[VTableSlot(1)]
		void SetPersonaName(string pchPersonaName);
		[VTableSlot(2)]
		UInt64 SetPersonaNameEx(string pchPersonaName, bool bSendCallback);
		[VTableSlot(3)]
		bool IsPersonaNameSet();
		[VTableSlot(4)]
		EPersonaState GetPersonaState();
		[VTableSlot(5)]
		void SetPersonaState(EPersonaState ePersonaState);
		[VTableSlot(6)]
		bool NotifyUIOfMenuChange(bool bShowAvatars, bool bSortByName, bool bShowOnlineOnly, bool bShowUntaggedFriends);
		[VTableSlot(7)]
		Int32 GetFriendCount(EFriendFlags iFriendFlags);
		[VTableSlot(8)]
		UInt32 GetFriendArray(ref CSteamID arg0, StringBuilder arg1, Int32 arg2, Int32 arg3);
		[VTableSlot(9)]
		CSteamID GetFriendByIndex(Int32 iFriend, EFriendFlags iFriendFlags);
		[VTableSlot(10)]
		Int32 GetOnlineFriendCount();
		[VTableSlot(11)]
		EFriendRelationship GetFriendRelationship(CSteamID steamIDFriend);
		[VTableSlot(12)]
		EPersonaState GetFriendPersonaState(CSteamID steamIDFriend);
		[VTableSlot(13)]
		string GetFriendPersonaName(CSteamID steamIDFriend);
		[VTableSlot(14)]
		Int32 GetSmallFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(15)]
		Int32 GetMediumFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(16)]
		Int32 GetLargeFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(17)]
		void SetFriendRegValue(CSteamID steamIDFriend, string pchKey, string pchValue);
		[VTableSlot(18)]
		string GetFriendRegValue(CSteamID steamIDFriend, string pchKey);
		[VTableSlot(19)]
		bool DeleteFriendRegValue(CSteamID steamID, string pchKey);
		[VTableSlot(20)]
		bool GetFriendGamePlayed(CSteamID steamID, ref FriendGameInfo_t pGamePlayInfo);
		[VTableSlot(21)]
		string GetFriendGamePlayedExtraInfo(CSteamID steamIDFriend);
		[VTableSlot(22)]
		CSteamID GetFriendGameServer(CSteamID steamIDFriend);
		[VTableSlot(23)]
		EPersonaStateFlag GetFriendPersonaStateFlags(CSteamID steamIDFriend);
		[VTableSlot(24)]
		bool IsFriendGameOnConsole(CSteamID steamIDFriend);
		[VTableSlot(25)]
		FriendSessionStateInfo_t GetFriendSessionStateInfo(CSteamID steamIDFriend);
		[VTableSlot(26)]
		EUserRestriction GetFriendRestrictions(CSteamID steamIDFriend);
		[VTableSlot(27)]
		string GetFriendPersonaNameHistory(CSteamID steamIDFriend, Int32 iPersonaName);
		[VTableSlot(28)]
		UInt32 GetFriendSteamLevel(CSteamID steamIDFriend);
		[VTableSlot(29)]
		UInt64 RequestPersonaNameHistory(CSteamID steamIDFriend);
		[VTableSlot(30)]
		string GetFriendPersonaNameHistoryAndDate(CSteamID steamIDFriend, Int32 iPersonaName, ref UInt32 puTime);
		[VTableSlot(31)]
		bool AddFriend(CSteamID steamID);
		[VTableSlot(32)]
		bool RemoveFriend(CSteamID steamID);
		[VTableSlot(33)]
		bool HasFriend(CSteamID steamID, EFriendFlags iFriendFlags);
		[VTableSlot(34)]
		Int32 AddFriendByName(string pchEmailOrAccountName);
		[VTableSlot(35)]
		bool InviteFriendByEmail(string pchEmailAddress);
		[VTableSlot(36)]
		bool RequestUserInformation(CSteamID steamIDUser, bool bRequireNameOnly);
		[VTableSlot(37)]
		bool SetIgnoreFriend(CSteamID steamIDFriend, bool bIgnore);
		[VTableSlot(38)]
		bool ReportChatDeclined(CSteamID steamID);
		[VTableSlot(39)]
		bool CreateFriendsGroup(string pchGroupName);
		[VTableSlot(40)]
		bool DeleteFriendsGroup(Int16 iGroupID);
		[VTableSlot(41)]
		bool RenameFriendsGroup(string pchNewGroupName, Int16 iGroupID);
		[VTableSlot(42)]
		bool AddFriendToGroup(CSteamID steamID, Int16 iGroupID);
		[VTableSlot(43)]
		bool RemoveFriendFromGroup(CSteamID steamID, Int16 iGroupID);
		[VTableSlot(44)]
		bool IsFriendMemberOfFriendsGroup(CSteamID steamID, Int16 iGroupID);
		[VTableSlot(45)]
		Int16 GetFriendsGroupCount();
		[VTableSlot(46)]
		Int16 GetFriendsGroupIDByIndex(Int16 iGroupIndex);
		[VTableSlot(47)]
		string GetFriendsGroupName(Int16 iGroupID);
		[VTableSlot(48)]
		Int16 GetFriendsGroupMembershipCount(Int16 iGroupID);
		[VTableSlot(49)]
		CSteamID GetFirstFriendsGroupMember(Int16 iGroupID);
		[VTableSlot(50)]
		CSteamID GetNextFriendsGroupMember(Int16 iGroupID);
		[VTableSlot(51)]
		Int16 GetGroupFriendsMembershipCount(CSteamID steamID);
		[VTableSlot(52)]
		Int16 GetFirstGroupFriendsMember(CSteamID steamID);
		[VTableSlot(53)]
		Int16 GetNextGroupFriendsMember(CSteamID steamID);
		[VTableSlot(54)]
		string GetPlayerNickname(CSteamID playerSteamID);
		[VTableSlot(55)]
		bool SetPlayerNickname(CSteamID playerSteamID, string cszNickname);
		[VTableSlot(56)]
		UInt32 GetFriendsSteamLevel(CSteamID steamIDFriend);
		[VTableSlot(57)]
		Int32 GetChatMessagesCount(CSteamID steamIDFriend);
		[VTableSlot(58)]
		Int32 GetChatMessage(CSteamID steamIDFriend, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter, ref UInt32 puTime);
		[VTableSlot(59)]
		bool SendMsgToFriend(CSteamID steamIDFriend, EChatEntryType eChatEntryType, Byte[] pvMsgBody, Int32 cubMsgBody);
		[VTableSlot(60)]
		void ClearChatHistory(CSteamID steamIDFriend);
		[VTableSlot(61)]
		Int32 GetKnownClanCount();
		[VTableSlot(62)]
		CSteamID GetKnownClanByIndex(Int32 iClan);
		[VTableSlot(63)]
		Int32 GetClanCount();
		[VTableSlot(64)]
		CSteamID GetClanByIndex(Int32 iClan);
		[VTableSlot(65)]
		string GetClanName(CSteamID steamIDClan);
		[VTableSlot(66)]
		string GetClanTag(CSteamID steamIDClan);
		[VTableSlot(67)]
		bool GetFriendActivityCounts(ref Int32 pnOnline, ref Int32 pnInGame, bool bExcludeTaggedFriends);
		[VTableSlot(68)]
		bool GetClanActivityCounts(CSteamID steamID, ref Int32 pnOnline, ref Int32 pnInGame, ref Int32 pnChatting);
		[VTableSlot(69)]
		UInt64 DownloadClanActivityCounts(ref CSteamID groupIDs, Int32 nIds);
		[VTableSlot(70)]
		bool GetFriendsGroupActivityCounts(Int16 iGroupID, ref Int32 pnOnline, ref Int32 pnInGame);
		[VTableSlot(71)]
		bool IsClanPublic(CSteamID steamID);
		[VTableSlot(72)]
		UInt64 JoinClanChatRoom(CSteamID groupID);
		[VTableSlot(73)]
		bool LeaveClanChatRoom(CSteamID groupID);
		[VTableSlot(74)]
		Int32 GetClanChatMemberCount(CSteamID groupID);
		[VTableSlot(75)]
		CSteamID GetChatMemberByIndex(CSteamID groupID, Int32 iIndex);
		[VTableSlot(76)]
		bool SendClanChatMessage(CSteamID groupID, string cszMessage);
		[VTableSlot(77)]
		Int32 GetClanChatMessage(CSteamID groupID, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter);
		[VTableSlot(78)]
		bool IsClanChatAdmin(CSteamID groupID, CSteamID userID);
		[VTableSlot(79)]
		bool IsClanChatWindowOpenInSteam(CSteamID groupID);
		[VTableSlot(80)]
		bool OpenClanChatWindowInSteam(CSteamID groupID);
		[VTableSlot(81)]
		bool CloseClanChatWindowInSteam(CSteamID groupID);
		[VTableSlot(82)]
		bool SetListenForFriendsMessages(bool bListen);
		[VTableSlot(83)]
		bool ReplyToFriendMessage(CSteamID friendID, string cszMessage);
		[VTableSlot(84)]
		Int32 GetFriendMessage(CSteamID friendID, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType);
		[VTableSlot(85)]
		bool InviteFriendToClan(CSteamID steamIDfriend, CSteamID steamIDclan);
		[VTableSlot(86)]
		bool AcknowledgeInviteToClan(CSteamID steamID, bool bAcceptOrDenyClanInvite);
		[VTableSlot(87)]
		Int32 GetFriendCountFromSource(CSteamID steamIDSource);
		[VTableSlot(88)]
		CSteamID GetFriendFromSourceByIndex(CSteamID steamIDSource, Int32 iFriend);
		[VTableSlot(89)]
		bool IsUserInSource(CSteamID steamIDUser, CSteamID steamIDSource);
		[VTableSlot(90)]
		Int32 GetCoplayFriendCount();
		[VTableSlot(91)]
		CSteamID GetCoplayFriend(Int32 iCoplayEvent);
		[VTableSlot(92)]
		UInt32 GetFriendCoplayTime(CSteamID steamIDFriend);
		[VTableSlot(93)]
		UInt32 GetFriendCoplayGame(CSteamID steamIDFriend);
		[VTableSlot(94)]
		bool SetRichPresence(UInt32 nAppId, string pchKey, string pchValue);
		[VTableSlot(95)]
		void ClearRichPresence(UInt32 nAppId);
		[VTableSlot(96)]
		string GetFriendRichPresence(UInt32 nAppId, CSteamID steamIDFriend, string pchKey);
		[VTableSlot(97)]
		Int32 GetFriendRichPresenceKeyCount(UInt32 nAppId, CSteamID steamIDFriend);
		[VTableSlot(98)]
		string GetFriendRichPresenceKeyByIndex(UInt32 nAppId, CSteamID steamIDFriend, Int32 iIndex);
		[VTableSlot(99)]
		void RequestFriendRichPresence(UInt32 nAppId, CSteamID steamIDFriend);
		[VTableSlot(100)]
		bool JoinChatRoom(CSteamID steamIDChat);
		[VTableSlot(101)]
		void LeaveChatRoom(CSteamID steamIDChat);
		[VTableSlot(102)]
		bool InviteUserToChatRoom(CSteamID steamIDChat, CSteamID steamIDInvitee);
		[VTableSlot(103)]
		bool SendChatMsg(CSteamID steamIDChat, EChatEntryType eChatEntryType, Byte[] pvMsgBody, Int32 cubMsgBody);
		[VTableSlot(104)]
		Int32 GetChatRoomMessagesCount(CSteamID steamIDChat);
		[VTableSlot(105)]
		Int32 GetChatRoomEntry(CSteamID steamIDChat, Int32 iChatID, ref CSteamID steamIDuser, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType);
		[VTableSlot(106)]
		void ClearChatRoomHistory(CSteamID steamID);
		[VTableSlot(107)]
		bool SerializeChatRoomDlg(CSteamID steamIDChat, Byte[] pvHistory, Int32 cubHistory);
		[VTableSlot(108)]
		Int32 GetSizeOfSerializedChatRoomDlg(CSteamID steamIDChat);
		[VTableSlot(109)]
		bool GetSerializedChatRoomDlg(CSteamID steamIDChat, Byte[] pvHistory, Int32 cubBuffer, ref Int32 pcubData);
		[VTableSlot(110)]
		bool ClearSerializedChatRoomDlg(CSteamID steamIDChat);
		[VTableSlot(111)]
		bool KickChatMember(CSteamID steamIDChat, CSteamID steamIDUserToActOn);
		[VTableSlot(112)]
		bool BanChatMember(CSteamID steamIDChat, CSteamID steamIDUserToActOn);
		[VTableSlot(113)]
		bool UnBanChatMember(CSteamID steamIDChat, CSteamID steamIDUserToActOn);
		[VTableSlot(114)]
		bool SetChatRoomType(CSteamID steamIDChat, ELobbyType eLobbyType);
		[VTableSlot(115)]
		bool GetChatRoomLockState(CSteamID steamIDChat, ref bool pbLocked);
		[VTableSlot(116)]
		bool GetChatRoomPermissions(CSteamID steamIDChat, ref UInt32 prgfChatRoomPermissions);
		[VTableSlot(117)]
		bool SetChatRoomModerated(CSteamID steamIDChat, bool bModerated);
		[VTableSlot(118)]
		bool BChatRoomModerated(CSteamID steamIDChat);
		[VTableSlot(119)]
		bool NotifyChatRoomDlgsOfUIChange(CSteamID steamIDChat, bool bShowAvatars, bool bBeepOnNewMsg, bool bShowSteamIDs, bool bShowTimestampOnNewMsg);
		[VTableSlot(120)]
		bool TerminateChatRoom(CSteamID steamIDChat);
		[VTableSlot(121)]
		Int32 GetChatRoomCount();
		[VTableSlot(122)]
		CSteamID GetChatRoomByIndex(Int32 iChatRoom);
		[VTableSlot(123)]
		string GetChatRoomName(CSteamID steamIDChat);
		[VTableSlot(124)]
		bool BGetChatRoomMemberDetails(CSteamID steamIDChat, CSteamID steamIDUser, ref UInt32 prgfChatMemberDetails, ref UInt32 prgfChatMemberDetailsLocal);
		[VTableSlot(125)]
		void CreateChatRoom(EChatRoomType eType, UInt64 ulGameID, string pchName, ELobbyType eLobbyType, CSteamID steamIDClan, CSteamID steamIDFriendChat, CSteamID steamIDInvited, UInt32 rgfChatPermissionOfficer, UInt32 rgfChatPermissionMember, UInt32 rgfChatPermissionAll);
		[VTableSlot(126)]
		void VoiceCallNew(CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer);
		[VTableSlot(127)]
		void VoiceCall(CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer);
		[VTableSlot(128)]
		void VoiceHangUp(CSteamID steamIDLocalPeer, Int32 hVoiceCall);
		[VTableSlot(129)]
		void SetVoiceSpeakerVolume(float flVolume);
		[VTableSlot(130)]
		void SetVoiceMicrophoneVolume(float flVolume);
		[VTableSlot(131)]
		void SetAutoAnswer(bool bAutoAnswer);
		[VTableSlot(132)]
		void VoiceAnswer(Int32 hVoiceCall);
		[VTableSlot(133)]
		void AcceptVoiceCall(CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer);
		[VTableSlot(134)]
		void VoicePutOnHold(Int32 HVoiceCall, bool bLocalHold);
		[VTableSlot(135)]
		bool BVoiceIsLocalOnHold(Int32 hVoiceCall);
		[VTableSlot(136)]
		bool BVoiceIsRemoteOnHold(Int32 hVoiceCall);
		[VTableSlot(137)]
		void SetDoNotDisturb(bool bDoNotDisturb);
		[VTableSlot(138)]
		void EnableVoiceNotificationSounds(bool bEnable);
		[VTableSlot(139)]
		void SetPushToTalkEnabled(bool bEnable);
		[VTableSlot(140)]
		bool IsPushToTalkEnabled();
		[VTableSlot(141)]
		void SetPushToTalkKey(Int32 nVirtualKey);
		[VTableSlot(142)]
		Int32 GetPushToTalkKey();
		[VTableSlot(143)]
		bool IsPushToTalkKeyDown();
		[VTableSlot(144)]
		void EnableVoiceCalibration(bool bState);
		[VTableSlot(145)]
		bool IsVoiceCalibrating();
		[VTableSlot(146)]
		float GetVoiceCalibrationSamplePeak();
		[VTableSlot(147)]
		void SetMicBoost(bool bBoost);
		[VTableSlot(148)]
		bool GetMicBoost();
		[VTableSlot(149)]
		bool HasHardwareMicBoost();
		[VTableSlot(150)]
		string GetMicDeviceName();
		[VTableSlot(151)]
		void StartTalking(Int32 hVoiceCall);
		[VTableSlot(152)]
		void EndTalking(Int32 hVoiceCall);
		[VTableSlot(153)]
		bool VoiceIsValid(Int32 hVoiceCall);
		[VTableSlot(154)]
		void SetAutoReflectVoice(bool bState);
		[VTableSlot(155)]
		ECallState GetCallState(Int32 hVoiceCall);
		[VTableSlot(156)]
		float GetVoiceMicrophoneVolume();
		[VTableSlot(157)]
		float GetVoiceSpeakerVolume();
		[VTableSlot(158)]
		float TimeSinceLastVoiceDataReceived(Int32 hVoiceCall);
		[VTableSlot(159)]
		float TimeSinceLastVoiceDataSend(Int32 hVoiceCall);
		[VTableSlot(160)]
		bool BCanSend(Int32 hVoiceCall);
		[VTableSlot(161)]
		bool BCanReceive(Int32 hVoiceCall);
		[VTableSlot(162)]
		float GetEstimatedBitsPerSecond(Int32 hVoiceCall, bool bIncoming);
		[VTableSlot(163)]
		float GetPeakSample(Int32 hVoiceCall, bool bIncoming);
		[VTableSlot(164)]
		void SendResumeRequest(Int32 hVoiceCall);
		[VTableSlot(165)]
		void OpenChatDialog(CSteamID steamID);
		[VTableSlot(166)]
		void StartChatRoomVoiceSpeaking(CSteamID steamIDChat, CSteamID steamIDMember);
		[VTableSlot(167)]
		void EndChatRoomVoiceSpeaking(CSteamID steamIDChat, CSteamID steamIDMember);
		[VTableSlot(168)]
		UInt32 GetFriendLastLogonTime(CSteamID steamIDFriend);
		[VTableSlot(169)]
		UInt32 GetFriendLastLogoffTime(CSteamID steamIDFriend);
		[VTableSlot(170)]
		Int32 GetChatRoomVoiceTotalSlotCount(CSteamID steamIDChat);
		[VTableSlot(171)]
		Int32 GetChatRoomVoiceUsedSlotCount(CSteamID steamIDChat);
		[VTableSlot(172)]
		CSteamID GetChatRoomVoiceUsedSlot(CSteamID steamIDChat, Int32 iSlot);
		[VTableSlot(173)]
		EChatRoomVoiceStatus GetChatRoomVoiceStatus(CSteamID steamIDChat, CSteamID steamIDSpeaker);
		[VTableSlot(174)]
		bool BChatRoomHasAvailableVoiceSlots(CSteamID steamIDChat);
		[VTableSlot(175)]
		bool BIsChatRoomVoiceSpeaking(CSteamID steamIDChat, CSteamID steamIDSpeaker);
		[VTableSlot(176)]
		float GetChatRoomPeakSample(CSteamID steamIDChat, CSteamID steamIDSpeaker, bool bIncoming);
		[VTableSlot(177)]
		void ChatRoomVoiceRetryConnections(CSteamID steamIDChat);
		[VTableSlot(178)]
		void SetPortTypes(UInt32 unFlags);
		[VTableSlot(179)]
		void ReinitAudio();
		[VTableSlot(180)]
		void SetInGameVoiceSpeaking(CSteamID steamIDUser, bool bSpeaking);
		[VTableSlot(181)]
		bool IsInGameVoiceSpeaking();
		[VTableSlot(182)]
		void ActivateGameOverlay(string pchDialog);
		[VTableSlot(183)]
		void ActivateGameOverlayToUser(string pchDialog, CSteamID steamID);
		[VTableSlot(184)]
		void ActivateGameOverlayToWebPage(string pchURL);
		[VTableSlot(185)]
		void ActivateGameOverlayToStore(UInt32 nAppId, EOverlayToStoreFlag eFlag);
		[VTableSlot(186)]
		void ActivateGameOverlayInviteDialog(CSteamID steamIDLobby);
		[VTableSlot(187)]
		void NotifyGameOverlayStateChanged(bool bActive);
		[VTableSlot(188)]
		void NotifyGameServerChangeRequested(string pchServerAddress, string pchPassword);
		[VTableSlot(189)]
		bool NotifyLobbyJoinRequested(UInt32 nAppId, CSteamID steamIDLobby, CSteamID steamIDFriend);
		[VTableSlot(190)]
		bool NotifyRichPresenceJoinRequested(UInt32 nAppId, CSteamID steamIDFriend, string pchConnectString);
		[VTableSlot(191)]
		EClanRelationship GetClanRelationship(CSteamID steamIDclan);
		[VTableSlot(192)]
		EClanRank GetFriendClanRank(CSteamID steamIDUser, CSteamID steamIDClan);
		[VTableSlot(193)]
		bool VoiceIsAvailable();
		[VTableSlot(194)]
		void TestVoiceDisconnect(Int32 hVoiceCall);
		[VTableSlot(195)]
		void TestChatRoomPeerDisconnect(CSteamID steamIDChat, CSteamID steamIDSpeaker);
		[VTableSlot(196)]
		void TestVoicePacketLoss(float flFractionOfIncomingPacketsToDrop);
		[VTableSlot(197)]
		Int32 FindFriendVoiceChatHandle(CSteamID steamIDFriend);
		[VTableSlot(198)]
		void RequestFriendsWhoPlayGame(CGameID gameID);
		[VTableSlot(199)]
		UInt32 GetCountFriendsWhoPlayGame(CGameID gameID);
		[VTableSlot(200)]
		CSteamID GetFriendWhoPlaysGame(UInt32 iIndex, CGameID gameID);
		[VTableSlot(201)]
		void SetPlayedWith(CSteamID steamIDUserPlayedWith);
		[VTableSlot(202)]
		UInt64 RequestClanOfficerList(CSteamID steamIDClan);
		[VTableSlot(203)]
		CSteamID GetClanOwner(CSteamID steamIDClan);
		[VTableSlot(204)]
		Int32 GetClanOfficerCount(CSteamID steamIDClan);
		[VTableSlot(205)]
		CSteamID GetClanOfficerByIndex(CSteamID steamIDClan, Int32 iOfficer);
		[VTableSlot(206)]
		EUserRestriction GetUserRestrictions();
		[VTableSlot(207)]
		UInt64 RequestFriendProfileInfo(CSteamID steamIDFriend);
		[VTableSlot(208)]
		string GetFriendProfileInfo(CSteamID steamIDFriend, string pchKey);
		[VTableSlot(209)]
		bool InviteUserToGame(CSteamID steamIDFriend, string pchConnectString);
		[VTableSlot(210)]
		Int32 GetOnlineConsoleFriendCount();
		[VTableSlot(211)]
		UInt64 RequestTrade(CSteamID steamIDPartner);
		[VTableSlot(212)]
		void TradeResponse(UInt32 unTradeRequestID, bool bAccept);
		[VTableSlot(213)]
		void CancelTradeRequest(CSteamID steamIDPartner);
		[VTableSlot(214)]
		bool HideFriend(CSteamID steamIDFriend, bool bHide);
		[VTableSlot(215)]
		string GetFriendFacebookName(CSteamID steamIDFriend);
		[VTableSlot(216)]
		UInt64 GetFriendFacebookID(CSteamID steamIDFriend);
		[VTableSlot(217)]
		UInt64 GetFollowerCount(CSteamID steamID);
		[VTableSlot(218)]
		UInt64 IsFollowing(CSteamID steamID);
		[VTableSlot(219)]
		UInt64 EnumerateFollowingList(UInt32 uStartIndex);
		[VTableSlot(220)]
		void RequestFriendMessageHistory(CSteamID steamIDFriend);
		[VTableSlot(221)]
		void RequestFriendMessageHistoryForOfflineMessages();
		[VTableSlot(222)]
		Int32 GetCountFriendsWithOfflineMessages();
		[VTableSlot(223)]
		UInt32 GetFriendWithOfflineMessage(Int32 iFriend);
		[VTableSlot(224)]
		void ClearFriendHasOfflineMessage(UInt32 uFriend);
		[VTableSlot(225)]
		void RequestEmoticonList();
		[VTableSlot(226)]
		Int32 GetEmoticonCount();
		[VTableSlot(227)]
		string GetEmoticonName(Int32 iEmoticon);
		[VTableSlot(228)]
		void ClientLinkFilterInit();
		[VTableSlot(229)]
		UInt32 LinkDisposition(string arg0);
	};
}
