"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = update;
const format_changed_files_with_prettier_if_available_1 = require("../../generators/internal-utils/format-changed-files-with-prettier-if-available");
const nx_json_1 = require("../../generators/utils/nx-json");
async function update(tree) {
    const nxJson = (0, nx_json_1.readNxJson)(tree);
    if (nxJson?.tasksRunnerOptions?.['default']?.options?.useDaemonProcess !==
        undefined) {
        nxJson.useDaemonProcess =
            nxJson.tasksRunnerOptions['default'].options.useDaemonProcess;
        delete nxJson.tasksRunnerOptions['default'].options.useDaemonProcess;
        if (Object.keys(nxJson.tasksRunnerOptions['default'].options).length === 0) {
            delete nxJson.tasksRunnerOptions['default'].options;
        }
        if (Object.keys(nxJson.tasksRunnerOptions['default']).length === 0) {
            delete nxJson.tasksRunnerOptions['default'];
        }
        if (Object.keys(nxJson.tasksRunnerOptions).length === 0) {
            delete nxJson.tasksRunnerOptions;
        }
        (0, nx_json_1.updateNxJson)(tree, nxJson);
    }
    await (0, format_changed_files_with_prettier_if_available_1.formatChangedFilesWithPrettierIfAvailable)(tree);
}
