/**
 * find the first match for string, import, node, or default
 * at this point, we know we're on the right subpath already
 */
export const resolveConditionalValue = (exp, options) => {
    const { conditions = ['import', 'node'] } = options;
    if (exp === null || typeof exp === 'string')
        return exp;
    if (Array.isArray(exp)) {
        for (const e of exp) {
            const r = resolveConditionalValue(e, options);
            if (r)
                return r;
        }
        return null;
    }
    for (const [k, v] of Object.entries(exp)) {
        if (conditions.includes(k) || k === 'default') {
            return resolveConditionalValue(v, options);
        }
    }
    return null;
};
//# sourceMappingURL=resolve-conditional-value.js.map