"use strict";
/**
 * Errors raised by resolve failures.
 * @module
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageImportNotDefined = exports.moduleNotFound = exports.packageNotFound = exports.subpathNotExported = exports.relativeImportWithoutParentURL = exports.invalidPackage = exports.invalidImportSpecifier = void 0;
const resolve_import_js_1 = require("./resolve-import.js");
// TODO: move "caller" to an options object. Then the same options object can
// be used that handles conditions, parentURL, etc., and the relevant
// top-level function can set it explicitly at the start of the process and
// just pass it along.
const invalidImportSpecifier = (url, caller = resolve_import_js_1.resolveImport) => {
    const er = new Error('invalid import() specifier: ' + url);
    Error.captureStackTrace(er, caller);
    return er;
};
exports.invalidImportSpecifier = invalidImportSpecifier;
const invalidPackage = (pj, caller = resolve_import_js_1.resolveImport) => {
    const er = new Error(`Not a valid package: ${pj}`);
    Error.captureStackTrace(er, caller);
    return er;
};
exports.invalidPackage = invalidPackage;
const relativeImportWithoutParentURL = (url, parentURL, caller = resolve_import_js_1.resolveImport) => {
    const er = Object.assign(new Error('relative import without parentURL'), {
        url,
        parentURL,
    });
    Error.captureStackTrace(er, caller);
    return er;
};
exports.relativeImportWithoutParentURL = relativeImportWithoutParentURL;
const subpathNotExported = (sub, pj, from, caller = resolve_import_js_1.resolveImport) => {
    const p = sub === '.' ?
        'No "exports" main defined'
        : `Package subpath '${sub}' is not defined by "exports"`;
    const er = Object.assign(new Error(`${p} in ${pj} imported from ${from}`), {
        code: 'ERR_PACKAGE_PATH_NOT_EXPORTED',
    });
    Error.captureStackTrace(er, caller);
    return er;
};
exports.subpathNotExported = subpathNotExported;
const packageNotFound = (path, from, caller = resolve_import_js_1.resolveImport) => {
    const er = Object.assign(new Error(`Cannot find package '${path}' imported from ${from}`), {
        code: 'ERR_MODULE_NOT_FOUND',
    });
    Error.captureStackTrace(er, caller);
    return er;
};
exports.packageNotFound = packageNotFound;
const moduleNotFound = (path, from, caller = resolve_import_js_1.resolveImport) => {
    const er = Object.assign(new Error(`Cannot find module '${path}' imported from ${from}`), {
        code: 'ERR_MODULE_NOT_FOUND',
    });
    Error.captureStackTrace(er, caller);
    return er;
};
exports.moduleNotFound = moduleNotFound;
const packageImportNotDefined = (path, pj, from, caller = resolve_import_js_1.resolveImport) => {
    const er = Object.assign(new Error(`Package import specifier "${path}" is not defined in package ` +
        `${pj} imported from ${from}`), { code: 'ERR_PACKAGE_IMPORT_NOT_DEFINED' });
    Error.captureStackTrace(er, caller);
    return er;
};
exports.packageImportNotDefined = packageImportNotDefined;
//# sourceMappingURL=errors.js.map