import { TaskHasher } from '../hasher/task-hasher';
import { DefaultTasksRunnerOptions } from './default-tasks-runner';
import { TaskStatus } from './tasks-runner';
import { ProjectGraph } from '../config/project-graph';
import { TaskGraph } from '../config/task-graph';
import { DaemonClient } from '../daemon/client/client';
import { NxJsonConfiguration } from '../config/nx-json';
export declare class TaskOrchestrator {
    private readonly hasher;
    private readonly initiatingProject;
    private readonly projectGraph;
    private readonly taskGraph;
    private readonly nxJson;
    private readonly options;
    private readonly bail;
    private readonly daemon;
    private readonly outputStyle;
    private taskDetails;
    private cache;
    private forkedProcessTaskRunner;
    private tasksSchedule;
    private batchEnv;
    private reverseTaskDeps;
    private processedTasks;
    private processedBatches;
    private completedTasks;
    private waitingForTasks;
    private groups;
    private bailed;
    constructor(hasher: TaskHasher, initiatingProject: string | undefined, projectGraph: ProjectGraph, taskGraph: TaskGraph, nxJson: NxJsonConfiguration, options: DefaultTasksRunnerOptions, bail: boolean, daemon: DaemonClient, outputStyle: string);
    run(): Promise<{
        [id: string]: TaskStatus;
    }>;
    private executeNextBatchOfTasksUsingTaskSchedule;
    private processScheduledTask;
    private processScheduledBatch;
    private processAllScheduledTasks;
    private applyCachedResults;
    private applyCachedResult;
    private applyFromCacheOrRunBatch;
    private runBatch;
    private applyFromCacheOrRunTask;
    private runTaskInForkedProcess;
    private preRunSteps;
    private postRunSteps;
    private complete;
    private pipeOutputCapture;
    private shouldCacheTaskResult;
    private closeGroup;
    private openGroup;
    private shouldCopyOutputsFromCache;
    private recordOutputsHash;
}
