import { ProjectGraph, ProjectGraphProjectNode } from '../config/project-graph';
import { Task, TaskGraph } from '../config/task-graph';
import { TargetDefaults, TargetDependencies } from '../config/nx-json';
export declare class ProcessTasks {
    private readonly extraTargetDependencies;
    private readonly projectGraph;
    private readonly seen;
    readonly tasks: {
        [id: string]: Task;
    };
    readonly dependencies: {
        [k: string]: string[];
    };
    private readonly allTargetNames;
    constructor(extraTargetDependencies: TargetDependencies, projectGraph: ProjectGraph);
    processTasks(projectNames: string[], targets: string[], configuration: string, overrides: Object, excludeTaskDependencies: boolean): string[];
    processTask(task: Task, projectUsedToDeriveDependencies: string, configuration: string, overrides: Object): void;
    private processTasksForMultipleProjects;
    private processTasksForSingleProject;
    private processTasksForDependencies;
    private createDummyTask;
    createTask(id: string, project: ProjectGraphProjectNode, target: string, resolvedConfiguration: string | undefined, overrides: Object): Task;
    resolveConfiguration(project: ProjectGraphProjectNode, target: string, configuration: string | undefined): string;
    getId(project: string, target: string, configuration: string | undefined): string;
    /**
     * this function is used to get the non dummy dependencies of a task recursively
     * For example, when we have the following dependencies:
     * {
     *   'app1:compile': [ 'app2:__nx_dummy_task__' ],
     *   'app2:__nx_dummy_task__': [ 'app3:__nx_dummy_task__' ],
     *   'app3:__nx_dummy_task__': [ 'app4:precompile' ],
     *   'app4:precompile': []
     * }
     * getNonDummyDeps('app1:compile') will return ['app1:compile']
     * getNonDummyDeps('app2:__nx_dummy_task__') will return ['app4:precompile']
     * getNonDummyDeps('app3:__nx_dummy_task__') will return ['app4:precompile']
     * getNonDummyDeps('app4:precompile') will return ['app4:precompile']
     */
    private getNonDummyDeps;
    private filterDummyTasks;
}
export declare function createTaskGraph(projectGraph: ProjectGraph, extraTargetDependencies: TargetDependencies, projectNames: string[], targets: string[], configuration: string | undefined, overrides: Object, excludeTaskDependencies?: boolean): TaskGraph;
export declare function mapTargetDefaultsToDependencies(defaults: TargetDefaults | undefined): TargetDependencies;
