import { ResolveImportOpts } from './index.js';
/**
 * Given a path or file URL to a package.json file, return an object where each
 * possible export path is mapped to the file URL that it would resolve to.
 *
 * Invalid exports are omitted. No errors are raised as long as the file is a
 * valid `package.json`.
 *
 * Note: in cases like `"./x/*": "./file.js"`, where the list of possible
 * import paths is unbounded, the returned object will contain `"./x/*"` as the
 * key, since there's no way to expand that to every possible match.
 */
export declare const resolveAllExports: (packageJsonPath: string | URL, options?: ResolveImportOpts) => Promise<Record<string, string | URL>>;
//# sourceMappingURL=resolve-all-exports.d.ts.map