"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readPkg = void 0;
const read_json_js_1 = require("./read-json.js");
const isExports = (e) => !!e && (typeof e === 'object' || typeof e === 'string');
const isImports = (e) => {
    if (!e || typeof e !== 'object' || Array.isArray(e))
        return false;
    for (const p in e) {
        if (!p.startsWith('#'))
            return false;
    }
    return true;
};
const isPkg = (o) => !!o &&
    typeof o === 'object' &&
    (typeof o.name === 'string' || typeof o.name === 'undefined') &&
    (typeof o.main === 'string' || typeof o.main === 'undefined') &&
    (typeof o.module === 'string' || typeof o.module === 'undefined') &&
    (typeof o.exports === 'undefined' || isExports(o.exports)) &&
    (typeof o.imports === 'undefined' || isImports(o.imports));
const readPkg = async (f) => {
    const pj = await (0, read_json_js_1.readJSON)(f);
    return isPkg(pj) ? pj : null;
};
exports.readPkg = readPkg;
//# sourceMappingURL=read-pkg.js.map