"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findDepPackage = void 0;
const promises_1 = require("fs/promises");
const path_1 = require("path");
const walk_up_path_1 = require("walk-up-path");
const dirExists = async (f) => (0, promises_1.stat)(f).then(st => st.isDirectory(), () => false);
const findDepPackage = async (pkgName, parentPath) => {
    // starting from the dirname, try to find the nearest node_modules
    for (const dir of (0, walk_up_path_1.walkUp)((0, path_1.dirname)(parentPath))) {
        const nm = (0, path_1.resolve)(dir, 'node_modules') + path_1.sep;
        // if it's null, then we need the node_modules itself
        // if it's '' then we use node_modules with an extra / on it
        // thisis only relevant when generating the error message, since
        // of course node_modules// is never going to be a valid package.
        const ppath = pkgName === null ? nm : (!pkgName ? nm : (0, path_1.resolve)(nm, pkgName)) + path_1.sep;
        if (await dirExists(ppath)) {
            try {
                return (await (0, promises_1.realpath)(ppath)) + path_1.sep;
                // the direxists stat will avoid almost all throws that could
                // occur here, but just in case.
                /* c8 ignore start */
            }
            catch { }
            /* c8 ignore stop */
        }
    }
};
exports.findDepPackage = findDepPackage;
//# sourceMappingURL=find-dep-package.js.map