import { type ProjectType, type Tree } from 'nx/src/devkit-exports';
export type ProjectGenerationOptions = {
    directory: string;
    name?: string;
    projectType: ProjectType;
    importPath?: string;
    rootProject?: boolean;
};
export type ProjectNameAndRootOptions = {
    /**
     * Normalized full project name, including scope if name was provided with
     * scope (e.g., `@scope/name`)
     */
    projectName: string;
    /**
     * Normalized project root, including the layout directory if configured.
     */
    projectRoot: string;
    names: {
        /**
         * Normalized project name without scope. It's meant to be used when
         * generating file names that contain the project name.
         */
        projectFileName: string;
        /**
         * Normalized project name without scope or directory. It's meant to be used
         * when generating shorter file names that contain the project name.
         */
        projectSimpleName: string;
    };
    /**
     * Normalized import path for the project.
     */
    importPath?: string;
};
export declare function determineProjectNameAndRootOptions(tree: Tree, options: ProjectGenerationOptions): Promise<ProjectNameAndRootOptions>;
export declare function ensureProjectName(tree: Tree, options: Omit<ProjectGenerationOptions, 'projectType'>, projectType: 'application' | 'library'): Promise<void>;
