<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->








[![git-url-parse](http://i.imgur.com/HlfMsVf.png)](#)











# git-url-parse

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/git-url-parse.svg)](https://travis-ci.org/IonicaBizau/git-url-parse/) [![Version](https://img.shields.io/npm/v/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Downloads](https://img.shields.io/npm/dt/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> A high level git url parser for common git providers.

















## :cloud: Installation

```sh
# Using npm
npm install --save git-url-parse

# Using yarn
yarn add git-url-parse
```













## :clipboard: Example



```js
// Dependencies
const GitUrlParse = require("git-url-parse");

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: []
//   , port: null
//   , resource: "github.com"
//   , user: "git"
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "git@github.com:IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "ssh"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: ["https"]
//   , port: null
//   , resource: "github.com"
//   , user: ""
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "https://github.com/IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "https"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js"));
// { protocols: [ 'https' ],
//   protocol: 'https',
//   port: null,
//   resource: 'github.com',
//   user: '',
//   pathname: '/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   hash: '',
//   search: '',
//   href: 'https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   token: '',
//   toString: [Function],
//   source: 'github.com',
//   name: 'git-url-parse',
//   owner: 'IonicaBizau',
//   organization: '',
//   ref: 'master',
//   filepathtype: 'blob',
//   filepath: 'test/index.js',
//   full_name: 'IonicaBizau/git-url-parse' }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git").toString("ssh"));
// => "git@github.com:IonicaBizau/node-git-url-parse.git"

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git").toString("https"));
// => "https://github.com/IonicaBizau/node-git-url-parse.git"
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `gitUrlParse(url)`
Parses a Git url.

#### Params

- **String** `url`: The Git url to parse.

#### Return
- **GitUrl** The `GitUrl` object containing:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `protocol` (String): The git url protocol.
 - `token` (String): The oauth token (could appear in the https urls).
 - `source` (String): The Git provider (e.g. `"github.com"`).
 - `owner` (String): The repository owner.
 - `name` (String): The repository name.
 - `ref` (String): The repository ref (e.g., "master" or "dev").
 - `filepath` (String): A filepath relative to the repository root.
 - `filepathtype` (String): The type of filepath in the url ("blob" or "tree").
 - `full_name` (String): The owner and name values in the `owner/name` format.
 - `toString` (Function): A function to stringify the parsed url into another url type.
 - `organization` (String): The organization the owner belongs to. This is CloudForge specific.
 - `git_suffix` (Boolean): Whether to add the `.git` suffix or not.

### `stringify(obj, type)`
Stringifies a `GitUrl` object.

#### Params

- **GitUrl** `obj`: The parsed Git url object.
- **String** `type`: The type of the stringified url (default `obj.protocol`).

#### Return
- **String** The stringified url.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `lerna`
 - `release-it`
 - `@backstage/backend-common`
 - `documentation`
 - `apollo`
 - `@backstage/integration`
 - `@storybook/storybook-deployer`
 - `@atomist/automation-client`
 - `@plone/scripts`
 - `workspace-tools`
 - `@backstage/plugin-catalog-backend`
 - `@pvm/core`
 - `nextra-theme-docs`
 - `@kadira/storybook-deployer`
 - `gatsby-source-git`
 - `@nuxt/telemetry`
 - `umi-build-dev`
 - `@era-ci/utils`
 - `strapi-generate-new`
 - `git-source`
 - `@atomist/automation-client-ext-raven`
 - `renovate`
 - `semantic-release-gitmoji`
 - `@qiwi/semantic-release-gh-pages-plugin`
 - `@backstage/plugin-scaffolder`
 - `apify-shared`
 - `@atomist/sdm-pack-analysis`
 - `@git-stack/server-core`
 - `@backstage/cli`
 - `@backstage/plugin-techdocs-node`
 - `@dtwo/telemetry`
 - `@lerna/create`
 - `remax-stats`
 - `@s-ui/mono`
 - `common-boilerplate`
 - `@strapi/pack-up`
 - `@umijs/block-sdk`
 - `@backstage/plugin-techdocs`
 - `@akemona-org/strapi-generate-new`
 - `@stackbit/cms-git`
 - `package-json-from-git`
 - `pupils-generate-new`
 - `@toanz/strapi-generate-new`
 - `@x-team/strapi-generate-new`
 - `@servable/manifest`
 - `@backstage/plugin-catalog-import`
 - `@s-ui/studio`
 - `@appworks/project-utils`
 - `@jswork/next-git-url`
 - `@backstage/plugin-github-actions`
 - `@wetrial/block-sdk`
 - `datoit-generate-new`
 - `@micro-app/shared-utils`
 - `@appirio/appirio`
 - `@radjs/block-sdk`
 - `@stackbit/dev-common`
 - `@useoptic/optic`
 - `@tasenor/common-node`
 - `@oumi/block-sdk`
 - `@sanity/pkg-utils`
 - `@qoopido/lerna.version`
 - `@log4brains/core`
 - `@yarnpkg/plugin-git`
 - `@xdn/cli`
 - `@madm4ttus3r/l4bcore`
 - `@atomist/skill`
 - `@zeplin/cli`
 - `@lerna/github-client`
 - `@koumoul/gh-pages-multi`
 - `@brisk-docs/gatsby-generator`
 - `clipped`
 - `codesandbox-theme-docs`
 - `git-issues`
 - `gitbook-start-plugin-iaas-ull-es-noejaco2017`
 - `fotingo`
 - `hzero-block-sdk`
 - `miguelcostero-ng2-toasty`
 - `@microservices/cli`
 - `omg`
 - `@guardian/cdk`
 - `@atomist/cli`
 - `@vamsikc/plugin-catalog`
 - `@lerna-lite/version`
 - `@praella/localisationist`
 - `@spryker-lerna/github-client`
 - `copy-github-directory`
 - `docula-ui`
 - `lambda-service`
 - `octokit-downloader`
 - `sync-repos`
 - `stylelint-formatter-utils`
 - `@mongchhi/plugin-blocks`
 - `@enkeledi/react-native-week-month-date-picker`
 - `@tmplr/node`
 - `@kevinbds/techdocs-common`
 - `autorelease-setup`
 - `scaffolder-core`
 - `@facadecompany/ignition-ui`
 - `@geut/git-url-parse`
 - `@git-stack/hemera-plugin`
 - `testarmada-midway`
 - `react-native-shared-gesture`
 - `@lerna/legacy-package-management`
 - `@jaredpalmer/workspace-tools`
 - `@focusworkstemp/project-utils`
 - `@unibtc/release-it`
 - `@backstage/plugin-techdocs-module-addons-contrib`
 - `changelog.md`
 - `react-native-nice-learning`
 - `wiby`
 - `@erquhart/lerna-github-client`
 - `sherry-utils`
 - `@oumi/cli-ui`
 - `@monokle/synchronizer`
 - `@vrabbi/plugin-scaffolder-backend`
 - `@backstage/plugin-scaffolder-backend-module-confluence-to-markdown`
 - `@0x-lerna-fork/github-client`
 - `documentation-custom-markdown`
 - `@atomist/uhura`
 - `@vrabbi/plugin-scaffolder`
 - `@antv/gatsby-theme-antv`
 - `@pmworks/project-utils`
 - `@pubbo/github-client`
 - `@sanv/apify-shared`
 - `@scafflater/scafflater`
 - `gcpayz-block-sdk`
 - `@feizheng/next-git-url`
 - `@iceworks/project-utils`
 - `@hygiene/plugin-github-url`
 - `servable-manifest`
 - `tegit`
 - `@backstage/plugin-catalog-backend-module-github`
 - `auto-changelog-vsts`
 - `@belt/repo`
 - `@wolfy1339/gatsby-source-git`
 - `@axetroy/gpm`
 - `belt-repo`
 - `@brisk-docs/website`
 - `create-apex-js-app`
 - `cz-conventional-changelog-befe`
 - `cover-builder`
 - `@buschtoens/documentation`
 - `development-efficiency`
 - `debone`
 - `@deskbtm/workspace-tools`
 - `git-origin-check`
 - `git-yoink`
 - `git-service-node`
 - `gitbook-start-iaas-bbdd-alex-moi`
 - `gitbook-start-iaas-ull-es-merquililycony`
 - `gitc`
 - `@ckatzorke/renovate`
 - `@_nomtek/react-native-shimmer-animation`
 - `mdnext-loader`
 - `lime-cli`
 - `kef-core`
 - `khaled-salem-custom-components`
 - `@dandean/storybook-deployer`
 - `jsnix`
 - `l-other-data`
 - `laborious`
 - `konitor`
 - `konfig-release-it`
 - `native-kakao-login`
 - `@dfatwork-pkgs/backstage-cli`
 - `open-pull-request`
 - `npm_one_1_2_3`
 - `gtni`
 - `fster`
 - `griffin-ui-library`
 - `gatsby-theme-zh`
 - `gatsby-source-git-remotes`
 - `gaurav-react-native-loop`
 - `gatsby-source-npmjs`
 - `gitlab-ci-variables-cli`
 - `harry-reporter`
 - `@cliz/gpm`
 - `framework_test_library_sixdee`
 - `fluent.adflow.reactnativesdk-alpha`
 - `ewizard-cli`
 - `prep-barv11`
 - `react-native-azure-communication-services`
 - `react-native-android-video-player-view`
 - `react-native-animate-text`
 - `react-native-arunmeena1987`
 - `react-native-basic-screen`
 - `react-native-build-vesion-getter`
 - `react-native-biometric-authenticate`
 - `react-native-check-component`
 - `react-native-bleccs-components`
 - `react-native-ghn-ekyc`
 - `react-native-kakao-maps`
 - `react-native-klc`
 - `react-native-manh-test`
 - `react-native-library-testing-422522`
 - `release-it-http`
 - `react-native-test-comlibrary`
 - `react-native-uvc-camera-android`
 - `react-native-withframework-check`
 - `react-native-ytximkit`
 - `react-native-multiplier-component`
 - `react-native-multiplier-demo`
 - `react-native-multiplier2`
 - `react-native-multiselector`
 - `react-native-payu-payment-testing`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-progress-arrow`
 - `react-native-reanimated-sortable-list`
 - `react-native-rom-components`
 - `react-native-contact-list`
 - `react-native-create-video-thumbnail`
 - `react-native-components-design`
 - `react-native-module-for-testing`
 - `spk`
 - `redhatinsights-plugin-scaffolder-backend`
 - `simple-github-release`
 - `tanyao`
 - `@emedvedev/renovate`
 - `@hugomrdias/documentation`
 - `@hemith/react-native-tnk`
 - `snipx`
 - `@janus-idp/backstage-plugin-topology`
 - `@mmomtchev/documentation`
 - `@salla.sa/cli`
 - `@jswork/topics2keywords`
 - `@amiruldev/wajs`
 - `@safely-project/safely-ts`
 - `@rianfowler/backstage-backend-common`
 - `@status-im/react-native-transparent-video`
 - `@pvdlg/semantic-release`
 - `@rdfrontier/plugin-mobile`
 - `@veecode-platform/plugin-github-actions`
 - `@lehuyaa/my-assets`
 - `@lerna-test-v1/markdown`
 - `@pageshare/cli`
 - `@parallelnft/web3modal`
 - `@visulima/nextra-theme-docs`
 - `@xyz/create-package`
 - `react-native-cplus`
 - `react-native-input-library`
 - `react-native-klarify-ios`
 - `react-native-login-demo-test`
 - `react-native-jawwy_sample`
 - `react-native-arunjeyam1987`
 - `react-native-basic-app`
 - `react-native-bubble-chart`
 - `react-native-awesome-module-two`
 - `react-native-dhp-printer`
 - `react-native-flyy`
 - `react-native-innity-remaster`
 - `template-typescript-node-package`
 - `repom`
 - `storybook-deployer`
 - `rdmobile`
 - `react-native-rabbitmq-all`
 - `react-native-sandycomponent`
 - `react-native-savczuk-feature-library`
 - `react-native-ticker-tape`
 - `rn-check-btn`
 - `rn_unique_device_id`
 - `pr-log`
 - `semantic-release-squash3`
 - `publish-version`
 - `pyreswap-sdk`
 - `renovate-csm`
 - `test-library-123`
 - `@blackglory/git-list`
 - `checkbox-component`
 - `complan`
 - `configorama`
 - `@brainfried/github-books`
 - `def-core`
 - `bitbucket-pullr`
 - `tldw`
 - `nextra-theme-docs-mdxcomponents`
 - `manage-dependency`
 - `wsj.gatsby-source-git`
 - `winx-form-winx`
 - `zeo-collect`
 - `@felipesimmi/react-native-datalogic-module`
 - `@geut/chan-parser`
 - `@hawkingnetwork/react-native-tab-view`
 - `@infinitecsolutions/storybook-deployer`
 - `pbc`
 - `@voodeng/uppacks`
 - `toxics-rpc`
 - `@esops/publish-github-pages`
 - `@evanpurkhiser/tooling-personal`
 - `@oiti/rn-liveness2d`
 - `semantic-release-github-milestones`
 - `@taingo97/react-native-sunmi-printer`
 - `@taingo97/react-native-telpo-printer`
 - `@theowenyoung/gatsby-source-git`
 - `@speakeasy-sdks/nextra-theme-docs`
 - `@shopgate/pwa-releaser`
 - `@rocali/apollo`
 - `@stackbit/cli`
 - `@stepsec/release`
 - `@edgio/cli`
 - `@axetroy/git-clone`
 - `aral-vps-test`
 - `auto-clone`
 - `awesome-module-kd`
 - `@wekanteam/documentation`
 - `candlelabssdk`
 - `canarist`
 - `detect-node-support`
 - `@aysea/react-native-ui-library`
 - `@azalpacir/react-native-dhp-printer`
 - `@campus-online/gatsby-source-git`
 - `@x-team/create-strapi-starter`
 - `cirodown`
 - `create-pupils-starter`
 - `branch-release`
 - `fixed_form_builder`
 - `@1nd/documentation`
 - `@carrotwu/wcli`
 - `gatsby-theme-art-graph`
 - `gatsby-theme-cone-oc`
 - `gatsby-theme-iot`
 - `gd-cli`
 - `generate-preview`
 - `generator-bootstrap-boilerplate-template`
 - `generator-frida`
 - `gitline`
 - `semantic-release-telegram`
 - `@echolayer/plugin-backstage`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `yangtao-js`
 - `yarn-upgrade-on-ci`
 - `wp-continuous-deployment`
 - `@ali5049/react-native-buttons`
 - `@gogogosir/build-cli`
 - `@git-stack/module-server`
 - `@dvcorg/cml`
 - `@domestika/mono`
 - `react-native-sp-test-common`
 - `react-native-ui-components-library`
 - `react-native-xprinter-thermal-ble`
 - `reat-native-multiplierkpr`
 - `sn-flutter-boot`
 - `react-native-get-countries`
 - `react-native-dsphoto-module`
 - `react-native-lib-test-rn-1`
 - `react-native-native-audio-engine`
 - `react-native-onramp`
 - `react-native-nghia-sharering`
 - `react-native-recent-framework-update`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
