/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
declare const _default: "\ninterface ReadonlyArray<T> {\n  readonly length: number;\n  toString(): string;\n  toLocaleString(): string;\n  concat(...items: ConcatArray<T>[]): T[];\n  concat(...items: (T | ConcatArray<T>)[]): T[];\n  join(separator?: string): string;\n  slice(start?: number, end?: number): T[];\n  indexOf(searchElement: T, fromIndex?: number): number;\n  lastIndexOf(searchElement: T, fromIndex?: number): number;\n  every<S extends T>(predicate: (value: T, index: number, array: readonly T[]) => value is S, thisArg?: any): this is readonly S[];\n  every(predicate: (value: T, index: number, array: readonly T[]) => unknown, thisArg?: any): boolean;\n  some(predicate: (value: T, index: number, array: readonly T[]) => unknown, thisArg?: any): boolean;\n  forEach(callbackfn: (value: T, index: number, array: readonly T[]) => void, thisArg?: any): void;\n  map<U>(callbackfn: (value: T, index: number, array: readonly T[]) => U, thisArg?: any): U[];\n  filter<S extends T>(predicate: (value: T, index: number, array: readonly T[]) => value is S, thisArg?: any): S[];\n  filter(predicate: (value: T, index: number, array: readonly T[]) => unknown, thisArg?: any): T[];\n  reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: readonly T[]) => T): T;\n  reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: readonly T[]) => T, initialValue: T): T;\n  reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: readonly T[]) => U, initialValue: U): U;\n  reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: readonly T[]) => T): T;\n  reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: readonly T[]) => T, initialValue: T): T;\n  reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: readonly T[]) => U, initialValue: U): U;\n  readonly [n: number]: T;\n}\n\ninterface Array<T> {\n  length: number;\n  toString(): string;\n  toLocaleString(): string;\n  pop(): T | undefined;\n  push(...items: T[]): number;\n  concat(...items: ConcatArray<T>[]): T[];\n  concat(...items: (T | ConcatArray<T>)[]): T[];\n  join(separator?: string): string;\n  reverse(): T[];\n  shift(): T | undefined;\n  slice(start?: number, end?: number): T[];\n  sort(compareFn?: (a: T, b: T) => number): this;\n  splice(start: number, deleteCount?: number): T[];\n  splice(start: number, deleteCount: number, ...items: T[]): T[];\n  unshift(...items: T[]): number;\n  indexOf(searchElement: T, fromIndex?: number): number;\n  lastIndexOf(searchElement: T, fromIndex?: number): number;\n  every<S extends T>(predicate: (value: T, index: number, array: T[]) => value is S, thisArg?: any): this is S[];\n  every(predicate: (value: T, index: number, array: T[]) => unknown, thisArg?: any): boolean;\n  some(predicate: (value: T, index: number, array: T[]) => unknown, thisArg?: any): boolean;\n  forEach(callbackfn: (value: T, index: number, array: T[]) => void, thisArg?: any): void;\n  map<U>(callbackfn: (value: T, index: number, array: T[]) => U, thisArg?: any): U[];\n  filter<S extends T>(predicate: (value: T, index: number, array: T[]) => value is S, thisArg?: any): S[];\n  filter(predicate: (value: T, index: number, array: T[]) => unknown, thisArg?: any): T[];\n  reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T): T;\n  reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue: T): T;\n  reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n  reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T): T;\n  reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue: T): T;\n  reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n  [n: number]: T;\n}\n";
export default _default;
//# sourceMappingURL=minimalLibDts.d.ts.map