import { collect } from "./collect.js";
import { divide } from "./divide.js";
/**
 * Applies a transformation function to the given iterable with applied concurrency. Note that the
 * order of the returned iterable may not match the order of the input iterable.
 */
export function distribute(iterable, concurrency, transform) {
    return collect(divide(iterable, concurrency).map(transform));
}
//# sourceMappingURL=distribute.js.map